/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.util.jar;

import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class JarUtil
extends JarExtractor {
    private static final char SEPARATOR = '/';

    public JarUtil() {
    }

    public JarUtil(String jar) {
        super(jar);
    }

    public JarUtil(String jar, String outputDir) {
        super(jar, outputDir);
    }

    public static boolean hasEntry(String jar, String entryName) throws IOException {
        File jarFile = new File(jar);
        return JarUtil.hasEntry(jarFile, entryName);
    }

    public static boolean hasEntry(File jar, String entryName) throws IOException {
        JarFile jarFile = null;
        boolean result = false;
        try {
            jarFile = new JarFile(jar);
            result = JarUtil.hasEntry(jarFile, entryName);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {}
        return result;
    }

    public static boolean hasEntry(JarFile jarFile, String entryName) {
        return jarFile.getEntry(entryName) != null;
    }

    public void extractDir(JarFile jarFile, String entryName, String destDir) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry currentEntry = entries.nextElement();
            if (!currentEntry.getName().startsWith(entryName) || currentEntry.isDirectory()) continue;
            this.extractFile(jarFile, currentEntry.getName(), destDir);
        }
    }

    public void setJarFile(String s) {
        super.setJarFile(s);
    }

    public void extractFiles(String jarFileName, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String workingDir, boolean cutPrefix) throws IOException {
        this.extractFiles(new File(jarFileName), prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, workingDir, cutPrefix);
    }

    public void extractFiles(File jar, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String workingDir, boolean cutPrefix) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            this.extractFiles(jarFile, prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, workingDir, cutPrefix);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {}
    }

    public void extractFiles(JarFile jarFile, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String workingDir, boolean cutPrefix) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            boolean isFile = true;
            boolean startsWith = true;
            String firstPrefixThatStartsWith = "";
            boolean notStartsWith = true;
            boolean endsWith = true;
            boolean notEndsWith = true;
            JarEntry jarEntry = enumeration.nextElement();
            String jarEntryName = jarEntry.getName();
            boolean bl = isFile = !jarEntry.isDirectory();
            if (prefixFilters != null && prefixFilters.length > 0 && (firstPrefixThatStartsWith = WSUtil.startsWithPrefix(jarEntryName, prefixFilters)) == null) {
                startsWith = false;
            }
            if (prefixExcludeList != null && prefixExcludeList.length > 0) {
                boolean bl2 = notStartsWith = !WSUtil.startsWith(jarEntryName, prefixExcludeList);
            }
            if (suffixFilters != null && suffixFilters.length > 0) {
                endsWith = WSUtil.endsWith(jarEntryName, suffixFilters);
            }
            if (suffixExcludeList != null && suffixExcludeList.length > 0) {
                boolean bl3 = notEndsWith = !WSUtil.endsWith(jarEntryName, suffixExcludeList);
            }
            if (!isFile || !startsWith || !notStartsWith || !endsWith || !notEndsWith) continue;
            if (cutPrefix) {
                String relativeFileName = jarEntryName.substring(jarEntryName.indexOf(firstPrefixThatStartsWith) + firstPrefixThatStartsWith.length());
                this.extractFile(jarFile, jarEntryName, workingDir, relativeFileName);
                continue;
            }
            this.extractFile(jarFile, jarEntryName, workingDir);
        }
    }

    public void extractAndPackageFiles(String workingDir, String jarFileName, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String resultFileName) throws IOException {
        this.extractAndPackageFiles(workingDir, new File(jarFileName), prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, resultFileName);
    }

    public void extractAndPackageFiles(String workingDir, File jar, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String resultFileName) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            this.extractAndPackageFiles(workingDir, jarFile, prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, resultFileName);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {}
    }

    public void extractAndPackageFiles(String workingDir, JarFile jarFile, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String resultFileName) throws IOException {
        this.extractFiles(jarFile, prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, workingDir, false);
        JarUtils jarUtils = new JarUtils();
        jarUtils.makeJarFromDir(resultFileName, workingDir);
    }

    public void copyEntries(JarFile jarFile, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, boolean cutPrefix, JarOutputStream jarOutputStream) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            Object var22_21;
            boolean isFile = true;
            boolean startsWith = true;
            String firstPrefixThatStartsWith = "";
            boolean notStartsWith = true;
            boolean endsWith = true;
            boolean notEndsWith = true;
            JarEntry jarEntry = enumeration.nextElement();
            String jarEntryName = jarEntry.getName();
            boolean bl = isFile = !jarEntry.isDirectory();
            if (prefixFilters != null && prefixFilters.length > 0 && (firstPrefixThatStartsWith = WSUtil.startsWithPrefix(jarEntryName, prefixFilters)) == null) {
                startsWith = false;
            }
            if (prefixExcludeList != null && prefixExcludeList.length > 0) {
                boolean bl2 = notStartsWith = !WSUtil.startsWith(jarEntryName, prefixExcludeList);
            }
            if (suffixFilters != null && suffixFilters.length > 0) {
                endsWith = WSUtil.endsWith(jarEntryName, suffixFilters);
            }
            if (suffixExcludeList != null && suffixExcludeList.length > 0) {
                boolean bl3 = notEndsWith = !WSUtil.endsWith(jarEntryName, suffixExcludeList);
            }
            if (!isFile || !startsWith || !notStartsWith || !endsWith || !notEndsWith) continue;
            InputStream in = null;
            InputStream check = null;
            try {
                String newEntryName = jarEntryName;
                if (cutPrefix) {
                    String jarEntryNameWithoutExt = IOUtil.getFileNameWithoutExt(jarEntryName);
                    if (firstPrefixThatStartsWith.length() > 0 && firstPrefixThatStartsWith.length() < jarEntryNameWithoutExt.length() && ((newEntryName = jarEntryName.substring(jarEntryName.indexOf(firstPrefixThatStartsWith) + firstPrefixThatStartsWith.length())).startsWith("/") || newEntryName.startsWith("\\"))) {
                        newEntryName = newEntryName.substring(1);
                    }
                }
                in = jarFile.getInputStream(jarEntry);
                check = jarFile.getInputStream(jarEntry);
                this.makeEntry(jarOutputStream, newEntryName, in, check);
                var22_21 = null;
            }
            catch (Throwable throwable) {
                var22_21 = null;
                IOUtil.closeInputStreams(new InputStream[]{in, check});
                throw throwable;
            }
            IOUtil.closeInputStreams(new InputStream[]{in, check});
            {
            }
        }
    }

    public void makeJarFile(String file, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String resultFileName) throws IOException {
        this.makeJarFile(new File(file), prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, resultFileName);
    }

    public void makeJarFile(File file, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String resultFileName) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            this.makeJarFile(jarFile, prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, resultFileName);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void makeJarFile(JarFile jarFile, String[] prefixFilters, String[] prefixExcludeList, String[] suffixFilters, String[] suffixExcludeList, String resultFileName) throws IOException {
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(resultFileName));
            this.copyEntries(jarFile, prefixFilters, prefixExcludeList, suffixFilters, suffixExcludeList, true, jarOutputStream);
            Object var9_8 = null;
            if (jarOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (jarOutputStream == null) throw throwable;
            try {
                jarOutputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jarOutputStream.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JarEntry makeEntry(ZipOutputStream zip, String entryName, InputStream in, InputStream check) throws IOException {
        if (in == null) {
            return null;
        }
        JarEntry entry = null;
        try {
            try {
                int count = 0;
                int size = 0;
                byte[] buff = new byte[16384];
                CRC32 crc = new CRC32();
                entry = new JarEntry(entryName.replace('\\', '/'));
                try {
                    while ((count = check.read(buff)) != -1) {
                        size += count;
                        crc.update(buff, 0, count);
                    }
                    entry.setMethod(0);
                    entry.setCrc(crc.getValue());
                    entry.setSize(size);
                    entry.setCompressedSize(size);
                    zip.putNextEntry(entry);
                    while ((count = in.read(buff)) != -1) {
                        zip.write(buff, 0, count);
                    }
                }
                catch (EOFException ex) {
                    throw new IOException(ex.getMessage());
                }
                Object var12_12 = null;
                zip.closeEntry();
                return entry;
            }
            catch (ZipException zipEx) {
                throw new IOException(zipEx.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            zip.closeEntry();
            throw throwable;
        }
    }

    public static String[] getEntryNames(String prefix, JarFile jarFile) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Vector<String> filteredEntryNames = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String entryName = zipEntry.getName();
            if (!entryName.startsWith(prefix)) continue;
            filteredEntryNames.add(entryName);
        }
        Object[] filteredEntryNamesArr = new String[filteredEntryNames.size()];
        filteredEntryNames.copyInto(filteredEntryNamesArr);
        return filteredEntryNamesArr;
    }
}

