/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.util;

import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;

public class WSUtil {
    public static String getModuleNameByType(String fileName) {
        String extension = IOUtil.getFileExtension(fileName);
        int moduleType = WSUtil.getModuleType(extension);
        if (moduleType != -1) {
            return WSUtil.getJarNameAsString(fileName) + moduleType;
        }
        return WSUtil.replaceForbiddenChars(fileName);
    }

    public static String getFileNameAsString(String fileName) {
        String tmpString = WSUtil.replaceForbiddenChars(fileName);
        return tmpString.replace('.', '_');
    }

    public static String getJarNameAsString(String jarName) {
        if ((jarName = new File(jarName).getName()).lastIndexOf(".") != -1) {
            jarName = jarName.substring(0, jarName.indexOf("."));
        }
        return WSUtil.replaceForbiddenChars(jarName);
    }

    public static String replaceForbiddenChars(String str) {
        char[] forbiddenChars = new char[]{'-', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '~', ' '};
        int charsLength = forbiddenChars.length;
        int i = 0;
        while (i < charsLength) {
            str = str.replace(forbiddenChars[i], '_');
            ++i;
        }
        return str;
    }

    public static String cutString(String str, String subStr) {
        String resultStr = str;
        int cutIndex = str.indexOf(subStr);
        if (cutIndex != -1) {
            resultStr = str.substring(cutIndex);
        }
        return resultStr;
    }

    public static String getIndentString(String prefix, ArrayList strs) {
        String nl = "\n";
        if (strs == null) {
            return null;
        }
        String resultStr = "";
        int i = 0;
        while (i < strs.size()) {
            String str = (String)strs.get(i);
            resultStr = resultStr + prefix + str + nl;
            ++i;
        }
        return resultStr;
    }

    public static String[] getSeparateStrings(String str, String delimiter) {
        StringTokenizer stringTokenizer = new StringTokenizer(str, delimiter);
        ArrayList<String> separateStrings = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String nextStr = stringTokenizer.nextToken();
            separateStrings.add(nextStr);
        }
        return WSUtil.getAsArrayOfStrings(separateStrings);
    }

    public static String[] getAsArrayOfStrings(ArrayList strArrayList) {
        String[] stringsArray = new String[strArrayList.size()];
        int i = 0;
        while (i < strArrayList.size()) {
            stringsArray[i] = (String)strArrayList.get(i);
            ++i;
        }
        return stringsArray;
    }

    public static String concatStrings(Vector strs, String delimiter) {
        if (strs == null || delimiter == null) {
            return null;
        }
        String resultStr = "";
        int i = 0;
        while (i < strs.size()) {
            resultStr = resultStr + strs.get(i) + delimiter;
            ++i;
        }
        return resultStr;
    }

    public static String concatStrings(String[] strs, String delimiter) {
        if (strs == null || delimiter == null) {
            return null;
        }
        String resultStr = "";
        int i = 0;
        while (i < strs.length) {
            resultStr = resultStr + strs[i] + delimiter;
            ++i;
        }
        return resultStr;
    }

    public static String[] addPrefixToStrings(String prefix, String[] strings) {
        return WSUtil.addStrToStrings(prefix, strings, true);
    }

    public static String[] addSuffixToStrings(String[] strings, String suffix) {
        return WSUtil.addStrToStrings(suffix, strings, false);
    }

    public static Vector addPrefixToStrings(String prefix, Vector strings) {
        return WSUtil.addStrToStrings(prefix, strings, true);
    }

    public static Vector addSuffixToStrings(Vector strings, String suffix) {
        return WSUtil.addStrToStrings(suffix, strings, false);
    }

    public static Vector addStrToStrings(String str, Vector strings, boolean isPrefix) {
        if (strings == null) {
            return new Vector();
        }
        Vector<String> resultStrings = new Vector<String>();
        int i = 0;
        while (i < strings.size()) {
            if (isPrefix) {
                resultStrings.add(str + strings.get(i));
            } else {
                resultStrings.add(strings.get(i) + str);
            }
            ++i;
        }
        return resultStrings;
    }

    public static String[] addStrToStrings(String str, String[] strings, boolean isPrefix) {
        if (strings == null) {
            return new String[0];
        }
        String[] resultStrings = new String[strings.length];
        int i = 0;
        while (i < strings.length) {
            resultStrings[i] = isPrefix ? str + strings[i] : strings[i] + str;
            ++i;
        }
        return resultStrings;
    }

    public static String[] unifyStrings(String[][] strings) {
        String[] allStrings = new String[]{};
        int size = strings.length;
        int i = 0;
        while (i < size) {
            String[] currentStrings = strings[i];
            String[] newStrings = new String[allStrings.length + currentStrings.length];
            System.arraycopy(allStrings, 0, newStrings, 0, allStrings.length);
            System.arraycopy(currentStrings, 0, newStrings, allStrings.length, currentStrings.length);
            allStrings = newStrings;
            ++i;
        }
        return allStrings;
    }

    public static void printStrings(String[] strings) {
        if (strings == null) {
            return;
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            System.out.println(string);
            ++i;
        }
    }

    public static boolean startsWith(String str, String[] prefixes) {
        return WSUtil.startsWithPrefix(str, prefixes) != null;
    }

    public static String startsWithPrefix(String str, String[] prefixes) {
        int i = 0;
        while (i < prefixes.length) {
            String prefix = prefixes[i];
            if (str.startsWith(prefix)) {
                return prefix;
            }
            ++i;
        }
        return null;
    }

    public static boolean endsWith(String str, String[] suffixes) {
        return WSUtil.endsWithPrefix(str, suffixes) != null;
    }

    public static String endsWithPrefix(String str, String[] suffixes) {
        int i = 0;
        while (i < suffixes.length) {
            String suffix = suffixes[i];
            if (str.endsWith(suffix)) {
                return suffix;
            }
            ++i;
        }
        return null;
    }

    public static String getUpLevelStringLeftToRight(String str, String delimiter, int level) {
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        if (level < 0) {
            return null;
        }
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String currentStr = tokenizer.nextToken();
            if (i != level) continue;
            return currentStr;
        }
        return null;
    }

    public static String getUpLevelStringRightToLeft(String str, String delimiter, int level) {
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        int tokensCount = tokenizer.countTokens();
        return WSUtil.getUpLevelStringLeftToRight(str, delimiter, tokensCount - level - 1);
    }

    public static String getLastToken(String str, String delimiter) {
        return WSUtil.getUpLevelStringRightToLeft(str, delimiter, 0);
    }

    public static String[] collectStringProperties(Properties properties, String delimiter) {
        if (properties == null) {
            return new String[0];
        }
        String[] strs = new String[]{};
        Enumeration enumeration = ((Hashtable)properties).elements();
        while (enumeration.hasMoreElements()) {
            String str = (String)enumeration.nextElement();
            strs = WSUtil.unifyStrings(new String[][]{strs, WSUtil.collectStrings(str, delimiter)});
        }
        return strs;
    }

    public static Set collectPropertiesSet(Properties properties, String delimiter) {
        if (properties == null) {
            return new HashSet();
        }
        HashSet strSet = new HashSet();
        Enumeration enumeration = ((Hashtable)properties).elements();
        while (enumeration.hasMoreElements()) {
            String str = (String)enumeration.nextElement();
            strSet.addAll(WSUtil.collectStringsSet(str, delimiter));
        }
        return strSet;
    }

    public static String[] collectStrings(String str, String delimiter) {
        StringTokenizer strTokenizer = new StringTokenizer(str, delimiter);
        Vector<String> strs = new Vector<String>();
        while (strTokenizer.hasMoreTokens()) {
            strs.add(strTokenizer.nextToken());
        }
        Object[] strsArr = new String[strs.size()];
        strs.copyInto(strsArr);
        return strsArr;
    }

    public static Set collectStringsSet(String str, String delimiter) {
        StringTokenizer strTokenizer = new StringTokenizer(str, delimiter);
        HashSet<String> strSet = new HashSet<String>();
        while (strTokenizer.hasMoreTokens()) {
            strSet.add(strTokenizer.nextToken());
        }
        return strSet;
    }

    public static Set collectSet(Object[] objs) {
        if (objs == null) {
            return new HashSet();
        }
        HashSet<Object> set = new HashSet<Object>();
        int i = 0;
        while (i < objs.length) {
            set.add(objs[i]);
            ++i;
        }
        return set;
    }

    public static String getApplicationProviderName(String applicationName) {
        int cutIndex = applicationName.indexOf("/");
        if (cutIndex == -1) {
            return null;
        }
        return applicationName.substring(0, cutIndex);
    }

    public static String getPureApplicationName(String applicationName) {
        int cutIndex = applicationName.indexOf("/");
        if (cutIndex == -1) {
            return null;
        }
        return applicationName.substring(cutIndex + 1);
    }

    public static Context createSubContext(Context rootCtx, String subCtxName) throws NamingException {
        String[] subCtxNames = WSUtil.getSeparateStrings(subCtxName, "/");
        if (subCtxNames == null || subCtxNames.length == 0) {
            return null;
        }
        Context ctx = rootCtx;
        int i = 0;
        while (i < subCtxNames.length) {
            String currentSubCtxName = subCtxNames[i];
            try {
                ctx = ctx.createSubcontext(currentSubCtxName);
            }
            catch (NameAlreadyBoundException e) {
                ctx = (Context)ctx.lookup(currentSubCtxName);
            }
            ++i;
        }
        return ctx;
    }

    public static String getParentContexName(String jndiName) {
        int cutIndex = jndiName.lastIndexOf("/");
        if (cutIndex == -1) {
            return null;
        }
        return jndiName.substring(0, cutIndex);
    }

    public static String getJndiName(String jndiName) {
        int cutIndex = jndiName.lastIndexOf("/");
        if (cutIndex == -1) {
            return jndiName;
        }
        return jndiName.substring(cutIndex + 1);
    }

    public static Context lookUpContext(Context rootCtx, String subCtxName) throws NamingException {
        if (subCtxName == null) {
            return null;
        }
        String[] subCtxNames = WSUtil.getSeparateStrings(subCtxName, "/");
        Context ctx = rootCtx;
        int i = 0;
        while (i < subCtxNames.length) {
            String currentCtxName = subCtxNames[i];
            ctx = (Context)ctx.lookup(currentCtxName);
            ++i;
        }
        return ctx;
    }

    public static void rebind(Context ctx, String jndiName, Object obj) throws NamingException {
        String parentCtxName = WSUtil.getParentContexName(jndiName);
        String realJndiName = WSUtil.getJndiName(jndiName);
        Context parentCtx = null;
        parentCtx = parentCtxName == null ? ctx : WSUtil.createSubContext(ctx, parentCtxName);
        parentCtx.rebind(realJndiName, obj);
    }

    public static void unbind(Context ctx, String jndiName) throws NamingException {
        ctx.unbind(jndiName);
        String parentCtx = WSUtil.getParentContexName(jndiName);
        WSUtil.destroyEmptyContext(ctx, parentCtx);
    }

    public static void destroyEmptyContext(Context rootCtx, String relCtxName) throws NamingException {
        if (relCtxName == null) {
            return;
        }
        String currentRelCtxName = relCtxName;
        int cutIndex = currentRelCtxName.length();
        while (cutIndex != -1) {
            Context currentRelCtx = (Context)rootCtx.lookup(currentRelCtxName = currentRelCtxName.substring(0, cutIndex));
            if (WSUtil.isEmpty(currentRelCtx)) {
                WSUtil.destroyContext(rootCtx, currentRelCtxName);
            }
            cutIndex = currentRelCtxName.lastIndexOf("/");
        }
    }

    public static void destroyApplicationContext(Context ctx, String applicationName) throws NamingException {
        try {
            WSUtil.lookUpContext(ctx, applicationName);
        }
        catch (NameNotFoundException e) {
            return;
        }
        String providerName = WSUtil.getApplicationProviderName(applicationName);
        String pureApplicationName = WSUtil.getPureApplicationName(applicationName);
        Context providerCtx = WSUtil.lookUpContext(ctx, providerName);
        if (providerCtx != null) {
            WSUtil.destroyContext(providerCtx, pureApplicationName);
            if (WSUtil.isEmpty(providerCtx)) {
                WSUtil.destroyContext(ctx, providerName);
            }
        }
    }

    public static void destroyContext(Context root, String contextToDestroy) throws NamingException {
        WSUtil.emptyContext((Context)root.lookup(contextToDestroy));
        root.destroySubcontext(contextToDestroy);
    }

    public static void emptyContext(Context root) throws NamingException {
        NameClassPair pair = null;
        NamingEnumeration<NameClassPair> ne = root.list("");
        while (ne.hasMoreElements()) {
            pair = (NameClassPair)ne.nextElement();
            if (WSUtil.isContext(pair.getClassName())) {
                WSUtil.emptyContext((Context)root.lookup(pair.getName()));
                root.destroySubcontext(pair.getName());
                continue;
            }
            root.unbind(pair.getName());
        }
    }

    public static boolean isContext(String name) {
        return name.indexOf("javax.naming.Context") != -1 || name.indexOf("javax.naming.directory.DirContext") != -1;
    }

    private static boolean isEmpty(Context ctx) {
        try {
            NamingEnumeration<NameClassPair> ne = ctx.list("");
            return !ne.hasMoreElements();
        }
        catch (NamingException e) {
            return false;
        }
    }

    public static Reference getLinkReference(String jndiLinkName) {
        return new Reference(jndiLinkName, "com.sap.engine.services.jndi.ComponentObjectFactory", null);
    }

    public static int getModuleType(String extension) {
        if (extension.equals(".wsar")) {
            return 0;
        }
        if (extension.equals(".jar")) {
            return 1;
        }
        if (extension.equals(".war")) {
            return 2;
        }
        return -1;
    }

    public static Properties unifyProperties(Properties props1, Properties props2, String delimiter) {
        if (props1 == null) {
            return props2;
        }
        if (props2 == null) {
            return props1;
        }
        Properties resultProps = new Properties();
        ((Hashtable)resultProps).putAll(WSUtil.makeSubtraction(props1, (Hashtable)props2));
        ((Hashtable)resultProps).putAll(WSUtil.makeSubtraction(props2, (Hashtable)props1));
        Properties intersectionProps = WSUtil.makeIntersection(props1, (Hashtable)props2);
        Enumeration enumeration = ((Hashtable)intersectionProps).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            resultProps.setProperty(key, WSUtil.concatStrings(new String[]{props1.getProperty(key), props2.getProperty(key)}, delimiter));
        }
        return resultProps;
    }

    public static Properties unifyProperties(Properties[] props, String delimiter) {
        if (props == null) {
            return new Properties();
        }
        Properties resultProps = new Properties();
        int i = 0;
        while (i < props.length) {
            resultProps = WSUtil.unifyProperties(resultProps, props[i], delimiter);
            ++i;
        }
        return resultProps;
    }

    public static Properties makeSubtraction(Properties t1, Hashtable t2) {
        if (t1 == null || t2 == null) {
            return new Properties();
        }
        Properties substractionTable = new Properties();
        Enumeration t1Enum = ((Hashtable)t1).keys();
        while (t1Enum.hasMoreElements()) {
            Object key = t1Enum.nextElement();
            if (t2.containsKey(key)) continue;
            ((Hashtable)substractionTable).put(key, ((Hashtable)t1).get(key));
        }
        return substractionTable;
    }

    public static Hashtable makeSubtraction(Hashtable t1, Hashtable t2) {
        if (t1 == null || t2 == null) {
            return new Hashtable();
        }
        Hashtable substractionTable = new Hashtable();
        Enumeration t1Enum = t1.keys();
        while (t1Enum.hasMoreElements()) {
            Object key = t1Enum.nextElement();
            if (t2.containsKey(key)) continue;
            substractionTable.put(key, t1.get(key));
        }
        return substractionTable;
    }

    public static Properties makeIntersection(Properties t1, Hashtable t2) {
        if (t1 == null || t2 == null) {
            return new Properties();
        }
        Properties intersectionTable = new Properties();
        Enumeration t1Enum = ((Hashtable)t1).keys();
        while (t1Enum.hasMoreElements()) {
            Object key = t1Enum.nextElement();
            if (!t2.containsKey(key)) continue;
            ((Hashtable)intersectionTable).put(key, ((Hashtable)t1).get(key));
        }
        return intersectionTable;
    }

    public static Hashtable makeIntersection(Hashtable t1, Hashtable t2) {
        if (t1 == null || t2 == null) {
            return new Hashtable();
        }
        Hashtable intersectionTable = new Hashtable();
        Enumeration t1Enum = t1.keys();
        while (t1Enum.hasMoreElements()) {
            Object key = t1Enum.nextElement();
            if (!t2.containsKey(key)) continue;
            intersectionTable.put(key, t1.get(key));
        }
        return intersectionTable;
    }

    public static Properties filterProperties(Set keySetFiltered, Properties props) {
        if (keySetFiltered == null) {
            return new Properties();
        }
        Properties propsFiltered = new Properties();
        Iterator iter = keySetFiltered.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!((Hashtable)props).containsKey(key)) continue;
            ((Hashtable)propsFiltered).put(key, props.getProperty(key));
        }
        return propsFiltered;
    }

    public static String[] collectKeys(Properties props) {
        if (props == null) {
            return new String[0];
        }
        String[] keys = new String[((Hashtable)props).size()];
        Enumeration enumeration = ((Hashtable)props).keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            keys[i++] = (String)enumeration.nextElement();
        }
        return keys;
    }

    public static String[] collecProperties(Properties props) {
        if (props == null) {
            return new String[0];
        }
        String[] properties = new String[((Hashtable)props).size()];
        Enumeration enumeration = ((Hashtable)props).elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            properties[i++] = (String)enumeration.nextElement();
        }
        return properties;
    }

    public static Set collectKeySet(Hashtable table) {
        if (table == null) {
            return new HashSet();
        }
        HashSet keySet = new HashSet();
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            keySet.add(enumeration.nextElement());
        }
        return keySet;
    }

    public static int getMaxPositiveInt(Set ints) {
        if (ints == null || ints.size() == 0) {
            return -1;
        }
        Iterator iter = ints.iterator();
        int maxInt = (Integer)iter.next();
        while (iter.hasNext()) {
            int currentInt = (Integer)iter.next();
            if (currentInt <= maxInt) continue;
            maxInt = currentInt;
        }
        return maxInt;
    }

    public static Set getMissedInts(Set ints, int minInt, int maxInt) {
        HashSet<Integer> missedInts = new HashSet<Integer>();
        int i = minInt;
        while (i <= maxInt) {
            if (!ints.contains(new Integer(i))) {
                missedInts.add(new Integer(i));
            }
            ++i;
        }
        return missedInts;
    }

    public static int[] getIntArray(Set intSet) {
        if (intSet == null) {
            return new int[0];
        }
        Iterator iter = intSet.iterator();
        int[] intArray = new int[intSet.size()];
        int i = 0;
        while (iter.hasNext()) {
            intArray[i++] = (Integer)iter.next();
        }
        return intArray;
    }

    public static int[] unifyInts(int[][] ints) {
        if (ints == null) {
            return new int[0];
        }
        int[] allInts = new int[]{};
        int i = 0;
        while (i < ints.length) {
            int[] currentInts = ints[i];
            int[] newInts = new int[allInts.length + currentInts.length];
            System.arraycopy(allInts, 0, newInts, 0, allInts.length);
            System.arraycopy(currentInts, 0, newInts, allInts.length, currentInts.length);
            allInts = newInts;
            ++i;
        }
        return allInts;
    }
}

