/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.util;

import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class IOUtil {
    private static final String separator = "/";

    public static boolean mkDirs(String[] dirs) {
        boolean madeDirs = true;
        int dirsSize = dirs.length;
        int i = 0;
        while (i < dirsSize) {
            String dir = dirs[i];
            File dirFile = new File(dir);
            madeDirs = madeDirs && dirFile.mkdirs();
            ++i;
        }
        return madeDirs;
    }

    public static boolean mkDirs(File[] dirs) {
        boolean madeDirs = true;
        int dirsSize = dirs.length;
        int i = 0;
        while (i < dirsSize) {
            File dir = dirs[i];
            madeDirs = madeDirs && dir.mkdirs();
            ++i;
        }
        return madeDirs;
    }

    public static boolean isEmptyDir(String dir) throws IOException {
        return IOUtil.isEmptyDir(new File(dir));
    }

    public static boolean isEmptyDir(File dir) throws IOException {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Error occured, checking if directory is empty: " + dir.getAbsolutePath() + ". The current file is not a directory.");
        }
        File[] files = dir.listFiles();
        return files == null || files.length == 0;
    }

    public static boolean deleteDir(String dir) throws IOException {
        return IOUtil.deleteDir(new File(dir));
    }

    public static boolean deleteDir(File dir) throws IOException {
        IOUtil.deleteDirSubTree(dir);
        dir.delete();
        return !dir.exists();
    }

    public static boolean deleteDirSubTree(String dir) throws IOException {
        return IOUtil.deleteDirSubTree(new File(dir));
    }

    public static boolean deleteDirSubTree(File dir) throws IOException {
        if (IOUtil.isEmptyDir(dir)) {
            return true;
        }
        if (!dir.isDirectory()) {
            throw new IOException("The current file is not a directory.");
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                IOUtil.deleteDir(files[i]);
            }
            if (files[i].isFile()) {
                files[i].delete();
            }
            ++i;
        }
        files = dir.listFiles();
        return files == null || files.length == 0;
    }

    public static boolean deleteDirs(String[] dirs) throws IOException {
        int dirsSize = dirs.length;
        int i = 0;
        while (i < dirsSize) {
            String dir = dirs[i];
            if (!IOUtil.deleteDir(dir)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void deleteDirs(File[] dirs) throws IOException {
        int dirsSize = dirs.length;
        int i = 0;
        while (i < dirsSize) {
            File dir = dirs[i];
            IOUtil.deleteDir(dir);
            ++i;
        }
    }

    public static void deleteDir(String prefixFilter, File dirFile) throws IOException {
        if (dirFile.exists() && dirFile.isDirectory() && dirFile.getName().startsWith(prefixFilter)) {
            IOUtil.deleteDir(dirFile);
        }
    }

    public static void deleteDirs(String prefixFilter, File[] dirs) throws IOException {
        int dirsSize = dirs.length;
        int i = 0;
        while (i < dirsSize) {
            File dir = dirs[i];
            IOUtil.deleteDir(prefixFilter, dir);
            ++i;
        }
    }

    public static void deleteDirs(String prefixFilter, String parentDir) throws IOException {
        File[] dirs = new File(parentDir).listFiles();
        IOUtil.deleteDirs(prefixFilter, dirs);
    }

    public static void copyDir(String sourceDir, String destinationDir) throws IOException {
        IOUtil.copyDir(new File(sourceDir), new File(destinationDir));
    }

    public static void copyDir(File sourceDir, File destinationDir) throws IOException {
        if (destinationDir.exists()) {
            IOUtil.deleteDir(destinationDir);
        }
        destinationDir.mkdirs();
        if (sourceDir.exists() && sourceDir.isDirectory()) {
            File[] files = sourceDir.listFiles();
            int i = 0;
            while (i < files.length) {
                File currentFile = files[i];
                File newDestination = new File(destinationDir, currentFile.getName());
                if (currentFile.isDirectory()) {
                    IOUtil.copyDir(currentFile, newDestination);
                } else {
                    IOUtil.copyFile(currentFile, newDestination);
                }
                ++i;
            }
        }
    }

    public static void copyFile(String source, String destination) throws IOException {
        IOUtil.copyFile(new File(source), new File(destination));
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            IOUtil.copy(in, out);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtil.closeInputStreams(new InputStream[]{in});
            IOUtil.closeOutputStreams(new OutputStream[]{out});
            throw throwable;
        }
        IOUtil.closeInputStreams(new InputStream[]{in});
        IOUtil.closeOutputStreams(new OutputStream[]{out});
    }

    public static void copyFile(String source, String destDir, String destRelFile) throws IOException {
        File sourceFile = new File(source);
        File destFile = new File(destDir + separator + destRelFile);
        destFile.getParentFile().mkdirs();
        destFile.createNewFile();
        IOUtil.copyFile(sourceFile, destFile);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        int allCount = 0;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
            allCount += count;
        }
        out.flush();
    }

    public static void createParentDir(String[] fileNames) {
        if (fileNames == null) {
            return;
        }
        int i = 0;
        while (i < fileNames.length) {
            String fileName = fileNames[i];
            File parentDir = new File(fileName).getParentFile();
            parentDir.mkdirs();
            ++i;
        }
    }

    public static File[] getFiles(String parentDir, String[] relPaths) {
        if (relPaths == null) {
            return new File[0];
        }
        File[] files = new File[relPaths.length];
        int i = 0;
        while (i < relPaths.length) {
            files[i] = new File(parentDir, relPaths[i]);
            ++i;
        }
        return files;
    }

    public static File[] getFiles(String[] filePaths) {
        if (filePaths == null) {
            return new File[0];
        }
        File[] files = new File[filePaths.length];
        int i = 0;
        while (i < filePaths.length) {
            files[i] = new File(filePaths[i]);
            ++i;
        }
        return files;
    }

    public static String[] getFileAbsolutePaths(File[] files) {
        int length = files.length;
        String[] filePaths = new String[length];
        int i = 0;
        while (i < length) {
            filePaths[i] = files[i].getAbsolutePath();
            ++i;
        }
        return filePaths;
    }

    public static String getFilePath(String parentDir, String relPath) {
        return parentDir + separator + relPath;
    }

    public static String[] getFilePaths(String parentDir, String[] relPaths) {
        if (relPaths == null) {
            return new String[0];
        }
        String[] filePaths = new String[relPaths.length];
        int i = 0;
        while (i < relPaths.length) {
            filePaths[i] = IOUtil.getFilePath(parentDir, relPaths[i]);
            ++i;
        }
        return filePaths;
    }

    public static String[] getFileNames(File[] files) {
        if (files == null) {
            return new String[0];
        }
        String[] fileNames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            fileNames[i] = files[i].getName();
            ++i;
        }
        return fileNames;
    }

    public static String getFileNameWithoutExt(File file) {
        return IOUtil.getFileNameWithoutExt(file.getAbsolutePath());
    }

    public static String getFileNameWithoutExt(String fileName) {
        int cutIndex = fileName.lastIndexOf(".");
        if (cutIndex != -1) {
            return fileName.substring(0, cutIndex);
        }
        return fileName;
    }

    public static String getFileExtension(File file) {
        return IOUtil.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String[] convertPackageToDirPaths(String[] packagePaths, String[] fileNames) {
        if (packagePaths == null) {
            return new String[0];
        }
        String[] dirPaths = new String[packagePaths.length];
        int i = 0;
        while (i < packagePaths.length) {
            dirPaths[i] = IOUtil.convertPackageToDirPath(packagePaths[i], fileNames[i]);
            ++i;
        }
        return dirPaths;
    }

    public static String convertPackageToDirPath(String packagePath, String fileName) {
        return IOUtil.convertPackageToDirPath(packagePath, fileName, '/');
    }

    public static String convertPackageToDirPath(String packagePath, String fileName, char separator) {
        String filePath = fileName;
        if (packagePath != null && !packagePath.equals("")) {
            filePath = packagePath.replace('.', separator) + separator + fileName;
        }
        return filePath;
    }

    public static String getAsJarName(String name) {
        name = new File(name).getName();
        String jarName = name.substring(0, name.lastIndexOf(".")) + ".jar";
        return jarName;
    }

    public static String getRelativeDir(String relativeFilePath) {
        return IOUtil.getParentPath(relativeFilePath, separator);
    }

    public static String getParentPath(String path, String delimiter) {
        int cutIndex;
        if (path.endsWith(delimiter)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((cutIndex = path.lastIndexOf(delimiter)) < 0) {
            cutIndex = 0;
        }
        return path.substring(0, cutIndex);
    }

    public static String getName(String path, String delimiter) {
        int cutIndex;
        if (path.endsWith(delimiter)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((cutIndex = path.lastIndexOf(delimiter) + 1) < 0) {
            cutIndex = 0;
        }
        return path.substring(cutIndex);
    }

    public static void closeInputStreams(InputStream[] ins) {
        if (ins == null) {
            return;
        }
        int i = 0;
        while (i < ins.length) {
            InputStream in = ins[i];
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void closeInputStreams(InputStream[] ins, String[] msgs, Location location) {
        if (ins == null) {
            return;
        }
        int i = 0;
        while (i < ins.length) {
            block5: {
                InputStream in = ins[i];
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    String msg = msgs[i];
                    if (msg == null) break block5;
                    location.catching(msg, (Throwable)e);
                }
            }
            ++i;
        }
    }

    public static void closeOutputStreams(OutputStream[] outs) {
        if (outs == null) {
            return;
        }
        int i = 0;
        while (i < outs.length) {
            OutputStream out = outs[i];
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void closeOutputStreams(OutputStream[] outs, String[] msgs, Location location) {
        if (outs == null) {
            return;
        }
        int i = 0;
        while (i < outs.length) {
            block5: {
                OutputStream out = outs[i];
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    String msg = msgs[i];
                    if (msg == null) break block5;
                    location.catching(msg, (Throwable)e);
                }
            }
            ++i;
        }
    }

    public static File[] collectFiles(File[] files, Set filterList) {
        if (files == null) {
            return new File[0];
        }
        if (filterList == null) {
            filterList = new HashSet();
        }
        Vector<File> filteredFiles = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (filterList.contains(file.getName())) {
                filteredFiles.add(file);
            }
            ++i;
        }
        Object[] filteredFilesArr = new File[filteredFiles.size()];
        filteredFiles.copyInto(filteredFilesArr);
        return filteredFilesArr;
    }

    public static Hashtable getModuleCrcTable(File[] moduleArchives) throws IOException {
        if (moduleArchives == null) {
            return new Hashtable();
        }
        Hashtable<String, byte[]> moduleCrcTable = new Hashtable<String, byte[]>();
        int i = 0;
        while (i < moduleArchives.length) {
            File moduleArchive = moduleArchives[i];
            byte[] moduleCrc = HashUtils.generateFileHash((File)moduleArchive);
            moduleCrcTable.put(moduleArchive.getName(), moduleCrc);
            ++i;
        }
        return moduleCrcTable;
    }

    public static File[] collectFiles(Hashtable filesTable) {
        if (filesTable == null) {
            return new File[0];
        }
        File[] elements = new File[filesTable.size()];
        Enumeration enumeration = filesTable.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            elements[i++] = (File)filesTable.get((String)enumeration.nextElement());
        }
        return elements;
    }

    public static File[] filterFiles(File[] files, Set fileNamesExcludeList) {
        if (files == null) {
            return new File[0];
        }
        Vector<File> filesFiltered = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (!fileNamesExcludeList.contains(files[i].getName())) {
                filesFiltered.add(file);
            }
            ++i;
        }
        Object[] filesFilteredArr = new File[filesFiltered.size()];
        filesFiltered.copyInto(filesFilteredArr);
        return filesFilteredArr;
    }
}

