/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.external;

import com.sap.engine.interfaces.webservices.runtime.TransportBinding;
import com.sap.engine.interfaces.webservices.runtime.component.ComponentInstantiationException;
import com.sap.engine.interfaces.webservices.runtime.component.TransportBindingFactory;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.services.webservices.exceptions.BaseComponentInstantiationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.TransportBindingProvider;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingsImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSAppDeployResult;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploySettingsProvider;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSFileStorageHandler;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;

public class ExternalWSDeployGenerator
implements WSDeploySettingsProvider,
TransportBindingProvider {
    private Properties trBindingClassMapping = null;
    private String baseWorkingDir = null;
    private String workingDir = null;
    private String resultDir = null;
    private String classPath = null;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$additions$soaphttp$SOAPHTTPFactroy;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$additions$soaphttp$MIMEFactory;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$additions$soaphttp$HTTPFactory;

    public ExternalWSDeployGenerator(String baseWorkingDir) {
        this.baseWorkingDir = baseWorkingDir;
        this.initClassPath("");
        this.initTrBindingClassMapping(null);
    }

    public ExternalWSDeployGenerator(String baseWorkingDir, String classPath) {
        this.baseWorkingDir = baseWorkingDir;
        this.initClassPath(classPath);
        this.initTrBindingClassMapping(null);
    }

    public ExternalWSDeployGenerator(String baseWorkingDir, Properties trBindingClassMapping) {
        this.baseWorkingDir = baseWorkingDir;
        this.initClassPath("");
        this.initTrBindingClassMapping(trBindingClassMapping);
    }

    public ExternalWSDeployGenerator(String baseWorkingDir, Properties trBindingClassMapping, String classPath) {
        this.baseWorkingDir = baseWorkingDir;
        this.initClassPath(classPath);
        this.initTrBindingClassMapping(trBindingClassMapping);
    }

    private void initClassPath(String classPath) {
        this.classPath = System.getProperty("java.class.path") + File.pathSeparator + classPath;
    }

    private void initTrBindingClassMapping(Properties props) {
        if (props == null) {
            this.trBindingClassMapping = new Properties();
            this.trBindingClassMapping.setProperty("SOAPHTTP_TransportBinding", (class$com$sap$engine$services$webservices$additions$soaphttp$SOAPHTTPFactroy == null ? (class$com$sap$engine$services$webservices$additions$soaphttp$SOAPHTTPFactroy = ExternalWSDeployGenerator.class$("com.sap.engine.services.webservices.additions.soaphttp.SOAPHTTPFactroy")) : class$com$sap$engine$services$webservices$additions$soaphttp$SOAPHTTPFactroy).getName());
            this.trBindingClassMapping.setProperty("MIME_TransportBinding", (class$com$sap$engine$services$webservices$additions$soaphttp$MIMEFactory == null ? (class$com$sap$engine$services$webservices$additions$soaphttp$MIMEFactory = ExternalWSDeployGenerator.class$("com.sap.engine.services.webservices.additions.soaphttp.MIMEFactory")) : class$com$sap$engine$services$webservices$additions$soaphttp$MIMEFactory).getName());
            this.trBindingClassMapping.setProperty("HTTP_TransportBinding", (class$com$sap$engine$services$webservices$additions$soaphttp$HTTPFactory == null ? (class$com$sap$engine$services$webservices$additions$soaphttp$HTTPFactory = ExternalWSDeployGenerator.class$("com.sap.engine.services.webservices.additions.soaphttp.HTTPFactory")) : class$com$sap$engine$services$webservices$additions$soaphttp$HTTPFactory).getName());
        } else {
            this.trBindingClassMapping = props;
        }
    }

    public Vector generateDeployFiles(String workingModule) throws IOException, WSDeploymentException {
        String resultArchive = this.baseWorkingDir + '/' + WSUtil.getJarNameAsString(workingModule) + ".jar";
        return this.generateDeployFiles(workingModule, resultArchive);
    }

    public Vector generateDeployFiles(String moduleArchivePath, String resultArchivePath) throws IOException, WSDeploymentException {
        File moduleArchive = new File(moduleArchivePath);
        if (!moduleArchive.isFile() || !moduleArchive.exists()) {
            Object[] args = new Object[]{"The specified module archive is not file or does not exist: " + moduleArchivePath + ". ", "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        WSAppDeployResult wsAppDeployResult = null;
        WSDeployGenerator wsDeployGenerator = new WSDeployGenerator(this, this, new ModuleDeployGenerator(), new ModuleFileStorageHandler());
        try {
            String resultDir = this.baseWorkingDir + '/' + "result";
            String workingDir = this.baseWorkingDir + '/' + "temp";
            wsAppDeployResult = wsDeployGenerator.generateDeployFiles("", WSDirsHandler.getWebServicesDir(resultDir), WSDirsHandler.getWebServicesWorkingDir(workingDir), new File[]{moduleArchive});
            if (wsAppDeployResult.getDeployedComponentNames().length == 0) {
                Object[] args = new Object[]{"The specified module archive does not contain web services. Module archive: " + moduleArchivePath + ". "};
                throw new WSDeploymentException("webservices_5040", args);
            }
            new JarUtils().makeJarFromDir(resultArchivePath, resultDir);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            IOUtil.deleteDirs(new String[]{this.resultDir, this.workingDir});
            throw throwable;
        }
        IOUtil.deleteDirs(new String[]{this.resultDir, this.workingDir});
        return wsAppDeployResult.getWarnings();
    }

    public void generateStandAloneWsdls(String moduleArchivePath, String outputDir, String style, String hostAddress, QName qname, boolean sapMode) throws IOException, WSDeploymentException {
        String resultDir = this.baseWorkingDir + '/' + "result";
        String workingDir = this.baseWorkingDir + '/' + "temp";
        String webServicesDir = WSDirsHandler.getWebServicesDir(resultDir);
        String webServicesWorkingDir = WSDirsHandler.getWebServicesWorkingDir(workingDir);
        WSDeployGenerator wsDeployGenerator = new WSDeployGenerator(this, this, new ModuleDeployGenerator(), new ModuleFileStorageHandler());
        WSAppDeployResult wsAppDeployResult = wsDeployGenerator.generateDeployFiles("", webServicesDir, webServicesWorkingDir, new File[]{new File(moduleArchivePath)});
        WSDeploymentInfo[] wsDeploymentInfoes = wsAppDeployResult.getWsDeploymentInfos();
        WSDeploymentInfo wsDeploymentInfo = null;
        WSRuntimeDefinition wsRuntimeDefinition = null;
        int wsSize = wsDeploymentInfoes.length;
        if (wsSize == 0) {
            return;
        }
        if (wsSize == 1 || qname == null) {
            wsDeploymentInfo = wsDeploymentInfoes[0];
            new WSFileStorageHandler().saveDoc(wsDeploymentInfo);
            wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        } else {
            int i = 0;
            while (i < wsSize) {
                wsDeploymentInfo = wsDeploymentInfoes[i];
                if (wsDeploymentInfo.getWsRuntimeDefinition().getWsQName().equals(qname)) {
                    new WSFileStorageHandler().saveDoc(wsDeploymentInfo);
                    wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
                    break;
                }
                ++i;
            }
            if (i == wsSize) {
                throw new WSDeploymentException((Throwable)new Exception("Cannot find webservice with qname: " + qname));
            }
        }
        Hashtable viSchemaInfoes = new Hashtable();
        DOMSource[][] schemas = new DOMSource[2][];
        HashMap[] mappings = new HashMap[2];
        wsDeployGenerator.getSchemas(wsDeploymentInfo.getVirtualInterfaceEntries(), wsDeploymentInfo.getVirtualInterfaces(), viSchemaInfoes, schemas, mappings);
        JavaToQNameMappingsImpl literalMappings = new JavaToQNameMappingsImpl(mappings[0]);
        JavaToQNameMappingsImpl encodedMappings = new JavaToQNameMappingsImpl(mappings[1]);
        JavaToQNameMappingRegistryImpl registry = new JavaToQNameMappingRegistryImpl();
        registry.setLiteralMappings(literalMappings);
        registry.setEncodedMappings(encodedMappings);
        wsRuntimeDefinition.setJavaToQNameMappingRegistry(registry);
        new WSDLGenerator(this).generateStandAloneWsdls(wsRuntimeDefinition, viSchemaInfoes, outputDir, style, hostAddress, sapMode);
        IOUtil.deleteDirs(new String[]{resultDir, workingDir});
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void defineImplLink(ServiceEndpointDefinition serviceEndpointDefinition) throws WSDeploymentException {
    }

    public TransportBinding getTransportBinding(String trBindingId) throws ComponentInstantiationException {
        String excMsg = "Error occured, trying to instantiate transport binding instance with id " + trBindingId + ".";
        ClassLoader loader = this.getClass().getClassLoader();
        TransportBindingFactory transportBindingFactory = null;
        try {
            String trBindingFactoryClass = this.trBindingClassMapping.getProperty(trBindingId);
            transportBindingFactory = (TransportBindingFactory)loader.loadClass(trBindingFactoryClass).newInstance();
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to instantiate the corresponding transport binding factory. ";
            Object[] args = new Object[]{msg, trBindingId, "server transport binding"};
            throw new BaseComponentInstantiationException("webservices_5020", args, e);
        }
        return transportBindingFactory.newInstance();
    }

    public static void main(String[] args) throws IOException, WSDeploymentException {
        ExternalWSDeployGenerator wsDeployGenerator = new ExternalWSDeployGenerator(args[0]);
        if (args.length > 2) {
            wsDeployGenerator.generateDeployFiles(args[1], args[2]);
        } else {
            wsDeployGenerator.generateDeployFiles(args[1]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

