/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.uddipublication;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.server.event.EventListener;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.UDDIPublication;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeParser;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationContext;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationEvent;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.tc.logging.Location;
import java.util.Vector;

public class UDDIPublicationListener
implements EventListener {
    public static final String LISTENER_ID = "UDDI_KEY_LISTENER";
    private HashMapObjectObject runtimeEventContexts = new HashMapObjectObject();
    private HashMapObjectObject persistentEventContexts = new HashMapObjectObject();

    public String getOwnerIdentifier() {
        return "";
    }

    public String getIdentifier() {
        return LISTENER_ID;
    }

    public boolean needRestart(Event event) {
        return false;
    }

    public void makeRuntimeChanges(Event event, String dir, Configuration configuration) throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occurred, trying to make runtime changes (make phase). Event listener  UDDI_KEY_LISTENER, event " + event.getEventId() + ", event state stamp " + event.getStateStamp() + ". ";
        if (!(event instanceof UDDIPublicationEvent)) {
            return;
        }
        UDDIPublicationEvent uddiPublicationEvent = (UDDIPublicationEvent)event;
        UDDIPublicationContext uddiPublicationContext = new UDDIPublicationContext(uddiPublicationEvent, dir, configuration);
        this.runtimeEventContexts.put((Object)uddiPublicationEvent.getStateStamp(), (Object)uddiPublicationContext);
        String applicationName = uddiPublicationEvent.getApplicationName();
        String wsName = uddiPublicationEvent.getWebServiceName();
        if (!WSContainer.getWSRegistry().contains(applicationName, wsName)) {
            String msg = excMsg + "No web service registered. Application " + applicationName + ", web service " + wsName + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    public void notifyRuntimeChanges(Event event, String dir, Configuration configuration) throws WSWarningException {
        String excMsg = "Error occurred, trying to make runtime changes (notify phase) on remote server. Event listener  UDDI_KEY_LISTENER, event " + event.getEventId() + ", event state stamp " + event.getStateStamp() + ". ";
        UDDIPublicationEvent uddiPublicationEvent = (UDDIPublicationEvent)event;
        String applicationName = uddiPublicationEvent.getApplicationName();
        String wsName = uddiPublicationEvent.getWebServiceName();
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSContainer.getWSRegistry().getWebService(applicationName, wsName);
        }
        catch (RegistryException e) {
            Location wsDepLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDepLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unexpected exception - no web service registered: application " + applicationName + ", web service " + wsName + ". ";
            WSWarningException wExc = new WSWarningException((Throwable)((Object)e));
            wExc.addWarning(msg);
            throw wExc;
        }
        String wsRuntimeDescriptorBaseParentDir = wsRuntimeDefinition.getWsDirsHandler().getWSRuntimeDescriptorBaseParentDir();
        String wsRuntimeDesctiptorFileName = WSDirsHandler.getWSRuntimeDescriptorFileName();
        try {
            Configuration descriptorsDir = configuration.getSubConfiguration("descriptors");
            WSConfigurationHandler.downloadFile(wsRuntimeDescriptorBaseParentDir, wsRuntimeDesctiptorFileName, descriptorsDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occured, trying to download  " + "ws-runtime-descriptor.xml" + " from configuration " + configuration.getPath();
            WSWarningException wExc = new WSWarningException((Throwable)e);
            wExc.addWarning(msg);
            throw wExc;
        }
        wsRuntimeDefinition.setUddiPublications(uddiPublicationEvent.getUddiPublications());
    }

    public void commitRuntimeChanges(String stateStamp) throws WSWarningException {
        String excMsg = "Error occurred, trying to make runtime changes (make phase). Event listener  UDDI_KEY_LISTENER, event UDDI_KEY_EVENT, event state stamp " + stateStamp + ". ";
        UDDIPublicationContext uddiPublicationContext = (UDDIPublicationContext)this.runtimeEventContexts.remove((Object)stateStamp);
        if (uddiPublicationContext == null) {
            String msg = excMsg + "Unexpected error - event context is null. ";
            WSWarningException e = new WSWarningException();
            e.addWarning(msg);
            throw e;
        }
        UDDIPublicationEvent uddiPublicationEvent = uddiPublicationContext.getUddiPublicationEvent();
        String applicationName = uddiPublicationEvent.getApplicationName();
        String wsName = uddiPublicationEvent.getWebServiceName();
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSContainer.getWSRegistry().getWebService(applicationName, wsName);
        }
        catch (RegistryException e) {
            Location wsDepLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDepLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unexpected exception - no web service registered: application " + applicationName + ", web service " + wsName + ". ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        wsRuntimeDefinition.setUddiPublications(uddiPublicationEvent.getUddiPublications());
    }

    public void rollbackRuntimeChanges(String stateStamp) throws WSWarningException {
        this.runtimeEventContexts.remove((Object)stateStamp);
    }

    public void makePersistentChanges(Event event, String dir, Configuration configuration) throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occurred, trying to make persistent changes (make phase). Event listener  UDDI_KEY_LISTENER, event UDDI_KEY_EVENT, event state stamp " + event.getStateStamp() + ". ";
        if (!(event instanceof UDDIPublicationEvent)) {
            return;
        }
        UDDIPublicationEvent uddiPublicationEvent = (UDDIPublicationEvent)event;
        UDDIPublicationContext uddiPublicationContext = new UDDIPublicationContext(uddiPublicationEvent, dir, configuration);
        this.persistentEventContexts.put((Object)uddiPublicationEvent.getStateStamp(), (Object)uddiPublicationContext);
        String applicationName = uddiPublicationEvent.getApplicationName();
        String wsName = uddiPublicationEvent.getWebServiceName();
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSContainer.getWSRegistry().getWebService(applicationName, wsName);
        }
        catch (RegistryException e) {
            Location wsDepLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDepLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unexpected exception - no web service registered: application " + applicationName + ", web service " + wsName + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        String wsRuntimeDesctiptorPath = wsRuntimeDefinition.getWsDirsHandler().getWSRuntimeDescriptorPath();
        try {
            WSRuntimeDescriptor wsRuntimeDescriptor = WSRuntimeParser.loadWSRuntimeDescriptor(wsRuntimeDesctiptorPath);
            uddiPublicationEvent.setOldUddiPublications(wsRuntimeDescriptor.getUddiPublications());
            UDDIPublication[] newUddiPublications = uddiPublicationEvent.getUddiPublications();
            wsRuntimeDescriptor.setUddiPublications(newUddiPublications);
            if (newUddiPublications == null) {
                if (wsRuntimeDescriptor.getUddiKey() != null) {
                    uddiPublicationEvent.setOldUddiKeyValue(wsRuntimeDescriptor.getUddiKey());
                }
                wsRuntimeDescriptor.setUddiKey(null);
            }
            WSRuntimeParser.saveWSRuntimeDescriptor(wsRuntimeDescriptor, wsRuntimeDesctiptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occured, trying to update " + wsRuntimeDesctiptorPath + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        try {
            Configuration descriptorsDir = configuration.getSubConfiguration("descriptors");
            String wsRuntimeDescriptorBaseDir = wsRuntimeDefinition.getWsDirsHandler().getWSRuntimeDescriptorBaseParentDir();
            String wsRuntimeDescriptorFileName = WSDirsHandler.getWSRuntimeDescriptorFileName();
            WSConfigurationHandler.uploadFile(wsRuntimeDescriptorBaseDir, wsRuntimeDescriptorFileName, descriptorsDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occured, trying to upload " + "ws-runtime-descriptor.xml" + " from configuration " + configuration.getPath();
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public void commitPersistentChanges(String stateStamp) throws WSWarningException {
        this.persistentEventContexts.remove((Object)stateStamp);
    }

    public void rollbackPersistentChanges(String stateStamp) throws WSWarningException {
        String excMsg = "Error occurred, trying to make persistent changes (rollback phase). Event listener  UDDI_KEY_LISTENER, event UDDI_KEY_EVENT, event state stamp " + stateStamp + ". ";
        UDDIPublicationContext uddiPublicationContext = (UDDIPublicationContext)this.persistentEventContexts.remove((Object)stateStamp);
        if (uddiPublicationContext == null) {
            String msg = excMsg + "Unexpected error - event context is null. ";
            WSWarningException e = new WSWarningException();
            e.addWarning(msg);
            throw e;
        }
        UDDIPublicationEvent uddiPublicationEvent = uddiPublicationContext.getUddiPublicationEvent();
        String applicationName = uddiPublicationEvent.getApplicationName();
        String wsName = uddiPublicationEvent.getWebServiceName();
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSContainer.getWSRegistry().getWebService(applicationName, wsName);
        }
        catch (RegistryException e) {
            Location wsDepLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDepLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unexpected exception - no web service registered: application " + applicationName + ", web service " + wsName + ". ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        String wsRuntimeDesctiptorPath = wsRuntimeDefinition.getWsDirsHandler().getWSRuntimeDescriptorPath();
        Vector<String> warnings = new Vector<String>();
        try {
            WSRuntimeDescriptor wsRuntimeDescriptor = WSRuntimeParser.loadWSRuntimeDescriptor(wsRuntimeDesctiptorPath);
            UDDIPublication[] oldUddiPublications = uddiPublicationEvent.getOldUddiPublications();
            wsRuntimeDescriptor.setUddiPublications(oldUddiPublications);
            if (uddiPublicationEvent.getUddiPublications() == null) {
                wsRuntimeDescriptor.setUddiKey(uddiPublicationEvent.getOldUddiKeyValue());
            }
            WSRuntimeParser.saveWSRuntimeDescriptor(wsRuntimeDescriptor, wsRuntimeDesctiptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occured, trying to update " + wsRuntimeDesctiptorPath + ". ";
            warnings.add(msg);
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }
}

