/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.uddipublication;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.server.event.EventFactory;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.UDDIPublication;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationEvent;
import com.sap.tc.logging.Location;
import java.util.Properties;

public class UDDIPublicationFactory
implements EventFactory {
    private static final String APPLICATION_NAME = "application_name";
    private static final String WS_NAME = "ws_name";
    private static final String WS_CONFIG_NAME = "ws_config_name";
    private static final String STATE_STAMP = "state_stamp";
    private static final String UDDI_PUBLICATIONS = "uddi_publications";
    private static final String GENERAL_PROPS = "general_props";
    private static final String INQUIRY_URL = "inquiry_url";
    private static final String PUBLISH_URL = "publish_url";
    private static final String SERVICE_KEY = "service_key";

    public String getEventId() {
        return "UDDI_KEY_EVENT";
    }

    public void save(Event event, Configuration eventConfiguration) throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occured, trying to save UDDI_KEY_EVENT event in DB configuration. ";
        if (!(event instanceof UDDIPublicationEvent)) {
            return;
        }
        UDDIPublicationEvent uddiPublicationEvent = (UDDIPublicationEvent)event;
        Properties generalProps = new Properties();
        generalProps.setProperty(APPLICATION_NAME, uddiPublicationEvent.getApplicationName());
        generalProps.setProperty(WS_NAME, uddiPublicationEvent.getWebServiceName());
        generalProps.setProperty(WS_CONFIG_NAME, uddiPublicationEvent.getWSConfigName());
        generalProps.setProperty(STATE_STAMP, uddiPublicationEvent.getStateStamp());
        Properties[] uddiPublicationProps = this.saveUddiPublcationsProps(uddiPublicationEvent.getUddiPublications());
        if (eventConfiguration == null) {
            String msg = excMsg + "Event configuration is null. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        try {
            eventConfiguration.addConfigEntry(GENERAL_PROPS, (Object)generalProps);
            eventConfiguration.addConfigEntry(UDDI_PUBLICATIONS, (Object)uddiPublicationProps);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public Event load(Configuration eventConfiguration) throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occured, trying to load UDDI_KEY_EVENT event in DB configuration. ";
        if (eventConfiguration == null) {
            String msg = excMsg + "Event configuration is null. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        Properties props = null;
        Properties[] uddiPublicationProps = null;
        try {
            props = (Properties)eventConfiguration.getConfigEntry(GENERAL_PROPS);
            uddiPublicationProps = (Properties[])eventConfiguration.getConfigEntry(UDDI_PUBLICATIONS);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        UDDIPublicationEvent uddiPublicationEvent = new UDDIPublicationEvent();
        uddiPublicationEvent.setApplicationName(props.getProperty(APPLICATION_NAME));
        uddiPublicationEvent.setWebServiceName(props.getProperty(WS_NAME));
        uddiPublicationEvent.setWSConfigName(props.getProperty(WS_CONFIG_NAME));
        uddiPublicationEvent.setStateStamp(props.getProperty(STATE_STAMP));
        uddiPublicationEvent.setUddiPublications(this.loadUddiPublications(uddiPublicationProps));
        return uddiPublicationEvent;
    }

    private Properties[] saveUddiPublcationsProps(UDDIPublication[] uddiPublications) {
        if (uddiPublications == null) {
            return new Properties[0];
        }
        Properties[] uddiPublicationsProps = new Properties[uddiPublications.length];
        int i = 0;
        while (i < uddiPublications.length) {
            UDDIPublication uddiPublication = uddiPublications[i];
            Properties props = new Properties();
            props.setProperty(INQUIRY_URL, uddiPublication.getInquiryURL());
            props.setProperty(PUBLISH_URL, uddiPublication.getPublishURL());
            props.setProperty(SERVICE_KEY, uddiPublication.getServiceKey());
            uddiPublicationsProps[i] = props;
            ++i;
        }
        return uddiPublicationsProps;
    }

    private UDDIPublication[] loadUddiPublications(Properties[] uddiPublicationsProps) {
        if (uddiPublicationsProps == null) {
            return new UDDIPublication[0];
        }
        UDDIPublication[] uddiPublications = new UDDIPublication[uddiPublicationsProps.length];
        int i = 0;
        while (i < uddiPublicationsProps.length) {
            Properties props = uddiPublicationsProps[i];
            UDDIPublication uddiPublication = new UDDIPublication();
            uddiPublication.setInquiryURL(props.getProperty(INQUIRY_URL));
            uddiPublication.setPublishURL(props.getProperty(PUBLISH_URL));
            uddiPublication.setServiceKey(props.getProperty(SERVICE_KEY));
            uddiPublications[i] = uddiPublication;
            ++i;
        }
        return uddiPublications;
    }
}

