/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.uddipublication;

import com.sap.engine.interfaces.webservices.server.event.WSEvent;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.UDDIPublication;

public class UDDIPublicationEvent
implements WSEvent {
    public static final String EVENT_ID = "UDDI_KEY_EVENT";
    private String applicationName = null;
    private String wsName = null;
    private String wsConfigName = null;
    private String stateStamp = null;
    private UDDIPublication[] uddiPublications = null;
    private String oldUddiKeyValue = null;
    private UDDIPublication[] oldUddiPublications = null;

    public UDDIPublicationEvent() {
    }

    public UDDIPublicationEvent(String applicationName, String wsName) {
        this.applicationName = applicationName;
        this.wsName = wsName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setWebServiceName(String wsName) {
        this.wsName = wsName;
    }

    public String getWebServiceName() {
        return this.wsName;
    }

    public void setWSConfigName(String wsConfigName) {
        this.wsConfigName = wsConfigName;
    }

    public String getWSConfigName() {
        return this.wsConfigName;
    }

    public void setStateStamp(String stateStamp) {
        this.stateStamp = stateStamp;
    }

    public String getStateStamp() {
        return this.stateStamp;
    }

    public String getEventId() {
        return EVENT_ID;
    }

    public UDDIPublication[] getUddiPublications() {
        return this.uddiPublications;
    }

    public void setUddiPublications(UDDIPublication[] uddiPublications) {
        this.uddiPublications = uddiPublications;
    }

    public String getOldUddiKeyValue() {
        return this.oldUddiKeyValue;
    }

    public void setOldUddiKeyValue(String oldUddiKeyValue) {
        this.oldUddiKeyValue = oldUddiKeyValue;
    }

    public UDDIPublication[] getOldUddiPublications() {
        return this.oldUddiPublications;
    }

    public void setOldUddiPublications(UDDIPublication[] oldUddiPublications) {
        this.oldUddiPublications = oldUddiPublications;
    }

    public Object getValue() {
        return this.uddiPublications;
    }

    public String toString() {
        String nl = WSBaseConstants.LINE_SEPARATOR;
        String result = "";
        result = result + "Event id: UDDI_KEY_EVENT" + nl;
        result = result + "Event state stamp: " + this.stateStamp + nl;
        result = result + "Application: " + this.applicationName + nl;
        result = result + "Web service: " + this.wsName + nl;
        result = result + "Web service configuration name: " + this.wsConfigName + nl;
        if (this.uddiPublications != null) {
            int i = 0;
            while (i < this.uddiPublications.length) {
                UDDIPublication uddiPublication = this.uddiPublications[i];
                result = result + "Uddi publication[" + i + "]" + nl;
                result = result + "Service key: " + uddiPublication.getServiceKey() + nl;
                result = result + "Inquiry URL: " + uddiPublication.getInquiryURL() + nl;
                result = result + "Publish URL: " + uddiPublication.getPublishURL() + nl;
                ++i;
            }
        }
        return result;
    }
}

