/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.system;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.server.event.EventListener;
import com.sap.engine.services.webservices.server.deploy.event.system.PersistentTransaction;
import com.sap.engine.services.webservices.server.deploy.event.system.RuntimeTransaction;
import com.sap.engine.services.webservices.server.deploy.event.system.Transaction;
import java.util.Vector;

public class Runtime_PersistentTransaction
implements Transaction {
    private RuntimeTransaction runtimeTransaction = null;
    private PersistentTransaction persistentTransaction = null;

    public Runtime_PersistentTransaction() {
    }

    public Runtime_PersistentTransaction(Event event, String[] dirs, Configuration configuration, Configuration eventConfiguration, Configuration rootEventConfiguration, EventListener[] eventListeners) {
        this.runtimeTransaction = new RuntimeTransaction(event, dirs, configuration, eventListeners);
        this.persistentTransaction = new PersistentTransaction(event, dirs, configuration, eventConfiguration, rootEventConfiguration, eventListeners);
    }

    public Runtime_PersistentTransaction(RuntimeTransaction runtimeTransaction, PersistentTransaction persistentTransaction) {
        this.runtimeTransaction = runtimeTransaction;
        this.persistentTransaction = persistentTransaction;
    }

    public RuntimeTransaction getRuntimeTransaction() {
        return this.runtimeTransaction;
    }

    public void setRuntimeTransaction(RuntimeTransaction runtimeTransaction) {
        this.runtimeTransaction = runtimeTransaction;
    }

    public PersistentTransaction getPersistentTransaction() {
        return this.persistentTransaction;
    }

    public void setPersistentTransaction(PersistentTransaction persistentTransaction) {
        this.persistentTransaction = persistentTransaction;
    }

    public void make() throws WSDeploymentException, WSWarningException {
        Vector warnings = new Vector();
        try {
            this.persistentTransaction.make();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.runtimeTransaction.make();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void commit() throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.persistentTransaction.commit();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.runtimeTransaction.commit();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void rollback() throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.persistentTransaction.rollback();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.runtimeTransaction.rollback();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void makeRemote() throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.runtimeTransaction.makeRemote();
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }
}

