/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.system;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.server.event.EventListener;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.event.system.Transaction;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.tc.logging.Location;
import java.util.Vector;

public class RuntimeTransaction
implements Transaction {
    private Event event = null;
    private String[] dirs = new String[0];
    Configuration configuration = null;
    private EventListener[] eventListeners = new EventListener[0];

    public RuntimeTransaction() {
    }

    public RuntimeTransaction(Event event, String[] dirs, Configuration configuration, EventListener[] eventListeners) {
        this.event = event;
        this.dirs = dirs;
        this.configuration = configuration;
        this.eventListeners = eventListeners;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String[] getDirs() {
        return this.dirs;
    }

    public void setDirs(String[] dirs) {
        this.dirs = dirs;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public EventListener[] getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void make() throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occured, trying to make runtime transaction (make phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            String dir = this.dirs[i];
            try {
                eventListener.makeRuntimeChanges(this.event, dir, this.configuration);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void commit() throws WSWarningException {
        String excMsg = "Error occured, trying to make runtime transaction (commit phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            try {
                eventListener.commitRuntimeChanges(this.event.getStateStamp());
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void rollback() throws WSWarningException {
        String excMsg = "Error occured, trying to make runtime transaction (rollback phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            try {
                eventListener.rollbackRuntimeChanges(this.event.getStateStamp());
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void makeRemote() throws WSWarningException {
        String excMsg = "Error occured, trying to make runtime transaction (notify phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            String dir = this.dirs[i];
            try {
                eventListener.notifyRuntimeChanges(this.event, dir, this.configuration);
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }
}

