/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.system;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.server.event.EventFactory;
import com.sap.engine.interfaces.webservices.server.event.EventListener;
import com.sap.engine.interfaces.webservices.server.event.WSClientEvent;
import com.sap.engine.interfaces.webservices.server.event.WSEvent;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.event.system.Transaction;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.tc.logging.Location;
import java.util.Properties;
import java.util.Vector;

public class PersistentTransaction
implements Transaction {
    private Event event = null;
    private String[] dirs = new String[0];
    private Configuration configuration = null;
    private Configuration eventConfiguration = null;
    private Configuration rootEventConfiguration = null;
    private EventListener[] eventListeners = new EventListener[0];

    public PersistentTransaction() {
    }

    public PersistentTransaction(Event event, String[] dirs, Configuration configuration, Configuration eventConfiguration, Configuration rootEventConfiguration, EventListener[] eventListeners) {
        this.event = event;
        this.dirs = dirs;
        this.configuration = configuration;
        this.eventConfiguration = eventConfiguration;
        this.rootEventConfiguration = rootEventConfiguration;
        this.eventListeners = eventListeners;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String[] getDirs() {
        return this.dirs;
    }

    public void setDirs(String[] dirs) {
        this.dirs = dirs;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getEventConfiguration() {
        return this.eventConfiguration;
    }

    public void setEventConfiguration(Configuration eventConfiguration) {
        this.eventConfiguration = eventConfiguration;
    }

    public EventListener[] getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void make() throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occured, trying to make persistent transaction (make phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            String dir = this.dirs[i];
            try {
                eventListener.makePersistentChanges(this.event, dir, this.configuration);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        try {
            this.saveEvent();
        }
        catch (WSWarningException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void commit() throws WSWarningException {
        String excMsg = "Error occured, trying to make persistent transaction (commit phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            try {
                eventListener.commitPersistentChanges(this.event.getStateStamp());
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void rollback() throws WSWarningException {
        String excMsg = "Error occured, trying to make persistent transaction (rollback phase). ";
        if (this.eventListeners == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < this.eventListeners.length) {
            EventListener eventListener = this.eventListeners[i];
            try {
                eventListener.rollbackPersistentChanges(this.event.getStateStamp());
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void makeRemote() throws WSWarningException {
    }

    private void saveEvent() throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occured, trying to save event: " + this.event.getStateStamp() + ". ";
        String eventStateStamp = this.event.getStateStamp();
        Configuration instanceEventConfiguration = null;
        try {
            if (this.eventConfiguration != null) {
                instanceEventConfiguration = this.eventConfiguration.createSubConfiguration(eventStateStamp);
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocaton = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocaton.catching((Throwable)e);
            String msg = excMsg + "Unable to create DB configuration for the event instance. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (instanceEventConfiguration == null) {
            String msg = excMsg + "DB configuration for the event instance is null. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        EventFactory eventFactory = WSContainer.getEventContext().getEventFactoryRegistry().getFactory(this.event.getEventId());
        if (eventFactory == null) {
            String msg = excMsg + "No event factory registered for event " + this.event.getEventId() + ".";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        try {
            eventFactory.save(this.event, instanceEventConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Event factory could not save event " + eventStateStamp + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        catch (WSWarningException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Event factory generated some errrors, saving event " + eventStateStamp + ". ";
            WSWarningException wExc = new WSWarningException((Throwable)e);
            wExc.addWarnings(WSUtil.addPrefixToStrings(msg, e.getWarningsVector()));
            throw wExc;
        }
        this.saveMostRecentEventProps();
    }

    private void saveMostRecentEventProps() throws WSDeploymentException {
        String excMsg = "Error occured, trying to save most_recent_event DB configuration entry. ";
        Properties props = new Properties();
        props.setProperty("event_state_stamp", this.event.getStateStamp());
        props.setProperty("event_identifier", this.event.getEventId());
        if (this.event instanceof WSEvent) {
            WSEvent wsEvent = (WSEvent)this.event;
            props.setProperty("type", "webservices");
            props.setProperty("ws_config_name", wsEvent.getWSConfigName());
        } else if (this.event instanceof WSClientEvent) {
            WSClientEvent wsClientEvent = (WSClientEvent)this.event;
            props.setProperty("type", "wsClients");
            props.setProperty("wsclient_config_name", wsClientEvent.getWSClientConfigName());
        }
        try {
            if (this.rootEventConfiguration.existsConfigEntry("most_recent_event")) {
                this.rootEventConfiguration.modifyConfigEntry("most_recent_event", (Object)props);
            } else {
                this.rootEventConfiguration.addConfigEntry("most_recent_event", (Object)props);
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }
}

