/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.system;

import com.sap.engine.interfaces.webservices.server.event.EventListener;
import com.sap.engine.lib.util.HashMapObjectObject;
import java.util.Enumeration;

public class EventListenerRegistry {
    private HashMapObjectObject listeners = new HashMapObjectObject();

    public EventListenerRegistry() {
    }

    public EventListenerRegistry(HashMapObjectObject listeners) {
        this.listeners = listeners;
    }

    public HashMapObjectObject getListeners() {
        return this.listeners;
    }

    public void setListeners(HashMapObjectObject listeners) {
        this.listeners = listeners;
    }

    public boolean contains(String eventId) {
        return this.listeners.containsKey((Object)eventId);
    }

    public boolean contains(String eventId, String listenerId) {
        if (this.contains(eventId)) {
            HashMapObjectObject registeredListeners = (HashMapObjectObject)this.listeners.get((Object)eventId);
            return registeredListeners.contains((Object)listenerId);
        }
        return false;
    }

    public HashMapObjectObject registerListeners(String eventId, HashMapObjectObject eventListeners) {
        return (HashMapObjectObject)this.listeners.put((Object)eventId, (Object)eventListeners);
    }

    public void registerListener(String eventId, EventListener listener) {
        if (this.contains(eventId)) {
            HashMapObjectObject registeredListeners = (HashMapObjectObject)this.listeners.get((Object)eventId);
            registeredListeners.put((Object)listener.getIdentifier(), (Object)listener);
        } else {
            HashMapObjectObject newListeners = new HashMapObjectObject();
            newListeners.put((Object)listener.getIdentifier(), (Object)listener);
            this.listeners.put((Object)eventId, (Object)newListeners);
        }
    }

    public HashMapObjectObject getListeners(String eventId) {
        return (HashMapObjectObject)this.listeners.get((Object)eventId);
    }

    public EventListener getListener(String eventId, String listenerId) {
        EventListener eventListener = null;
        if (this.contains(eventId)) {
            HashMapObjectObject registeredListeners = (HashMapObjectObject)this.listeners.get((Object)eventId);
            eventListener = (EventListener)registeredListeners.get((Object)listenerId);
        }
        return eventListener;
    }

    public void unregisterListener(String eventId) {
        this.listeners.remove((Object)eventId);
    }

    public EventListener unregisterListener(String eventId, String listenerId) {
        EventListener eventListener = null;
        if (this.contains(eventId)) {
            HashMapObjectObject registeredListeners = (HashMapObjectObject)this.listeners.get((Object)eventId);
            eventListener = (EventListener)registeredListeners.remove((Object)listenerId);
            if (registeredListeners.isEmpty()) {
                this.listeners.remove((Object)eventId);
            }
        }
        return eventListener;
    }

    public EventListener[] listListeners(String eventId) {
        HashMapObjectObject eventListeners = (HashMapObjectObject)this.listeners.get((Object)eventId);
        if (eventListeners == null) {
            return new EventListener[0];
        }
        EventListener[] eventListenersArray = new EventListener[eventListeners.size()];
        Enumeration eventListenerEnum = eventListeners.elements();
        int i = 0;
        while (eventListenerEnum.hasMoreElements()) {
            eventListenersArray[i++] = (EventListener)eventListenerEnum.nextElement();
        }
        return eventListenersArray;
    }
}

