/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.event.system;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.server.event.EventFactory;
import com.sap.engine.interfaces.webservices.server.event.EventListener;
import com.sap.engine.interfaces.webservices.server.event.WSClientEvent;
import com.sap.engine.interfaces.webservices.server.event.WSEvent;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.event.system.PersistentTransaction;
import com.sap.engine.services.webservices.server.deploy.event.system.RuntimeTransaction;
import com.sap.engine.services.webservices.server.deploy.event.system.RuntimeTransactionContext;
import com.sap.engine.services.webservices.server.deploy.event.system.Runtime_PersistentTransaction;
import com.sap.engine.services.webservices.server.deploy.event.system.Transaction;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Properties;

public class EventHandler {
    private RuntimeTransactionContext transactionContext = new RuntimeTransactionContext();
    private DeployCommunicator deployCommunicator = null;

    public EventHandler() {
    }

    public EventHandler(DeployCommunicator deployCommunicator) {
        this.deployCommunicator = deployCommunicator;
    }

    public void init(DeployCommunicator deployCommunicator) {
        this.deployCommunicator = deployCommunicator;
    }

    public RuntimeTransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setTransactionContext(RuntimeTransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public DeployCommunicator getDeployCommunicator() {
        return this.deployCommunicator;
    }

    public void setDeployCommunicator(DeployCommunicator deployCommunicator) {
        this.deployCommunicator = deployCommunicator;
    }

    public void handle(Event event) throws WSDeploymentException {
        event.setStateStamp(event.getEventId() + "_" + System.currentTimeMillis());
        if (event instanceof WSEvent) {
            this.handleWSEvent((WSEvent)event);
        } else if (event instanceof WSClientEvent) {
            this.handleWSClientEvent((WSClientEvent)event);
        }
    }

    private void handleWSEvent(WSEvent wsEvent) throws WSDeploymentException {
        String eventId = wsEvent.getEventId();
        String applicationName = wsEvent.getApplicationName();
        String wsName = wsEvent.getWebServiceName();
        String excMsg = "Error occured, trying to handle web service event. Unable to make runtime changes for application " + applicationName + ", web service " + wsName + ". ";
        EventListener[] eventListeners = WSContainer.getEventContext().getEventListenerRegistry().listListeners(eventId);
        boolean needRestart = this.needRestart((Event)wsEvent, eventListeners);
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSContainer.getWSRegistry().getWebService(applicationName, wsName);
        }
        catch (RegistryException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to get (find) web service. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        String wsDir = wsRuntimeDefinition.getWsDirsHandler().getWsDirectory();
        String[] listenersDirs = this.getListenerDirs(wsDir, this.getOwnerIds(eventListeners));
        Configuration appConfiguration = null;
        try {
            appConfiguration = this.deployCommunicator.startRuntimeChanges(applicationName);
        }
        catch (DeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Deploy Service can not start runtime changes. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Configuration wsConfiguration = null;
        Configuration rootEventConfiguration = null;
        Configuration wsEventConfiguration = null;
        try {
            String wsConfigName = wsRuntimeDefinition.getWsDirsHandler().getWSConfigName();
            wsEvent.setWSConfigName(wsConfigName);
            wsConfiguration = this.getWSConfiguration(wsConfigName, appConfiguration);
            rootEventConfiguration = this.getRootEventConfiguration(appConfiguration);
            wsEventConfiguration = this.getWSEventConfiguration(wsConfigName, appConfiguration);
        }
        catch (Throwable th) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(th);
            String rawMsg = "Unable to get web service, \"event\" or web service event configuration. ";
            try {
                this.deployCommunicator.rollbackRuntimeChanges(applicationName);
            }
            catch (RemoteException rExc) {
                wsDeployLocation.catching((Throwable)rExc);
                String msg = excMsg + "Deploy Service could not rollback runtime changes. Reason for rollback is: " + rawMsg;
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)rExc);
            }
            String msg = excMsg + rawMsg;
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, th);
        }
        if (wsConfiguration == null || wsEventConfiguration == null || rootEventConfiguration == null) {
            String rawMsg = "Web Service, \"event\" or web service event DB configuration is null. ";
            try {
                this.deployCommunicator.rollbackRuntimeChanges(applicationName);
            }
            catch (RemoteException rExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)rExc);
                String msg = excMsg + "Deploy Service could not rollback runtime changes. Reason for rollback is: " + rawMsg;
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)rExc);
            }
            String msg = excMsg + rawMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        Transaction transaction = null;
        transaction = needRestart ? new PersistentTransaction((Event)wsEvent, listenersDirs, wsConfiguration, wsEventConfiguration, rootEventConfiguration, eventListeners) : new Runtime_PersistentTransaction((Event)wsEvent, listenersDirs, wsConfiguration, wsEventConfiguration, rootEventConfiguration, eventListeners);
        this.transactionContext.putTransaction(applicationName, transaction);
        try {
            this.deployCommunicator.makeRuntimeChanges(applicationName, needRestart);
        }
        catch (RemoteException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Deploy Service could not make runtime changes. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void handleWSClientEvent(WSClientEvent wsClientEvent) throws WSDeploymentException {
        String eventId = wsClientEvent.getEventId();
        String applicationName = wsClientEvent.getApplicationName();
        String wsClientName = wsClientEvent.getWSClientName();
        String excMsg = "Error occured, trying to handle web service event. Unable to make runtime changes for application " + applicationName + ", web service " + wsClientName + ". ";
        EventListener[] eventListeners = WSContainer.getEventContext().getEventListenerRegistry().listListeners(eventId);
        boolean needRestart = this.needRestart((Event)wsClientEvent, eventListeners);
        WSClientRuntimeInfo wsClientRuntimeInfo = null;
        try {
            wsClientRuntimeInfo = WSContainer.getWsClientRegistry().getWSClient(applicationName, wsClientName);
        }
        catch (RegistryException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to get (find) web service. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        String wsClientDir = wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientDirectory();
        String[] listenersDirs = this.getListenerDirs(wsClientDir, this.getOwnerIds(eventListeners));
        Configuration appConfiguration = null;
        try {
            appConfiguration = this.deployCommunicator.startRuntimeChanges(applicationName);
        }
        catch (DeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Deploy Service can not start runtime changes. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Configuration wsClientConfiguration = null;
        Configuration rootEventConfiguration = null;
        Configuration wsClientEventConfiguration = null;
        try {
            String wsClientConfigName = wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientConfigName();
            wsClientEvent.setWSClientConfigName(wsClientConfigName);
            wsClientConfiguration = this.getWSClientConfiguration(wsClientConfigName, appConfiguration);
            rootEventConfiguration = this.getRootEventConfiguration(appConfiguration);
            wsClientEventConfiguration = this.getWSClientEventConfiguration(wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientConfigName(), appConfiguration);
        }
        catch (Throwable th) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(th);
            String rawMsg = "Unable to get ws client, \"event\" or ws client event configuration. ";
            try {
                this.deployCommunicator.rollbackRuntimeChanges(applicationName);
                throw new RemoteException();
            }
            catch (RemoteException rExc) {
                wsDeployLocation.catching((Throwable)rExc);
                String intMsg = excMsg + "Deploy Service could not rollback runtime changes. Reason for rollback is: " + rawMsg;
                Object[] args = new String[]{intMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)rExc);
            }
        }
        if (wsClientConfiguration == null || wsClientEventConfiguration == null) {
            String rawMsg = "WS client, \"event\" or ws client event DB configuration is null. ";
            try {
                this.deployCommunicator.rollbackRuntimeChanges(applicationName);
            }
            catch (RemoteException rExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)rExc);
                String intMsg = excMsg + "Deploy Service could not rollback runtime changes. Reason for rollback is: " + rawMsg;
                Object[] args = new String[]{intMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)rExc);
            }
            String msg = excMsg + rawMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        Transaction transaction = null;
        transaction = needRestart ? new PersistentTransaction((Event)wsClientEvent, listenersDirs, wsClientConfiguration, wsClientEventConfiguration, rootEventConfiguration, eventListeners) : new Runtime_PersistentTransaction((Event)wsClientEvent, listenersDirs, wsClientConfiguration, wsClientEventConfiguration, rootEventConfiguration, eventListeners);
        this.transactionContext.putTransaction(applicationName, transaction);
        try {
            this.deployCommunicator.makeRuntimeChanges(applicationName, needRestart);
        }
        catch (RemoteException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Deploy Service could not make runtime changes. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public void makeRuntimeChanges(String applicationName) throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occured, making runtime changes for application: " + applicationName + ". ";
        Transaction transaction = this.transactionContext.getTransaction(applicationName);
        if (transaction == null) {
            String msg = excMsg + "Unexpected error - no transaction registered for the application. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        transaction.make();
    }

    public void commitRuntimeChanges(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, making runtime changes (commit phase) for application: " + applicationName + ". ";
        Transaction transaction = this.transactionContext.getTransaction(applicationName);
        if (transaction == null) {
            String msg = excMsg + "Unexpected error - no transaction registered for the application. ";
            WSWarningException e = new WSWarningException();
            e.addWarning(msg);
            throw e;
        }
        transaction.commit();
        this.transactionContext.removeTransaction(applicationName);
    }

    public void rollbackRuntimeChanges(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, making runtime changes (rollback phase) for application: " + applicationName + ". ";
        Transaction transaction = this.transactionContext.getTransaction(applicationName);
        if (transaction == null) {
            String msg = excMsg + "Unexpected error - no transaction registered for the application. ";
            WSWarningException e = new WSWarningException();
            e.addWarning(msg);
            throw e;
        }
        transaction.rollback();
        this.transactionContext.removeTransaction(applicationName);
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured, making runtime changes (makeRemote phase) for application: " + applicationName + ". ";
        Event event = null;
        try {
            event = this.loadMostRecentEvent(applicationName, appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            e.printStackTrace();
            String msg = excMsg + "Unalbe to load most recent event from DB. ";
            WSWarningException wExc = new WSWarningException((Throwable)e);
            wExc.addWarning(msg);
            throw wExc;
        }
        try {
            this.handleRemoteEvent(event, appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to proces event. Event id: " + event.getEventId() + ", event state stamp " + event.getStateStamp() + ". ";
            WSWarningException wExc = new WSWarningException((Throwable)e);
            wExc.addWarning(msg);
            throw wExc;
        }
        Transaction transaction = this.transactionContext.getTransaction(applicationName);
        if (transaction == null) {
            String msg = excMsg + "Unexpected error - no transaction registered for the application. ";
            WSWarningException e = new WSWarningException();
            e.addWarning(msg);
            throw e;
        }
        transaction.makeRemote();
        this.transactionContext.removeTransaction(applicationName);
    }

    public void handleRemoteEvent(Event event, Configuration appConfiguration) throws WSDeploymentException {
        if (event instanceof WSEvent) {
            this.handleRemoteWSEvent((WSEvent)event, appConfiguration);
        } else if (event instanceof WSClientEvent) {
            this.handleRemoteWSClientEvent((WSClientEvent)event, appConfiguration);
        }
    }

    public void handleRemoteWSEvent(WSEvent wsEvent, Configuration appConfiguration) throws WSDeploymentException {
        String eventId = wsEvent.getEventId();
        String applicationName = wsEvent.getApplicationName();
        String wsName = wsEvent.getWebServiceName();
        String excMsg = "Error occured, trying to handle web service event. Unable to make remote runtime changes for application " + applicationName + ", web service " + wsName + ". ";
        EventListener[] eventListeners = WSContainer.getEventContext().getEventListenerRegistry().listListeners(eventId);
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSContainer.getWSRegistry().getWebService(applicationName, wsName);
        }
        catch (RegistryException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to get (find) web service. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        String wsDir = wsRuntimeDefinition.getWsDirsHandler().getWsDirectory();
        String[] listenersDirs = this.getListenerDirs(wsDir, this.getOwnerIds(eventListeners));
        Configuration wsConfiguration = null;
        try {
            wsConfiguration = this.getWSConfiguration(wsRuntimeDefinition.getWsDirsHandler().getWSConfigName(), appConfiguration);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get web service, \"" + "event" + "\" or web service event configuration. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Runtime_PersistentTransaction transaction = new Runtime_PersistentTransaction(new RuntimeTransaction((Event)wsEvent, listenersDirs, wsConfiguration, eventListeners), null);
        this.transactionContext.putTransaction(applicationName, transaction);
    }

    public void handleRemoteWSClientEvent(WSClientEvent wsClientEvent, Configuration appConfiguration) throws WSDeploymentException {
        String eventId = wsClientEvent.getEventId();
        String applicationName = wsClientEvent.getApplicationName();
        String wsClientName = wsClientEvent.getWSClientName();
        String excMsg = "Error occured, trying to handle web service event. Unable to make remote runtime changes for application " + applicationName + ", web service " + wsClientName + ". ";
        EventListener[] eventListeners = WSContainer.getEventContext().getEventListenerRegistry().listListeners(eventId);
        WSClientRuntimeInfo wsClientRuntimeInfo = null;
        try {
            wsClientRuntimeInfo = WSContainer.getWsClientRegistry().getWSClient(applicationName, wsClientName);
        }
        catch (RegistryException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to get (find) web service. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        String wsClientDir = wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientDirectory();
        String[] listenersDirs = this.getListenerDirs(wsClientDir, this.getOwnerIds(eventListeners));
        Configuration wsClientConfiguration = null;
        try {
            wsClientConfiguration = this.getWSClientConfiguration(wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientConfigName(), appConfiguration);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get web service, \"" + "event" + "\" or web service event configuration. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Runtime_PersistentTransaction transaction = new Runtime_PersistentTransaction(new RuntimeTransaction((Event)wsClientEvent, listenersDirs, wsClientConfiguration, eventListeners), null);
        this.transactionContext.putTransaction(applicationName, transaction);
    }

    private boolean needRestart(Event event, EventListener[] eventListeners) {
        if (eventListeners == null) {
            return false;
        }
        int i = 0;
        while (i < eventListeners.length) {
            EventListener eventListener = eventListeners[i];
            if (eventListener.needRestart(event)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Configuration getWSConfiguration(String wsConfigName, Configuration appConfiguration) throws ConfigurationException {
        Configuration wsConfiguration = null;
        Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
        Configuration webservicesConfiguration = null;
        if (wsContainerConfiguration != null) {
            webservicesConfiguration = wsContainerConfiguration.getSubConfiguration("webservices");
        }
        if (webservicesConfiguration != null) {
            wsConfiguration = webservicesConfiguration.getSubConfiguration(wsConfigName);
        }
        return wsConfiguration;
    }

    private Configuration getWSClientConfiguration(String wsClientConfigName, Configuration appConfiguration) throws ConfigurationException {
        Configuration wsConfiguration = null;
        Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
        Configuration wsClientsConfiguration = null;
        if (wsContainerConfiguration != null) {
            wsClientsConfiguration = wsContainerConfiguration.getSubConfiguration("wsClients");
        }
        if (wsClientsConfiguration != null) {
            wsConfiguration = wsClientsConfiguration.getSubConfiguration(wsClientConfigName);
        }
        return wsConfiguration;
    }

    private Configuration getRootEventConfiguration(Configuration appConfiguration) throws ConfigurationException {
        Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
        Configuration eventsConfiguration = null;
        if (wsContainerConfiguration != null) {
            eventsConfiguration = wsContainerConfiguration.existsSubConfiguration("event") ? wsContainerConfiguration.getSubConfiguration("event") : wsContainerConfiguration.createSubConfiguration("event");
        }
        return eventsConfiguration;
    }

    private Configuration getWSEventConfiguration(String wsName, Configuration appConfiguration) throws ConfigurationException {
        Configuration wsConfiguration = null;
        Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
        Configuration eventsConfiguration = null;
        if (wsContainerConfiguration != null) {
            eventsConfiguration = wsContainerConfiguration.existsSubConfiguration("event") ? wsContainerConfiguration.getSubConfiguration("event") : wsContainerConfiguration.createSubConfiguration("event");
        }
        Configuration webservicesConfiguration = null;
        if (eventsConfiguration != null) {
            webservicesConfiguration = eventsConfiguration.existsSubConfiguration("webservices") ? eventsConfiguration.getSubConfiguration("webservices") : eventsConfiguration.createSubConfiguration("webservices");
        }
        if (webservicesConfiguration != null) {
            wsConfiguration = webservicesConfiguration.existsSubConfiguration(wsName) ? webservicesConfiguration.getSubConfiguration(wsName) : webservicesConfiguration.createSubConfiguration(wsName);
        }
        return wsConfiguration;
    }

    private Configuration getWSClientEventConfiguration(String wsClientName, Configuration appConfiguration) throws ConfigurationException {
        Configuration wsClientConfiguration = null;
        Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
        Configuration eventsConfiguration = null;
        if (wsContainerConfiguration != null) {
            eventsConfiguration = wsContainerConfiguration.existsSubConfiguration("event") ? wsContainerConfiguration.getSubConfiguration("event") : wsContainerConfiguration.createSubConfiguration("event");
        }
        Configuration wsClientsConfiguration = null;
        if (eventsConfiguration != null) {
            wsClientsConfiguration = eventsConfiguration.existsSubConfiguration("wsClients") ? eventsConfiguration.getSubConfiguration("wsClients") : eventsConfiguration.createSubConfiguration("wsClients");
        }
        if (wsClientsConfiguration != null) {
            wsClientConfiguration = wsClientsConfiguration.existsSubConfiguration(wsClientName) ? wsClientsConfiguration.getSubConfiguration(wsClientName) : wsClientsConfiguration.createSubConfiguration(wsClientName);
        }
        return wsClientConfiguration;
    }

    private Event loadMostRecentEvent(String applicationName, Configuration appConfiguration) throws WSDeploymentException, WSWarningException {
        String excMsg = "Error occurred, trying to load most recent event for application: " + applicationName + ". ";
        Properties props = null;
        try {
            props = this.loadMostRecentEventProps(appConfiguration);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to load most recent event properties. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String eventStateStamp = props.getProperty("event_state_stamp");
        String eventId = props.getProperty("event_identifier");
        Configuration eventConfiguration = null;
        String wsConfigName = null;
        String type = props.getProperty("type");
        try {
            if (type.equals("webservices")) {
                wsConfigName = props.getProperty("ws_config_name");
                eventConfiguration = this.getWSEventConfiguration(wsConfigName, appConfiguration);
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get web service event configuration with state stamp: " + eventStateStamp + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsClientConfigName = null;
        try {
            if (type.equals("wsClients")) {
                wsClientConfigName = props.getProperty("wsclient_config_name");
                eventConfiguration = this.getWSClientEventConfiguration(wsClientConfigName, appConfiguration);
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get ws client event configuration with state stamp: " + eventStateStamp + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Configuration instanceEventConfiguration = null;
        try {
            instanceEventConfiguration = eventConfiguration.getSubConfiguration(eventStateStamp);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get event instance DB configuration with state stamp: " + eventStateStamp + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        EventFactory eventFactory = WSContainer.getEventContext().getEventFactoryRegistry().getFactory(eventId);
        if (eventFactory == null) {
            String msg = excMsg + "No event factory registered for event " + eventId + ".";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        Event event = null;
        try {
            event = eventFactory.load(instanceEventConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Event factory could not load event " + eventStateStamp + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        catch (WSWarningException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Event factory generated some errors, loading event " + eventStateStamp + ". ";
            WSWarningException wExc = new WSWarningException((Throwable)e);
            wExc.addWarnings(WSUtil.addPrefixToStrings(msg, e.getWarningsVector()));
            throw wExc;
        }
        return event;
    }

    private Properties loadMostRecentEventProps(Configuration appConfiguration) throws ConfigurationException {
        Configuration rootEventConfiguration = this.getRootEventConfiguration(appConfiguration);
        return (Properties)rootEventConfiguration.getConfigEntry("most_recent_event");
    }

    private String[] getOwnerIds(EventListener[] eventListeners) {
        if (eventListeners == null) {
            return new String[0];
        }
        String[] listenersIds = new String[eventListeners.length];
        int i = 0;
        while (i < eventListeners.length) {
            listenersIds[i] = eventListeners[i].getOwnerIdentifier();
            ++i;
        }
        return listenersIds;
    }

    private String[] getDirs(String baseDir, String[] relativeDirs) {
        if (baseDir == null) {
            return new String[0];
        }
        String[] dirs = new String[relativeDirs.length];
        int i = 0;
        while (i < relativeDirs.length) {
            String dir;
            String relativeDir = relativeDirs[i];
            dirs[i] = dir = baseDir + '/' + relativeDir;
            ++i;
        }
        return dirs;
    }

    private String[] getListenerDirs(String baseDir, String[] listenerIds) {
        if (listenerIds == null) {
            return new String[0];
        }
        String[] listenerRelDirs = new String[listenerIds.length];
        int i = 0;
        while (i < listenerIds.length) {
            listenerRelDirs[i] = WSUtil.replaceForbiddenChars(listenerIds[i]);
            ++i;
        }
        return this.getDirs(baseDir, listenerRelDirs);
    }
}

