/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.descriptors.vi;

import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.wsdl.DefinitionsHolder;
import com.sap.engine.services.webservices.runtime.wsdl.SchemaConvertor;
import com.sap.engine.services.webservices.runtime.wsdl.ServiceGenerator;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLPortTypeGenerator;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VInterfaceParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceState;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitionsParser;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLImport;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;

public class WSDLAbstractGeneratorImpl {
    private static final String DOCUMENT_STYLE = "document";
    private static final String RPC_STYLE = "rpc";
    private static WSDLDefinitionsParser parser = new WSDLDefinitionsParser();

    public static void generatePortTypesWSDL(String wsdName, String wsdDocumentation, InputStream[] viStreams, String[] rpcLocations, String[] docLocations, OutputStream resultOutput) throws Exception {
        VirtualInterfaceState[] viStates = new VirtualInterfaceState[viStreams.length];
        if (viStates.length != rpcLocations.length || viStates.length != docLocations.length) {
            throw new Exception("VI.length: " + viStates.length + " rpcLocations.length: " + rpcLocations.length + " docLocations.length: " + docLocations.length);
        }
        WSDLDefinitions definitions = new WSDLDefinitions();
        definitions.setName(wsdName);
        if (wsdDocumentation != null) {
            WSDLDocumentation documentation = new WSDLDocumentation();
            documentation.setContent(new CharArray(wsdDocumentation));
            definitions.setDocumentation(documentation);
        }
        ArrayList<WSDLImport> imports = new ArrayList<WSDLImport>();
        definitions.targetNamespace = WSDLAbstractGeneratorImpl.getMainDefinitionsTNS(wsdName);
        int i = 0;
        while (i < viStates.length) {
            viStates[i] = VInterfaceParser.getVInterface(viStreams[i]);
            String targetNamespace = WSDLAbstractGeneratorImpl.getTargetNamespaceForVI(wsdName, viStates[i].getName(), DOCUMENT_STYLE);
            imports.add(new WSDLImport(null, docLocations[i], targetNamespace));
            ++i;
        }
        definitions.setImportDeclaratuions(imports);
        WSDLDefinitionsParser wSDLDefinitionsParser = parser;
        synchronized (wSDLDefinitionsParser) {
            parser.writeDefintionsToStream(definitions, resultOutput);
            parser.init();
        }
    }

    public static void generateDocumentPortType(String wsdName, InputStream viInputStream, OutputStream resultStream) throws Exception {
        VirtualInterfaceState viState = VInterfaceParser.getVInterface(viInputStream);
        VIStruct viStruct = WSDLAbstractGeneratorImpl.parseVIType(viState, wsdName, DOCUMENT_STYLE);
        Struct str = WSDLAbstractGeneratorImpl.processVirtualTypes(viState);
        String targetNamespace = WSDLAbstractGeneratorImpl.getTargetNamespaceForVI(wsdName, viState.getName(), DOCUMENT_STYLE);
        String operationsNS = WSDLAbstractGeneratorImpl.getOperationsNS(wsdName, viState.getName());
        DefinitionsHolder holder = WSDLPortTypeGenerator.generateDocumentLiteralPortType(str.mappingRegistry, str.schemas, viStruct.operations, targetNamespace, operationsNS, WSDLAbstractGeneratorImpl.getPortTypeName(viState.getName(), DOCUMENT_STYLE));
        WSDLDefinitions definitions = holder.getDefinitions();
        WSDLDefinitionsParser wSDLDefinitionsParser = parser;
        synchronized (wSDLDefinitionsParser) {
            parser.writeDefintionsToStream(definitions, resultStream);
            parser.init();
        }
    }

    public static void generateRPCPortType(String wsdName, InputStream viInputStream, OutputStream resultStream) throws Exception {
        VirtualInterfaceState viState = VInterfaceParser.getVInterface(viInputStream);
        VIStruct viStruct = WSDLAbstractGeneratorImpl.parseVIType(viState, wsdName, RPC_STYLE);
        Struct str = WSDLAbstractGeneratorImpl.processVirtualTypes(viState);
        String targetNamespace = WSDLAbstractGeneratorImpl.getTargetNamespaceForVI(wsdName, viState.getName(), RPC_STYLE);
        String operationsNS = WSDLAbstractGeneratorImpl.getOperationsNS(wsdName, viState.getName());
        DefinitionsHolder holder = WSDLPortTypeGenerator.generateRPCLiteralPortType(str.mappingRegistry, str.schemas, viStruct.operations, targetNamespace, WSDLAbstractGeneratorImpl.getPortTypeName(viState.getName(), RPC_STYLE), operationsNS);
        WSDLDefinitions definitions = holder.getDefinitions();
        WSDLDefinitionsParser wSDLDefinitionsParser = parser;
        synchronized (wSDLDefinitionsParser) {
            parser.writeDefintionsToStream(definitions, resultStream);
            parser.init();
        }
    }

    public void generate(OutputStream resultStream, InputStream wsdInputStream, InputStream[] viInputStreams, String[] guid, int type) throws Exception {
    }

    private static String getOperationsNS(String wsdName, String viName) {
        return "urn:" + wsdName + "/" + viName;
    }

    private static String getTargetNamespaceForVI(String wsdName, String viName, String style) {
        return "urn:" + wsdName + "/" + viName + "/" + style;
    }

    private static String getMainDefinitionsTNS(String wsdName) {
        return "urn:" + wsdName;
    }

    private static VIStruct parseVIType(VirtualInterfaceState viState, String wsdName, String style) throws Exception {
        ServiceEndpointDefinition def = new ServiceEndpointDefinition();
        WSDefinitionFactory wsF = new WSDefinitionFactory();
        wsF.parseVInterface(null, def, viState, wsdName);
        def.setPortTypeName(new QName("", viState.getName()));
        VIStruct struct = new VIStruct();
        struct.operations = def.getOperations();
        struct.state = viState;
        return struct;
    }

    private static Struct processVirtualTypes(VirtualInterfaceState viState) throws Exception {
        SchemaConvertor convertor = new SchemaConvertor();
        Struct str = new Struct();
        str.schemas = convertor.parseInLiteralMode(viState);
        JavaToQNameMappingRegistryImpl registry = new JavaToQNameMappingRegistryImpl();
        registry.setLiteralMappings(convertor.getJavaToQNameMappings());
        str.mappingRegistry = registry;
        return str;
    }

    private static String getPortTypeName(String viName, String ptStyle) {
        return viName + "_" + ServiceGenerator.getUpperLetteredString(ptStyle);
    }

    private static class VIStruct {
        OperationDefinition[] operations;
        VirtualInterfaceState state;

        private VIStruct() {
        }
    }

    private static class Struct {
        DOMSource[] schemas;
        JavaToQNameMappingRegistry mappingRegistry;

        private Struct() {
        }
    }
}

