/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.common.update;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployResult;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateInfo;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateResult;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ModuleUpdateProcessor {
    private JarUtil jarUtil = null;
    private ModuleDeployGenerator moduleDeployGenerator = null;
    private ModuleFileStorageHandler moduleFileStorageHandler = null;

    public ModuleUpdateProcessor(ModuleDeployGenerator moduleDeployGenerator, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.moduleDeployGenerator = moduleDeployGenerator;
        this.moduleFileStorageHandler = moduleFileStorageHandler;
        this.jarUtil = new JarUtil();
    }

    public Hashtable collectNotChangedModules(File[] moduleArchivesNew, Hashtable moduleCrcOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect not updated modules. ";
        if (moduleArchivesNew == null) {
            return new Hashtable();
        }
        Hashtable<String, File> notChangedModules = new Hashtable<String, File>();
        int i = 0;
        while (i < moduleArchivesNew.length) {
            File moduleArchiveNew = moduleArchivesNew[i];
            String moduleName = moduleArchiveNew.getName();
            try {
                if (moduleCrcOld.containsKey(moduleName)) {
                    byte[] oldCrc = (byte[])moduleCrcOld.get(moduleName);
                    byte[] newCrc = HashUtils.generateFileHash((File)moduleArchiveNew);
                    if (HashUtils.compareHash((byte[])newCrc, (byte[])oldCrc)) {
                        notChangedModules.put(moduleName, moduleArchiveNew);
                    }
                }
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Unable to process module " + moduleArchiveNew.getAbsolutePath() + ". ";
                Object[] args = new String[]{msg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
        return notChangedModules;
    }

    public String[] collectNotChangedWSComponentsPerModules(Set notChangedModules, String wsComponentDir) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect not changed ws components per module. ";
        Properties wsComponentsPerModule = null;
        try {
            wsComponentsPerModule = this.hasDeployedComponentsPerModuleFile(wsComponentDir) ? this.loadProperties(ModuleDirsHandler.getDeployedComponentsPerModulePath(wsComponentDir)) : new Properties();
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Properties notChangedWSComponentsPerModule = WSUtil.filterProperties(notChangedModules, wsComponentsPerModule);
        return WSUtil.collectStringProperties(notChangedWSComponentsPerModule, ";");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadProperties(String propertiesPath) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load " + propertiesPath + ". ";
        Properties mappings = new Properties();
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(propertiesPath);
                mappings.load(in);
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg;
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var10_5 = null;
            if (in == null) return mappings;
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        in.close();
        return mappings;
    }

    public ModuleUpdateResult updateModuleFiles(String applicationName, String wsComponentDir, File[] moduleArchives, Hashtable notChangedModuleArchives, Configuration appConfiguration, String wsComponentConfigName) throws WSDeploymentException {
        if (this.hasModuleMappingsFile(wsComponentDir)) {
            return this.updateModuleFiles(applicationName, wsComponentDir, moduleArchives, notChangedModuleArchives, appConfiguration, wsComponentConfigName, true);
        }
        return this.updateModuleFiles(applicationName, wsComponentDir, moduleArchives, notChangedModuleArchives, appConfiguration, wsComponentConfigName, false);
    }

    private ModuleUpdateResult updateModuleFiles(String applicationName, String wsComponentDir, File[] moduleArchives, Hashtable notChangedModuleArchives, Configuration appConfiguration, String wsComponentConfigName, boolean isVersion70) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update module files for application " + applicationName + ". ";
        ModuleUpdateResult moduleUpdateResult = null;
        moduleUpdateResult = isVersion70 ? this.updateModuleFiles70(applicationName, wsComponentDir, moduleArchives, notChangedModuleArchives) : this.updateModuleFiles630(applicationName, wsComponentDir, moduleArchives, notChangedModuleArchives);
        try {
            if (moduleUpdateResult.hasDeletedModules() || moduleUpdateResult.hasChangedModules() || moduleUpdateResult.hasDeployedModules()) {
                this.moduleFileStorageHandler.saveModuleMappings(wsComponentDir, moduleUpdateResult.getModuleMappings());
                WSConfigurationHandler.uploadModuleJarsDir(new File(ModuleDirsHandler.getAppJarsDir(wsComponentDir)), moduleUpdateResult.getModuleCrcTable(), WSConfigurationHandler.getAndMakeConfiguration(appConfiguration, wsComponentConfigName));
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to save " + ModuleDirsHandler.getModuleMappingsFileName() + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return moduleUpdateResult;
    }

    private ModuleUpdateResult updateModuleFiles70(String applicationName, String wsComponentDir, File[] moduleArchives, Hashtable notChangedModuleArchives) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update module files for application " + applicationName + ". ";
        Properties moduleMappingsOld = null;
        try {
            moduleMappingsOld = this.loadProperties(ModuleDirsHandler.getModuleMappingsPath(wsComponentDir));
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Hashtable modulesNew = this.collectFilesTable(moduleArchives);
        Hashtable modulesChanged = WSUtil.makeSubtraction(modulesNew, notChangedModuleArchives);
        Properties moduleMappingsNotChanged = WSUtil.makeIntersection(moduleMappingsOld, notChangedModuleArchives);
        Properties moduleMappingsOldChanged = WSUtil.makeSubtraction(moduleMappingsOld, notChangedModuleArchives);
        ModuleUpdateInfo wsModuleUpdateInfo = this.collectWSModuleUpdateInfo70(modulesChanged, moduleMappingsOldChanged);
        ModuleUpdateResult moduleUpdateResultNotChanged = null;
        ModuleUpdateResult moduleUpdateResultChanged = null;
        try {
            moduleUpdateResultNotChanged = this.defineModuleUpdateResult(applicationName, wsComponentDir, this.getFilesArray(notChangedModuleArchives), moduleMappingsNotChanged, false);
            moduleUpdateResultChanged = this.updateModuleFiles0(applicationName, wsComponentDir, wsModuleUpdateInfo);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        ModuleUpdateResult moduleUpdateResultFinal = new ModuleUpdateResult();
        moduleUpdateResultFinal.addModuleUpdateResult(moduleUpdateResultNotChanged);
        moduleUpdateResultFinal.addModuleUpdateResult(moduleUpdateResultChanged);
        return moduleUpdateResultFinal;
    }

    private ModuleUpdateResult updateModuleFiles630(String applicationName, String wsComponentDir, File[] moduleArchives, Hashtable notChangedModuleArchives) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update module files for application " + applicationName + ". ";
        Hashtable modulesNew = this.collectFilesTable(moduleArchives);
        Hashtable modulesChanged = WSUtil.makeSubtraction(modulesNew, notChangedModuleArchives);
        Properties defaultModuleMappingsAll = ModuleDirsHandler.generateDefaultModuleMappings(new File(ModuleDirsHandler.getAppJarsDir(wsComponentDir)).listFiles());
        Hashtable mappedNotChangedModuleArchives = this.mapFilesTable(notChangedModuleArchives);
        Properties moduleMappingsNotChanged = this.collectNotMappedModuleMappings(notChangedModuleArchives, WSUtil.makeIntersection(defaultModuleMappingsAll, mappedNotChangedModuleArchives));
        Properties defaultModuleMappingsOld = WSUtil.makeSubtraction(defaultModuleMappingsAll, mappedNotChangedModuleArchives);
        ModuleUpdateInfo wsModuleUpdateInfo = this.collectWSModuleUpdateInfo630(modulesChanged, defaultModuleMappingsOld);
        ModuleUpdateResult moduleUpdateResultNotChanged = null;
        ModuleUpdateResult moduleUpdateResultChanged = null;
        try {
            moduleUpdateResultNotChanged = this.defineModuleUpdateResult(applicationName, wsComponentDir, this.getFilesArray(notChangedModuleArchives), moduleMappingsNotChanged, false);
            moduleUpdateResultChanged = this.updateModuleFiles0(applicationName, wsComponentDir, wsModuleUpdateInfo);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        ModuleUpdateResult moduleUpdateResultFinal = new ModuleUpdateResult();
        moduleUpdateResultFinal.addModuleUpdateResult(moduleUpdateResultNotChanged);
        moduleUpdateResultFinal.addModuleUpdateResult(moduleUpdateResultChanged);
        return moduleUpdateResultFinal;
    }

    private ModuleUpdateResult updateModuleFiles0(String applicationName, String wsComponentDir, ModuleUpdateInfo wsModuleUpdateInfo) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update module files for application " + applicationName + ". ";
        ModuleUpdateResult moduleUpdateResultFinal = new ModuleUpdateResult();
        try {
            this.deleteModules(wsComponentDir, wsModuleUpdateInfo.getModuleMappingsForDelete());
            ModuleUpdateResult moduleUpdateResult = this.updateModules(wsComponentDir, wsModuleUpdateInfo.getModulesForUpdateNewFiles(), wsModuleUpdateInfo.getModulesForUpdateOldMappings());
            ModuleDeployResult moduleDeployResult = this.deployModules(applicationName, wsComponentDir, wsModuleUpdateInfo.getModulesForDeploy());
            moduleUpdateResultFinal.addModuleUpdateResult(moduleDeployResult);
            moduleUpdateResultFinal.addModuleUpdateResult(moduleUpdateResult);
            moduleUpdateResultFinal.setHasDeletedModules(((Hashtable)wsModuleUpdateInfo.getModuleMappingsForDelete()).size() != 0);
            moduleUpdateResultFinal.setHasDeployedModules(wsModuleUpdateInfo.getModulesForDeploy().length != 0);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return moduleUpdateResultFinal;
    }

    private ModuleUpdateInfo collectWSModuleUpdateInfo70(Hashtable modulesNew, Properties moduleMappingsOld) {
        Hashtable modulesForDeploy = WSUtil.makeSubtraction(modulesNew, (Hashtable)moduleMappingsOld);
        Properties moduleMappingsForDelete = WSUtil.makeSubtraction(moduleMappingsOld, modulesNew);
        Hashtable modulesForUpdateNewFiles = WSUtil.makeIntersection(modulesNew, (Hashtable)moduleMappingsOld);
        Properties modulesForUpdateOldMappings = WSUtil.makeIntersection(moduleMappingsOld, modulesNew);
        ModuleUpdateInfo wsModuleUpdateInfo = new ModuleUpdateInfo();
        wsModuleUpdateInfo.setModulesForDeploy(IOUtil.collectFiles(modulesForDeploy));
        wsModuleUpdateInfo.setModuleMappingsForDelete(moduleMappingsForDelete);
        wsModuleUpdateInfo.setModulesForUpdateNewFiles(modulesForUpdateNewFiles);
        wsModuleUpdateInfo.setModulesForUpdateOldMappings(modulesForUpdateOldMappings);
        return wsModuleUpdateInfo;
    }

    private ModuleUpdateInfo collectWSModuleUpdateInfo630(Hashtable modulesNew, Properties moduleMappingsOld) {
        Hashtable mappedFilesTable = this.mapFilesTable(modulesNew);
        Hashtable modulesForDeploy = this.filterWithMappedFilesTable(modulesNew.keySet(), WSUtil.makeSubtraction(mappedFilesTable, (Hashtable)moduleMappingsOld));
        Properties moduleMappingsForDelete = WSUtil.makeSubtraction(moduleMappingsOld, mappedFilesTable);
        Hashtable modulesForUpdateNewFiles = this.filterWithMappedFilesTable(modulesNew.keySet(), WSUtil.makeIntersection(mappedFilesTable, (Hashtable)moduleMappingsOld));
        Properties modulesForUpdateOldMappings = (Properties)this.filterWithMappedFilesTable(modulesNew.keySet(), WSUtil.makeIntersection(moduleMappingsOld, mappedFilesTable));
        ModuleUpdateInfo wsModuleUpdateInfo = new ModuleUpdateInfo();
        wsModuleUpdateInfo.setModulesForDeploy(IOUtil.collectFiles(modulesForDeploy));
        wsModuleUpdateInfo.setModuleMappingsForDelete(moduleMappingsForDelete);
        wsModuleUpdateInfo.setModulesForUpdateNewFiles(modulesForUpdateNewFiles);
        wsModuleUpdateInfo.setModulesForUpdateOldMappings(modulesForUpdateOldMappings);
        return wsModuleUpdateInfo;
    }

    private ModuleDeployResult deployModules(String applicationName, String wsComponentDir, File[] moduleArchives) throws WSDeploymentException {
        return this.moduleDeployGenerator.generateModuleDeployFiles(applicationName, wsComponentDir, moduleArchives);
    }

    private ModuleUpdateResult updateModules(String wsComponentDir, Hashtable modulesForUpdateNewFiles, Properties modulesForUpdateOldMappings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to regenerate files for updated modules. ";
        boolean hasChangedModules = false;
        hasChangedModules = this.regenerateModuleFiles70(wsComponentDir, modulesForUpdateNewFiles, modulesForUpdateOldMappings);
        ModuleUpdateResult moduleUpdateResult = new ModuleUpdateResult();
        moduleUpdateResult.setModuleMappings(modulesForUpdateOldMappings);
        moduleUpdateResult.setFilesForClassLoader(this.getModuleFilesForClassLoader(wsComponentDir, modulesForUpdateOldMappings));
        moduleUpdateResult.setHasChangedModules(hasChangedModules);
        try {
            moduleUpdateResult.setModuleCrcTable(IOUtil.getModuleCrcTable(IOUtil.collectFiles(modulesForUpdateNewFiles)));
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to generate module hash table. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return moduleUpdateResult;
    }

    private boolean regenerateModuleFiles70(String wsComponentDir, Hashtable modulesForUpdateNewFiles, Properties modulesForUpdateOldMappings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to regenerate files for updated modules. ";
        boolean hasChangedModules = false;
        Enumeration enumeration = modulesForUpdateNewFiles.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String moduleName = (String)enumeration.nextElement();
                File moduleArchiveNew = (File)modulesForUpdateNewFiles.get(moduleName);
                String moduleJarName = (String)((Hashtable)modulesForUpdateOldMappings).get(moduleName);
                String moduleJarPath = ModuleDirsHandler.getModuleJarPath(wsComponentDir, moduleJarName);
                byte[] oldCrc = HashUtils.generateFileHash((File)new File(moduleJarPath));
                this.jarUtil.makeJarFile(moduleArchiveNew, new String[0], WSBaseConstants.META_INF, new String[0], new String[0], moduleJarPath);
                byte[] newCrc = HashUtils.generateFileHash((File)new File(moduleJarPath));
                hasChangedModules = hasChangedModules || !HashUtils.compareHash((byte[])newCrc, (byte[])oldCrc);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
        }
        return hasChangedModules;
    }

    private void deleteModules(String wsComponentDir, Properties moduleMappings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to delete old module files. ";
        if (moduleMappings == null) {
            return;
        }
        Enumeration enumeration = ((Hashtable)moduleMappings).elements();
        while (enumeration.hasMoreElements()) {
            String moduleArchiveFileName = (String)enumeration.nextElement();
            String moduleJarPath = ModuleDirsHandler.getModuleJarPath(wsComponentDir, moduleArchiveFileName);
            boolean isDeleted = new File(moduleJarPath).delete();
            if (isDeleted) continue;
            String msg = excMsg + " Unable to delete file " + moduleJarPath + " - this may cause problems on web services/ ws clients start or update phase. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    private Hashtable collectFilesTable(File[] files) {
        if (files == null) {
            return new Hashtable();
        }
        Hashtable<String, File> filesTable = new Hashtable<String, File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            filesTable.put(file.getName(), file);
            ++i;
        }
        return filesTable;
    }

    private Hashtable mapFilesTable(Hashtable filesTable) {
        if (filesTable == null) {
            return new Hashtable();
        }
        Hashtable mappedFilesTable = new Hashtable();
        Enumeration enumeration = filesTable.keys();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            String mappedFileName = ModuleDirsHandler.getModuleJarName(fileName);
            mappedFilesTable.put(mappedFileName, filesTable.get(fileName));
        }
        return mappedFilesTable;
    }

    private Hashtable filterWithMappedFilesTable(Set filesSet, Hashtable mappedFilesTable) {
        if (filesSet == null) {
            return new Hashtable();
        }
        if (mappedFilesTable == null) {
            mappedFilesTable = new Hashtable();
        }
        Hashtable filteredFilesTable = null;
        filteredFilesTable = mappedFilesTable instanceof Properties ? new Properties() : new Hashtable();
        Iterator iter = filesSet.iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            String mappedFileName = ModuleDirsHandler.getModuleJarName(fileName);
            if (!mappedFilesTable.containsKey(mappedFileName)) continue;
            filteredFilesTable.put(fileName, mappedFilesTable.get(mappedFileName));
        }
        return filteredFilesTable;
    }

    private Properties collectNotMappedModuleMappings(Hashtable filesTable, Properties mappedModuleMappings) {
        if (filesTable == null) {
            return new Properties();
        }
        if (mappedModuleMappings == null) {
            mappedModuleMappings = new Properties();
        }
        Properties notMappedModuleMappings = new Properties();
        Enumeration enumeration = filesTable.keys();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            String mappedFileName = ModuleDirsHandler.getModuleJarName(fileName);
            if (!((Hashtable)mappedModuleMappings).containsKey(mappedFileName)) continue;
            ((Hashtable)notMappedModuleMappings).put(fileName, mappedModuleMappings.getProperty(mappedFileName));
        }
        return notMappedModuleMappings;
    }

    private ModuleUpdateResult defineModuleUpdateResult(String applicationName, String wsComponentDir, File[] notChangedModules, Properties modulesMappings, boolean hasChangedModules) throws WSDeploymentException {
        String excMsg = "Error occured, trying to define module update result for application " + applicationName + ". ";
        ModuleUpdateResult moduleUpdateResult = new ModuleUpdateResult();
        moduleUpdateResult.setFilesForClassLoader(this.getModuleFilesForClassLoader(wsComponentDir, modulesMappings));
        moduleUpdateResult.setModuleMappings(modulesMappings);
        try {
            moduleUpdateResult.setModuleCrcTable(IOUtil.getModuleCrcTable(notChangedModules));
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        moduleUpdateResult.setHasChangedModules(hasChangedModules);
        return moduleUpdateResult;
    }

    private File[] getFilesArray(Hashtable filesTable) {
        if (filesTable == null) {
            return new File[0];
        }
        File[] filesArr = new File[filesTable.size()];
        Enumeration enumeration = filesTable.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            filesArr[i++] = (File)enumeration.nextElement();
        }
        return filesArr;
    }

    public String[] getModuleFilesForClassLoader(String wsComponentDir, Properties moduleMappings) {
        if (moduleMappings == null) {
            return new String[0];
        }
        Enumeration elementsEnum = ((Hashtable)moduleMappings).elements();
        String[] moduleFilesForClassLoader = new String[((Hashtable)moduleMappings).size()];
        int i = 0;
        while (elementsEnum.hasMoreElements()) {
            String moduleJarName = (String)elementsEnum.nextElement();
            moduleFilesForClassLoader[i++] = ModuleDirsHandler.getModuleJarPath(wsComponentDir, moduleJarName);
        }
        return moduleFilesForClassLoader;
    }

    private boolean hasDeployedComponentsPerModuleFile(String wsComponentDir) {
        String moduleMappingsPath = ModuleDirsHandler.getDeployedComponentsPerModulePath(wsComponentDir);
        return new File(moduleMappingsPath).exists();
    }

    private boolean hasModuleMappingsFile(String wsComponentDir) {
        String moduleMappingsPath = ModuleDirsHandler.getModuleMappingsPath(wsComponentDir);
        return new File(moduleMappingsPath).exists();
    }
}

