/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.common;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.tc.logging.Location;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class ModuleFileStorageHandler {
    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveModuleMappings(String wsComponentDir, Properties moduleMappings) throws WSDeploymentException {
        String moduleMappingsPath = ModuleDirsHandler.getModuleMappingsPath(wsComponentDir);
        String excMsg = "Error occured, trying to save module mappings file " + moduleMappingsPath + ". ";
        IOUtil.createParentDir(new String[]{moduleMappingsPath});
        FileOutputStream out = null;
        out = new FileOutputStream(moduleMappingsPath);
        moduleMappings.store(out, "Properties file, specifying the mapping between the name of the original module archive, containg the web services/ws clients class files and the deployment generated one. ");
        Object var10_6 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException iExc) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + moduleMappingsPath + ". ";
            wsDeployLocation.catching(msg, (Throwable)iExc);
        }
        return;
        {
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException iExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + moduleMappingsPath + ". ";
                wsDeployLocation.catching(msg, (Throwable)iExc);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDeployedComponentsPerModule(String webServicesDir, Properties deployedComponentsPerModuleTable) throws WSDeploymentException {
        String deployedComponentsPerModulePath = ModuleDirsHandler.getDeployedComponentsPerModulePath(webServicesDir);
        String excMsg = "Error occured, trying to save deployed components per module file " + deployedComponentsPerModulePath + ". ";
        IOUtil.createParentDir(new String[]{deployedComponentsPerModulePath});
        FileOutputStream out = null;
        out = new FileOutputStream(deployedComponentsPerModulePath);
        deployedComponentsPerModuleTable.store(out, "Properties file, listing the deployed web services/ws clients for each module. ");
        Object var10_6 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException iExc) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + deployedComponentsPerModulePath + ". ";
            wsDeployLocation.catching(msg, (Throwable)iExc);
        }
        return;
        {
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException iExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + deployedComponentsPerModulePath + ". ";
                wsDeployLocation.catching(msg, (Throwable)iExc);
            }
            throw throwable;
        }
    }
}

