/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.common;

import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public abstract class ModuleDirsHandler {
    public static String getAppJarsRelDir() {
        return "app_jars";
    }

    public static String getAppJarsDir(String webServicesDir) {
        return webServicesDir + '/' + ModuleDirsHandler.getAppJarsRelDir();
    }

    public static String getAppJarsConfigRelName() {
        return "app_jars";
    }

    public static String getAppJarsConfigName(String wsComponentConfigPath) {
        return wsComponentConfigPath + '/' + ModuleDirsHandler.getAppJarsConfigRelName();
    }

    public static String getModuleWorkingDir(String wsClientsWorkingDir, String moduleName) {
        return wsClientsWorkingDir + '/' + WSUtil.getModuleNameByType(moduleName);
    }

    public static String getModuleExtractDir(String moduleWorkingDir) {
        return moduleWorkingDir + '/' + "extract";
    }

    public static String getModuleExtractFileName(String moduleName) {
        return IOUtil.getAsJarName(moduleName);
    }

    public static String getModuleExtractPath(String moduleWorkingDir, String moduleName) {
        return ModuleDirsHandler.getModuleExtractDir(moduleWorkingDir) + '/' + ModuleDirsHandler.getModuleExtractFileName(moduleName);
    }

    public static String getModuleJarName(String moduleName) {
        return IOUtil.getAsJarName(moduleName);
    }

    public static String getModuleJarPath(String webServicesDir, String moduleName) {
        return ModuleDirsHandler.getAppJarsDir(webServicesDir) + '/' + moduleName;
    }

    public static String getModuleMappingsFileName() {
        return "module_mappings.props";
    }

    public static String getModuleMappingsPath(String webServicesDir) {
        return ModuleDirsHandler.getAppJarsDir(webServicesDir) + '/' + ModuleDirsHandler.getModuleMappingsFileName();
    }

    public static String getDeployedComponestPerModuleFileName() {
        return "deployed_components.props";
    }

    public static String getDeployedComponentsPerModuleParentDir(String webServicesDir) {
        return ModuleDirsHandler.getAppJarsDir(webServicesDir);
    }

    public static String getDeployedComponentsPerModulePath(String webServicesDir) {
        return ModuleDirsHandler.getDeployedComponentsPerModuleParentDir(webServicesDir) + '/' + ModuleDirsHandler.getDeployedComponestPerModuleFileName();
    }

    public static Properties generateDefaultModuleMappings(File[] files) {
        HashSet<String> fileNamesExcludeList = new HashSet<String>();
        fileNamesExcludeList.add(ModuleDirsHandler.getDeployedComponestPerModuleFileName());
        return ModuleDirsHandler.generateDefaultModuleMappings(files, fileNamesExcludeList);
    }

    public static Properties generateDefaultModuleMappings(File[] files, Set fileNamesExcludeList) {
        if (files == null) {
            return new Properties();
        }
        Properties moduleMappings = new Properties();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String fileName = file.getName();
            if (!fileNamesExcludeList.contains(fileName)) {
                ((Hashtable)moduleMappings).put(fileName, fileName);
            }
            ++i;
        }
        return moduleMappings;
    }
}

