/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.common;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployResult;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ModuleDeployGenerator {
    private ModuleFileStorageHandler moduleFileStorageHandler = new ModuleFileStorageHandler();

    public ModuleDeployResult generateAndSaveModuleDeployFiles(String applicationName, String wsComponentDir, File[] moduleArchves) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate ws clients module deploy files for application " + applicationName + ". ";
        ModuleDeployResult moduleDeployResult = this.generateModuleDeployFiles(applicationName, wsComponentDir, moduleArchves);
        try {
            this.moduleFileStorageHandler.saveModuleMappings(wsComponentDir, moduleDeployResult.getModuleMappings());
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return moduleDeployResult;
    }

    public ModuleDeployResult generateModuleDeployFiles(String applicationName, String wsComponentDir, File[] moduleArchives) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate ws clients module deploy files for application " + applicationName + ". ";
        ModuleDeployResult moduleDeployResult = this.generateModuleDeployFiles0(applicationName, wsComponentDir, moduleArchives);
        Hashtable moduleCrcTable = null;
        try {
            moduleCrcTable = IOUtil.getModuleCrcTable(moduleArchives);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        moduleDeployResult.setModuleCrcTable(moduleCrcTable);
        return moduleDeployResult;
    }

    private ModuleDeployResult generateModuleDeployFiles0(String applicationName, String wsClientsDir, File[] wsClientsModuleArchves) throws WSDeploymentException {
        Properties moduleFullMappings = this.generateModuleDeployFiles1(applicationName, wsClientsDir, wsClientsModuleArchves);
        ModuleDeployResult moduleDeployResult = new ModuleDeployResult();
        moduleDeployResult.setFilesForClassLoader(WSUtil.collecProperties(moduleFullMappings));
        moduleDeployResult.setModuleMappings(this.collectFileNameMappings(moduleFullMappings));
        return moduleDeployResult;
    }

    private Properties generateModuleDeployFiles1(String applicationName, String wsClientsDir, File[] moduleArchves) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate ws clients module deploy files for application " + applicationName + ". ";
        if (moduleArchves == null) {
            return new Properties();
        }
        Properties moduleFullMappings = new Properties();
        int i = 0;
        while (i < moduleArchves.length) {
            File moduleArchive = moduleArchves[i];
            String moduleJarAppPath = null;
            try {
                moduleJarAppPath = this.extractAndPackageAppJars(wsClientsDir, moduleArchive);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg;
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            if (moduleJarAppPath != null) {
                ((Hashtable)moduleFullMappings).put(moduleArchive.getName(), moduleJarAppPath);
            }
            ++i;
        }
        return moduleFullMappings;
    }

    private Properties collectFileNameMappings(Properties filePathsMapping) {
        if (filePathsMapping == null) {
            return new Properties();
        }
        Properties fileNameMapping = new Properties();
        Enumeration enumeration = ((Hashtable)filePathsMapping).keys();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            String filePath = filePathsMapping.getProperty(fileName);
            fileNameMapping.setProperty(fileName, new File(filePath).getName());
        }
        return fileNameMapping;
    }

    private String extractAndPackageAppJars(String wsClientsDir, File moduleArchive) throws WSDeploymentException {
        String excMsg = "Error occurred trying to extract and package class files for module: " + moduleArchive.getName() + ". ";
        String moduleAppJarPath = null;
        String moduleExtension = IOUtil.getFileExtension(moduleArchive);
        try {
            if (moduleExtension.equals(".wsar")) {
                moduleAppJarPath = ModuleDirsHandler.getModuleJarPath(wsClientsDir, ModuleDirsHandler.getModuleJarName(moduleArchive.getName()));
                IOUtil.createParentDir(new String[]{moduleAppJarPath});
                new JarUtil().makeJarFile(moduleArchive, new String[0], WSBaseConstants.META_INF, new String[0], new String[0], moduleAppJarPath);
            }
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return moduleAppJarPath;
    }
}

