/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.common;

import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DeployResult {
    private Properties deployedWSPerModule = new Properties();
    private String[] filesForClassLoader = new String[0];
    private String[] deployedComponentNames = new String[0];

    public Properties getDeployedWSPerModule() {
        return this.deployedWSPerModule;
    }

    public void setDeployedWSPerModule(Properties deployedWSPerModule) {
        this.deployedWSPerModule = deployedWSPerModule;
    }

    public void addDeployedWSPerModule(Properties deployedWSPerModule) {
        this.deployedWSPerModule = WSUtil.unifyProperties(this.deployedWSPerModule, deployedWSPerModule, "");
    }

    public String[] getFilesForClassLoader() {
        return this.filesForClassLoader;
    }

    public void setFilesForClassLoader(String[] filesForClassLoader) {
        this.filesForClassLoader = filesForClassLoader;
    }

    public void addFilesForClassLoader(String[] filesForClassLoader) {
        this.filesForClassLoader = WSUtil.unifyStrings(new String[][]{this.filesForClassLoader, filesForClassLoader});
    }

    public String[] getDeployedComponentNames() {
        return this.deployedComponentNames;
    }

    public void setDeployedComponentNames(String[] deployedComponentNames) {
        this.deployedComponentNames = deployedComponentNames;
    }

    public void addDeployedComponentNames(String[] deployedComponentNames) {
        this.deployedComponentNames = WSUtil.unifyStrings(new String[][]{this.deployedComponentNames, deployedComponentNames});
    }

    public void addDeployResult(DeployResult deployResult) {
        if (deployResult == null) {
            return;
        }
        this.addDeployedWSPerModule(deployResult.getDeployedWSPerModule());
        this.addDeployedComponentNames(deployResult.getDeployedComponentNames());
        this.addFilesForClassLoader(deployResult.getFilesForClassLoader());
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(this.toStringdeployedComponentNames());
        strBuffer.append(this.toStringFilesForClassLoader());
        strBuffer.append(this.toStringDeployedComponentPerModule());
        return strBuffer.toString();
    }

    public String toStringdeployedComponentNames() {
        String nl = System.getProperty("line.separator");
        StringBuffer strBuffer = new StringBuffer();
        if (this.deployedComponentNames.length == 0) {
            strBuffer.append("No deployed components. ");
        } else {
            strBuffer.append("Deployed component names: " + nl);
            int i = 0;
            while (i < this.deployedComponentNames.length) {
                strBuffer.append(this.deployedComponentNames[i] + nl);
                ++i;
            }
        }
        return strBuffer.toString();
    }

    public String toStringFilesForClassLoader() {
        String nl = System.getProperty("line.separator");
        StringBuffer strBuffer = new StringBuffer();
        if (this.filesForClassLoader.length == 0) {
            strBuffer.append("No files for classloader. ");
        } else {
            strBuffer.append("Files for classloader: " + nl);
            int i = 0;
            while (i < this.filesForClassLoader.length) {
                strBuffer.append(this.filesForClassLoader[i] + nl);
                ++i;
            }
        }
        return strBuffer.toString();
    }

    public String toStringDeployedComponentPerModule() {
        String nl = System.getProperty("line.separator");
        StringBuffer strBuffer = new StringBuffer();
        if (((Hashtable)this.deployedWSPerModule).size() == 0) {
            strBuffer.append("No deployed components per module. ");
        } else {
            strBuffer.append("Deployed components per module: " + nl);
            Enumeration enumeration = ((Hashtable)this.deployedWSPerModule).keys();
            while (enumeration.hasMoreElements()) {
                String moduleName = (String)enumeration.nextElement();
                strBuffer.append(moduleName + ":" + nl);
                strBuffer.append(((Hashtable)this.deployedWSPerModule).get(moduleName) + nl);
            }
        }
        return strBuffer.toString();
    }
}

