/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.WSContainerInterfaceImpl;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.AppDeployInfo;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSAppDeployResult;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployManager;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.ws.WSServerDeploySettingsProvider;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSAppUpdateResult;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSUpdateManager;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployManager;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.wsclient.deploy.WSClientsAppDeployResult;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsAppUpdateResult;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsUpdateManager;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;

public class WSDeployer
implements ContainerInterface {
    public static final int PRIORITY = 77;
    private DeployCommunicator deployCommunicator = null;
    private String serviceWorkingDir = null;
    private WSDeployManager wsDeployManager = null;
    private WSRuntimeActivator wsRuntimeActivator = null;
    private WSClientsDeployManager wsClientsDeployManager = null;
    private WSClientsRuntimeActivator wsClientsRuntimeActivator = null;
    private WSUpdateManager wsUpdateManager = null;
    private WSClientsUpdateManager wsClientsUpdateManager = null;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$server$deploy$WSDeployer;

    public WSDeployer() {
        ModuleDeployGenerator moduleDeployGenerator = new ModuleDeployGenerator();
        ModuleFileStorageHandler moduleFileStorageHandler = new ModuleFileStorageHandler();
        WSServerDeploySettingsProvider wsServerDeploySettingsProvider = new WSServerDeploySettingsProvider();
        WSDeployGenerator wsDeployGenerator = new WSDeployGenerator(wsServerDeploySettingsProvider, wsServerDeploySettingsProvider, moduleDeployGenerator, moduleFileStorageHandler);
        this.wsDeployManager = new WSDeployManager(wsDeployGenerator);
        this.wsRuntimeActivator = new WSRuntimeActivator();
        WSClientsDeployGenerator wsClientsDeployGenerator = new WSClientsDeployGenerator(moduleDeployGenerator, moduleFileStorageHandler);
        this.wsClientsDeployManager = new WSClientsDeployManager(wsClientsDeployGenerator);
        this.wsClientsRuntimeActivator = new WSClientsRuntimeActivator();
        this.wsUpdateManager = new WSUpdateManager(this.wsDeployManager, wsDeployGenerator, moduleDeployGenerator, moduleFileStorageHandler);
        this.wsClientsUpdateManager = new WSClientsUpdateManager(this.wsClientsDeployManager, wsClientsDeployGenerator, moduleDeployGenerator, moduleFileStorageHandler);
        this.serviceWorkingDir = WSContainer.getServiceContext().getServiceState().getWorkingDirectoryName().replace('\\', '/');
    }

    public void setDeployCommunicator(DeployCommunicator deployCommunicator) {
        this.deployCommunicator = deployCommunicator;
    }

    public DeployCommunicator getDeployCommunicator() {
        return this.deployCommunicator;
    }

    public ContainerInfo getContainerInfo() {
        ContainerInfo info = new ContainerInfo();
        info.setJ2EEContainer(false);
        info.setFileExtensions(new String[]{".war", ".jar", ".wsar"});
        info.setName("webservices_container");
        info.setServiceName(WSContainer.NAME);
        info.setModuleName(WSContainer.NAME);
        info.setPriority(77);
        return info;
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        return "wsar" + System.currentTimeMillis();
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        String applicationName = dInfo.getApplicationName();
        String excMsg = "Error occured, trying to deploy web services and/or ws clients for application " + applicationName + ". ";
        String wsContainerDir = null;
        try {
            wsContainerDir = this.getWSContainerDir(applicationName, 0);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get deploying directory for " + "webservices_container" + " container. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsContainerWorkingDir = this.getWSContainerWorkingDir(applicationName);
        ApplicationDeployInfo applicationDeployInfo = null;
        try {
            WSAppDeployResult wsAppDeployResult = this.wsDeployManager.deploy(applicationName, wsContainerDir, wsContainerWorkingDir, archiveFiles, dInfo.getConfiguration());
            WSClientsAppDeployResult wsClientsAppDeployResult = this.wsClientsDeployManager.deploy(wsContainerDir, wsContainerWorkingDir, this.getAppDeployInfo(dInfo), archiveFiles);
            applicationDeployInfo = this.defineApplicationDeployInfo(wsAppDeployResult, wsClientsAppDeployResult);
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                IOUtil.deleteDir(wsContainerWorkingDir);
            }
            catch (IOException e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! Unable to delete ws temporary directory, used for deploy needs: " + wsContainerWorkingDir + ". ";
                wsLocation.catching(msg, (Throwable)e);
            }
            throw throwable;
        }
        try {
            IOUtil.deleteDir(wsContainerWorkingDir);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! Unable to delete ws temporary directory, used for deploy needs: " + wsContainerWorkingDir + ". ";
            wsLocation.catching(msg, (Throwable)e);
        }
        return applicationDeployInfo;
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.postDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsDeployManager.postDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void commitDeploy(String applicationName) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.commitDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsDeployManager.commitDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.rollbackDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsDeployManager.rollbackDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        String applicationName = dInfo.getApplicationName();
        String excMsg = "Error occured during update of application " + applicationName + ". ";
        Configuration appConfiguration = dInfo.getConfiguration();
        String wsContainerDir = null;
        try {
            wsContainerDir = this.getWSContainerDir(applicationName, 0);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Can not resolve application deploy directory for " + "webservices_container" + " container. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new Object[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsContainerWorkingDir = this.getWSContainerWorkingDir(applicationName);
        ApplicationDeployInfo appDeployInfo = null;
        try {
            WSAppUpdateResult wsAppUpdateResult = this.wsUpdateManager.makeUpdate(applicationName, WSDirsHandler.getWebServicesDir(wsContainerDir), WSDirsHandler.getWebServicesWorkingDir(wsContainerWorkingDir), archiveFiles, appConfiguration);
            WSClientsAppUpdateResult wsClientsAppDeployResult = this.wsClientsUpdateManager.makeUpdate(WSClientDirsHandler.getWSClientsDir(wsContainerDir), WSClientDirsHandler.getWSClientsWorkingDir(wsContainerWorkingDir), archiveFiles, this.getAppDeployInfo(dInfo));
            appDeployInfo = this.defineApplicationDeployInfo(wsAppUpdateResult, wsClientsAppDeployResult);
            Object var13_17 = null;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            try {
                IOUtil.deleteDir(wsContainerWorkingDir);
            }
            catch (IOException e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! Unable to delete ws temporary directory, used for deploy needs: " + wsContainerWorkingDir + ". ";
                wsLocation.catching(msg, (Throwable)e);
            }
            throw throwable;
        }
        try {
            IOUtil.deleteDir(wsContainerWorkingDir);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! Unable to delete ws temporary directory, used for deploy needs: " + wsContainerWorkingDir + ". ";
            wsLocation.catching(msg, (Throwable)e);
        }
        try {
            if (appDeployInfo.getDeployedComponentNames() == null || appDeployInfo.getDeployedComponentNames().length == 0) {
                if (WSConfigurationHandler.existsSubConfiguration(appConfiguration, "webservices_container")) {
                    WSConfigurationHandler.deleteConfiguration(appConfiguration, "webservices_container", "/");
                }
                this.removeWSContainerDir(applicationName);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Can not remove " + "webservices_container" + "'s container DB configuration or file system directory. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new Object[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return appDeployInfo;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsUpdateManager.notifyUpdatedComponents(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsUpdateManager.notifyUpdatedComponents(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWSContainerDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
        Vector warnings = new Vector();
        try {
            this.wsUpdateManager.prepareUpdate(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsUpdateManager.prepareUpdate(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsUpdateManager.commitUpdate(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsUpdateManager.commitUpdate(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsUpdateManager.rollbackUpdate(applicationName, applicationConfig, props);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsUpdateManager.rollbackUpdate(applicationName, applicationConfig, props);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.remove(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsDeployManager.remove(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWSContainerDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void downloadApplicationFiles(String applicationName, Configuration configuration) throws DeploymentException, WSWarningException {
        Vector warnings = new Vector();
        try {
            this.wsRuntimeActivator.downloadApplicationFiles(applicationName, configuration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsRuntimeActivator.downloadApplicationFiles(applicationName, configuration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void prepareStart(String applicationName, Configuration configuration) throws DeploymentException, WarningException {
        String excMsg = "Unable to start web services and/or wsclients for application " + applicationName + ". ";
        String wsContainerDir = null;
        try {
            wsContainerDir = this.getWSContainerDir(applicationName, 0);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Can not resolve application deploy directory for " + "webservices_container" + " container. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new Object[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Vector warnings = new Vector();
        try {
            this.wsRuntimeActivator.start(applicationName, WSDirsHandler.getWebServicesDir(wsContainerDir), configuration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsRuntimeActivator.startWSClients(applicationName, WSClientDirsHandler.getWSClientsDir(wsContainerDir), configuration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void commitStart(String applicationName) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsRuntimeActivator.commitStart(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsRuntimeActivator.commitStart(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.checkEJBMethods(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void rollbackStart(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.wsRuntimeActivator.rollbackStart(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsRuntimeActivator.rollbackStart(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWSContainerDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void prepareStop(String applicationName, Configuration appConfiguration) throws WSDeploymentException, WarningException {
    }

    public void commitStop(String applicationName) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsRuntimeActivator.stop(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsRuntimeActivator.stop(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfiguration) throws WarningException {
        WSContainer.getEventContext().getEventHandler().notifyRuntimeChanges(applicationName, appConfiguration);
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
        WSContainer.getEventContext().getEventHandler().makeRuntimeChanges(applicationName);
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        WSContainer.getEventContext().getEventHandler().commitRuntimeChanges(applicationName);
        return new ApplicationDeployInfo();
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
        WSContainer.getEventContext().getEventHandler().rollbackRuntimeChanges(applicationName);
    }

    public File[] getClientJar(String applicationName) {
        return new File[0];
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return new ExportInfo[0];
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void notifySingleFileUpdate(String applicationName, Properties props) throws WarningException {
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return new String[0];
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    public int getWSType(String applicationName) throws Exception {
        int wsType = 0;
        InitialContext ctx = new InitialContext();
        WSContainerInterfaceImpl wsContainerInterface = (WSContainerInterfaceImpl)ctx.lookup("wsContext/wsContainerInterface");
        if (wsContainerInterface.isExernalWSComponent(applicationName)) {
            wsType = 1;
        }
        return wsType;
    }

    public String getWSContainerDir(String applicationName) throws Exception {
        return this.getWSContainerDir(applicationName, this.getWSType(applicationName));
    }

    public String getWSContainerDir(String applicationName, int wsType) throws IOException {
        String wsContainerDir = null;
        if (wsType == 0) {
            wsContainerDir = this.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        if (wsType == 1) {
            wsContainerDir = this.serviceWorkingDir + '/' + "apps" + '/' + applicationName + '/' + "webservices_container";
        }
        return wsContainerDir;
    }

    private String getWSContainerWorkingDir(String applicationName) {
        return this.serviceWorkingDir + '/' + "deploy" + '/' + WSUtil.replaceForbiddenChars(applicationName);
    }

    private AppDeployInfo getAppDeployInfo(ContainerDeploymentInfo containerDeploymentInfo) {
        AppDeployInfo appDeployInfo = new AppDeployInfo();
        appDeployInfo.setApplicationName(containerDeploymentInfo.getApplicationName());
        appDeployInfo.setLoader(containerDeploymentInfo.getLoader());
        appDeployInfo.setAppConfiguration(containerDeploymentInfo.getConfiguration());
        appDeployInfo.setWebMappings(this.getWebModuleMappings(containerDeploymentInfo));
        return appDeployInfo;
    }

    private Hashtable getWebModuleMappings(ContainerDeploymentInfo containerDeploymentInfo) {
        String[] aliases = containerDeploymentInfo.getAliases();
        if (aliases == null) {
            return new Hashtable();
        }
        Hashtable<String, String> webMappings = new Hashtable<String, String>();
        int i = 0;
        while (i < aliases.length) {
            webMappings.put(containerDeploymentInfo.getUri(aliases[i]), aliases[i]);
            ++i;
        }
        return webMappings;
    }

    private ApplicationDeployInfo defineApplicationDeployInfo(WSAppDeployResult wsAppDeployResult, WSClientsAppDeployResult wsClientsAppDeployResult) {
        ApplicationDeployInfo applicationDeployInfo = new ApplicationDeployInfo();
        applicationDeployInfo.setDeployedComponentNames(WSUtil.unifyStrings(new String[][]{wsAppDeployResult.getDeployedComponentNames(), wsClientsAppDeployResult.getWsClientsDeployResult().getDeployedComponentNames()}));
        applicationDeployInfo.setFilesForClassloader(WSUtil.unifyStrings(new String[][]{wsAppDeployResult.getFilesForClassloader(), wsClientsAppDeployResult.getModuleDeployResult().getFilesForClassLoader(), wsClientsAppDeployResult.getWsClientsDeployResult().getFilesForClassLoader()}));
        Vector warnings = new Vector();
        warnings.addAll(wsAppDeployResult.getWarnings());
        warnings.addAll(wsClientsAppDeployResult.getWarnings());
        applicationDeployInfo.setWarnings(warnings);
        return applicationDeployInfo;
    }

    private ApplicationDeployInfo defineApplicationDeployInfo(WSAppUpdateResult wsAppUpdateResult, WSClientsAppUpdateResult wsClientsAppUpdateResult) {
        ApplicationDeployInfo applicationDeployInfo = new ApplicationDeployInfo();
        applicationDeployInfo.setDeployedComponentNames(WSUtil.unifyStrings(new String[][]{wsAppUpdateResult.getWsUpdateResult().getDeployedComponentNames(), wsClientsAppUpdateResult.getWsClientsUpdateResult().getDeployedComponentNames()}));
        applicationDeployInfo.setFilesForClassloader(WSUtil.unifyStrings(new String[][]{wsAppUpdateResult.getModuleDeployResult().getFilesForClassLoader(), wsAppUpdateResult.getWsUpdateResult().getFilesForClassLoader(), wsClientsAppUpdateResult.getModuleUpdateResult().getFilesForClassLoader(), wsClientsAppUpdateResult.getWsClientsUpdateResult().getFilesForClassLoader()}));
        Vector warnings = new Vector();
        warnings.addAll(wsAppUpdateResult.getWarnings());
        warnings.addAll(wsClientsAppUpdateResult.getWarnings());
        applicationDeployInfo.setWarnings(warnings);
        return applicationDeployInfo;
    }

    public String[] getWSReferences() {
        return new String[]{"library:sapxmltoolkit", "library:webservices_lib", "interface:webservices"};
    }

    public String getJarsPath() {
        String[] resourceNames = this.getWSReferences();
        SystemMonitor systemMonitor = WSContainer.getServiceContext().getContainerContext().getSystemMonitor();
        String[] jars = new String[]{};
        int resourcesSize = resourceNames.length;
        int i = 0;
        while (i < resourcesSize) {
            String resource = resourceNames[i];
            String resourceType = resource.substring(0, resource.indexOf(":"));
            String resourceName = resource.substring(resource.indexOf(":") + 1);
            String[] currentJars = null;
            if (resourceType.equals("library")) {
                currentJars = systemMonitor.getLibrary(resourceName).getJars();
            }
            if (resourceType.equals("interface")) {
                currentJars = systemMonitor.getInterface(resourceName).getJars();
            }
            if (resourceType.equals("service")) {
                currentJars = systemMonitor.getService(resourceName).getJars();
            }
            String[] newJars = new String[jars.length + currentJars.length];
            System.arraycopy(jars, 0, newJars, 0, jars.length);
            System.arraycopy(currentJars, 0, newJars, jars.length, currentJars.length);
            jars = newJars;
            ++i;
        }
        String classPath = "";
        int jarsSize = jars.length;
        int i2 = 0;
        while (i2 < jarsSize) {
            classPath = classPath + jars[i2] + File.pathSeparator;
            ++i2;
        }
        classPath = classPath + "./bin/system/exception.jar" + File.pathSeparator;
        classPath = classPath + "./bin/system/logging.jar" + File.pathSeparator;
        return classPath;
    }

    private void removeWSContainerDir(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, deleting webservices_container directory. ";
        String wsContainerDir = null;
        try {
            wsContainerDir = this.getWSContainerDir(applicationName, 0);
            IOUtil.deleteDir(wsContainerDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = null;
            msg = wsContainerDir != null ? excMsg + "Unable to delete" + wsContainerDir + " directory. " : excMsg + "Unable to delete" + "webservices_container" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    private void checkEJBMethods(String applicationName) throws WSWarningException {
        WSWarningException e = new WSWarningException();
        Location loc = Location.getLocation((Class)(class$com$sap$engine$services$webservices$server$deploy$WSDeployer == null ? (class$com$sap$engine$services$webservices$server$deploy$WSDeployer = WSDeployer.class$("com.sap.engine.services.webservices.server.deploy.WSDeployer")) : class$com$sap$engine$services$webservices$server$deploy$WSDeployer));
        try {
            loc.debugT("CommitStart is invoked for app " + applicationName);
            ApplicationServiceContext serviceContext = WSContainer.getServiceContext();
            ClassLoader loader = serviceContext.getCoreContext().getLoadContext().getClassLoader(applicationName);
            WSRuntimeDefinition[] rtDefs = WSContainer.getWSRegistry().getWebServicesByApplicationName(applicationName);
            EJBManager ejbM = WSContainer.getInterfaceContext().getEjbManager();
            int i = 0;
            while (i < rtDefs.length) {
                ServiceEndpointDefinition[] sEPs = rtDefs[i].getServiceEndpointDefinitions();
                if (sEPs != null) {
                    int j = 0;
                    while (j < sEPs.length) {
                        block13: {
                            loc.debugT("WSDeployer/checkEJBMethods/is appName " + applicationName + " EJBimpl: " + sEPs[j].getImplLink().getImplId().equals("ejb-impllink"));
                            ServiceEndpointDefinition curEp = sEPs[j];
                            String jarName = curEp.getOwner().getWSIdentifier().getJarName();
                            ImplLink implLink = sEPs[j].getImplLink();
                            String beanName = implLink.getProperties().getProperty("ejb-name");
                            if (implLink.getImplId().equals("ejb-impllink")) {
                                block14: {
                                    String jndiName = implLink.getProperties().getProperty("ejb-jndi-name");
                                    String jndiNameLocal = implLink.getProperties().getProperty("ejb-jndi-name-local");
                                    if (jndiNameLocal != null) {
                                        try {
                                            String localName = ejbM.getLocalInterfaceName(applicationName, jarName, beanName);
                                            loc.debugT("WSDeployer/checkEJBMethods/ appName " + applicationName + " localName is : " + localName + " for appName: " + applicationName + " jarName: " + jarName + " beanName: " + beanName);
                                            Class<?> localInfClass = loader.loadClass(localName);
                                            loc.debugT("WSDeployer/checkEJBMethods/ appName " + applicationName + "localClass is : " + localInfClass);
                                            this.checkVIOperationsVSEJBMethods(curEp, localInfClass, loader);
                                            curEp.setFastEJB(true);
                                            LoggingHelper.SYS_SERVER.logT(300, loc, "FastEJB is set for endpointid: " + curEp.getServiceEndpointId() + ", appName " + applicationName);
                                            break block13;
                                        }
                                        catch (WSWarningException wsWE) {
                                            e.addWarning("LocalInterface cannot be used to invoke business methods of endpoint: " + curEp.getServiceEndpointId());
                                            e.addWarnings(wsWE.getWarnings());
                                            break block14;
                                        }
                                        catch (Exception ex) {
                                            e.addWarning("LocalInterface cannot be used to invoke business methods of endpoint: " + curEp.getServiceEndpointId());
                                            e.addWarning(ex.toString());
                                            break block14;
                                        }
                                    }
                                    e.addWarning("LocalInterface is not provided for endpoint: " + curEp.getServiceEndpointId());
                                }
                                try {
                                    String remoteName = ejbM.getRemoteInterfaceName(applicationName, jarName, beanName);
                                    loc.debugT("WSDeployer/checkEJBMethods/ appName " + applicationName + ", remoteName is : " + remoteName + " for appName: " + applicationName + " jarName: " + jarName + " beanName: " + beanName);
                                    Class<?> remoteInfClass = loader.loadClass(remoteName);
                                    loc.debugT("WSDeployer/checkEJBMethods/ appName " + applicationName + ", remoteClass is : " + remoteInfClass);
                                    this.checkVIOperationsVSEJBMethods(curEp, remoteInfClass, loader);
                                    loc.debugT("NormalEJB is set for endpointid: " + curEp.getServiceEndpointId() + ", appName " + applicationName);
                                }
                                catch (WSWarningException wsWE) {
                                    e.addWarning("RemoteInterface cannot be used to invoke business methods of endpoint: " + curEp.getServiceEndpointId());
                                    e.addWarnings(wsWE.getWarnings());
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (e.getWarnings() != null && e.getWarnings().length > 0) {
                throw e;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WSWarningException((Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkVIOperationsVSEJBMethods(ServiceEndpointDefinition sEP, Class ejbInterface, ClassLoader appLoader) throws WSWarningException {
        loc = Location.getLocation((Class)(WSDeployer.class$com$sap$engine$services$webservices$server$deploy$WSDeployer == null ? (WSDeployer.class$com$sap$engine$services$webservices$server$deploy$WSDeployer = WSDeployer.class$("com.sap.engine.services.webservices.server.deploy.WSDeployer")) : WSDeployer.class$com$sap$engine$services$webservices$server$deploy$WSDeployer));
        wsWarning = new WSWarningException();
        try {
            operations = sEP.getOperations();
            i = 0;
            while (i < operations.length) {
                block8: {
                    m = null;
                    opParams = RuntimeProcessor.loadParameterClasses(operations[i], appLoader);
                    try {
                        loc.debugT("WSDeployer/checkViOperationsVSEJBMethods JavaName: " + operations[i].getJavaOperationName());
                        p = 0;
                        while (p < opParams.length) {
                            loc.debugT("WSDeployer/checkViOperationsVSEJBMethods Param: [" + p + "] " + opParams[p]);
                            ++p;
                        }
                        m = ejbInterface.getMethod(operations[i].getJavaOperationName(), opParams);
                        break block8;
                    }
                    catch (NoSuchMethodException nsmE) {
                        prmArray = "";
                        p = 0;
                        ** while (p < opParams.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        prmArray = prmArray + opParams[p].toString() + " ";
                        ++p;
                        continue;
                    }
lbl27:
                    // 1 sources

                    wsWarning.addWarning("Method with name '" + operations[i].getJavaOperationName() + "' and parameters '" + prmArray + "' cannot be found in class " + ejbInterface);
                }
                ++i;
            }
        }
        catch (Exception e) {
            wsWarning.addWarning("Problem checking ejbInterface " + ejbInterface + ". Exception: " + e.toString());
        }
        if (wsWarning.getWarnings() != null && wsWarning.getWarnings().length > 0) {
            throw wsWarning;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

