/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.hash.HashCompare;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class WSConfigurationHandler
implements WebServicesConstants,
WSClientsConstants {
    private static final char SEPARATOR = '/';

    public static void makeWebServicesConfiguration(String webservicesDir, Hashtable moduleCrcTable, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to make " + WSDirsHandler.getWebServicesConfigName("webservices_container") + ", root configuration " + appConfiguration.getPath() + ", uploading directory " + webservicesDir + ". ";
        Configuration webServicesConfiguration = null;
        try {
            webServicesConfiguration = WSConfigurationHandler.getAndMakeConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.makeUniversalWSConfiguration(webservicesDir, moduleCrcTable, webServicesConfiguration);
    }

    public static void makeWSClientsConfiguration(String wsClientsDir, Hashtable moduleCrcTable, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to make " + WSClientDirsHandler.getWSClientsConfigName("webservices_container") + ", root configuration " + appConfiguration.getPath() + ", uploading directory " + wsClientsDir + ". ";
        Configuration wsClientsConfiguration = null;
        try {
            wsClientsConfiguration = WSConfigurationHandler.getAndMakeConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.makeUniversalWSConfiguration(wsClientsDir, moduleCrcTable, wsClientsConfiguration);
    }

    public static void makeUniversalWSConfiguration(String wsComponentsRootDir, Hashtable moduleCrcTable, Configuration wsComponentsRootConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to make universal ws components configuration, root configuration " + wsComponentsRootConfiguration.getPath() + ", uploading directory " + wsComponentsRootDir + ". ";
        File[] wsComponentsDirs = new File(wsComponentsRootDir).listFiles();
        if (wsComponentsDirs == null) {
            return;
        }
        try {
            int i = 0;
            while (i < wsComponentsDirs.length) {
                File wsComponentDir = wsComponentsDirs[i];
                if (wsComponentDir.getName().equals("app_jars")) {
                    WSConfigurationHandler.uploadModuleJarsDir(wsComponentDir, moduleCrcTable, wsComponentsRootConfiguration);
                } else {
                    WSConfigurationHandler.uploadDirectory(wsComponentDir.getAbsolutePath(), wsComponentDir.getName(), wsComponentsRootConfiguration);
                }
                ++i;
            }
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, (Throwable)((Object)e));
        }
    }

    public static void makeWebServicesModuleJarsDir(File moduleJarsDir, Hashtable moduleCrcTable, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to upload " + moduleJarsDir.getAbsolutePath() + ", root configuration " + appConfiguration.getPath() + ", relative configuration " + WSDirsHandler.getWebServicesConfigName("webservices_container");
        try {
            Configuration webServicesConfiguration = WSConfigurationHandler.getAndMakeConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
            WSConfigurationHandler.uploadModuleJarsDir(moduleJarsDir, moduleCrcTable, webServicesConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void makeWSConfigurations(String[] dirs, Configuration appConfiguration) throws WSConfigurationException {
        WSConfigurationHandler.makeUniversalWSConfigurations(dirs, appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
    }

    public static void makeWSClientConfigurations(String[] dirs, Configuration appConfiguration) throws WSConfigurationException {
        WSConfigurationHandler.makeUniversalWSConfigurations(dirs, appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
    }

    private static void makeUniversalWSConfigurations(String[] dirs, Configuration appConfiguration, String relConfigPath) throws WSConfigurationException {
        String excMsg = "Error occured, trying to make web services configuration,  root configuration " + appConfiguration.getPath() + ". ";
        if (dirs == null) {
            return;
        }
        Configuration configuration = null;
        try {
            configuration = WSConfigurationHandler.getAndMakeConfiguration(appConfiguration, relConfigPath);
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        int i = 0;
        while (i < dirs.length) {
            String wsDir = dirs[i];
            WSConfigurationHandler.uploadDirectory(wsDir, new File(dirs[i]).getName(), configuration);
            ++i;
        }
    }

    public static Hashtable downloadWebServicesConfiguration(String webServicesDir, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download " + WSDirsHandler.getWebServicesConfigName("webservices_container") + ", root configuration " + appConfiguration.getPath() + ", downloading directory " + webServicesDir + ". ";
        Configuration webServicesConfiguration = null;
        try {
            webServicesConfiguration = WSConfigurationHandler.getConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return WSConfigurationHandler.downloadUniversalWSConfiguration(webServicesDir, webServicesConfiguration);
    }

    public static Hashtable downloadWSClientsConfiguration(String wsClientsDir, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download " + WSClientDirsHandler.getWSClientsConfigName("webservices_container") + ", root configuration " + appConfiguration.getPath() + ", downloading directory " + wsClientsDir + ". ";
        Configuration wsClientsConfiguration = null;
        try {
            wsClientsConfiguration = WSConfigurationHandler.getConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return WSConfigurationHandler.downloadUniversalWSConfiguration(wsClientsDir, wsClientsConfiguration);
    }

    public static Hashtable downloadUniversalWSConfiguration(String wsComponentsRootDir, Configuration wsComponentsRootConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download universal ws component configuration, root configuration " + wsComponentsRootConfiguration.getPath() + ", downloading directory " + wsComponentsRootDir + ". ";
        Hashtable<String, String> configsToDirsMapping = new Hashtable<String, String>();
        try {
            WSConfigurationHandler.deleteDirs(wsComponentsRootDir, wsComponentsRootConfiguration);
            Map wsComponentsConfigurations = wsComponentsRootConfiguration.getAllSubConfigurations();
            Iterator iter = wsComponentsConfigurations.keySet().iterator();
            while (iter.hasNext()) {
                String wsComponentConfigName = (String)iter.next();
                if (wsComponentConfigName.equals("app_jars")) {
                    WSConfigurationHandler.downloadModuleJarsConfig(IOUtil.getFilePath(wsComponentsRootDir, "app_jars"), (Configuration)wsComponentsConfigurations.get(wsComponentConfigName));
                    continue;
                }
                Configuration wsComponentConfiguration = (Configuration)wsComponentsConfigurations.get(wsComponentConfigName);
                String relDir = WSConfigurationHandler.downloadConfigurationToParent(wsComponentsRootDir, wsComponentConfiguration, new HashSet());
                configsToDirsMapping.put(wsComponentConfiguration.getMetaData().getName(), relDir);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return configsToDirsMapping;
    }

    public static void downloadWebServicesBaseConfiguration(String webServicesDir, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download " + WSDirsHandler.getWebServicesConfigName("webservices_container") + " base configuration, root configuration " + appConfiguration.getPath() + ", downloading directory " + webServicesDir + ". ";
        try {
            Configuration webServicesConfiguration = WSConfigurationHandler.getConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
            WSConfigurationHandler.deleteDirs(webServicesDir, webServicesConfiguration);
            Hashtable<String, String> configsToDirsMapping = new Hashtable<String, String>();
            Map wsConfigurations = webServicesConfiguration.getAllSubConfigurations();
            Iterator iter = wsConfigurations.keySet().iterator();
            while (iter.hasNext()) {
                String wsConfigName = (String)iter.next();
                if (wsConfigName.equals(ModuleDirsHandler.getAppJarsRelDir())) {
                    WSConfigurationHandler.downloadModuleJarsConfig(ModuleDirsHandler.getAppJarsDir(webServicesDir), (Configuration)wsConfigurations.get(wsConfigName));
                    continue;
                }
                Configuration wsConfiguration = (Configuration)wsConfigurations.get(wsConfigName);
                String wsRelDir = wsConfigName;
                String wsDir = IOUtil.getFilePath(webServicesDir, wsRelDir);
                WSConfigurationHandler.downloadWSBaseConfiguration(wsDir, wsConfiguration);
                configsToDirsMapping.put(wsConfigName, wsRelDir);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void downloadWSClientsBaseConfiguration(String wsClientsDir, Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download " + WSClientDirsHandler.getWSClientsConfigName("webservices_container") + " base configuration, root configuration " + appConfiguration.getPath() + ", downloading directory " + wsClientsDir + ". ";
        try {
            Configuration wsClientsConfiguration = WSConfigurationHandler.getConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
            WSConfigurationHandler.deleteDirs(wsClientsDir, wsClientsConfiguration);
            Hashtable<String, String> configsToDirsMapping = new Hashtable<String, String>();
            Map wsConfigurations = wsClientsConfiguration.getAllSubConfigurations();
            Iterator iter = wsConfigurations.keySet().iterator();
            while (iter.hasNext()) {
                String wsConfigName = (String)iter.next();
                if (wsConfigName.equals("app_jars")) {
                    WSConfigurationHandler.downloadModuleJarsConfig(IOUtil.getFilePath(wsClientsDir, "app_jars"), (Configuration)wsConfigurations.get(wsConfigName));
                    continue;
                }
                Configuration wsConfiguration = (Configuration)wsConfigurations.get(wsConfigName);
                String wsRelDir = wsConfigName;
                String wsClientDir = IOUtil.getFilePath(wsClientsDir, wsRelDir);
                WSConfigurationHandler.downloadWSClientBaseConfiguration(wsClientDir, wsConfiguration);
                configsToDirsMapping.put(wsConfigName, wsRelDir);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void downloadWSBaseConfiguration(String wsDir, Configuration wsConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download web service base configuration. Configuration " + wsConfiguration.getPath() + ", root directory " + wsDir + ". ";
        if (wsConfiguration == null) {
            return;
        }
        try {
            WSConfigurationHandler.deleteDirs(wsDir, wsConfiguration);
            String mappingsFileName = WSDirsHandler.getMappingsFileName();
            String mappingsParentRelDir = WSDirsHandler.getMappingsParentRelDir();
            String mappingsParentDir = WSDirsHandler.getMappingsParentDir(wsDir);
            Properties mappings = null;
            if (WSConfigurationHandler.existsFile(mappingsFileName, wsConfiguration, mappingsParentRelDir)) {
                WSConfigurationHandler.downloadFile(mappingsParentDir, mappingsFileName, wsConfiguration, mappingsParentRelDir);
                mappings = WSRuntimeActivator.loadMappingsFile(WSDirsHandler.getMappingsPath(wsDir));
            } else {
                mappings = WSDirsHandler.generateBaseDefaultMappings();
            }
            String wsDDescriptorFileName = WSDirsHandler.getWSDeploymentDescriptorFileName();
            String wsDDescriptorParentRelDir = WSDirsHandler.getWSDeploymentDescriptorParentRelDir(mappings);
            String wsDDescriptorParentDir = WSDirsHandler.getWSDeploymentDescriptorParentDir(wsDir, mappings);
            WSConfigurationHandler.downloadFile(wsDDescriptorParentDir, wsDDescriptorFileName, wsConfiguration, wsDDescriptorParentRelDir);
            String wsRuntimeDescriptorFileName = WSDirsHandler.getWSRuntimeDescriptorFileName();
            String wsRuntimeDescriptorRelDir = WSDirsHandler.getWSRuntimeDescriptorParentRelDir(mappings);
            String wsRuntimeDescriptorParentDir = WSDirsHandler.getWSRuntimeDescriptorParentDir(wsDir, mappings);
            WSConfigurationHandler.downloadFile(wsRuntimeDescriptorParentDir, wsRuntimeDescriptorFileName, wsConfiguration, wsRuntimeDescriptorRelDir);
            String moduleJarsRelDir = WSDirsHandler.getJarsRelDir(mappings);
            String moduleJarsDir = WSDirsHandler.getJarsDir(wsDir, mappings);
            WSConfigurationHandler.downloadConfiguration(moduleJarsDir, moduleJarsRelDir, wsConfiguration, new HashSet());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void downloadWSClientBaseConfiguration(String wsClientDir, Configuration wsClientConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download ws client base configuration. Configuration " + wsClientConfiguration.getPath() + ", root directory " + wsClientDir + ". ";
        if (wsClientConfiguration == null) {
            return;
        }
        try {
            WSConfigurationHandler.deleteDirs(wsClientDir, wsClientConfiguration);
            String mappingsFileName = WSClientDirsHandler.getMappingsFileName();
            String mappingsParentRelDir = WSClientDirsHandler.getMappingsParentRelDir();
            String mappingsParentDir = WSClientDirsHandler.getMappingsParentDir(wsClientDir);
            Properties mappings = null;
            if (WSConfigurationHandler.existsFile(mappingsFileName, wsClientConfiguration, mappingsParentRelDir)) {
                WSConfigurationHandler.downloadFile(mappingsParentDir, mappingsFileName, wsClientConfiguration, mappingsParentRelDir);
                mappings = WSClientsFactory.loadMappings(wsClientDir);
            } else {
                mappings = WSClientDirsHandler.generateBaseDefaultMappings();
            }
            String wsClientsDDescriptorFileName = WSClientDirsHandler.getWSClientsDeploymentDescriptorFileName();
            String wsClientsDDescriptorParentRelDir = WSClientDirsHandler.getWSClientsDDescriptorParentRelDir(mappings);
            String wsClientsDDescriptorParentDir = WSClientDirsHandler.getWSClientsDDescriptorParentDir(wsClientDir, mappings);
            WSConfigurationHandler.downloadFile(wsClientsDDescriptorParentDir, wsClientsDDescriptorFileName, wsClientConfiguration, wsClientsDDescriptorParentRelDir);
            String wsClientRuntimeDescriptorFileName = WSClientDirsHandler.getWSClientsRuntimeDescriptorFileName();
            String wsClientRuntimeDescriptorRelDir = WSClientDirsHandler.getWSClientsRuntimeDescriptorParentRelDir(mappings);
            String wsClientRuntimeDescriptorParentDir = WSClientDirsHandler.getWSClientsRuntimeDescriptorParentDir(wsClientDir, mappings);
            WSConfigurationHandler.downloadFile(wsClientRuntimeDescriptorParentDir, wsClientRuntimeDescriptorFileName, wsClientConfiguration, wsClientRuntimeDescriptorRelDir);
            String jarsRelDir = WSClientDirsHandler.getJarsRelDir(mappings);
            String jarsDir = WSClientDirsHandler.getJarsDir(wsClientDir, mappings);
            WSConfigurationHandler.downloadConfiguration(jarsDir, jarsRelDir, wsClientConfiguration, new HashSet());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void downloadWSConfiguration(String wsDir, String wsConfigName, Configuration rootConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download ws configuration. Root configuration " + rootConfiguration.getPath() + ", relative configuration " + WSDirsHandler.getWebServicesConfigName("webservices_container") + ", ws configuration " + wsConfigName + ", downloading directory " + wsDir + ". ";
        Configuration webServicesConfiguration = null;
        try {
            webServicesConfiguration = WSConfigurationHandler.getConfiguration(rootConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.downloadConfiguration(wsDir, wsConfigName, webServicesConfiguration, new HashSet());
    }

    public static void deleteWSConfiguration(Configuration appConfiguration, String wsConfigName) throws WSConfigurationException {
        WSConfigurationHandler.deleteConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"), wsConfigName, "/");
    }

    public static void deleteWSClientConfiguration(Configuration appConfiguration, String wsClientConfigName) throws WSConfigurationException {
        WSConfigurationHandler.deleteConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"), wsClientConfigName, "/");
    }

    public static boolean existsWebServicesConfiguration(Configuration appConfiguration) throws ConfigurationException {
        return WSConfigurationHandler.existsSubConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
    }

    public static Configuration getWebServicesConfiguration(Configuration appConfiguration) throws ConfigurationException {
        return WSConfigurationHandler.getConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
    }

    public static boolean existsWSClientsConfiguration(Configuration appConfiguration) throws ConfigurationException {
        return WSConfigurationHandler.existsSubConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
    }

    public static Configuration getWSClientsConfiguration(Configuration appConfiguration) throws ConfigurationException {
        return WSConfigurationHandler.getConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
    }

    public static Hashtable downloadConfiguration(String rootDir, String configRelPath, Configuration rootConfiguration, Set configExcludeList) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download " + configRelPath + " configuration, root configuratrion " + rootConfiguration.getPath() + ". ";
        Hashtable configsToDirsMapping = null;
        try {
            if (WSConfigurationHandler.existsSubConfiguration(rootConfiguration, configRelPath)) {
                Configuration configuration = WSConfigurationHandler.getConfiguration(rootConfiguration, configRelPath);
                configsToDirsMapping = WSConfigurationHandler.downloadConfiguration(rootDir, configuration, configExcludeList);
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return configsToDirsMapping;
    }

    public static Hashtable downloadConfiguration(String rootDir, Configuration configuration, Set configExcludeList) throws WSConfigurationException {
        WSConfigurationHandler.downloadFiles(rootDir, configuration);
        return WSConfigurationHandler.downloadSubConfigurations(rootDir, configuration, configExcludeList);
    }

    public static void downloadFiles(String rootDir, Configuration configuration) throws WSConfigurationException {
        String excMsg = "Error occured, downloading files from configuration " + configuration.getPath() + ". ";
        Map fileRelPathEntriesMap = null;
        try {
            fileRelPathEntriesMap = configuration.getAllConfigEntries();
        }
        catch (ConfigurationException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to extract file relative paths. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        Set fileRelPathEntries = fileRelPathEntriesMap.keySet();
        Iterator iter = fileRelPathEntries.iterator();
        while (iter.hasNext()) {
            String fileRelPath = (String)iter.next();
            WSConfigurationHandler.downloadFile(rootDir, fileRelPath, configuration);
        }
    }

    public static void downloadFileToRootDir(String rootDir, String fileRelPath, Configuration configuration) throws WSConfigurationException {
        String excMsg = "Error occured, downloading " + fileRelPath + ", root directory " + rootDir + ", from configuration " + configuration.getPath() + ". ";
        String parentDir = null;
        try {
            parentDir = rootDir + '/' + configuration.getMetaData().getName();
        }
        catch (ConfigurationException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to construct parent directory name. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.downloadFile(parentDir, fileRelPath, configuration);
    }

    public static boolean existsFile630(String fileRelPath, Configuration rootConfiguration) throws ConfigurationException {
        if (fileRelPath.startsWith("/")) {
            fileRelPath = fileRelPath.substring(1);
        }
        return rootConfiguration.existsConfigEntry(fileRelPath) || rootConfiguration.existsConfigEntry("/" + fileRelPath);
    }

    public static void downloadFile630(String parentDir, String fileRelPath, Configuration configuration) throws WSConfigurationException {
        String excMsg = "Error occured, downloading " + fileRelPath + ", parent directory " + parentDir + ", from configuration " + configuration.getPath() + ". ";
        InputStream in = null;
        FileOutputStream out = null;
        try {
            block4: {
                try {
                    File file = new File(parentDir, fileRelPath);
                    fileRelPath = fileRelPath.replace('\\', '/');
                    boolean isForDownload = WSConfigurationHandler.isForDownload(new File(parentDir, fileRelPath), (byte[])configuration.getConfigEntry(fileRelPath));
                    if (!isForDownload) break block4;
                    IOUtil.mkDirs(new File[]{file.getParentFile()});
                    Configuration fileConfiguration = WSConfigurationHandler.getConfiguration(configuration, IOUtil.getRelativeDir(fileRelPath));
                    in = fileConfiguration.getFile(file.getName());
                    out = new FileOutputStream(file);
                    IOUtil.copy(in, out);
                }
                catch (Exception e) {
                    Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsLocation.catching((Throwable)e);
                    Object[] args = new Object[]{excMsg, "none"};
                    throw new WSConfigurationException("webservices_5060", args, e);
                }
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            IOUtil.closeInputStreams(new InputStream[]{in}, new String[]{"Warning! " + excMsg + " Unable to close input stream. "}, wsLocation);
            IOUtil.closeOutputStreams(new OutputStream[]{out}, new String[]{"Warning! " + excMsg + "Unable to close output stream. "}, wsLocation);
            throw throwable;
        }
        Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        IOUtil.closeInputStreams(new InputStream[]{in}, new String[]{"Warning! " + excMsg + " Unable to close input stream. "}, wsLocation);
        IOUtil.closeOutputStreams(new OutputStream[]{out}, new String[]{"Warning! " + excMsg + "Unable to close output stream. "}, wsLocation);
    }

    public static boolean existsFile70(String relFilePath, Configuration rootConfiguration) throws ConfigurationException {
        String relativeDir = IOUtil.getRelativeDir(relFilePath);
        String fileName = new File(relFilePath).getName();
        if (!WSConfigurationHandler.existsSubConfiguration(rootConfiguration, relativeDir)) {
            return false;
        }
        Configuration configuration = WSConfigurationHandler.getConfiguration(rootConfiguration, relativeDir);
        return configuration.existsConfigEntry(fileName);
    }

    public static void downloadFile70(String parentDir, String relFilePath, Configuration rootConfiguration) throws WSConfigurationException {
        File file = new File(parentDir, relFilePath);
        String excMsg = "Error occured, downloading file" + file.getAbsolutePath() + " to configuration " + rootConfiguration.getPath() + ". ";
        Configuration fileConfiguration = null;
        try {
            fileConfiguration = WSConfigurationHandler.getConfiguration(rootConfiguration, IOUtil.getRelativeDir(relFilePath));
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.downloadFile630(file.getParent(), file.getName(), fileConfiguration);
    }

    public static boolean existsFile(String relFilePath, Configuration rootConfiguration, String relConfigPath) throws ConfigurationException {
        if (relConfigPath == null || relConfigPath.equals("")) {
            return WSConfigurationHandler.existsFile(relFilePath, rootConfiguration);
        }
        if (!WSConfigurationHandler.existsSubConfiguration(rootConfiguration, relConfigPath)) {
            return false;
        }
        return WSConfigurationHandler.existsFile(relFilePath, WSConfigurationHandler.getConfiguration(rootConfiguration, relConfigPath));
    }

    public static boolean existsFile(String relFilePath, Configuration rootConfiguration) throws ConfigurationException {
        return WSConfigurationHandler.existsFile630(relFilePath, rootConfiguration) || WSConfigurationHandler.existsFile70(relFilePath, rootConfiguration);
    }

    public static void downloadFile(String parentDir, String relFilePath, Configuration rootConfiguration) throws WSConfigurationException {
        File file = new File(parentDir, relFilePath);
        String excMsg = "Error occured, downloading file" + file.getAbsolutePath() + " to configuration " + rootConfiguration.getPath() + ". ";
        if (relFilePath.startsWith("/") || relFilePath.startsWith("\\")) {
            relFilePath = relFilePath.substring(1);
        }
        try {
            if (rootConfiguration.existsConfigEntry(relFilePath)) {
                WSConfigurationHandler.downloadFile630(parentDir, relFilePath, rootConfiguration);
            } else if (rootConfiguration.existsConfigEntry('/' + relFilePath)) {
                WSConfigurationHandler.downloadFile630(parentDir, '/' + relFilePath, rootConfiguration);
            } else {
                WSConfigurationHandler.downloadFile70(parentDir, relFilePath, rootConfiguration);
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void downloadFile(String parentDir, String relFilePath, Configuration rootConfiguration, String relConfigPath) throws WSConfigurationException {
        String excMsg = "Error occured, downloading file" + new File(parentDir, relFilePath).getAbsolutePath() + " to  root configuration " + rootConfiguration.getPath() + ", relative configuration " + relConfigPath + ". ";
        try {
            WSConfigurationHandler.downloadFile(parentDir, relFilePath, WSConfigurationHandler.getConfiguration(rootConfiguration, relConfigPath));
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to retrieve relative configuration. ";
            Object[] args = new Object[]{msg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void downloadFiles(Hashtable parentDirs, String[] relFilePaths, Configuration rootConfiguration, String relConfigPath) throws WSConfigurationException {
        if (relFilePaths == null) {
            return;
        }
        int i = 0;
        while (i < relFilePaths.length) {
            String relFilePath = relFilePaths[i];
            String parentDir = (String)parentDirs.get(relFilePath);
            WSConfigurationHandler.downloadFile(parentDir, relFilePaths[i], rootConfiguration, relConfigPath);
            ++i;
        }
    }

    public static void downloadFilesToRootDir(String rootDir, String[] relFilePaths, Configuration rootConfiguration, String relConfigPath) throws WSConfigurationException {
        if (relFilePaths == null) {
            return;
        }
        String parentDir = rootDir + '/' + relConfigPath;
        int i = 0;
        while (i < relFilePaths.length) {
            WSConfigurationHandler.downloadFile(parentDir, relFilePaths[i], rootConfiguration, relConfigPath);
            ++i;
        }
    }

    public static Hashtable downloadSubConfigurations(String rootDir, Configuration configuration, Set configExcludeList) throws WSConfigurationException {
        String excMsg = "Error occured, downloading subconfigurations for configuration " + configuration.getPath() + ". ";
        Hashtable configsToDirsMapping = null;
        try {
            WSConfigurationHandler.deleteDirs(rootDir, configuration);
            configsToDirsMapping = WSConfigurationHandler.downloadConfigurations(rootDir, configuration.getAllSubConfigurations(), configExcludeList);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new Object[]{msg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return configsToDirsMapping;
    }

    public static void deleteDirs(String rootDir, Configuration configuration) throws WSConfigurationException {
        String excMsg = "Error occured, deleting child directories for directory " + rootDir + ", configuration " + configuration.getPath() + ". ";
        if (rootDir == null) {
            return;
        }
        File[] files = new File(rootDir).listFiles();
        if (files == null) {
            return;
        }
        Map subConfigurations = new HashMap();
        try {
            subConfigurations = configuration.getAllSubConfigurations();
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new Object[]{msg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (currentFile.isDirectory() && !subConfigurations.containsKey(currentFile.getName())) {
                boolean isDeleted = true;
                try {
                    isDeleted = IOUtil.deleteDir(currentFile);
                }
                catch (Exception e) {
                    Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsLocation.catching((Throwable)e);
                    String msg = excMsg;
                    Object[] args = new Object[]{msg, "none"};
                    throw new WSConfigurationException("webservices_5060", args, e);
                }
                if (!isDeleted) {
                    String msg = excMsg + "Unable to delete directory " + currentFile + ". ";
                    Object[] args = new Object[]{msg, "none"};
                    throw new WSConfigurationException("webservices_5060", args);
                }
            }
            ++i;
        }
    }

    public static Hashtable downloadConfigurations(String parentDir, Map configurations, Set configExcludeList) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download configurations to parent directory " + parentDir + ". ";
        if (configurations == null) {
            return new Hashtable();
        }
        Hashtable<String, String> congigsToDirsMapping = new Hashtable<String, String>();
        Iterator iter = configurations.keySet().iterator();
        while (iter.hasNext()) {
            String configurationName = (String)iter.next();
            if (configExcludeList.contains(configurationName)) continue;
            Configuration configuration = (Configuration)configurations.get(configurationName);
            String relDir = WSConfigurationHandler.downloadConfigurationToParent(parentDir, configuration, configExcludeList);
            try {
                congigsToDirsMapping.put(configuration.getMetaData().getName(), relDir);
            }
            catch (ConfigurationException e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsLocation.catching((Throwable)e);
                String msg = excMsg + "Unable to construct configuration to directory name mapping for configuration " + configuration.getPath() + ". ";
                Object[] args = new Object[]{msg, "none"};
                throw new WSConfigurationException("webservices_5060", args, e);
            }
        }
        return congigsToDirsMapping;
    }

    public static String downloadConfigurationToParent(String parentDir, Configuration configuration, Set configExcludeList) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download configuration" + configuration.getPath() + " to parent directory " + parentDir + ". ";
        String relDir = null;
        String rootDir = null;
        try {
            relDir = configuration.getMetaData().getName();
            rootDir = parentDir + '/' + configuration.getMetaData().getName();
        }
        catch (ConfigurationException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to construct directory name for download.";
            Object[] args = new Object[]{msg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.downloadConfiguration(rootDir, configuration, configExcludeList);
        return relDir;
    }

    public static void uploadDirectory(String dir, String configRelPath, Configuration rootConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to make " + configRelPath + " configuration, root configuratrion " + rootConfiguration.getPath() + ". ";
        try {
            if (!IOUtil.isEmptyDir(dir)) {
                Configuration configuration = WSConfigurationHandler.getAndMakeConfiguration(rootConfiguration, configRelPath);
                WSConfigurationHandler.uploadDirectory(dir, configuration);
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void uploadDirectory(String dir, Configuration configuration) throws WSConfigurationException {
        WSConfigurationHandler.uploadDirectory(new File(dir), configuration);
    }

    public static void uploadDirectory(File dir, Configuration configuration) throws WSConfigurationException {
        String excMsg = "Error occured, uploading directory " + dir.getAbsolutePath() + " to configuration " + configuration.getPath() + ". ";
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                if (file.isFile()) {
                    WSConfigurationHandler.uploadFile(file.getParent(), file.getName(), configuration);
                } else {
                    WSConfigurationHandler.uploadDirectory(file, WSConfigurationHandler.getAndMakeConfiguration(configuration, file.getName()));
                }
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsLocation.catching((Throwable)e);
                Object[] args = new Object[]{excMsg, "none"};
                throw new WSConfigurationException("webservices_5060", args, e);
            }
            ++i;
        }
    }

    public static void uploadFile630(String parentDir, String relFilePath, Configuration rootConfiguration) throws WSConfigurationException {
        File file = new File(parentDir, relFilePath);
        String excMsg = "Error occured, uploading file" + file.getAbsolutePath() + " to configuration " + rootConfiguration.getPath() + ". ";
        try {
            Configuration fileConfiguration = WSConfigurationHandler.getAndMakeConfiguration(rootConfiguration, IOUtil.getRelativeDir(relFilePath));
            relFilePath = relFilePath.replace('\\', '/');
            if (relFilePath.startsWith("/") || relFilePath.startsWith("\\")) {
                relFilePath = relFilePath.substring(1);
            }
            if (!rootConfiguration.existsConfigEntry(relFilePath)) {
                if (!rootConfiguration.existsConfigEntry('/' + relFilePath)) {
                    rootConfiguration.addConfigEntry(relFilePath, (Object)HashUtils.generateFileHash((File)file));
                    fileConfiguration.addFileEntry(file);
                } else {
                    rootConfiguration.modifyConfigEntry('/' + relFilePath, (Object)HashUtils.generateFileHash((File)file));
                    fileConfiguration.updateFile(file);
                }
            } else {
                rootConfiguration.modifyConfigEntry(relFilePath, (Object)HashUtils.generateFileHash((File)file));
                fileConfiguration.updateFile(file);
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void uploadFile(String parentDir, String relFilePath, Configuration rootConfiguration) throws WSConfigurationException {
        File file = new File(parentDir, relFilePath);
        String excMsg = "Error occured, uploading file" + file.getAbsolutePath() + " to configuration " + rootConfiguration.getPath() + ". ";
        if (relFilePath.startsWith("/") || relFilePath.startsWith("\\")) {
            relFilePath = relFilePath.substring(1);
        }
        try {
            if (rootConfiguration.existsConfigEntry(relFilePath) || rootConfiguration.existsConfigEntry('/' + relFilePath)) {
                WSConfigurationHandler.uploadFile630(parentDir, relFilePath, rootConfiguration);
            } else {
                WSConfigurationHandler.uploadFile70(parentDir, relFilePath, rootConfiguration);
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void uploadFile(String parentDir, String relFilePath, Configuration rootConfiguration, String relConfigPath) throws WSConfigurationException {
        String excMsg = "Error occured, uploading file" + new File(parentDir, relFilePath).getAbsolutePath() + " to  root configuration " + rootConfiguration.getPath() + ", relative configuration " + relConfigPath + ". ";
        try {
            WSConfigurationHandler.uploadFile(parentDir, relFilePath, WSConfigurationHandler.getAndMakeConfiguration(rootConfiguration, relConfigPath));
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static void uploadFile70(String parentDir, String relFilePath, Configuration rootConfiguration) throws WSConfigurationException {
        File file = new File(parentDir, relFilePath);
        String excMsg = "Error occured, uploading file" + file.getAbsolutePath() + " to configuration " + rootConfiguration.getPath() + ". ";
        Configuration fileConfiguration = null;
        try {
            fileConfiguration = WSConfigurationHandler.getAndMakeConfiguration(rootConfiguration, IOUtil.getRelativeDir(relFilePath));
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        WSConfigurationHandler.uploadFile630(file.getParent(), file.getName(), fileConfiguration);
    }

    public static boolean existsSubConfiguration(Configuration rootConfiguration, String str) throws ConfigurationException {
        String delimiter = new String(new char[]{'/'});
        str = str.replace('\\', '/');
        return WSConfigurationHandler.existsSubConfiguration(rootConfiguration, str, delimiter);
    }

    public static boolean existsSubConfiguration(Configuration rootConfiguration, String str, String delimiter) throws ConfigurationException {
        StringTokenizer stringTokenizer = new StringTokenizer(str, delimiter);
        Configuration configuration = rootConfiguration;
        while (stringTokenizer.hasMoreTokens()) {
            String currentToken = stringTokenizer.nextToken();
            if (!configuration.existsSubConfiguration(currentToken)) {
                return false;
            }
            configuration = configuration.getSubConfiguration(currentToken);
        }
        return true;
    }

    public static Configuration getConfiguration(Configuration rootConfiguration, String str) throws ConfigurationException {
        return WSConfigurationHandler.getConfiguration(rootConfiguration, str, false);
    }

    public static Configuration getAndMakeConfiguration(Configuration rootConfiguration, String str) throws ConfigurationException {
        return WSConfigurationHandler.getConfiguration(rootConfiguration, str, true);
    }

    public static Configuration getConfiguration(Configuration rootConfiguration, String str, boolean toBeMade) throws ConfigurationException {
        String delimiter = new String(new char[]{'/'});
        str = str.replace('\\', '/');
        return WSConfigurationHandler.getConfiguration(rootConfiguration, str, delimiter, toBeMade);
    }

    public static Configuration getConfiguration(Configuration rootConfiguration, String str, String delimiter, boolean toBeMade) throws ConfigurationException {
        StringTokenizer stringTokenizer = new StringTokenizer(str, delimiter);
        Configuration configuration = rootConfiguration;
        while (stringTokenizer.hasMoreTokens()) {
            String currentToken = stringTokenizer.nextToken();
            if (!configuration.existsSubConfiguration(currentToken) && toBeMade) {
                configuration.createSubConfiguration(currentToken);
            }
            configuration = configuration.getSubConfiguration(currentToken);
        }
        return configuration;
    }

    public static void deleteConfiguration(Configuration rootConfiguration, String relConfigName, String delimiter) throws WSConfigurationException {
        WSConfigurationHandler.deleteConfiguration(rootConfiguration, "", relConfigName, delimiter);
    }

    public static void deleteConfiguration(Configuration rootConfiguration, String relConfigPath, String relConfigName, String delimiter) throws WSConfigurationException {
        String excMsg = "Error occured, tring to delete configuration " + relConfigName + ", root configuration " + rootConfiguration.getPath() + ", relative configuration " + relConfigPath + ". ";
        try {
            if (!WSConfigurationHandler.existsSubConfiguration(rootConfiguration, relConfigPath)) {
                return;
            }
            Configuration relConfiguration = WSConfigurationHandler.getConfiguration(rootConfiguration, relConfigPath, delimiter, false);
            String relConfigPath2 = IOUtil.getParentPath(relConfigName, delimiter);
            String configName = IOUtil.getName(relConfigName, delimiter);
            if (!WSConfigurationHandler.existsSubConfiguration(relConfiguration, relConfigPath2)) {
                return;
            }
            Configuration relConfiguration2 = WSConfigurationHandler.getConfiguration(relConfiguration, relConfigPath2);
            relConfiguration2.deleteSubConfigurations(new String[]{configName});
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    public static boolean isForDownload(String filePath, byte[] dbCRC) throws IOException {
        return WSConfigurationHandler.isForDownload(new File(filePath), dbCRC);
    }

    private static boolean isForDownload(File file, byte[] dbCRC) throws IOException {
        byte[] crc;
        boolean isForDownload = false;
        isForDownload = file.exists() ? !HashCompare.compareHash((byte[])(crc = HashUtils.generateFileHash((File)file)), (byte[])dbCRC) : true;
        return isForDownload;
    }

    public static void uploadModuleJarsDir(File moduleJarsDir, Hashtable moduleCrcTable, Configuration configuration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to upload " + moduleJarsDir.getAbsolutePath() + " into configuration " + configuration.getPath() + ". ";
        try {
            String moduleJarsConfigName = moduleJarsDir.getName();
            if (WSConfigurationHandler.existsSubConfiguration(configuration, moduleJarsConfigName)) {
                WSConfigurationHandler.deleteConfiguration(configuration, moduleJarsConfigName, "/");
            }
            Configuration moduleJarsConfig = WSConfigurationHandler.getAndMakeConfiguration(configuration, moduleJarsConfigName);
            WSConfigurationHandler.uploadDirectory(moduleJarsDir, moduleJarsConfig);
            Configuration moduleCrcConfiguration = WSConfigurationHandler.getAndMakeConfiguration(moduleJarsConfig, "module_crc_table");
            WSConfigurationHandler.uploadTable(moduleCrcTable, moduleCrcConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
    }

    private static void uploadTable(Hashtable table, Configuration configuration) throws ConfigurationException {
        if (table == null) {
            return;
        }
        Enumeration keysEnum = table.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            configuration.addConfigEntry(key, table.get(key));
        }
    }

    private static Hashtable downloadModuleJarsConfig(String rootDir, Configuration moduleJarsConfig) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download " + moduleJarsConfig.getPath() + ", root directory " + rootDir + ". ";
        Hashtable moduleCrcTable = new Hashtable();
        try {
            HashSet<String> configExcludeList = new HashSet<String>();
            configExcludeList.add("module_crc_table");
            WSConfigurationHandler.downloadConfiguration(rootDir, moduleJarsConfig, configExcludeList);
            if (WSConfigurationHandler.existsSubConfiguration(moduleJarsConfig, "module_crc_table")) {
                Configuration moduleCrcConfiguration = WSConfigurationHandler.getConfiguration(moduleJarsConfig, "module_crc_table");
                moduleCrcTable = WSConfigurationHandler.loadTable(moduleCrcConfiguration);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return moduleCrcTable;
    }

    public static Hashtable loadWSModuleCrcTable(Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download web services module crc table, configuration " + appConfiguration.getPath() + ". ";
        Hashtable moduleCrcTable = null;
        try {
            if (!WSConfigurationHandler.existsSubConfiguration(appConfiguration, ModuleDirsHandler.getAppJarsConfigName(WSDirsHandler.getWebServicesConfigName("webservices_container")))) {
                return new Hashtable();
            }
            Configuration moduleJarsConfig = WSConfigurationHandler.getConfiguration(appConfiguration, ModuleDirsHandler.getAppJarsConfigName(WSDirsHandler.getWebServicesConfigName("webservices_container")));
            if (!WSConfigurationHandler.existsSubConfiguration(moduleJarsConfig, "module_crc_table")) {
                return new Hashtable();
            }
            Configuration moduleCrcConfiguration = WSConfigurationHandler.getConfiguration(moduleJarsConfig, "module_crc_table");
            moduleCrcTable = WSConfigurationHandler.loadTable(moduleCrcConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return moduleCrcTable;
    }

    public static Hashtable loadWSClientsModuleCrcTable(Configuration appConfiguration) throws WSConfigurationException {
        String excMsg = "Error occured, trying to download ws clients module crc table, configuration " + appConfiguration.getPath() + ". ";
        Hashtable moduleCrcTable = null;
        try {
            if (!WSConfigurationHandler.existsSubConfiguration(appConfiguration, ModuleDirsHandler.getAppJarsConfigName(WSClientDirsHandler.getWSClientsConfigName("webservices_container")))) {
                return new Hashtable();
            }
            Configuration moduleJarsConfig = WSConfigurationHandler.getConfiguration(appConfiguration, ModuleDirsHandler.getAppJarsConfigName(WSClientDirsHandler.getWSClientsConfigName("webservices_container")));
            if (!WSConfigurationHandler.existsSubConfiguration(moduleJarsConfig, "module_crc_table")) {
                return new Hashtable();
            }
            Configuration moduleCrcConfiguration = WSConfigurationHandler.getConfiguration(moduleJarsConfig, "module_crc_table");
            moduleCrcTable = WSConfigurationHandler.loadTable(moduleCrcConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSConfigurationException("webservices_5060", args, e);
        }
        return moduleCrcTable;
    }

    private static Hashtable loadTable(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            return new Hashtable();
        }
        Hashtable table = new Hashtable();
        Map configEntries = configuration.getAllConfigEntries();
        Iterator iter = configEntries.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            table.put(key, configEntries.get(key));
        }
        return table;
    }

    private static HashMap constructDirs(String parentDir, Iterator relDirsIterator) {
        if (relDirsIterator == null) {
            return new HashMap();
        }
        HashMap<String, String> dirs = new HashMap<String, String>();
        while (relDirsIterator.hasNext()) {
            String relDir = (String)relDirsIterator.next();
            dirs.put(relDir, IOUtil.getFilePaths(parentDir, new String[]{relDir})[0]);
        }
        return dirs;
    }
}

