/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.connection;

import com.sap.engine.interfaces.webservices.client.WSConnection;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.server.connection.ConnectionIdentifier;
import com.sap.engine.services.webservices.server.connection.WSConnectionImpl;
import java.util.Enumeration;

public class WSConnectionRegistry {
    private HashMapObjectObject connections = null;

    public void registerConnection(WSConnection wsConnection) throws RegistryException {
        ConnectionIdentifier connectionId;
        if (this.connections == null) {
            this.connections = new HashMapObjectObject();
        }
        if (this.connections.get((Object)(connectionId = ((WSConnectionImpl)wsConnection).getConnectionIdentifier())) != null) {
            throw new RegistryException("webservices_5012", new Object[]{connectionId.toString()});
        }
        this.connections.put((Object)connectionId, (Object)wsConnection);
    }

    public void unregisterConnection(ConnectionIdentifier connectionIdentifier) {
        if (this.connections != null) {
            this.connections.remove((Object)connectionIdentifier);
        }
    }

    public WSConnection getConnection(ConnectionIdentifier connectionIdentifier) throws RegistryException {
        WSConnection wsConnection = null;
        if (this.connections != null) {
            wsConnection = (WSConnection)this.connections.get((Object)connectionIdentifier);
        }
        if (wsConnection == null) {
            throw new RegistryException("webservices_5011", new Object[]{connectionIdentifier.toString()});
        }
        return wsConnection;
    }

    public ConnectionIdentifier[] listConnections() {
        if (this.connections == null) {
            return new ConnectionIdentifier[0];
        }
        int connectionsSize = this.connections.size();
        ConnectionIdentifier[] connectionIds = new ConnectionIdentifier[connectionsSize];
        Enumeration connectionsEnum = this.connections.keys();
        int i = 0;
        while (connectionsEnum.hasMoreElements()) {
            connectionIds[i++] = (ConnectionIdentifier)connectionsEnum.nextElement();
        }
        return connectionIds;
    }

    public WSConnection[] getConnections() {
        if (this.connections == null) {
            return new WSConnection[0];
        }
        int connectionsSize = this.connections.size();
        WSConnection[] connectionsArr = new WSConnection[connectionsSize];
        Enumeration connectionsEnum = this.connections.elements();
        int i = 0;
        while (connectionsEnum.hasMoreElements()) {
            connectionsArr[i++] = (WSConnection)connectionsEnum.nextElement();
        }
        return connectionsArr;
    }
}

