/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.connection;

import com.sap.engine.services.webservices.server.connection.WSConnectionImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WSConnectionOutputStream
extends OutputStream {
    private static int DEFAULT_BUFFER_SIZE = 1024;
    private WSConnectionImpl wsConnection;
    private ByteArrayOutputStream buffer;

    public WSConnectionOutputStream(WSConnectionImpl wsConnection) {
        this.wsConnection = wsConnection;
        this.buffer = new ByteArrayOutputStream(DEFAULT_BUFFER_SIZE);
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
        if (this.buffer.size() > DEFAULT_BUFFER_SIZE) {
            this.flush();
        }
    }

    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
        this.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
        this.flush();
    }

    public void flush() throws IOException {
        byte[] data = this.buffer.toByteArray();
        this.wsConnection.sendRequest(data);
        this.buffer.reset();
    }

    public void close() throws IOException {
        this.flush();
        this.buffer.close();
    }
}

