/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.connection;

import com.sap.engine.interfaces.webservices.client.WSConnection;
import com.sap.engine.services.webservices.server.connection.ConnectionIdentifier;
import com.sap.engine.services.webservices.server.connection.WSConnectionManipulator;
import com.sap.engine.services.webservices.server.connection.WSConnectionOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class WSConnectionImpl
implements WSConnection {
    private ConnectionIdentifier connectionIdentifier = null;
    private PipedOutputStream dataStream;
    private PipedInputStream inputStream = null;
    private WSConnectionManipulator wsConnectionManipulator = null;

    public WSConnectionImpl(int containerId, int connectionId, WSConnectionManipulator wsConnectionManipulator) throws IOException {
        this.connectionIdentifier = new ConnectionIdentifier(containerId, connectionId);
        this.wsConnectionManipulator = wsConnectionManipulator;
        this.dataStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.dataStream);
    }

    public ConnectionIdentifier getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return new WSConnectionOutputStream(this);
    }

    public void receive(byte[] data, int offset, int length) throws IOException {
        if (length > 0) {
            this.dataStream.write(data, offset, length);
            this.dataStream.flush();
        } else {
            this.dataStream.close();
        }
    }

    public void sendRequest(byte[] data) throws IOException {
        this.wsConnectionManipulator.send(this.connectionIdentifier.getContainerId(), this.connectionIdentifier.getConnectionId(), data);
    }

    public void close() throws IOException {
        this.wsConnectionManipulator.closeConnection(this.connectionIdentifier);
    }
}

