/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.connection;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.core.pool.PoolContext;
import com.sap.engine.interfaces.webservices.client.WSConnection;
import com.sap.engine.interfaces.webservices.client.WSConnectionFactory;
import com.sap.engine.lib.xml.util.Convert;
import com.sap.engine.services.webservices.common.OpenSocketRequest;
import com.sap.engine.services.webservices.common.Request;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.exceptions.lib.WSConnectionException;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.connection.ConnectionIdentifier;
import com.sap.engine.services.webservices.server.connection.WSConnectionImpl;
import com.sap.engine.services.webservices.server.connection.WSConnectionManipulator;
import com.sap.tc.logging.Location;
import java.io.IOException;

public class WSConnectionFactoryImpl
implements WSConnectionFactory,
WSConnectionManipulator {
    private ApplicationServiceContext serviceCtx = null;

    public WSConnectionFactoryImpl(ApplicationServiceContext serviceCtx) {
        this.serviceCtx = serviceCtx;
    }

    public WSConnection getConnection(String host, int port, String proxyHost, int proxyPort) throws IOException {
        return this.getConnection(host, port, proxyHost, proxyPort, false);
    }

    public WSConnection getSSLConnection(String host, int port, String proxyHost, int proxyPort) throws IOException {
        return this.getConnection(host, port, proxyHost, proxyPort, true);
    }

    private WSConnection getConnection(String host, int port, String proxyHost, int proxyPort, boolean secure) throws WSConnectionException {
        int dispatcherId = 0;
        int connectionId = 0;
        try {
            OpenSocketRequest openSocketRequest = new OpenSocketRequest(host, port, secure);
            openSocketRequest.setProxyHost(proxyHost);
            openSocketRequest.setProxyPort(proxyPort);
            dispatcherId = this.getDispatcher(this.serviceCtx.getClusterContext().getClusterMonitor().getParticipants());
            MessageAnswer messageAnswer = this.sendRequest(dispatcherId, 0, openSocketRequest);
            connectionId = Convert.byteArrToInt((byte[])messageAnswer.getMessage(), (int)messageAnswer.getOffset());
            if (connectionId == -1) {
                Object[] args = new Object[]{"Connection refused by dispatcher!", "trying to open socket - host " + host + ", port: " + port};
                throw new WSConnectionException("webservices_5030", args);
            }
            WSConnectionImpl wsConnection = new WSConnectionImpl(dispatcherId, connectionId, this);
            this.registerConnection(wsConnection);
            return wsConnection;
        }
        catch (WSConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"An exception occured in attempt to create ws connection", "trying to open socket - host " + host + ", port: " + port};
            throw new WSConnectionException("webservices_5030", args, (Throwable)e);
        }
    }

    public void receive(int communicationContainerId, int connectionId, byte[] request, int offset, int length) throws WSConnectionException {
        try {
            WSConnection wsConnection = WSContainer.getWsConnectionRegistry().getConnection(new ConnectionIdentifier(communicationContainerId, connectionId));
            ((WSConnectionImpl)wsConnection).receive(request, offset, length);
            this.serviceCtx.getCoreContext().getPoolContext().release(request);
        }
        catch (IOException ioe) {
            Location location = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            location.catching((Throwable)ioe);
            this.send(communicationContainerId, connectionId, new byte[0], (byte)1);
        }
        catch (RegistryException e) {
            Location location = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            location.logT(200, "ConnectionID[" + connectionId + "]");
            e.setLogSettings(null, 200, location);
            e.log();
            this.send(communicationContainerId, connectionId, new byte[0], (byte)1);
        }
    }

    public void send(int communicationId, int connectionId, byte[] data) throws WSConnectionException {
        try {
            int realDataSize = data.length;
            byte[] buf = this.serviceCtx.getCoreContext().getPoolContext().get(realDataSize);
            System.arraycopy(data, 0, buf, 0, realDataSize);
            this.serviceCtx.getClusterContext().getApplicationSessionContext().getConnection().send(communicationId, connectionId, buf, 0, realDataSize);
        }
        catch (ClusterException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            wsLocation.catching((Throwable)e);
            int currentParticipantId = this.serviceCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            Object[] args = new Object[]{new Integer(currentParticipantId), new Integer(communicationId), "Unable to send data from server to dispatcher, because an exception occurred.", new Integer(connectionId)};
            throw new WSConnectionException("webservices_5036", args, (Throwable)e);
        }
    }

    public void send(int communicationId, int connectionId, byte[] data, byte flag) throws WSConnectionException {
        try {
            int realDataSize = data.length;
            byte[] buf = this.serviceCtx.getCoreContext().getPoolContext().get(realDataSize);
            System.arraycopy(data, 0, buf, 0, realDataSize);
            this.serviceCtx.getClusterContext().getApplicationSessionContext().getConnection().send(communicationId, connectionId, buf, 0, realDataSize, flag);
        }
        catch (ClusterException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            wsLocation.catching((Throwable)e);
            int currentParticipantId = this.serviceCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            Object[] args = new Object[]{new Integer(currentParticipantId), new Integer(communicationId), "Unable to send data from server to dispatcher, because an exception occurred.", new Integer(connectionId)};
            throw new WSConnectionException("webservices_5036", args, (Throwable)e);
        }
    }

    public void closeConnection(ConnectionIdentifier connectionIdentifier) throws WSConnectionException {
        this.send(connectionIdentifier.getContainerId(), connectionIdentifier.getConnectionId(), new byte[0], (byte)1);
        WSContainer.getWsConnectionRegistry().unregisterConnection(connectionIdentifier);
    }

    private MessageAnswer sendRequest(int dispatcherId, int requestId, Request request) throws WSConnectionException {
        MessageAnswer messageAnswer = null;
        OpenSocketRequest openSocketRequest = (OpenSocketRequest)request;
        try {
            MessageContext messageCtx = this.serviceCtx.getClusterContext().getMessageContext();
            PoolContext poolCtx = this.serviceCtx.getCoreContext().getPoolContext();
            byte[] messageRequestBytes = request.getBytes();
            int realMessageSize = messageRequestBytes.length;
            byte[] buf = poolCtx.get(realMessageSize);
            System.arraycopy(messageRequestBytes, 0, buf, 0, realMessageSize);
            if (dispatcherId == -1) {
                int currentParticipantId = this.serviceCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
                Object[] args = new Object[]{new Integer(currentParticipantId), new Integer(dispatcherId), "Server error! The current server node is participant in cluster with no dispatcher nodes", openSocketRequest.getRequestName(), "trying to open socket -  host: " + openSocketRequest.getHost() + ", port " + openSocketRequest.getPort()};
                throw new WSConnectionException("webservices_5031", args);
            }
            messageAnswer = messageCtx.sendAndWaitForAnswer(dispatcherId, requestId, buf, 0, realMessageSize, 0L);
        }
        catch (ClusterException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            wsLocation.catching((Throwable)e);
            int currentParticipantId = this.serviceCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            Object[] args = new Object[]{new Integer(currentParticipantId), new Integer(dispatcherId), "An exception occurred", openSocketRequest.getRequestName(), "trying to open socket -  host: " + openSocketRequest.getHost() + ", port " + openSocketRequest.getPort()};
            throw new WSConnectionException("webservices_5031", args);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            wsLocation.catching((Throwable)e);
            int currentParticipantId = this.serviceCtx.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            Object[] args = new Object[]{new Integer(currentParticipantId), new Integer(dispatcherId), "An exception occurred", openSocketRequest.getRequestName(), "trying to open socket -  host: " + openSocketRequest.getHost() + ", port " + openSocketRequest.getPort()};
            throw new WSConnectionException("webservices_5031", args);
        }
        return messageAnswer;
    }

    private void registerConnection(WSConnection wsConnection) {
        try {
            WSContainer.getWsConnectionRegistry().registerConnection(wsConnection);
        }
        catch (RegistryException e) {
            Location location = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
            location.logT(200, "ConnectionID[" + ((WSConnectionImpl)wsConnection).getConnectionIdentifier().getConnectionId() + "]");
            e.setLogSettings(null, 200, location);
            e.log();
        }
    }

    private int getDispatcher(ClusterElement[] clusterParticipants) {
        int clusterParticipantsSize = clusterParticipants.length;
        int i = 0;
        while (i < clusterParticipantsSize) {
            ClusterElement currentClusterElement = clusterParticipants[i];
            if (currentClusterElement.getType() == 1 && currentClusterElement.getState() == 3) {
                return currentClusterElement.getClusterId();
            }
            ++i;
        }
        return -1;
    }
}

