/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.connection;

import com.sap.engine.services.webservices.exceptions.lib.WSConnectionException;
import com.sap.engine.services.webservices.server.connection.ConnectionIdentifier;
import com.sap.engine.services.webservices.server.connection.WSByteArrayInputStream;
import com.sap.engine.services.webservices.server.connection.WSConnectionManipulator;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class WSConnection {
    private static int DEFAULT_BUFFER_SIZE = 1024;
    private ConnectionIdentifier connectionIdentifier = null;
    private WSByteArrayInputStream inputStream = null;
    private ByteArrayOutputStream outputStream = null;
    private WSConnectionManipulator wsConnectionManipulator = null;

    public WSConnection(ConnectionIdentifier connectionIdentifier, WSConnectionManipulator wsConnectionManipulator) {
        this.connectionIdentifier = connectionIdentifier;
        this.wsConnectionManipulator = wsConnectionManipulator;
    }

    public WSConnection(int containerId, int connectionId, WSConnectionManipulator wsConnectionManipulator) {
        this.connectionIdentifier = new ConnectionIdentifier(containerId, connectionId);
        this.wsConnectionManipulator = wsConnectionManipulator;
    }

    public void init() {
        this.inputStream = new WSByteArrayInputStream(new byte[DEFAULT_BUFFER_SIZE]);
        this.outputStream = new ByteArrayOutputStream(DEFAULT_BUFFER_SIZE);
    }

    public ConnectionIdentifier getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void receive(byte[] data) {
        this.inputStream.saveData(data);
    }

    public void flushBuffer() throws WSConnectionException {
        byte[] data = this.outputStream.toByteArray();
        this.wsConnectionManipulator.send(this.connectionIdentifier.getContainerId(), this.connectionIdentifier.getConnectionId(), data);
        this.outputStream.reset();
    }

    public void close() throws WSConnectionException {
        this.wsConnectionManipulator.closeConnection(this.connectionIdentifier);
    }
}

