/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.connection;

import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;

public class WSByteArrayInputStream
extends ByteArrayInputStream {
    private byte[] buf = null;
    private int bytesRead = 0;

    public WSByteArrayInputStream(byte[] buf) {
        super(buf);
        this.buf = buf;
    }

    public synchronized int read() {
        int bufferSize = this.buf.length;
        this.bytesRead = this.bytesRead < bufferSize + 4 ? bufferSize : (this.bytesRead += 4);
        this.notifyAll();
        return super.read();
    }

    public synchronized int read(byte[] buf, int off, int len) {
        int bufferSize = this.buf.length;
        int bytesReadLen = super.read(buf, off, len);
        this.bytesRead = this.bytesRead < bufferSize + bytesReadLen ? bufferSize : (this.bytesRead += bytesReadLen);
        this.notifyAll();
        return bytesReadLen;
    }

    public synchronized void saveData(byte[] data) {
        int len = data.length;
        while (len > this.bytesRead) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                Location wsLocation = Location.getLocation((String)WSLogging.CONNECTION_LOCATION);
                wsLocation.catching((Throwable)e);
            }
        }
        int remainder = this.buf.length - this.bytesRead;
        System.arraycopy(this.buf, this.bytesRead, this.buf, 0, remainder);
        System.arraycopy(data, 0, this.buf, remainder, len);
        this.reset();
    }
}

