/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.command;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.registry.WebServiceRegistry;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ListWebServicesCommand
implements Command {
    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        try {
            if (params.length == 0) {
                output.write(this.getWebServices(false, null).getBytes());
            } else if (params[0].equalsIgnoreCase("-a")) {
                output.write(this.getWebServices(true, params[1]).getBytes());
            } else if (params[0].equals("-ws") && params.length == 4) {
                output.write(this.getWSInfo(new WSIdentifier(params[1], params[2], params[3]), environment).getBytes());
            } else {
                output.write(this.getHelpMessage().getBytes());
            }
            output.flush();
        }
        catch (IOException e) {
            Location serverLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            serverLocation.catching("Unexpeced exception occured list_ws command.", (Throwable)e);
            try {
                environment.getErrorStream().write(("Unexpeced exception occured list_ws command: " + e.getMessage()).getBytes());
            }
            catch (IOException exc) {
                serverLocation.catching("IOException occured, printing error message while executing list_ws command.", (Throwable)exc);
            }
        }
    }

    public String getName() {
        return "list_ws";
    }

    public String getGroup() {
        return "webservices";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String helpMessage = "Prints all started webservices on the current cluster element." + nl + nl + "USAGE    : " + this.getName() + " -[<parameter>] " + nl + "Parameter: " + nl + "  default             : lists all started webservices" + nl + "  a <application name>: lists all started webservices for the specified application" + nl + "  ws <application name> <module name> <web service name>: lists additional information for the specified web service " + nl + "- all ws congigurations and their transport addresses." + nl;
        return helpMessage;
    }

    private String getWebServices(boolean applicationFlag, String applicationName) {
        String nl;
        String resultString = nl = SystemProperties.getProperty((String)"line.separator");
        WebServiceRegistry wsRegistry = WSContainer.getWSRegistry();
        WSIdentifier[] wsIds = new WSIdentifier[]{};
        wsIds = applicationFlag ? wsRegistry.listWebServicesByApplicationName(applicationName) : wsRegistry.listWebServices();
        int wsIdsSize = wsIds.length;
        if (wsIdsSize == 0) {
            resultString = applicationFlag ? "No webservices registered/started for application: " + applicationName + ". " + nl : "No webservices have been registered/started." + nl;
        }
        int i = 0;
        while (i < wsIdsSize) {
            WSIdentifier wsId = wsIds[i];
            if (!applicationFlag) {
                resultString = resultString + "Application: " + wsId.getApplicationName() + nl;
            }
            resultString = resultString + "Module     : " + wsId.getJarName() + nl;
            resultString = resultString + "Web Service: " + wsId.getServiceName() + nl + nl;
            ++i;
        }
        return resultString;
    }

    private String getWSInfo(WSIdentifier wsIdentifier, Environment environment) {
        String nl;
        String resultString = nl = SystemProperties.getProperty((String)"line.separator");
        WebServiceRegistry webServiceRegistry = WSContainer.getWSRegistry();
        if (!webServiceRegistry.contains(wsIdentifier)) {
            resultString = resultString + "The specified web service is not registered/started: " + nl + wsIdentifier + nl;
            return resultString;
        }
        try {
            WSRuntimeDefinition wsRuntimeDefinition = webServiceRegistry.getWebService(wsIdentifier);
            String[] seiInfoes = this.getSEIInfoes(wsRuntimeDefinition.getServiceEndpointDefinitions());
            resultString = resultString + this.getConcatStrings(seiInfoes);
        }
        catch (RegistryException e) {
            Location serverLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            serverLocation.catching("Unexpeced exception occured, executing list_ws command.", (Throwable)((Object)e));
            try {
                environment.getErrorStream().write(("Unexpeced exception occured, executing list_ws command: " + ((Throwable)((Object)e)).getMessage()).getBytes());
            }
            catch (IOException exc) {
                serverLocation.catching("IOException occured, printing error message while executing list_ws command.", (Throwable)exc);
            }
        }
        return resultString;
    }

    private String[] getSEIInfoes(ServiceEndpointDefinition[] endpointDefinitions) {
        if (endpointDefinitions == null) {
            return new String[0];
        }
        int endpointSize = endpointDefinitions.length;
        String[] seiInfoes = new String[endpointSize];
        int i = 0;
        while (i < endpointSize) {
            seiInfoes[i] = this.getSEIInfo(endpointDefinitions[i]);
            ++i;
        }
        return seiInfoes;
    }

    private String getSEIInfo(ServiceEndpointDefinition endpointDefinition) {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String resultString = "";
        resultString = resultString + "WS Configuration : " + endpointDefinition.getConfigurationName() + nl;
        resultString = resultString + "Transport Address: " + endpointDefinition.getServiceEndpointId() + nl;
        return resultString;
    }

    private String getConcatStrings(String[] strs) {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String resultString = "";
        int strSize = strs.length;
        int i = 0;
        while (i < strSize) {
            resultString = resultString + strs[i] + nl;
            ++i;
        }
        return resultString;
    }
}

