/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.command;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.registry.wsclient.WSClientRegistry;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ListWSClientsCommand
implements Command {
    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        try {
            if (params.length == 0) {
                output.write(this.getWSClients(false, null).getBytes());
            } else if (params[0].equalsIgnoreCase("-a")) {
                output.write(this.getWSClients(true, params[1]).getBytes());
            } else {
                output.write(this.getHelpMessage().getBytes());
            }
            output.flush();
        }
        catch (IOException e) {
            Location serverLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            serverLocation.catching("Unexpected exception occured executing list_wsclients command.", (Throwable)e);
            try {
                environment.getErrorStream().write(("Unexpected exception occured executing list_wsclients command: " + e.getMessage()).getBytes());
            }
            catch (IOException exc) {
                serverLocation.catching("IOException occured, printing error message while executing list_wsclients command.", (Throwable)exc);
            }
        }
    }

    public String getName() {
        return "list_wsclients";
    }

    public String getGroup() {
        return "webservices";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String helpMessage = "Prints all started wsClients on the current cluster element." + nl + nl + "USAGE    : " + this.getName() + " -[<parameter>" + nl + "Parameter: " + nl + "  default             : lists all started wsclients" + nl + "  a <application name>: lists all started wsclients for the specified application" + nl;
        return helpMessage;
    }

    private String getWSClients(boolean applicationFlag, String applicationName) {
        String nl;
        String resultString = nl = SystemProperties.getProperty((String)"line.separator");
        WSClientRegistry wsClientRegistry = WSContainer.getWsClientRegistry();
        WSClientIdentifier[] wsClientIds = new WSClientIdentifier[]{};
        wsClientIds = applicationFlag ? wsClientRegistry.listWSClientsByApplicationName(applicationName) : wsClientRegistry.listWSClients();
        int wsClientIdsSize = wsClientIds.length;
        if (wsClientIdsSize == 0) {
            resultString = applicationFlag ? "No wsclients registered for application: " + applicationName + ". " + nl : "No wsclients have been registered." + nl;
        }
        int i = 0;
        while (i < wsClientIdsSize) {
            WSClientIdentifier wsClientId = wsClientIds[i];
            if (!applicationFlag) {
                resultString = resultString + "Application: " + wsClientId.getApplicationName() + nl;
            }
            resultString = resultString + "Module     : " + wsClientId.getJarName() + nl;
            resultString = resultString + "WS Client  : " + wsClientId.getServiceRefName() + nl + nl;
            ++i;
        }
        if (wsClientIdsSize == 0) {
            resultString = applicationFlag ? "No wsclients registered/started for application: " + applicationName + ". " + nl : "No wsclients have been registered/started." + nl;
        }
        return resultString;
    }
}

