/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.command;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ListTransportAddressesCommand
implements Command {
    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        try {
            if (params.length == 0) {
                output.write(this.getTrAddresses().getBytes());
            } else {
                output.write(this.getHelpMessage().getBytes());
            }
            output.flush();
        }
        catch (IOException e) {
            Location serverLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            serverLocation.catching("Unexpected exception occured executing list_tr_addresses command.", (Throwable)e);
            try {
                environment.getErrorStream().write(("Unexpected exception occured executing list_tr_addresses command: " + e.getMessage()).getBytes());
            }
            catch (IOException exc) {
                serverLocation.catching("IOException occured, printing error message while executing list_tr_addresses command.", (Throwable)exc);
            }
        }
    }

    public String getName() {
        return "list_tr_addresses";
    }

    public String getGroup() {
        return "webservices";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String helpMessage = "Prints transport addresses for all started service endpoint interfaces on the current cluster element. " + nl + nl + "USAGE: " + this.getName() + nl;
        return helpMessage;
    }

    private String getTrAddresses() {
        String nl;
        String resultString = nl = SystemProperties.getProperty((String)"line.separator");
        String[] ids = new String[]{};
        ids = WSContainer.getRuntimeRegistry().listServiceEndpoints();
        int idsSize = ids.length;
        if (idsSize == 0) {
            resultString = resultString + "No service endpoint interfaces have been registered/started." + nl;
            return resultString;
        }
        resultString = resultString + this.getConcatStrings(ids);
        return resultString;
    }

    private String getConcatStrings(String[] strs) {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String resultString = "";
        int strSize = strs.length;
        int i = 0;
        while (i < strSize) {
            resultString = resultString + strs[i] + nl;
            ++i;
        }
        return resultString;
    }
}

