/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.command;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ListAdditionalComponentsCommand
implements Command {
    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        try {
            if (params.length == 1) {
                if (params[0].equals("-tr_bindings")) {
                    output.write(this.getTrBindings(false).getBytes());
                } else if (params[0].equals("-cl_tr_bindings")) {
                    output.write(this.getTrBindings(true).getBytes());
                } else if (params[0].equals("-protocols")) {
                    output.write(this.getProtocols(false).getBytes());
                } else if (params[0].equals("-cl_protocols")) {
                    output.write(this.getProtocols(true).getBytes());
                } else {
                    output.write(this.getHelpMessage().getBytes());
                }
            } else {
                output.write(this.getHelpMessage().getBytes());
            }
            output.flush();
        }
        catch (IOException e) {
            Location serverLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            serverLocation.catching("Unexpected exception occured executing list_wsadd_ons command.", (Throwable)e);
            try {
                environment.getErrorStream().write(("Unexpected exception occured executing list_wsadd_ons command: " + e.getMessage()).getBytes());
            }
            catch (IOException exc) {
                serverLocation.catching("IOException occured, printing error message while executing list_wsadd_ons command.", (Throwable)exc);
            }
        }
    }

    public String getName() {
        return "list_wsadd_ons";
    }

    public String getGroup() {
        return "webservices";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String helpMessage = "Prints all additional webservices components: client and server transport bindings and protocols, registered on the current cluster element." + nl + nl + "USAGE    :" + this.getName() + " -<parameter> " + nl + "Parameter: " + nl + "  tr_bindings   : lists all registered server transport bindings" + nl + "  cl_tr_bindings: lists all registered client transport bindings" + nl + "  protocols     : lists all registered server protocols" + nl + "  cl_protocols  : lists all registered client protocols" + nl;
        return helpMessage;
    }

    private String getTrBindings(boolean clientTrBindingsFlag) {
        String nl;
        String resultString = nl = SystemProperties.getProperty((String)"line.separator");
        String[] ids = new String[]{};
        ids = clientTrBindingsFlag ? WSContainer.getClientTransportBindingFactoryRegistry().listComponentIds() : WSContainer.getTransportBindingFactoryRegistry().listComponentIds();
        int idsSize = ids.length;
        if (idsSize == 0) {
            resultString = clientTrBindingsFlag ? resultString + "No client transport bindings have been registered." + nl : resultString + "No server transport bindings have been registered." + nl;
            return resultString;
        }
        resultString = resultString + this.getConcatStrings(ids);
        return resultString;
    }

    private String getProtocols(boolean clientProtocolsFlag) {
        String nl;
        String resultString = nl = SystemProperties.getProperty((String)"line.separator");
        String[] ids = new String[]{};
        ids = clientProtocolsFlag ? WSContainer.getClientProtocolFactoryRegistry().listComponentIds() : WSContainer.getProtocolFactoryRegistry().listComponentIds();
        int idsSize = ids.length;
        if (idsSize == 0) {
            resultString = clientProtocolsFlag ? resultString + "No client protocols have been registered." + nl : resultString + "No server protocols have been registered." + nl;
            return resultString;
        }
        resultString = resultString + this.getConcatStrings(ids);
        return resultString;
    }

    private String getConcatStrings(String[] strs) {
        String nl = SystemProperties.getProperty((String)"line.separator");
        String resultString = "";
        int strSize = strs.length;
        int i = 0;
        while (i < strSize) {
            resultString = resultString + strs[i] + nl;
            ++i;
        }
        return resultString;
    }
}

