/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.ant;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import java.io.File;

public class GenerateProxy {
    public static synchronized File getTempDir() {
        File tempDir;
        String tempDirectory;
        String string = tempDirectory = System.getProperty("java.io.tmpdir", ".");
        synchronized (string) {
            while ((tempDir = new File(tempDirectory, "proxy" + System.currentTimeMillis())).exists()) {
            }
            tempDir.mkdirs();
        }
        return tempDir;
    }

    public static void removeDirectory(File tempDir) {
        if (tempDir == null || !tempDir.exists()) {
            return;
        }
        File[] files = tempDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    GenerateProxy.removeDirectory(files[i]);
                }
                files[i].delete();
                ++i;
            }
        }
        tempDir.delete();
    }

    public static void main(String[] args) throws Exception {
        String wsdl = null;
        String packageName = null;
        String jar = null;
        boolean standalone = false;
        boolean rpcStyleMethods = false;
        boolean rpcInterfaces = false;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("wsdl=")) {
                wsdl = arg.substring(5);
            } else if (arg.startsWith("packageName=")) {
                packageName = arg.substring(12);
            } else if (arg.startsWith("jar=")) {
                jar = arg.substring(4);
            } else if (arg.equals("standalone")) {
                standalone = true;
            } else if (arg.equals("rpcStyleMethods")) {
                rpcStyleMethods = true;
            } else if (arg.equals("rpcInterfaces")) {
                rpcInterfaces = true;
            }
            ++i;
        }
        File tempDir = GenerateProxy.getTempDir();
        try {
            String tempDirString = tempDir.getAbsolutePath();
            ProxyGenerator generator = new ProxyGenerator();
            ProxyGeneratorConfig config = new ProxyGeneratorConfig(wsdl, tempDirString, packageName);
            config.setJarName(jar);
            config.setCompile(true);
            config.setInterfacesOnly(!standalone);
            config.setAdditionalMethods(rpcStyleMethods);
            config.setJaxRpcMethods(rpcInterfaces);
            config.setJarExtensions(new String[]{"class", "java", "xml", "txt", "properties"});
            generator.generateProxy(config);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            GenerateProxy.removeDirectory(tempDir);
            throw throwable;
        }
        GenerateProxy.removeDirectory(tempDir);
    }
}

