/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.cluster.session.ApplicationSessionProcessor;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.interfaces.webservices.uddi.UDDIServerAdmin;
import com.sap.engine.interfaces.webservices.uddi4j.DispatcherPortsGetter;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxm.soap.HTTPSocket;
import com.sap.engine.services.webservices.runtime.ApplicationWebServiceContextImpl;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.engine.services.webservices.runtime.monitor.WSMonitor;
import com.sap.engine.services.webservices.runtime.servlet.ServletDispatcherImpl;
import com.sap.engine.services.webservices.runtime.servlet.ServletsHelperImpl;
import com.sap.engine.services.webservices.runtime.wsdl.WsdlVisualiserImpl;
import com.sap.engine.services.webservices.server.DispatcherPortsGetterImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.WSContainerInterfaceImpl;
import com.sap.engine.services.webservices.server.WSManagementInterfaceImpl;
import com.sap.engine.services.webservices.server.WebServiceInterfaceImpl;
import com.sap.engine.services.webservices.server.command.ListAdditionalComponentsCommand;
import com.sap.engine.services.webservices.server.command.ListTransportAddressesCommand;
import com.sap.engine.services.webservices.server.command.ListWSClientsCommand;
import com.sap.engine.services.webservices.server.command.ListWebServicesCommand;
import com.sap.engine.services.webservices.server.connection.WSApplicationProcessor;
import com.sap.engine.services.webservices.server.deploy.WSDeployer;
import com.sap.engine.services.webservices.server.dynamic.DynamicServiceFactoryImpl;
import com.sap.engine.services.webservices.tools.SAPTransportImpl;
import com.sap.engine.services.webservices.uddi.UDDIServerAdminImpl;
import com.sap.engine.services.webservices.uddi.UDDIUserStoreConfig;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class WebServicesFrame
implements ApplicationServiceFrame,
ContainerEventListener {
    public static final String WS_CONTEXT_NAME = "wsContext";
    private ApplicationServiceContext serviceContext = null;
    private WSDeployer wsDeployer = null;
    private ServletDispatcherImpl servletDispatcher;
    private ApplicationWebServiceContextImpl applicationWSContextImpl;
    private int wsCommandId = 0;

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        this.setServiceProperty("wsclients.dispatcher", serviceContext.getServiceState().getProperty("wsclients.dispatcher", "false"));
        this.serviceContext = serviceContext;
        this.initWSContainer();
        this.initWSJndiContexts();
        this.registerManagementInterface();
        serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("webservices", (Object)new WebServiceInterfaceImpl());
        serviceContext.getClusterContext().getApplicationSessionContext().registerProcessor((ApplicationSessionProcessor)new WSApplicationProcessor());
        this.registerContainerEventListener();
    }

    public void stop() throws ServiceRuntimeException {
        HTTPSocket.onServer = false;
        this.stopMyApplications();
        WSMonitor.clear();
        this.destroyWSJndiContexts();
        if (this.serviceContext.getContainerContext().getSystemMonitor().getInterface("container").getStatus() == 5) {
            ContainerManagement containerManagement = (ContainerManagement)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("container");
            containerManagement.unregisterContainer("webservices_container");
        }
        this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("webservices");
        this.serviceContext.getServiceState().unregisterManagementInterface();
        this.serviceContext.getClusterContext().getApplicationSessionContext().unregisterProcessor();
        this.serviceContext.getServiceState().unregisterContainerEventListener();
        if (this.serviceContext.getContainerContext().getSystemMonitor().getInterface("shell").getStatus() == 11) {
            ShellInterface shellInterface = (ShellInterface)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("shell");
            shellInterface.unregisterCommands(this.wsCommandId);
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
        if (serviceName.equals("monitor")) {
            WSContainer.setMonitorServiceStarted(false);
            WSMonitor.clear();
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("container")) {
            this.containerInterfaceAvailable((ContainerManagement)interfaceImpl);
        } else if (interfaceName.equals("ejbmonitor")) {
            WSContainer.getInterfaceContext().setEjbManager((EJBManager)interfaceImpl);
        } else if (interfaceName.equals("shell")) {
            ShellInterface shellInterface = (ShellInterface)interfaceImpl;
            this.wsCommandId = shellInterface.registerCommands(this.getWSCommands());
        } else if (interfaceName.equals("security")) {
            this.securityInterfaceAvailable((SecurityContext)interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void serviceInterfaceRegistered(String serviceName, Object serviceInterface) {
    }

    public void markForShutdown(long timeout) {
    }

    public void serviceInterfaceUnregistered(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        if ("wsclients.dispatcher".equals(key)) {
            HTTPSocket.onServer = !value.equalsIgnoreCase("false");
        }
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        Enumeration keys = ((Hashtable)serviceProperties).keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = serviceProperties.getProperty(key);
            this.setServiceProperty(key, value);
        }
        return false;
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals("log_configurator")) {
            WSContainer.setLogConfiguratorInterface((LogConfiguratorManagementInterface)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface(serviceName));
        } else if (serviceName.equals("timeout")) {
            WSContainer.getImplementationContainerManager().registerTimeoutListeners((TimeoutManager)serviceInterface);
        } else if (serviceName.equals("monitor")) {
            WSContainer.setMonitorServiceStarted(true);
        }
    }

    private void initWSContainer() {
        WSContainer.init(this.serviceContext);
        this.wsDeployer = new WSDeployer();
        WSContainer.setWSDeployer(this.wsDeployer);
    }

    private void initWSJndiContexts() throws ServiceException {
        try {
            InitialContext ctx = new InitialContext();
            ctx.createSubcontext("wsclients");
            ctx.createSubcontext("wsclients/proxies");
            Context wsContext = ctx.createSubcontext(WS_CONTEXT_NAME);
            UDDIServerAdminImpl uddiServerAdmin = WSContainer.getUddiServerAdmin();
            SAPTransportImpl sapTransport = new SAPTransportImpl(WSContainer.getHTTPProxyResolver(), (UDDIServerAdmin)uddiServerAdmin, (DispatcherPortsGetter)new DispatcherPortsGetterImpl());
            wsContext.rebind("/SAPTransport", (Object)sapTransport);
            wsContext.rebind("/ServletsHelper", (Object)new ServletsHelperImpl());
            wsContext.rebind("/WSConnectionFactory", (Object)WSContainer.getWsConnectionFactory());
            wsContext.rebind("/DynamicServiceFactory", (Object)new DynamicServiceFactoryImpl());
            wsContext.rebind("/UDDI", (Object)uddiServerAdmin);
            wsContext.rebind("/wsContainerInterface", (Object)new WSContainerInterfaceImpl());
            ThreadSystem threadSystem = this.serviceContext.getCoreContext().getThreadSystem();
            this.applicationWSContextImpl = ApplicationWebServiceContextImpl.initializeApplicationContext(threadSystem);
            wsContext.rebind("/ApplicationWebServiceContext", (Object)this.applicationWSContextImpl);
            RuntimeProcessor processor = new RuntimeProcessor(this.applicationWSContextImpl);
            wsContext.rebind("/RuntimeProcessor", (Object)processor);
            this.servletDispatcher = new ServletDispatcherImpl(processor);
            wsContext.rebind("/WSDispatcher", (Object)this.servletDispatcher);
        }
        catch (NamingException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void destroyWSJndiContexts() {
        try {
            InitialContext ctx = new InitialContext();
            WSContainerInterfaceImpl wsContainerInterfaceImpl = (WSContainerInterfaceImpl)ctx.lookup("wsContext/wsContainerInterface");
            wsContainerInterfaceImpl.stop();
            ApplicationWebServiceContextImpl applicationWSContextImpl = (ApplicationWebServiceContextImpl)ctx.lookup("wsContext/ApplicationWebServiceContext");
            applicationWSContextImpl.destroy();
            this.emptyContext((Context)ctx.lookup(WS_CONTEXT_NAME));
            ctx.destroySubcontext(WS_CONTEXT_NAME);
            this.emptyContext((Context)ctx.lookup("wsclients"));
            ctx.destroySubcontext("wsclients");
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void registerManagementInterface() throws ServiceException {
        try {
            WSManagementInterfaceImpl mngmntIntf = new WSManagementInterfaceImpl();
            mngmntIntf.setWsdlVisualizer(new WsdlVisualiserImpl());
            this.serviceContext.getServiceState().registerManagementInterface((ManagementInterface)mngmntIntf);
        }
        catch (RemoteException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
        }
    }

    private void registerContainerEventListener() {
        int mask = 229;
        HashSet<String> names = new HashSet<String>(4);
        names.add("container");
        names.add("ejbmonitor");
        names.add("log_configurator");
        names.add("shell");
        names.add("security");
        names.add("monitor");
        this.serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
    }

    private void stopMyApplications() throws ServiceRuntimeException {
        try {
            String[] myApplications = this.getMyApplications();
            this.wsDeployer.getDeployCommunicator().stopMyApplications(myApplications);
        }
        catch (RemoteException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private void containerInterfaceAvailable(ContainerManagement container) {
        DeployCommunicator deployCommunicator = container.registerContainer("webservices_container", (ContainerInterface)this.wsDeployer);
        this.wsDeployer.setDeployCommunicator(deployCommunicator);
        try {
            deployCommunicator.startMyApplications(deployCommunicator.getMyApplications());
        }
        catch (RemoteException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
        }
        WSContainer.getEventContext().getEventHandler().init(deployCommunicator);
    }

    /*
     * Unable to fully structure code
     */
    private void securityInterfaceAvailable(SecurityContext secCtx) {
        block15: {
            factory = WSContainer.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
            handler = null;
            try {
                block14: {
                    handler = factory.getConfigurationHandler();
                    names = handler.getAllRootNames();
                    rootExists = false;
                    i = 0;
                    while (i < names.length) {
                        if (names[i].equals("UDDI_SERVER_USERSTORE")) {
                            rootExists = true;
                        }
                        ++i;
                    }
                    if (rootExists) break block14;
                    handler.createRootConfiguration("UDDI_SERVER_USERSTORE");
                    handler.commit();
                }
                var8_9 = null;
                ** if (handler == null) goto lbl-1000
            }
            catch (Throwable var7_18) {
                var8_11 = null;
                if (handler != null) {
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (ConfigurationException ce) {
                        wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                        wsLocation.catching((Throwable)ce);
                    }
                }
                throw var7_18;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    handler.closeAllConfigurations();
                }
                catch (ConfigurationException ce) {
                    wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                    wsLocation.catching((Throwable)ce);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception e) {
                    wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                    wsLocation.catching((Throwable)e);
                    var8_10 = null;
                    if (handler != null) {
                        try {
                            handler.closeAllConfigurations();
                        }
                        catch (ConfigurationException ce) {
                            wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                            wsLocation.catching((Throwable)ce);
                        }
                    }
                }
            }
        }
        if ((store = secCtx.getUserStoreContext().getUserStore("UDDI")) == null) {
            secCtx.getUserStoreContext().registerUserStore((UserStoreConfiguration)new UDDIUserStoreConfig(), this.getClass().getClassLoader());
            store = secCtx.getUserStoreContext().getUserStore("UDDI");
        }
        WSContainer.getUddiServerAdmin().setUserStore(store);
    }

    private String[] getMyApplications() {
        String[] myWSApplications = WSContainer.getWSRegistry().listApplications();
        String[] myWSClientApplications = WSContainer.getWsClientRegistry().listApplications();
        String[] myApplications = new String[myWSApplications.length + myWSClientApplications.length];
        System.arraycopy(myWSApplications, 0, myApplications, 0, myWSApplications.length);
        System.arraycopy(myWSClientApplications, 0, myApplications, myWSApplications.length, myWSClientApplications.length);
        return myApplications;
    }

    private Command[] getWSCommands() {
        Command[] wsCommands = new Command[]{new ListWebServicesCommand(), new ListWSClientsCommand(), new ListAdditionalComponentsCommand(), new ListTransportAddressesCommand()};
        return wsCommands;
    }

    private void emptyContext(Context ctx) throws NamingException {
        NamingEnumeration<NameClassPair> nEnum = ctx.list("");
        while (nEnum.hasMore()) {
            NameClassPair nCPair = nEnum.next();
            String name = nCPair.getName();
            Object obj = ctx.lookup(name);
            if (obj instanceof Context) {
                this.emptyContext((Context)obj);
                ctx.destroySubcontext(name);
                continue;
            }
            ctx.unbind(name);
        }
    }
}

