/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.interfaces.webservices.runtime.ImplementationContainer;
import com.sap.engine.interfaces.webservices.runtime.component.BaseRegistryException;
import com.sap.engine.interfaces.webservices.runtime.component.ClientProtocolFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ClientTransportBindingFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ProtocolFactory;
import com.sap.engine.interfaces.webservices.runtime.component.TransportBindingFactory;
import com.sap.engine.interfaces.webservices.server.SLDLogicalPort;
import com.sap.engine.interfaces.webservices.server.WSClientStructure;
import com.sap.engine.interfaces.webservices.server.WebServiceInterface;
import com.sap.engine.interfaces.webservices.server.WebServiceStructure;
import com.sap.engine.interfaces.webservices.server.event.EventContext;
import com.sap.engine.interfaces.webservices.server.management.WSClientReferencedStructure;
import com.sap.engine.interfaces.webservices.server.management.exception.WSBaseException;
import com.sap.engine.services.webservices.exceptions.WSException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBaseServer;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.ComponentDescriptor;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.runtime.registry.wsclient.WSClientRegistry;
import com.sap.engine.services.webservices.server.SLDConnectionImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientRuntimetHelper;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMInstance;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMValueNamedInstance;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.CIMNames;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.CIMOMClient;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;

public class WebServiceInterfaceImpl
implements WebServiceInterface {
    public WSClientReferencedStructure[] getWSClientReferencedObjects(String applicationName) throws WSException {
        WSClientReferencedStructure[] wsClientReferencedStructures = new WSClientReferencedStructure[]{};
        WSClientRegistry wsClientRegistry = WSContainer.getWsClientRegistry();
        WSClientRuntimeInfo[] wsClients = wsClientRegistry.getWSClientsByApplicationName(applicationName);
        int wsClientsSize = wsClients.length;
        int i = 0;
        while (i < wsClientsSize) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClients[i];
            WSClientReferencedStructure[] currentStructures = this.getWSClientReferencedStructure(wsClientRuntimeInfo);
            WSClientReferencedStructure[] newStructures = new WSClientReferencedStructure[wsClientReferencedStructures.length + currentStructures.length];
            System.arraycopy(wsClientReferencedStructures, 0, newStructures, 0, wsClientReferencedStructures.length);
            System.arraycopy(currentStructures, 0, newStructures, wsClientReferencedStructures.length, currentStructures.length);
            wsClientReferencedStructures = newStructures;
            ++i;
        }
        return wsClientReferencedStructures;
    }

    public void registerProtocolFactory(String id, ProtocolFactory protocolFactory) throws BaseRegistryException {
        WSContainer.getProtocolFactoryRegistry().registerProtocolFactory(id, protocolFactory);
    }

    public void unregisterProtocolFactory(String id) {
        WSContainer.getProtocolFactoryRegistry().unregisterProtocolFactory(id);
    }

    public void registerTransportBindingFactory(String id, TransportBindingFactory transportBindingFactory) throws BaseRegistryException {
        WSContainer.getTransportBindingFactoryRegistry().registerTransportBindingFactory(id, transportBindingFactory);
    }

    public void unregisterTransportBindingFactory(String id) {
        WSContainer.getTransportBindingFactoryRegistry().unregisterTransportBindingFactory(id);
    }

    public void registerClientProtocolFactory(String id, ClientProtocolFactory clientProtocolFactory) throws BaseRegistryException {
        WSContainer.getClientProtocolFactoryRegistry().registerClientProtocolFactory(id, clientProtocolFactory);
    }

    public void unregisterClientProtocolFactory(String id) {
        WSContainer.getClientProtocolFactoryRegistry().unregisterClientProtocolFactory(id);
    }

    public void registerClientTransportBindingFactory(String id, ClientTransportBindingFactory clientTransportBindingFactory) throws BaseRegistryException {
        WSContainer.getClientTransportBindingFactoryRegistry().registerClientTransportBindingFactory(id, clientTransportBindingFactory);
    }

    public void unregisterClientTransportBindingFactory(String id) {
        WSContainer.getClientTransportBindingFactoryRegistry().unregisterClientTransportBindingFactory(id);
    }

    public void registerImplementationContainerInterface(ImplementationContainer implementationContainer) throws BaseRegistryException {
        WSContainer.getImplementationContainerManager().register(implementationContainer);
    }

    public void unregisterImplementationContainerInterface(String id) {
        WSContainer.getImplementationContainerManager().unregister(id);
    }

    public EventContext getEventContext() {
        return WSContainer.getEventContext();
    }

    public WebServiceStructure[] listWebServices() {
        WSIdentifier[] wsIdentifiers = WSContainer.getWSRegistry().listWebServices();
        WebServiceStructure[] webServiceStructures = new WebServiceStructure[wsIdentifiers.length];
        int i = 0;
        while (i < webServiceStructures.length) {
            WSIdentifier wsIdentifier = wsIdentifiers[i];
            WebServiceStructure webServiceStructure = new WebServiceStructure();
            webServiceStructure.setApplicationName(wsIdentifier.getApplicationName());
            webServiceStructure.setArchiveName(wsIdentifier.getJarName());
            webServiceStructure.setWebServiceName(wsIdentifier.getServiceName());
            webServiceStructures[i] = webServiceStructure;
            ++i;
        }
        return webServiceStructures;
    }

    public WSClientStructure[] listWSClients() {
        WSClientIdentifier[] wsClientIds = WSContainer.getWsClientRegistry().listWSClients();
        WSClientStructure[] wsClientStructures = new WSClientStructure[wsClientIds.length];
        int i = 0;
        while (i < wsClientIds.length) {
            WSClientIdentifier wsClientIdentifier = wsClientIds[i];
            WSClientStructure wsClientStructure = new WSClientStructure();
            wsClientStructure.setApplicationName(wsClientIdentifier.getApplicationName());
            wsClientStructure.setArchiveName(wsClientIdentifier.getJarName());
            wsClientStructure.setProxyName(wsClientIdentifier.getServiceRefName());
            wsClientStructures[i] = wsClientStructure;
            ++i;
        }
        return wsClientStructures;
    }

    private WSClientReferencedStructure[] getWSClientReferencedStructure(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSException {
        String excMsg = "Error occured trying to get reference to service instance in case of web clients. ";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String moduleExtension = IOUtil.getFileExtension(wsClientId.getJarName());
        WSClientReferencedStructure[] wsClientReferencedStructures = new WSClientReferencedStructure[]{};
        if (moduleExtension.equals(".war")) {
            ComponentDescriptor[] componentDescriptors = wsClientRuntimeInfo.getComponentDescriptors();
            try {
                int componentsSize = componentDescriptors.length;
                wsClientReferencedStructures = new WSClientReferencedStructure[componentsSize];
                int i = 0;
                while (i < componentsSize) {
                    ComponentDescriptor componentDescriptor = componentDescriptors[i];
                    String serviceJndiName = WSClientRuntimetHelper.getServiceJndiNameInRootCtx(wsClientId);
                    Reference linkedServiceReference = WSUtil.getLinkReference(serviceJndiName);
                    WSClientReferencedStructure wsClientReferencedStructure = new WSClientReferencedStructure();
                    wsClientReferencedStructure.setContextRoot(componentDescriptor.getName());
                    wsClientReferencedStructure.setJndiLinkName(wsClientRuntimeInfo.getLinkServiceRefName());
                    wsClientReferencedStructure.setReferencedObject((Object)linkedServiceReference);
                    wsClientReferencedStructures[i] = wsClientReferencedStructure;
                    ++i;
                }
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                wsLocation.catching(excMsg, (Throwable)e);
                Object[] args = new String[]{excMsg, "not available"};
                throw new WSException(WSException.WS_BASE_EXCEPTION, args, e);
            }
        }
        return wsClientReferencedStructures;
    }

    private ServiceBaseServer getServiceBaseServer(String applicationName, String jndiName) throws WSException {
        WSClientIdentifier wsClientID = new WSClientIdentifier(applicationName, "", jndiName);
        String serviceJndiName = WSClientRuntimetHelper.getServiceJndiName(wsClientID);
        try {
            Context proxiesCtx = (Context)new InitialContext().lookup("wsclients/proxies");
            return (ServiceBaseServer)proxiesCtx.lookup(serviceJndiName);
        }
        catch (NamingException e) {
            throw new WSException("webservices_4001", new Object[]{applicationName, jndiName}, e);
        }
    }

    public Object updateWSClientFromSLD(String applicationName, String jndiName, String lpName, SLDLogicalPort sldLP) throws WSBaseException {
        ServiceBaseServer serviceInterface;
        WSClientIdentifier wsClientID = new WSClientIdentifier(applicationName, "", jndiName);
        String serviceJndiName = WSClientRuntimetHelper.getServiceJndiName(wsClientID);
        try {
            Context proxiesCtx = (Context)new InitialContext().lookup("wsclients/proxies");
            serviceInterface = (ServiceBaseServer)proxiesCtx.lookup(serviceJndiName);
        }
        catch (NamingException e) {
            throw new WSException("webservices_4001", new Object[]{applicationName, jndiName}, e);
        }
        try {
            return serviceInterface.updateLPTypeFromSLD(lpName, sldLP);
        }
        catch (Throwable thr) {
            throw new WSException("webservices_4002", new Object[0], thr);
        }
    }

    public void changeEndpointURL(String applicationName, String jndiName, String lpName, String newURL) throws WSBaseException {
        ServiceBaseServer serviceInterface = this.getServiceBaseServer(applicationName, jndiName);
        try {
            serviceInterface.changeEndpointURL(lpName, newURL);
        }
        catch (Throwable thr) {
            throw new WSException("webservices_4003", new Object[0], thr);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getSLDEntries(String className, Properties props) throws WSException {
        Vector vector;
        CIMOMClient cimClient = null;
        try {
            try {
                cimClient = SLDConnectionImpl.getCIMOMClient();
                CIMValueNamedInstanceList instances = cimClient.enumerateInstances(CIMNames.getCimClassNameValue(className), false, true, true, true, null);
                int size = instances.size();
                Vector entries = new Vector(size);
                int i = 0;
                while (true) {
                    if (i >= size) {
                        vector = entries;
                        Object var18_18 = null;
                        if (cimClient == null) return vector;
                        break;
                    }
                    CIMValueNamedInstance valueNamedInstance = instances.get(i);
                    CIMInstance instance = valueNamedInstance.getInstance();
                    String nameProp = instance.getPropertyValue(CIMNames.getProperty("P_NAME"));
                    String captionProp = instance.getPropertyValue(CIMNames.getProperty("P_CAPTION"));
                    if (captionProp == null) {
                        captionProp = nameProp;
                    }
                    boolean skip = false;
                    if (props != null) {
                        Enumeration propsEnum = ((Hashtable)props).keys();
                        while (propsEnum.hasMoreElements()) {
                            String realValue;
                            String property = propsEnum.nextElement().toString();
                            String value = props.getProperty(property);
                            if (value.equals(realValue = instance.getPropertyValue(CIMNames.getProperty(property)))) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (!skip) {
                        Vector<String> entry = new Vector<String>();
                        entry.addElement(nameProp);
                        entry.addElement(captionProp);
                        entries.addElement(entry);
                    }
                    ++i;
                }
            }
            catch (Throwable thr) {
                throw new WSException("webservices_4004", new Object[0], thr);
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (cimClient == null) throw throwable;
            try {
                cimClient.disconnect();
                throw throwable;
            }
            catch (Throwable thr) {
                throw new WSException("webservices_4005", new Object[0], thr);
            }
        }
        try {}
        catch (Throwable thr) {
            throw new WSException("webservices_4005", new Object[0], thr);
        }
        cimClient.disconnect();
        return vector;
    }

    public Vector getAvailableSLDSystems() throws WSBaseException {
        return this.getSLDEntries("C_SAP_J2EEEngineCluster", null);
    }

    public Vector getAvailableSLDWebServices(String systemID) throws WSBaseException {
        Properties props;
        if (systemID == null || "".equals(systemID)) {
            props = null;
        } else {
            props = new Properties();
            props.setProperty("P_SYSTEMNAME", systemID);
        }
        return this.getSLDEntries("C_SAP_WebService", props);
    }

    public Vector getAvailableSLDWSPorts(String systemID, String wsID) throws WSBaseException {
        Properties props;
        if (systemID == null || "".equals(systemID)) {
            props = null;
        } else {
            props = new Properties();
            props.setProperty("P_SYSTEMNAME", systemID);
        }
        return this.getSLDEntries("C_SAP_WebServicePort", props);
    }
}

