/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxy;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.uddi.UDDIServer;
import com.sap.engine.interfaces.webservices.uddi.UserAccount;
import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.gui.UIHelper;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.runtime.ServerRuntimeProcessException;
import com.sap.engine.services.webservices.runtime.definition.SLDWebService;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.monitor.WSConfigData;
import com.sap.engine.services.webservices.runtime.monitor.WSMonitor;
import com.sap.engine.services.webservices.runtime.monitor.WSOperationData;
import com.sap.engine.services.webservices.runtime.monitor.WSRequests;
import com.sap.engine.services.webservices.runtime.servlet.ServletsHelperImpl;
import com.sap.engine.services.webservices.runtime.wsdl.ServiceGenerator;
import com.sap.engine.services.webservices.runtime.wsdl.WsdlVisualiserImpl;
import com.sap.engine.services.webservices.server.SLDConnectionImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import com.sap.engine.services.webservices.server.deploy.WSDeployer;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationEvent;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMClass;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMInstance;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMProperty;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMPropertyList;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMValueNamedInstance;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.CIMNames;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.CIMOMClient;
import com.sap.engine.services.webservices.server.lcr.api.util.SystemExplorer;
import com.sap.engine.services.webservices.uddi.UDDIServerAdminImpl;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.rmi.PortableRemoteObject;
import javax.xml.namespace.QName;

public class WSManagementInterfaceImpl
extends PortableRemoteObject
implements WSManagementInterface {
    public static final String UDDI_REGISTRIES_SUB_CONFIG = "UDDIRegistries";
    public static final String HTTP_PROXY_SUB_CONFIG = "HTTPProxy";
    public static final String ENTRY_PROXY_HOST = "proxyHost";
    public static final String ENTRY_PROXY_PORT = "proxyPort";
    public static final String ENTRY_PROXY_EXCLUDE = "proxyExcludeList";
    public static final String ENTRY_PROXY_BYPASS = "proxyBypassProxy";
    public static final String ENTRY_PROXY_AUTHENTICATION = "ProxyAuth";
    public static final String ENTRY_PROXY_PROXYUSER = "proxyUser";
    public static final String ENTRY_PROXY_PROXYPASS = "proxyPass";
    public static final String ENTRY_UDDI_NAME = "name";
    public static final String ENTRY_UDDI_INQUIRY_URL = "inquiryURL";
    public static final String ENTRY_UDDI_PUBLISH_URL = "publishURL";
    public static final String ENTRY_UDDI_PROXY_HOST = "proxyHost";
    public static final String ENTRY_UDDI_PROXY_PORT = "proxyPort";
    public static final char SEP = File.separatorChar;
    private static WSManagementInterface managementInterface;
    private static WSDeployer wsDeployer;
    private static WsdlVisualiserImpl wsdlVisualizer;

    public WSManagementInterfaceImpl() throws RemoteException {
        wsDeployer = WSContainer.getWSDeployer();
        managementInterface = this;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public WSRuntimeDefinition[] listWebServices() {
        return WSContainer.getWSRegistry().getWebServices();
    }

    public WSClientRuntimeInfo[] listWSClients() {
        return WSContainer.getWsClientRegistry().getWSClients();
    }

    public static File getWSDLsDirectory(ServiceEndpointDefinition endpoint, String wsdlStyle, boolean sapMode, String host, int port, StringBuffer styleDirectoryPath) throws Exception, ServerRuntimeProcessException {
        File wsdlsDir;
        File wsdlFile;
        String applicationName = endpoint.getOwner().getApplicationName();
        int wsType = wsDeployer.getWSType(applicationName);
        String wsContainerDir = wsDeployer.getWSContainerDir(applicationName, wsType);
        String webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
        String wsDir = endpoint.getOwner().getWsDirsHandler().getWsDirectory();
        String hostDir = wsDir + SEP + "proxy" + SEP + host + "_" + port;
        String styleDir = hostDir + SEP + wsdlStyle + (sapMode ? "_sap" : "");
        if (styleDirectoryPath != null) {
            styleDirectoryPath.append(styleDir);
        }
        if (!(wsdlFile = new File(wsdlsDir = new File(styleDir + SEP + "wsdls"), "main.wsdl")).exists()) {
            String requestURL = "http://" + host + ":" + port + "/";
            if (wsdlStyle != null && wsdlStyle.length() == 0) {
                wsdlStyle = null;
            }
            ServiceGenerator.saveAllWSDLsInDirectory(endpoint.getOwner().getWsQName().getLocalPart(), requestURL, endpoint.getOwner(), wsdlStyle, sapMode, wsdlsDir);
        }
        return wsdlsDir;
    }

    private synchronized String getMappingID(File jarsDirectory, Properties mappings) throws IOException {
        File mappingsFile = new File(jarsDirectory, "uri2package.properties");
        StringBuffer mappingKey = new StringBuffer();
        Enumeration<?> enumeration = mappings.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            String value = mappings.getProperty(key);
            mappingKey.append(key + "=" + value + ",");
        }
        String uri2java = mappingKey.toString();
        String id = null;
        File file = mappingsFile;
        synchronized (file) {
            Properties ids;
            if (mappingsFile.exists()) {
                FileInputStream in = new FileInputStream(mappingsFile);
                ids = new Properties();
                ids.load(in);
                in.close();
            } else {
                ids = new Properties();
            }
            Enumeration mappingIDs = ((Hashtable)ids).keys();
            while (mappingIDs.hasMoreElements()) {
                String mappingID = mappingIDs.nextElement().toString();
                if (!uri2java.equals(ids.getProperty(mappingID))) continue;
                id = mappingID;
            }
            if (id == null) {
                id = "" + ((Hashtable)ids).keySet().size() + 1;
                ids.setProperty(id, uri2java);
                FileOutputStream out = new FileOutputStream(mappingsFile);
                ids.store(out, "Please do not edit this file!");
                out.close();
            }
        }
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SerializableFile sendProxyJar(WSRuntimeDefinition webService, String wsdlStyle, boolean sapMode, String packageName, boolean compiled, boolean interfaces, boolean additionalMethods, boolean jaxrpcServiceInterfaces, String host, int port, Properties uriToPackageMapping) throws RemoteException {
        try {
            WSIdentifier wsID = webService.getWSIdentifier();
            webService = WSContainer.getWSRegistry().getWebService(wsID);
        }
        catch (RegistryException re) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)((Object)re));
            throw new RemoteException("Error while sending jar. See Logs for more details", (Throwable)((Object)re));
        }
        if (webService.getServiceEndpointDefinitions().length == 0) {
            throw new RemoteException("The specified web service does not have any service endpoint definitions!");
        }
        try {
            StringBuffer styleDir = new StringBuffer();
            File wsdlsDir = WSManagementInterfaceImpl.getWSDLsDirectory(webService.getServiceEndpointDefinitions()[0], wsdlStyle, sapMode, host, port, styleDir);
            String jarsDir = styleDir.toString() + SEP + "jars" + SEP;
            if (packageName == null || packageName.length() == 0) {
                packageName = "default";
            }
            jarsDir = jarsDir + packageName.replace('.', SEP) + SEP;
            File jarsDirFile = new File(jarsDir);
            jarsDirFile.mkdirs();
            StringBuffer jarName = new StringBuffer();
            if (interfaces) {
                jarName.append("interfaces");
            } else {
                jarName.append("proxy");
            }
            jarName.append(additionalMethods ? "1" : "0");
            jarName.append(jaxrpcServiceInterfaces ? "1" : "0");
            jarName.append(uriToPackageMapping != null ? "1" : "0");
            if (uriToPackageMapping != null) {
                jarName.append("_" + this.getMappingID(jarsDirFile, uriToPackageMapping));
            }
            if (compiled) {
                jarName.append(".jar");
            } else {
                jarName.append(".zip");
            }
            File jarFile = new File(jarsDirFile, jarName.toString());
            File wsdlFile = new File(wsdlsDir, "main.wsdl");
            if (jarFile.exists()) return new SerializableFile(jarFile);
            File tempDir = null;
            try {
                tempDir = this.getTempProxyDir();
                this.generateJar(wsdlFile.getAbsolutePath(), tempDir.getAbsolutePath(), packageName, compiled, jarFile.getAbsolutePath(), interfaces, additionalMethods, jaxrpcServiceInterfaces, uriToPackageMapping);
                Object var21_24 = null;
                if (tempDir == null) return new SerializableFile(jarFile);
            }
            catch (Throwable throwable) {
                Object var21_25 = null;
                if (tempDir == null) throw throwable;
                WSManagementInterfaceImpl.removeDirectory(tempDir);
                throw throwable;
            }
            WSManagementInterfaceImpl.removeDirectory(tempDir);
            return new SerializableFile(jarFile);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
            throw new RemoteException("Error while sending jar! See Logs for more details!", e);
        }
    }

    private synchronized File getTempProxyDir() {
        File tempDir;
        String tempDirectory;
        String string = tempDirectory = SystemProperties.getProperty((String)"java.io.tmpdir", (String)".");
        synchronized (string) {
            while ((tempDir = new File(tempDirectory, "proxy" + System.currentTimeMillis())).exists()) {
            }
            tempDir.mkdirs();
        }
        return tempDir;
    }

    public static void removeDirectory(File tempDir) {
        if (tempDir == null || !tempDir.exists()) {
            return;
        }
        File[] files = tempDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    WSManagementInterfaceImpl.removeDirectory(files[i]);
                }
                files[i].delete();
                ++i;
            }
        }
        tempDir.delete();
    }

    private void generateJar(String rootWsdl, String targetDir, String packageName, boolean compiled, String jarFile, boolean interfaces, boolean additionalMethods, boolean jaxrpcServiceInterfaces, Properties uriToPackageMapping) throws Exception {
        ProxyGenerator generator = new ProxyGenerator();
        ProxyGeneratorConfig config = new ProxyGeneratorConfig(rootWsdl, targetDir, packageName);
        config.setCompile(compiled);
        config.setJarName(jarFile);
        config.setInterfacesOnly(interfaces);
        config.setAdditionalMethods(additionalMethods);
        config.setJaxRpcMethods(jaxrpcServiceInterfaces);
        config.setAdditionalClassPath(wsDeployer.getJarsPath());
        config.setJarExtensions(new String[]{"class", "java", "xml", "txt", "properties"});
        if (uriToPackageMapping != null) {
            config.setUriToPackageMapping(uriToPackageMapping);
        }
        generator.generateProxy(config);
    }

    /*
     * Loose catch block
     */
    public UDDIRegistry[] getUDDIRegistries() throws RemoteException {
        ClassLoader loader;
        UDDIRegistry[] registries;
        block16: {
            ConfigurationHandler handler;
            block15: {
                registries = null;
                loader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                handler = null;
                handler = ServletsHelperImpl.getHandler();
                Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, UDDI_REGISTRIES_SUB_CONFIG, 0);
                if (configuration == null) {
                    registries = new UDDIRegistry[]{};
                    break block15;
                }
                Map subconfigurations = configuration.getAllSubConfigurations();
                ArrayList list = new ArrayList(subconfigurations.keySet());
                Collections.sort(list);
                registries = new UDDIRegistry[list.size()];
                int i = 0;
                while (i < registries.length) {
                    Configuration registryConfig = (Configuration)subconfigurations.get(list.get(i));
                    String name = registryConfig.getConfigEntry(ENTRY_UDDI_NAME).toString();
                    String inquiryURL = null;
                    if (registryConfig.existsConfigEntry(ENTRY_UDDI_INQUIRY_URL)) {
                        inquiryURL = registryConfig.getConfigEntry(ENTRY_UDDI_INQUIRY_URL).toString();
                    }
                    String publishURL = null;
                    if (registryConfig.existsConfigEntry(ENTRY_UDDI_PUBLISH_URL)) {
                        publishURL = registryConfig.getConfigEntry(ENTRY_UDDI_PUBLISH_URL).toString();
                    }
                    String proxyHost = null;
                    if (registryConfig.existsConfigEntry("proxyHost")) {
                        proxyHost = registryConfig.getConfigEntry("proxyHost").toString();
                    }
                    int proxyPort = (Integer)registryConfig.getConfigEntry("proxyPort");
                    registries[i] = new UDDIRegistry(name, inquiryURL, publishURL);
                    registries[i].setProxyHost(proxyHost);
                    registries[i].setProxyPort(proxyPort);
                    ++i;
                }
            }
            Object var15_17 = null;
            if (handler == null) break block16;
            try {
                handler.closeAllConfigurations();
                break block16;
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                wsLocation.catching((Throwable)e);
            }
            {
                break block16;
                catch (Exception e) {
                    Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                    wsLocation.catching((Throwable)e);
                    throw new RemoteException("Error while getting UDDI Registries", e);
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (handler != null) {
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (Exception e) {
                        Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                        wsLocation.catching((Throwable)e);
                    }
                }
                Thread.currentThread().setContextClassLoader(loader);
                throw throwable;
            }
        }
        Thread.currentThread().setContextClassLoader(loader);
        if (registries.length == 0) {
            registries = this.getOldUDDIRegistries();
            int i = 0;
            while (i < registries.length) {
                this.addUDDIRegistry(registries[i]);
                ++i;
            }
        }
        return registries;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UDDIRegistry[] getOldUDDIRegistries() throws RemoteException {
        block19: {
            block17: {
                block15: {
                    block16: {
                        loader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        handler = null;
                        try {
                            try {
                                handler = ServletsHelperImpl.getHandler();
                                configuration = ServletsHelperImpl.getSubConfiguration(handler, "UDDIRegistries", 0);
                                if (configuration == null) {
                                    var4_5 = new UDDIRegistry[]{};
                                    var10_8 = null;
                                    if (handler == null) break block15;
                                    break block16;
                                }
                                try {
                                    entries = configuration.getAllConfigEntries();
                                }
                                catch (ConfigurationException ce) {
                                    wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                                    wsLocation.catching("Error while getting all config entries. Maybe an update caused this. Removing all UDDI Registries from DB.", (Throwable)ce);
                                    handler.closeAllConfigurations();
                                    handler = ServletsHelperImpl.getHandler();
                                    configuration = ServletsHelperImpl.getSubConfiguration(handler, "UDDIRegistries", 1);
                                    configuration.deleteAllConfigEntries();
                                    entries = new HashMap<K, V>();
                                }
                                handler.closeAllConfigurations();
                                list = new ArrayList<K>(entries.keySet());
                                Collections.sort(list);
                                registries = new UDDIRegistry[list.size()];
                                i = 0;
                                while (true) {
                                    if (i >= registries.length) {
                                        var8_21 = registries;
                                        break block17;
                                    }
                                    registries[i] = (UDDIRegistry)entries.get(list.get(i));
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                                wsLocation.catching((Throwable)e);
                                throw new RemoteException("Error while getting UDDI Registries", e);
                            }
                        }
                        catch (Throwable var9_22) {
                            var10_10 = null;
                            if (handler != null) {
                                try {
                                    handler.closeAllConfigurations();
                                }
                                catch (Exception e) {
                                    wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                                    wsLocation.catching((Throwable)e);
                                }
                            }
                            Thread.currentThread().setContextClassLoader(loader);
                            throw var9_22;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [3 : 241->250)] { 
lbl60:
                    // 1 sources

                    handler.closeAllConfigurations();
                    break block15;
lbl62:
                    // 1 sources

                    catch (Exception e) {
                        wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                        wsLocation.catching((Throwable)e);
                    }
                }
                Thread.currentThread().setContextClassLoader(loader);
                return var4_5;
            }
            var10_9 = null;
            if (handler != null) {
                ** try [egrp 3[TRYBLOCK] [3 : 241->250)] { 
lbl73:
                // 1 sources

                handler.closeAllConfigurations();
                break block19;
lbl75:
                // 1 sources

                catch (Exception e) {
                    wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                    wsLocation.catching((Throwable)e);
                }
            }
        }
        Thread.currentThread().setContextClassLoader(loader);
        return var8_21;
    }

    private void addUDDIRegistryAsPrimitive(UDDIRegistry registry, Configuration configuration) throws Exception {
        Configuration registryConfig;
        String name = registry.getName();
        if (configuration.existsSubConfiguration(name)) {
            registryConfig = configuration.getSubConfiguration(name);
            registryConfig.deleteAllConfigEntries();
        } else {
            registryConfig = configuration.createSubConfiguration(name);
        }
        registryConfig.addConfigEntry(ENTRY_UDDI_NAME, (Object)name);
        String inquiryURL = registry.getInquiryURL();
        String publishURL = registry.getPublishURL();
        String proxyHost = registry.getProxyHost();
        if (inquiryURL != null) {
            registryConfig.addConfigEntry(ENTRY_UDDI_INQUIRY_URL, (Object)registry.getInquiryURL());
        }
        if (publishURL != null) {
            registryConfig.addConfigEntry(ENTRY_UDDI_PUBLISH_URL, (Object)registry.getPublishURL());
        }
        if (registry.getProxyHost() != null) {
            registryConfig.addConfigEntry("proxyHost", (Object)registry.getProxyHost());
        }
        registryConfig.addConfigEntry("proxyPort", (Object)new Integer(registry.getProxyPort()));
    }

    public void addUDDIRegistry(UDDIRegistry registry) throws RemoteException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                ConfigurationHandler handler = ServletsHelperImpl.getHandler();
                Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, UDDI_REGISTRIES_SUB_CONFIG, 1);
                if (configuration.existsConfigEntry(registry.getName())) {
                    configuration.deleteConfigEntry(registry.getName());
                }
                this.addUDDIRegistryAsPrimitive(registry, configuration);
                handler.commit();
                handler.closeAllConfigurations();
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new RemoteException("Error while adding a UDDI Registry, called " + registry.getName(), e);
            }
            Object var6_7 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    public void removeUDDIRegistry(UDDIRegistry registry) throws RemoteException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                ConfigurationHandler handler = ServletsHelperImpl.getHandler();
                Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, UDDI_REGISTRIES_SUB_CONFIG, 1);
                String name = registry.getName();
                if (configuration.existsConfigEntry(name)) {
                    configuration.deleteConfigEntry(name);
                }
                if (configuration.existsSubConfiguration(name)) {
                    configuration.deleteSubConfigurations(new String[]{name});
                }
                handler.commit();
                handler.closeAllConfigurations();
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                wsLocation.catching((Throwable)e);
                throw new RemoteException("Error while removing a UDDI Registry, called " + registry.getName(), e);
            }
            Object var7_8 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    public void setWsdlVisualizer(WsdlVisualiserImpl wsdlVisualizer) {
        WSManagementInterfaceImpl.wsdlVisualizer = wsdlVisualizer;
    }

    public static synchronized WSManagementInterface getManagementInterface() {
        return managementInterface;
    }

    public Properties getSchemaToJavaMapping(String mainPackage, ServiceEndpointDefinition endpoint, String wsdlStyle, boolean sapMode, String host, int port) throws RemoteException {
        try {
            WSRuntimeDefinition oldDef = endpoint.getOwner();
            WSIdentifier wsID = oldDef.getWSIdentifier();
            WSRuntimeDefinition webService = WSContainer.getWSRegistry().getWebService(wsID);
            ServiceEndpointDefinition[] endpoints = webService.getServiceEndpointDefinitions();
            String endpointID = endpoint.getServiceEndpointId();
            int i = 0;
            while (i < endpoints.length) {
                ServiceEndpointDefinition endp = endpoints[i];
                String id = endp.getServiceEndpointId();
                if (endpointID.equals(id)) {
                    endpoint = endp;
                    break;
                }
                ++i;
            }
            File wsdlsDir = WSManagementInterfaceImpl.getWSDLsDirectory(endpoint, wsdlStyle, sapMode, host, port, null);
            File wsdlFile = new File(wsdlsDir, "main.wsdl");
            ProxyGenerator generator = new ProxyGenerator();
            ProxyGeneratorConfig config = new ProxyGeneratorConfig(wsdlFile.getAbsolutePath(), null, mainPackage);
            generator.getDefaultSchemaMapping(config);
            return config.getUriToPackageMapping();
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
            wsLocation.catching((Throwable)e);
            throw new RemoteException("Error while getting mapping.", e);
        }
    }

    public String getHTTPStartURI() throws RemoteException {
        ClusterElement[] clusterParticipants = WSContainer.getServiceContext().getClusterContext().getClusterMonitor().getParticipants();
        int clusterParticipantsSize = clusterParticipants.length;
        int i = 0;
        while (i < clusterParticipantsSize) {
            block7: {
                ClusterElement clusterElement = clusterParticipants[i];
                if (clusterElement.getType() == 1 && clusterElement.getState() == 3) {
                    int dispatcherID = clusterElement.getClusterId();
                    MessageContext msgCtx = WSContainer.getServiceContext().getClusterContext().getMessageContext();
                    try {
                        MessageAnswer msgAnswer = msgCtx.sendAndWaitForAnswer(dispatcherID, 3, new byte[0], 0, 0, 0L);
                        if (msgAnswer.getLength() == 0) break block7;
                        ByteArrayInputStream in = new ByteArrayInputStream(msgAnswer.getMessage(), msgAnswer.getOffset(), msgAnswer.getLength());
                        DataInputStream dataStream = new DataInputStream(in);
                        try {
                            int httpPort = dataStream.readInt();
                            if (httpPort != -1) {
                                InetAddress dispatcherAddress = clusterElement.getAddress();
                                String host = dispatcherAddress.getHostName();
                                return "http://" + host + ":" + httpPort;
                            }
                        }
                        catch (IOException ioe) {
                            Location.getLocation((String)WSLogging.SERVER_LOCATION).catching("An error occured while parsing getHttpPort response: " + dispatcherID, (Throwable)ioe);
                        }
                    }
                    catch (ClusterException ce) {
                        Location.getLocation((String)WSLogging.SERVER_LOCATION).catching("An error occured during the communication with the dispatcher node: " + dispatcherID, (Throwable)ce);
                    }
                }
            }
            ++i;
        }
        throw new RemoteException("Cannot determine HTTP Port");
    }

    public boolean hasUDDIServerRegisterred() {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        return uddiAdmin.getUDDIServer() != null;
    }

    public void resetUDDIDB(boolean preload) throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        UDDIServer uddiServer = uddiAdmin.getUDDIServer();
        uddiServer.resetDB();
        if (preload) {
            uddiServer.preloadCanonicalData();
        }
    }

    public void updateUDDIUser(UserAccount user, char[] password) throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        if (password != null) {
            uddiAdmin.createNewUser(user.getUsername(), password, user.getLevel());
            int i = 0;
            while (i < password.length) {
                password[i] = '\u0000';
                ++i;
            }
        } else {
            uddiAdmin.changeUserLevel(user.getUsername(), user.getLevel());
        }
        uddiAdmin.getUDDIServer().updateUserAccount(user);
    }

    public void removeUDDIUser(String username) throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        uddiAdmin.deleteUser(username);
    }

    public UserAccount[] getAllUDDIUsers() throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        UserAccount[] users = uddiAdmin.getUDDIServer().getAllUsers();
        int i = 0;
        while (i < users.length) {
            UserAccount user = users[i];
            if (user.getLevel() == -1) {
                user.setLevel(uddiAdmin.getUserLevel(user.getUsername()));
            }
            ++i;
        }
        return users;
    }

    public Properties getUDDIServerConfig() throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        return uddiAdmin.getUDDIServer().getUDDIServerProperties();
    }

    public boolean isCanonicalDataPreloaded() throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        return uddiAdmin.getUDDIServer().isCanonicalDataPreloaded();
    }

    public void setUDDIServerProperty(String key, String value) throws Exception {
        UDDIServerAdminImpl uddiAdmin = WSContainer.getUddiServerAdmin();
        uddiAdmin.getUDDIServer().setUDDIProperty(key, value);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HTTPProxy getHTTPProxy() throws RemoteException {
        block29: {
            block26: {
                block28: {
                    block25: {
                        block23: {
                            block24: {
                                loader = Thread.currentThread().getContextClassLoader();
                                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                                handler = null;
                                try {
                                    try {
                                        handler = ServletsHelperImpl.getHandler();
                                        configuration = ServletsHelperImpl.getSubConfiguration(handler, "HTTPProxy", 0);
                                        if (configuration == null) {
                                            var4_5 = new HTTPProxy();
                                            var15_8 = null;
                                            if (handler == null) break block23;
                                            break block24;
                                        }
                                        proxyHost = null;
                                        if (configuration.existsConfigEntry("proxyHost")) {
                                            proxyHost = (String)configuration.getConfigEntry("proxyHost");
                                        }
                                        proxyPort = null;
                                        if (configuration.existsConfigEntry("proxyPort")) {
                                            proxyPort = (Integer)configuration.getConfigEntry("proxyPort");
                                        }
                                        proxyExcludeList = null;
                                        if (configuration.existsConfigEntry("proxyExcludeList")) {
                                            proxyExcludeList = (String)configuration.getConfigEntry("proxyExcludeList");
                                        }
                                        bypassProxy = null;
                                        if (configuration.existsConfigEntry("proxyBypassProxy")) {
                                            bypassProxy = (Boolean)configuration.getConfigEntry("proxyBypassProxy");
                                        }
                                        if (proxyHost == null) {
                                            var8_23 = new HTTPProxy();
                                            break block25;
                                        }
                                        httpProxy = new HTTPProxy();
                                        httpProxy.setProxyHost(proxyHost);
                                        if (proxyPort != null) {
                                            httpProxy.setProxyPort(proxyPort.intValue());
                                        } else {
                                            httpProxy.setProxyPort(80);
                                        }
                                        httpProxy.setExcludeList(proxyExcludeList);
                                        if (bypassProxy != null) {
                                            httpProxy.setBypassLocalAddresses(bypassProxy.booleanValue());
                                        }
                                        if (configuration.existsSubConfiguration("ProxyAuth") && (value = (String)(proxyUser = (props = (proxyAuth = configuration.getSubConfiguration("ProxyAuth")).getPropertySheetInterface()).getPropertyEntry("proxyUser")).getValue()) != null && value.length() > 0) {
                                            httpProxy.setProxyUser(value);
                                            proxyPass = props.getPropertyEntry("proxyPass");
                                            value = (String)proxyPass.getValue();
                                            if (value != null && value.length() > 0) {
                                                httpProxy.setProxyPass(value);
                                            }
                                        }
                                        var9_25 = httpProxy;
                                        break block26;
                                    }
                                    catch (Throwable thr) {
                                        wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                                        wsLocation.catching(thr);
                                        throw new RemoteException("An error occurred while getting HTTP Proxy", thr);
                                    }
                                }
                                catch (Throwable var14_30) {
                                    var15_11 = null;
                                    if (handler != null) {
                                        try {
                                            handler.closeAllConfigurations();
                                        }
                                        catch (Throwable thr) {
                                            wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                                            wsLocation.catching(thr);
                                        }
                                    }
                                    Thread.currentThread().setContextClassLoader(loader);
                                    throw var14_30;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 411->420)] { 
lbl69:
                            // 1 sources

                            handler.closeAllConfigurations();
                            break block23;
lbl71:
                            // 1 sources

                            catch (Throwable thr) {
                                wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                                wsLocation.catching(thr);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(loader);
                        return var4_5;
                    }
                    var15_9 = null;
                    if (handler != null) {
                        ** try [egrp 2[TRYBLOCK] [2 : 411->420)] { 
lbl82:
                        // 1 sources

                        handler.closeAllConfigurations();
                        break block28;
lbl84:
                        // 1 sources

                        catch (Throwable thr) {
                            wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                            wsLocation.catching(thr);
                        }
                    }
                }
                Thread.currentThread().setContextClassLoader(loader);
                return var8_23;
            }
            var15_10 = null;
            if (handler != null) {
                ** try [egrp 2[TRYBLOCK] [2 : 411->420)] { 
lbl95:
                // 1 sources

                handler.closeAllConfigurations();
                break block29;
lbl97:
                // 1 sources

                catch (Throwable thr) {
                    wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                    wsLocation.catching(thr);
                }
            }
        }
        Thread.currentThread().setContextClassLoader(loader);
        return var9_25;
    }

    /*
     * Loose catch block
     */
    public void saveHTTPProxy(HTTPProxy httpProxy) throws Exception {
        ClassLoader loader;
        block14: {
            loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ConfigurationHandler handler = null;
            handler = ServletsHelperImpl.getHandler();
            Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, HTTP_PROXY_SUB_CONFIG, 1);
            configuration.deleteAllConfigEntries();
            if (httpProxy.getProxyHost() != null) {
                configuration.addConfigEntry("proxyHost", (Object)httpProxy.getProxyHost());
            }
            if (httpProxy.getProxyPort() > -1) {
                configuration.addConfigEntry("proxyPort", (Object)new Integer(httpProxy.getProxyPort()));
            }
            if (httpProxy.getExcludeList() != null) {
                configuration.addConfigEntry(ENTRY_PROXY_EXCLUDE, (Object)httpProxy.getExcludeList());
            }
            configuration.addConfigEntry(ENTRY_PROXY_BYPASS, (Object)new Boolean(httpProxy.isBypassLocalAddresses()));
            if (!configuration.existsSubConfiguration(ENTRY_PROXY_AUTHENTICATION)) {
                configuration.createSubConfiguration(ENTRY_PROXY_AUTHENTICATION, 1);
            }
            Configuration proxyAuth = configuration.getSubConfiguration(ENTRY_PROXY_AUTHENTICATION);
            PropertySheet props = proxyAuth.getPropertySheetInterface();
            props.deleteAllPropertyEntries();
            PropertyEntry proxyUser = props.createPropertyEntry(ENTRY_PROXY_PROXYUSER, (Object)"", "HTTP Proxy User");
            if (httpProxy.getProxyUser() != null) {
                proxyUser.setValue((Object)httpProxy.getProxyUser());
            }
            PropertyEntry proxyPass = props.createSecurePropertyEntry(ENTRY_PROXY_PROXYPASS, (Object)"", "HTTP Proxy Password");
            if (httpProxy.getProxyPass() != null) {
                proxyPass.setValue((Object)httpProxy.getProxyPass());
            }
            handler.commit();
            Object var10_11 = null;
            if (handler == null) break block14;
            try {
                handler.closeAllConfigurations();
                break block14;
            }
            catch (Throwable thr) {
                Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                wsLocation.catching(thr);
            }
            {
                break block14;
                catch (Throwable thr) {
                    Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                    wsLocation.catching(thr);
                    throw new RemoteException("An error occurred while getting HTTP Proxy", thr);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (handler != null) {
                    try {
                        handler.closeAllConfigurations();
                    }
                    catch (Throwable thr) {
                        Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
                        wsLocation.catching(thr);
                    }
                }
                Thread.currentThread().setContextClassLoader(loader);
                throw throwable;
            }
        }
        Thread.currentThread().setContextClassLoader(loader);
    }

    public void publishWSInSLD(WSRuntimeDefinition newDef) throws Exception {
        try {
            WSRuntimeDefinition[] definitions = this.listWebServices();
            WSRuntimeDefinition webService = null;
            WSIdentifier wsID = newDef.getWSIdentifier();
            int i = 0;
            while (i < definitions.length) {
                if (definitions[i].getWSIdentifier().equals(wsID)) {
                    webService = definitions[i];
                    break;
                }
                ++i;
            }
            if (webService == null) {
                throw new RemoteException("Cannot find Web service in repository");
            }
            webService.setSLDWebService(newDef.getSLDWebService());
            ServiceEndpointDefinition[] endpoints = webService.getServiceEndpointDefinitions();
            ServiceEndpointDefinition[] newEndpoints = newDef.getServiceEndpointDefinitions();
            int i2 = 0;
            while (i2 < newEndpoints.length) {
                endpoints[i2].setSldName(newEndpoints[i2].getSldName());
                ++i2;
            }
            CIMOMClient cimClient = SLDConnectionImpl.getCIMOMClient();
            try {
                CIMInstance cimWebService;
                SLDWebService sldWS = newDef.getSLDWebService();
                String sldName = sldWS.getName();
                CIMValueNamedInstance valueNamedInstance = SLDConnectionImpl.getOldInstance(cimClient, CIMNames.getCimClassNameValue("C_SAP_WebService"), sldName, SystemExplorer.getJ2EEClusterEngineName());
                if (valueNamedInstance == null) {
                    CIMClass wsClass = cimClient.getCIMClass(CIMNames.getCimClassNameValue("C_SAP_WebService"), false, true, true, null);
                    cimWebService = wsClass.createInstanceTemplate();
                } else {
                    cimWebService = valueNamedInstance.getInstance();
                }
                CIMPropertyList properties = cimWebService.getProperties();
                CIMProperty captionProp = properties.get(CIMNames.getProperty("P_CAPTION"));
                captionProp.setValue(sldWS.getCaption());
                CIMProperty descriptionProp = properties.get(CIMNames.getProperty("P_DESCRIPTION"));
                descriptionProp.setValue(sldWS.getDescription());
                CIMProperty nameProp = properties.get(CIMNames.getProperty("P_NAME"));
                nameProp.setValue(sldName);
                CIMProperty wsdlLocationProp = properties.get(CIMNames.getProperty("P_WSDLLOCATION"));
                wsdlLocationProp.setValue(sldWS.getWsdlLocation());
                CIMProperty creationClassNameProp = properties.get(CIMNames.getProperty("P_CREATIONCLASSNAME"));
                creationClassNameProp.setValue("SAP_WebService");
                CIMProperty systemCreationClassNameProp = properties.get(CIMNames.getProperty("P_SYSTEMCREATIONCLASSNAME"));
                systemCreationClassNameProp.setValue("SAP_J2EEEngineCluster");
                CIMProperty systemNameProp = properties.get(CIMNames.getProperty("P_SYSTEMNAME"));
                String systemName = SystemExplorer.getJ2EEClusterEngineName();
                systemNameProp.setValue(systemName);
                CIMValueNamedInstance systemValueNamedInstance = SLDConnectionImpl.getOldInstance(cimClient, CIMNames.getCimClassNameValue("C_SAP_J2EEEngineCluster"), systemName);
                if (systemValueNamedInstance == null) {
                    throw new RemoteException("Cannot find configured SAP_J2EEEngineCluster with name " + systemName);
                }
                CIMInstance systemInstance = systemValueNamedInstance.getInstance();
                if (valueNamedInstance != null) {
                    cimClient.modifyInstance(valueNamedInstance);
                } else {
                    cimClient.createInstance(cimWebService);
                    SLDConnectionImpl.makeAssociation(cimClient, systemInstance, cimWebService, CIMNames.getCimClassNameValue("C_SAP_HostedWebService"));
                }
                int i3 = 0;
                while (i3 < endpoints.length) {
                    this.createWSPortEntry(cimClient, endpoints[i3], systemInstance, cimWebService);
                    ++i3;
                }
                Object var27_30 = null;
            }
            catch (Throwable throwable) {
                Object var27_31 = null;
                cimClient.disconnect();
                throw throwable;
            }
            cimClient.disconnect();
            {
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Throwable thr) {
            Location.getLocation((String)WSLogging.SERVER_LOCATION).catching(thr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            thr.printStackTrace(pw);
            throw new RemoteException(sw.toString());
        }
    }

    private void createWSPortEntry(CIMOMClient cimClient, ServiceEndpointDefinition endpoint, CIMInstance systemInstance, CIMInstance webServiceInstance) throws Exception {
        QName portQName = endpoint.getServiceEndpointQualifiedName();
        String trBindingID = endpoint.getTransportBindingId();
        RuntimeTransportBinding runtimeBinding = (RuntimeTransportBinding)WSContainer.getComponentFactory().getTransportBindingInstance(trBindingID);
        String[] defaultStyles = runtimeBinding.getDefaultStyles();
        int i = 0;
        while (i < defaultStyles.length) {
            CIMInstance cimWebServicePort;
            String portName = portQName.toString() + "_" + ServiceGenerator.getUpperLetteredString(defaultStyles[i]);
            String caption = portQName.getLocalPart() + "_" + ServiceGenerator.getUpperLetteredString(defaultStyles[i]);
            String description = "";
            String sldName = UIHelper.wsIDtoSLDName(endpoint.getOwner().getWSIdentifier()) + portName;
            endpoint.setSldName(sldName);
            CIMValueNamedInstance valueNamedInstance = SLDConnectionImpl.getOldInstance(cimClient, CIMNames.getCimClassNameValue("C_SAP_WebServicePort"), sldName, SystemExplorer.getJ2EEClusterEngineName());
            if (valueNamedInstance == null) {
                CIMClass wsPortClass = cimClient.getCIMClass(CIMNames.getCimClassNameValue("C_SAP_WebServicePort"), false, true, true, null);
                cimWebServicePort = wsPortClass.createInstanceTemplate();
            } else {
                cimWebServicePort = valueNamedInstance.getInstance();
            }
            CIMPropertyList properties = cimWebServicePort.getProperties();
            CIMProperty captionProp = properties.get(CIMNames.getProperty("P_CAPTION"));
            captionProp.setValue(caption);
            CIMProperty descriptionProp = properties.get(CIMNames.getProperty("P_DESCRIPTION"));
            descriptionProp.setValue(description);
            CIMProperty nameProp = properties.get(CIMNames.getProperty("P_NAME"));
            nameProp.setValue(sldName);
            CIMProperty wsdlLocationProp = properties.get(CIMNames.getProperty("P_WSDLPORTNAME"));
            wsdlLocationProp.setValue(portName);
            CIMProperty creationClassNameProp = properties.get(CIMNames.getProperty("P_CREATIONCLASSNAME"));
            creationClassNameProp.setValue("SAP_WebServicePort");
            CIMProperty systemCreationClassNameProp = properties.get(CIMNames.getProperty("P_SYSTEMCREATIONCLASSNAME"));
            systemCreationClassNameProp.setValue("SAP_J2EEEngineCluster");
            CIMProperty systemNameProp = properties.get(CIMNames.getProperty("P_SYSTEMNAME"));
            systemNameProp.setValue(SystemExplorer.getJ2EEClusterEngineName());
            if (valueNamedInstance != null) {
                cimClient.modifyInstance(valueNamedInstance);
            } else {
                cimClient.createInstance(cimWebServicePort);
                SLDConnectionImpl.makeAssociation(cimClient, systemInstance, cimWebServicePort, CIMNames.getCimClassNameValue("C_SAP_HostedWebServicePort"));
                SLDConnectionImpl.makeAssociation(cimClient, webServiceInstance, cimWebServicePort, CIMNames.getCimClassNameValue("C_SAP_WebServiceAccess"));
            }
            ++i;
        }
    }

    public boolean existsInSLD(WSRuntimeDefinition newDef) throws Exception {
        try {
            boolean bl;
            CIMOMClient cimClient = SLDConnectionImpl.getCIMOMClient();
            try {
                String sldName = newDef.getSLDWebService().getName();
                bl = SLDConnectionImpl.getOldInstance(cimClient, CIMNames.getCimClassNameValue("C_SAP_WebService"), sldName, SystemExplorer.getJ2EEClusterEngineName()) != null;
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                cimClient.disconnect();
                throw throwable;
            }
            cimClient.disconnect();
            return bl;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Throwable thr) {
            Location.getLocation((String)WSLogging.SERVER_LOCATION).catching(thr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            thr.printStackTrace(pw);
            throw new RemoteException(sw.toString());
        }
    }

    public void makeRuntimeChangesToWS(WSRuntimeDefinition oldDef) throws Exception {
        WSRuntimeDefinition webService = null;
        try {
            webService = WSContainer.getWSRegistry().getWebService(oldDef.getWSIdentifier());
        }
        catch (RegistryException e) {
            String msg = "Cannot find web service with ID: " + oldDef.getWSIdentifier();
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        WSIdentifier wsIdentifier = webService.getWSIdentifier();
        UDDIPublicationEvent uddiPublicatinEvent = new UDDIPublicationEvent();
        uddiPublicatinEvent.setApplicationName(wsIdentifier.getApplicationName());
        uddiPublicatinEvent.setWebServiceName(wsIdentifier.getServiceName());
        uddiPublicatinEvent.setUddiPublications(oldDef.getUddiPublications());
        WSContainer.getEventContext().getEventHandler().handle((Event)uddiPublicatinEvent);
    }

    public long getSuccessfulRequestsForWS(String appName, String webServiceID) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceID);
        return wsReqs.getSuccessfulRequests();
    }

    public long getFailedRequestsForWS(String appName, String webServiceID) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceID);
        return wsReqs.getFailedRequests();
    }

    public long getCurrentClients(String appName, String webServiceName) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceName);
        return wsReqs.getRunningClients();
    }

    public String[][] getConfigurations() throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] appNames = this.listWebServiceApplications();
        int i = 0;
        while (i < appNames.length) {
            String appName = appNames[i];
            WSRuntimeDefinition[] definitions = WSContainer.getWSRegistry().getWebServicesByApplicationName(appName);
            int j = 0;
            while (j < definitions.length) {
                WSRuntimeDefinition def = definitions[j];
                String wsName = def.getServiceName();
                ServiceEndpointDefinition[] configs = def.getServiceEndpointDefinitions();
                int k = 0;
                while (k < configs.length) {
                    ServiceEndpointDefinition conf = configs[k];
                    String configName = conf.getConfigurationName();
                    OperationDefinition[] operations = conf.getOperations();
                    int l = 0;
                    while (l < operations.length) {
                        OperationDefinition oper = operations[l];
                        String opName = oper.getOperationName();
                        list.add(new String[]{appNames[i], wsName, configName, opName});
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        String[][] res = new String[list.size()][];
        int i2 = 0;
        while (i2 < list.size()) {
            res[i2] = (String[])list.get(i2);
            ++i2;
        }
        return res;
    }

    public String[][] getShortConfigurations() throws Exception {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] appNames = this.listWebServiceApplications();
        int i = 0;
        while (i < appNames.length) {
            String appName = appNames[i];
            WSRuntimeDefinition[] definitions = WSContainer.getWSRegistry().getWebServicesByApplicationName(appName);
            int j = 0;
            while (j < definitions.length) {
                WSRuntimeDefinition def = definitions[j];
                String wsName = def.getServiceName();
                list.add(new String[]{appNames[i], wsName});
                ++j;
            }
            ++i;
        }
        String[][] res = new String[list.size()][];
        int i2 = 0;
        while (i2 < list.size()) {
            res[i2] = (String[])list.get(i2);
            ++i2;
        }
        return res;
    }

    public long getAveragePrePrcssTimeForOperation(String appName, String webServiceName, String configurationName, String operationName) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceName);
        WSConfigData wsConfData = wsReqs.getConfigData(configurationName);
        WSOperationData opData = wsConfData.getWSOperationData(operationName);
        return opData.getAveragePrePrcssTime();
    }

    public long getAverageImplPrcssTimeForOperation(String appName, String webServiceName, String configurationName, String operationName) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceName);
        WSConfigData wsConfData = wsReqs.getConfigData(configurationName);
        WSOperationData opData = wsConfData.getWSOperationData(operationName);
        return opData.getAverageImplPrcssTime();
    }

    public long getAveragePostPrcssTimeForOperation(String appName, String webServiceName, String configurationName, String operationName) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceName);
        WSConfigData wsConfData = wsReqs.getConfigData(configurationName);
        WSOperationData opData = wsConfData.getWSOperationData(operationName);
        return opData.getAveragePostPrcssTime();
    }

    public long getSuccessfulRequestsForConfig(String appName, String webServiceName, String configurationName) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceName);
        WSConfigData wsConfData = wsReqs.getConfigData(configurationName);
        return wsConfData.getSuccessfulReq();
    }

    public long getFailedRequestsForConfig(String appName, String webServiceName, String configurationName) {
        WSRequests wsReqs = this.getWSRequestsContainer(appName, webServiceName);
        WSConfigData wsConfData = wsReqs.getConfigData(configurationName);
        return wsConfData.getUnsuccessfulReq();
    }

    private WSRequests getWSRequestsContainer(String appName, String webServiceName) {
        WSIdentifier wsID = new WSIdentifier(appName, null, webServiceName);
        return WSMonitor.getWSRequestsContainer(wsID);
    }

    private String[] listWebServiceApplications() {
        WSRuntimeDefinition[] definitions = this.listWebServices();
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < definitions.length) {
            WSIdentifier identifier = definitions[i].getWSIdentifier();
            map.put(identifier.getApplicationName(), "value");
            ++i;
        }
        Set keys = map.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    private String[] listApplicationWebServices(String appName) {
        WSRuntimeDefinition[] definitions = WSContainer.getWSRegistry().getWebServicesByApplicationName(appName);
        String[] webServices = new String[definitions.length];
        int i = 0;
        while (i < definitions.length) {
            webServices[i] = definitions[i].getWSIdentifier().getServiceName();
            ++i;
        }
        return webServices;
    }

    private String[] getConfigurationNames(String appName, String webServiceName) throws Exception {
        String[] appWebServices = this.listApplicationWebServices(appName);
        int i = 0;
        while (i < appWebServices.length) {
            if (appWebServices[i].equals(webServiceName)) {
                WSIdentifier wsId = new WSIdentifier(appName, null, webServiceName);
                WSRuntimeDefinition wsRDef = WSContainer.getWSRegistry().getWebService(wsId);
                ServiceEndpointDefinition[] defs = wsRDef.getServiceEndpointDefinitions();
                String[] res = new String[defs.length];
                int j = 0;
                while (j < defs.length) {
                    res[j] = defs[j].getConfigurationName();
                    ++j;
                }
                return res;
            }
            ++i;
        }
        return new String[0];
    }
}

