/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.frame.core.load.res.MultipleResource;
import com.sap.engine.frame.core.load.res.Resource;
import com.sap.engine.interfaces.webservices.server.WSContainerInterface;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.engine.lib.util.Set;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSDeployer;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesConstants;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class WSContainerInterfaceImpl
implements WSContainerInterface,
WebServicesConstants {
    public static final String SEPARATOR = File.separator;
    private static Set externalDeployedWebServices = new Set();
    private WSDeployer wsDeployer = WSContainer.getWSDeployer();
    private ApplicationServiceContext serviceContext = WSContainer.getServiceContext();
    private JarUtil jarUtil = new JarUtil();

    public boolean isExernalWSComponent(String applicationName) {
        return externalDeployedWebServices.contains((Object)applicationName);
    }

    public String registerWebServices(String archiveFile) throws WSDeploymentException, WarningException {
        String wsApplicationName = this.getWSApplicationName();
        this.extractWSFiles(wsApplicationName, archiveFile);
        this.registerWSAppClassLoader(wsApplicationName);
        this.registerWebServices0(wsApplicationName);
        return wsApplicationName;
    }

    public String registerWebServices(String archiveFile, Vector warnings) throws WSDeploymentException {
        String wsApplicationName = this.getWSApplicationName();
        this.extractWSFiles(wsApplicationName, archiveFile);
        this.registerWSAppClassLoader(wsApplicationName);
        try {
            this.registerWebServices0(wsApplicationName);
        }
        catch (WarningException e) {
            this.addToVector(warnings, e.getWarnings());
        }
        return wsApplicationName;
    }

    public void registerWebServices0(String wsApplicationName) throws WSDeploymentException, WarningException {
        Vector warnings = new Vector();
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(wsApplicationName, 1);
            String webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
            new WSRuntimeActivator().start(wsApplicationName, webServicesDir, null);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new String[]{"Unable to get wsContainer or webservices directory", "application name: " + wsApplicationName};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        catch (WSDeploymentException e) {
            try {
                this.wsDeployer.rollbackStart(wsApplicationName);
            }
            catch (WarningException wExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)wExc);
            }
            throw e;
        }
        try {
            this.wsDeployer.commitStart(wsApplicationName);
        }
        catch (WarningException e) {
            this.addToVector(warnings, e.getWarnings());
        }
        externalDeployedWebServices.add((Object)wsApplicationName);
        if (warnings.size() != 0) {
            e = new WarningException();
            e.setWarnings(warnings);
            throw e;
        }
    }

    public boolean isServiceEndpointRegistered(String transportAddress) {
        return WSContainer.getRuntimeRegistry().contains(transportAddress);
    }

    public void stop() throws WSDeploymentException, WarningException {
        this.unregisterExternalWebServices();
    }

    private void unregisterExternalWebServices() throws WSDeploymentException, WarningException {
        Enumeration enumeration = externalDeployedWebServices.elements();
        Vector warnings = new Vector();
        while (enumeration.hasMoreElements()) {
            String wsApplicationName = (String)enumeration.nextElement();
            try {
                this.unregisterWebServices(wsApplicationName);
            }
            catch (WarningException e) {
                this.addToVector(warnings, e.getWarnings());
            }
        }
        if (warnings.size() != 0) {
            WarningException e = new WarningException();
            e.setWarnings(warnings);
            throw e;
        }
    }

    public void unregisterWebServices(String wsApplicationName) throws WSDeploymentException, WarningException {
        String wsContainerDir = null;
        String webServicesDir = null;
        Vector warnings = new Vector();
        try {
            wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(wsApplicationName, 1);
            webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new String[]{"Unable to get wsContainer or webservices directory", "application name: " + wsApplicationName};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        this.deleteWebServicesDir(webServicesDir);
        this.unregisterAppLoader(wsApplicationName);
        try {
            this.unregisterWebServices0(wsApplicationName);
        }
        catch (WarningException e) {
            this.addToVector(warnings, e.getWarnings());
        }
        externalDeployedWebServices.remove((Object)wsApplicationName);
        if (warnings.size() != 0) {
            e = new WarningException();
            e.setWarnings(warnings);
            throw e;
        }
    }

    private void unregisterWebServices0(String wsApplicationName) throws WSDeploymentException, WarningException {
        Vector warnings = new Vector();
        try {
            this.wsDeployer.prepareStop(wsApplicationName, null);
        }
        catch (WSDeploymentException e) {
            try {
                this.wsDeployer.rollbackStop(wsApplicationName);
            }
            catch (WarningException wExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)wExc);
            }
            throw e;
        }
        catch (WarningException e) {
            this.addToVector(warnings, e.getWarnings());
        }
        try {
            this.wsDeployer.commitStop(wsApplicationName);
        }
        catch (WarningException e) {
            this.addToVector(warnings, e.getWarnings());
        }
        if (warnings.size() != 0) {
            e = new WarningException();
            e.setWarnings(warnings);
            throw e;
        }
    }

    private String getWSApplicationName() {
        return "externalWS" + System.currentTimeMillis();
    }

    private void extractWSFiles(String applicationName, String archiveFile) throws WSDeploymentException {
        try {
            String wsContainerDir = this.wsDeployer.getWSContainerDir(applicationName, 1);
            this.jarUtil.extractJar(archiveFile, wsContainerDir);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to get wsContainer or webservices directory", "application name: " + applicationName};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to extract webservices files from the archive", "application name: " + applicationName};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void registerWSAppClassLoader(String applicationName) throws WSDeploymentException {
        ResourceLoader appLoader = null;
        String wsContainerDir = null;
        try {
            wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName, 1);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new String[]{"Unable to get wsContainer directory, application name: " + applicationName};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
        String[] wsFilesForClassLoader = this.getWSFilesForClassLoader(webServicesDir);
        try {
            ClassLoader serviceContextLoader = this.serviceContext.getClass().getClassLoader();
            Class<?> tmpClass = serviceContextLoader.loadClass("com.sap.engine.frame.ApplicationServiceContext");
            ClassLoader frameLoader = tmpClass.getClassLoader();
            ProtectionDomain protectionDomain = ProtectionDomainFactory.getFactory().registerProtectionDomain(applicationName, new CodeSource(new URL("file:/" + wsContainerDir + SEPARATOR), null));
            MultipleResource multipleResource = this.getMultipleResource(wsFilesForClassLoader);
            appLoader = new ResourceLoader(applicationName, (Resource)multipleResource, frameLoader, protectionDomain);
            this.serviceContext.getCoreContext().getLoadContext().register((ReferencedLoader)appLoader);
            String[] wsReferences = this.wsDeployer.getWSReferences();
            this.makeReferences(appLoader.getName(), wsReferences);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new String[]{"Unable to define application loader", "application name: " + applicationName};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void unregisterAppLoader(String appLoaderName) throws WSDeploymentException {
        LoadContext loadContext = this.serviceContext.getCoreContext().getLoadContext();
        String[] wsReferences = this.wsDeployer.getWSReferences();
        this.destroyWSReferences(appLoaderName, wsReferences);
        ResourceLoader appLoader = (ResourceLoader)loadContext.getClassLoader(appLoaderName);
        try {
            loadContext.unregister((ReferencedLoader)appLoader);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to unregister application loader ", "application loader name: " + appLoader.getName()};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private String[] getWSFilesForClassLoader(String webservicesDir) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect web services jars for classloader from directory " + webservicesDir + ". ";
        String[] wsDirs = new File(webservicesDir).list();
        if (wsDirs == null) {
            return new String[0];
        }
        String[] wsFilesForClassLoader = new String[]{};
        int i = 0;
        while (i < wsDirs.length) {
            try {
                String currentWSDir = wsDirs[i];
                File currentWSDirFile = new File(currentWSDir);
                if (new File(currentWSDir).getName().equals("app_jars")) {
                    wsFilesForClassLoader = WSUtil.unifyStrings(new String[][]{wsFilesForClassLoader, currentWSDirFile.list()});
                } else {
                    String[] singleWSJars = this.getSingleWSFilesForClassLoader(currentWSDir);
                    wsFilesForClassLoader = WSUtil.unifyStrings(new String[][]{wsFilesForClassLoader, singleWSJars});
                }
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
        return wsFilesForClassLoader;
    }

    private String[] getSingleWSFilesForClassLoader(String wsDirectory) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect jars for classloader for a web service with directory " + wsDirectory + ". ";
        String[] wsJarsForClassLoader = new String[]{};
        try {
            Properties mappings = WSRuntimeActivator.loadMappings(wsDirectory);
            String jarsDir = WSDirsHandler.getJarsDir(wsDirectory, mappings);
            wsJarsForClassLoader = new File(jarsDir).list();
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsJarsForClassLoader;
    }

    private MultipleResource getMultipleResource(String[] files) {
        MultipleResource multipleResource = new MultipleResource();
        int filesSize = files.length;
        int i = 0;
        while (i < filesSize) {
            String file = files[i];
            JarResource resource = new JarResource(file);
            multipleResource.addResource((Resource)resource);
            ++i;
        }
        return multipleResource;
    }

    private void makeReferences(String fromLoader, String[] references) {
        LoadContext loadContext = this.serviceContext.getCoreContext().getLoadContext();
        int size = references.length;
        int i = 0;
        while (i < size) {
            String reference = references[i];
            String toLoaderName = reference.substring(reference.indexOf(":") + 1).trim();
            loadContext.registerReference(fromLoader, toLoaderName);
            ++i;
        }
    }

    private void destroyWSReferences(String fromLoader, String[] references) {
        LoadContext loadContext = this.serviceContext.getCoreContext().getLoadContext();
        int size = references.length;
        int i = 0;
        while (i < size) {
            String reference = references[i];
            String toLoaderName = reference.substring(reference.indexOf(":") + 1).trim();
            loadContext.registerReference(fromLoader, toLoaderName);
            ++i;
        }
    }

    private void deleteWebServicesDir(String webServicesDir) throws WSDeploymentException {
        try {
            IOUtil.deleteDir(webServicesDir);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to delete webservices directory", "application name: " + webServicesDir};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void addToVector(Vector vector, Object[] array) {
        if (vector == null || array == null) {
            return;
        }
        int i = 0;
        while (i < array.length) {
            Object obj = array[i];
            if (obj != null) {
                vector.add(obj);
            }
            ++i;
        }
    }
}

