/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.interfaces.webservices.client.WSConnectionFactory;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.interfaces.webservices.runtime.component.ClientProtocolFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ClientTransportBindingFactory;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.webservices.additions.soaphttp.HTTPFactory;
import com.sap.engine.services.webservices.additions.soaphttp.HTTPStatefulProtocolFactory;
import com.sap.engine.services.webservices.additions.soaphttp.MIMEFactory;
import com.sap.engine.services.webservices.additions.soaphttp.MessageIDProtocolImpl;
import com.sap.engine.services.webservices.additions.soaphttp.SOAPHTTPFactroy;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.SLDConnection;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.builtin.MessageIdProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.builtin.SessionProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.builtin.SoapHeadersProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.httpgetpost.ClientHTTPGetPostFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPHTTPFactory;
import com.sap.engine.services.webservices.runtime.component.ClientProtocolFactoryRegistry;
import com.sap.engine.services.webservices.runtime.component.ClientTransportBindingFactoryRegistry;
import com.sap.engine.services.webservices.runtime.component.ComponentFactoryImpl;
import com.sap.engine.services.webservices.runtime.component.ImplementationContainerManager;
import com.sap.engine.services.webservices.runtime.component.ProtocolFactoryRegistry;
import com.sap.engine.services.webservices.runtime.component.TransportBindingFactoryRegistry;
import com.sap.engine.services.webservices.runtime.registry.RuntimeRegistry;
import com.sap.engine.services.webservices.runtime.registry.WebServiceRegistry;
import com.sap.engine.services.webservices.runtime.registry.wsclient.WSClientRegistry;
import com.sap.engine.services.webservices.server.HTTPProxyResolverImpl;
import com.sap.engine.services.webservices.server.InterfaceContext;
import com.sap.engine.services.webservices.server.SLDConnectionImpl;
import com.sap.engine.services.webservices.server.connection.WSConnectionFactoryImpl;
import com.sap.engine.services.webservices.server.connection.WSConnectionManipulator;
import com.sap.engine.services.webservices.server.connection.WSConnectionRegistry;
import com.sap.engine.services.webservices.server.deploy.WSDeployer;
import com.sap.engine.services.webservices.server.deploy.event.system.EventContextImpl;
import com.sap.engine.services.webservices.server.deploy.event.system.EventFactoryRegistry;
import com.sap.engine.services.webservices.server.deploy.event.system.EventListenerRegistry;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationFactory;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationListener;
import com.sap.engine.services.webservices.uddi.UDDIServerAdminImpl;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class WSContainer {
    public static String NAME = "webservices";
    public static String SLD_KEY = "sld";
    private static WebServiceRegistry wsRegistry = null;
    private static WSClientRegistry wsClientRegistry = null;
    private static RuntimeRegistry runtimeRegistry = null;
    private static TransportBindingFactoryRegistry transportBindingFactoryRegistry = null;
    private static ProtocolFactoryRegistry protocolFactoryRegistry = null;
    private static ClientProtocolFactoryRegistry clientProtocolFactoryRegistry = null;
    private static ClientTransportBindingFactoryRegistry clientTransportBindingFactoryRegistry = null;
    private static ImplementationContainerManager implementationContainerManager = null;
    private static ComponentFactoryImpl componentFactory = null;
    private static EventContextImpl eventContext = null;
    private static InterfaceContext interfaceContext = null;
    private static WSConnectionFactoryImpl wsConnectionFactory = null;
    private static WSConnectionRegistry wsConnectionRegistry = null;
    private static HTTPProxyResolver proxyResolver = null;
    private static WSDeployer wsDeployer = null;
    private static ApplicationServiceContext wsServiceContext = null;
    private static LogConfiguratorManagementInterface logConfiguratorInterface = null;
    private static UDDIServerAdminImpl uddiServerAdmin = null;
    private static Object sldInterface = null;
    private static SLDConnection sldConnection = null;
    private static boolean monitorServiceStarted;

    public static void init(ApplicationServiceContext serviceContext) {
        wsServiceContext = serviceContext;
        wsRegistry = new WebServiceRegistry();
        wsClientRegistry = new WSClientRegistry();
        runtimeRegistry = new RuntimeRegistry();
        transportBindingFactoryRegistry = new TransportBindingFactoryRegistry();
        protocolFactoryRegistry = new ProtocolFactoryRegistry();
        clientProtocolFactoryRegistry = new ClientProtocolFactoryRegistry();
        clientTransportBindingFactoryRegistry = new ClientTransportBindingFactoryRegistry();
        implementationContainerManager = new ImplementationContainerManager((ServiceContext)wsServiceContext);
        WSContainer.initEventContext();
        interfaceContext = new InterfaceContext();
        componentFactory = new ComponentFactoryImpl();
        wsConnectionFactory = new WSConnectionFactoryImpl(serviceContext);
        wsConnectionRegistry = new WSConnectionRegistry();
        uddiServerAdmin = new UDDIServerAdminImpl();
        proxyResolver = new HTTPProxyResolverImpl();
        sldConnection = new SLDConnectionImpl();
        WSContainer.initAdditions();
    }

    public static ApplicationServiceContext getServiceContext() {
        return wsServiceContext;
    }

    public static WebServiceRegistry getWSRegistry() {
        return wsRegistry;
    }

    public static WSClientRegistry getWsClientRegistry() {
        return wsClientRegistry;
    }

    public static RuntimeRegistry getRuntimeRegistry() {
        return runtimeRegistry;
    }

    public static TransportBindingFactoryRegistry getTransportBindingFactoryRegistry() {
        return transportBindingFactoryRegistry;
    }

    public static ProtocolFactoryRegistry getProtocolFactoryRegistry() {
        return protocolFactoryRegistry;
    }

    public static ClientProtocolFactoryRegistry getClientProtocolFactoryRegistry() {
        return clientProtocolFactoryRegistry;
    }

    public static ClientTransportBindingFactoryRegistry getClientTransportBindingFactoryRegistry() {
        return clientTransportBindingFactoryRegistry;
    }

    public static EventContextImpl getEventContext() {
        return eventContext;
    }

    public static InterfaceContext getInterfaceContext() {
        return interfaceContext;
    }

    public static ImplementationContainerManager getImplementationContainerManager() {
        return implementationContainerManager;
    }

    public static ComponentFactoryImpl getComponentFactory() {
        return componentFactory;
    }

    public static WSConnectionFactory getWsConnectionFactory() {
        return wsConnectionFactory;
    }

    public static WSConnectionManipulator getWsConnectionManipulator() {
        return wsConnectionFactory;
    }

    public static WSConnectionRegistry getWsConnectionRegistry() {
        return wsConnectionRegistry;
    }

    public static void setWSDeployer(WSDeployer wsDeployer) {
        WSContainer.wsDeployer = wsDeployer;
    }

    public static WSDeployer getWSDeployer() {
        return wsDeployer;
    }

    private static void initEventContext() {
        eventContext = new EventContextImpl();
        EventFactoryRegistry eventFactoryRegistry = eventContext.getEventFactoryRegistry();
        EventListenerRegistry eventListenerRegistry = eventContext.getEventListenerRegistry();
        eventFactoryRegistry.registerFactory("UDDI_KEY_EVENT", new UDDIPublicationFactory());
        eventListenerRegistry.registerListener("UDDI_KEY_EVENT", new UDDIPublicationListener());
    }

    private static void initAdditions() {
        try {
            transportBindingFactoryRegistry.registerTransportBindingFactory("SOAPHTTP_TransportBinding", new SOAPHTTPFactroy());
            transportBindingFactoryRegistry.registerTransportBindingFactory("MIME_TransportBinding", new MIMEFactory());
            transportBindingFactoryRegistry.registerTransportBindingFactory("HTTP_TransportBinding", new HTTPFactory());
            clientTransportBindingFactoryRegistry.registerClientTransportBindingFactory("SOAP 1.1 HTTP Binding with Attachments", (ClientTransportBindingFactory)new ClientSOAPHTTPFactory());
            clientTransportBindingFactoryRegistry.registerClientTransportBindingFactory("HTTP Get/Post Transport binding", (ClientTransportBindingFactory)new ClientHTTPGetPostFactory());
            protocolFactoryRegistry.registerProtocolFactory("HTTP_StatefulProtocol", new HTTPStatefulProtocolFactory());
            protocolFactoryRegistry.registerProtocolFactory("MessageIDProtocol", new MessageIDProtocolImpl());
            clientProtocolFactoryRegistry.registerClientProtocolFactory("SessionProtocol", (ClientProtocolFactory)new SessionProtocol());
            clientProtocolFactoryRegistry.registerClientProtocolFactory("SoapHeadersProtocol", (ClientProtocolFactory)new SoapHeadersProtocol());
            clientProtocolFactoryRegistry.registerClientProtocolFactory("MessageIdProtocol", (ClientProtocolFactory)new MessageIdProtocol());
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.catching((Throwable)e);
        }
    }

    public static int[] getDispatcherIDs() {
        ClusterElement[] clusterParticipants = WSContainer.getServiceContext().getClusterContext().getClusterMonitor().getParticipants();
        int clusterParticipantsSize = clusterParticipants.length;
        int[] ids = new int[clusterParticipantsSize];
        int pos = 0;
        int i = 0;
        while (i < clusterParticipantsSize) {
            ClusterElement currentClusterElement = clusterParticipants[i];
            if (currentClusterElement.getType() == 1 && currentClusterElement.getState() == 3) {
                ids[pos++] = currentClusterElement.getClusterId();
            }
            ++i;
        }
        int[] realIDs = new int[pos];
        System.arraycopy(ids, 0, realIDs, 0, pos);
        return realIDs;
    }

    public static LogConfiguratorManagementInterface getLogConfiguratorInterface() {
        return logConfiguratorInterface;
    }

    public static void setLogConfiguratorInterface(LogConfiguratorManagementInterface logConfiguratorInterface) {
        WSContainer.logConfiguratorInterface = logConfiguratorInterface;
    }

    public static UDDIServerAdminImpl getUddiServerAdmin() {
        return uddiServerAdmin;
    }

    public static HTTPProxyResolver getHTTPProxyResolver() {
        return proxyResolver;
    }

    public static Object getSLDInterface() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("domain", "true");
        try {
            InitialContext ctx = new InitialContext(env);
            return ctx.lookup("applsld");
        }
        catch (NamingException ne) {
            Location wsLocation = Location.getLocation((String)WSLogging.SERVER_LOCATION);
            wsLocation.errorT("Cannot get SLD Service Interface: " + ne);
            wsLocation.catching((Throwable)ne);
            return null;
        }
    }

    public static void setSLDInterface(Object sldInterface) {
        WSContainer.sldInterface = sldInterface;
    }

    public static SLDConnection getSLDConnection() {
        return sldConnection;
    }

    public static void setSLDConnection(SLDConnection sldConnection) {
        WSContainer.sldConnection = sldConnection;
    }

    public static boolean isMonitorServiceStarted() {
        return monitorServiceStarted;
    }

    public static void setMonitorServiceStarted(boolean monitorServiceStarted) {
        WSContainer.monitorServiceStarted = monitorServiceStarted;
    }
}

