/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.SLDConnection;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.SLDPort;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.lcr.ObjectWrapper;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMClass;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMClassname;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMFactory;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMInstance;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMInstancename;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMValueNamedInstance;
import com.sap.engine.services.webservices.server.lcr.api.cim.CIMValueNamedInstanceList;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.CIMNames;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.CIMOMClient;
import com.sap.engine.services.webservices.server.lcr.api.cimclient.LcrException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class SLDConnectionImpl
implements SLDConnection {
    public static CIMOMClient getCIMOMClient() throws RemoteException {
        Object sldInterface = WSContainer.getSLDInterface();
        if (sldInterface == null) {
            throw new RemoteException("SLD service is stopped.");
        }
        CIMOMClient cimClient = null;
        try {
            Method getCimClientMethod = sldInterface.getClass().getMethod("getCimClient", null);
            Object clientObj = getCimClientMethod.invoke(sldInterface, null);
            cimClient = new CIMOMClient(clientObj);
        }
        catch (Exception e) {
            throw new RemoteException("Unable to create CIM Client. SLDInterface instance of " + sldInterface.getClass().getName(), e);
        }
        if (cimClient == null) {
            throw new RemoteException("Cannot create CIM Client. Check SLD settings.");
        }
        return cimClient;
    }

    public static CIMValueNamedInstance getOldInstance(CIMOMClient cimClient, CIMClassname className, String name) throws Exception {
        return SLDConnectionImpl.getOldInstance(cimClient, className, name, null);
    }

    public static CIMValueNamedInstance getOldInstance(CIMOMClient cimClient, CIMClassname className, String name, String systemName) throws Exception {
        CIMValueNamedInstanceList instances = cimClient.enumerateInstances(className, false, true, true, true, null);
        int i = 0;
        while (i < instances.size()) {
            CIMValueNamedInstance valueNamedInstance = instances.get(i);
            CIMInstance instance = valueNamedInstance.getInstance();
            String nameProp = instance.getPropertyValue(CIMNames.getProperty("P_NAME"));
            if (name.equals(nameProp) && (systemName == null || systemName.equals(instance.getPropertyValue(CIMNames.getProperty("P_SYSTEMNAME"))))) {
                return valueNamedInstance;
            }
            ++i;
        }
        return null;
    }

    public static void makeAssociation(CIMOMClient cimClient, CIMInstance leftInstance, CIMInstance rightInstance, CIMClassname associationType) throws Exception {
        CIMClass leftClass = cimClient.getCIMClass(leftInstance.getCIMClassname(), false, true, true, null);
        CIMClass rightClass = cimClient.getCIMClass(rightInstance.getCIMClassname(), false, true, true, null);
        CIMInstancename leftSide = leftInstance.buildInstanceName(leftClass);
        CIMInstancename rightSide = rightInstance.buildInstanceName(rightClass);
        CIMInstance associatedInstance = CIMFactory.instance(associationType, leftSide, "antecedent", rightSide, "dependent");
        try {
            cimClient.createInstance(associatedInstance);
        }
        catch (Exception exc) {
            if (ObjectWrapper.isInstanceOf(exc, "com.sap.lcr.api.cimclient.LcrException")) {
                LcrException lcre = new LcrException(exc);
                if (lcre.getStatusCode() != LcrException.getErrorCode("CIM_ERR_ALREADY_EXISTS")) {
                    throw exc;
                }
            }
            throw exc;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SLDPort getFromSLD(String sldSystem, String serviceName, String portName) throws Exception {
        SLDPort sLDPort;
        CIMOMClient cimClient;
        block6: {
            SLDPort sLDPort2;
            block5: {
                SLDPort sLDPort3;
                block4: {
                    cimClient = SLDConnectionImpl.getCIMOMClient();
                    try {
                        CIMValueNamedInstance webService = SLDConnectionImpl.getOldInstance(cimClient, CIMNames.getCimClassNameValue("C_SAP_WebService"), serviceName, sldSystem);
                        if (webService == null) {
                            sLDPort3 = null;
                            Object var11_8 = null;
                            break block4;
                        }
                        CIMValueNamedInstance webServicePort = SLDConnectionImpl.getOldInstance(cimClient, CIMNames.getCimClassNameValue("C_SAP_WebServicePort"), portName, sldSystem);
                        if (webServicePort == null) {
                            sLDPort2 = null;
                            break block5;
                        }
                        String wsdlLocation = webService.getInstance().getPropertyValue(CIMNames.getProperty("P_WSDLLOCATION"));
                        String wsdlPortName = webServicePort.getInstance().getPropertyValue(CIMNames.getProperty("P_WSDLPORTNAME"));
                        sLDPort = new SLDPort(wsdlLocation, wsdlPortName);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        cimClient.disconnect();
                        throw throwable;
                    }
                }
                cimClient.disconnect();
                return sLDPort3;
            }
            Object var11_9 = null;
            cimClient.disconnect();
            return sLDPort2;
        }
        Object var11_10 = null;
        cimClient.disconnect();
        return sLDPort;
    }
}

