/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.interfaces.webservices.uddi4j.DispatcherPortsGetter;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class DispatcherPortsGetterImpl
implements DispatcherPortsGetter {
    public static Object[] getPort(byte portID) {
        MessageContext msgCtx = WSContainer.getServiceContext().getClusterContext().getMessageContext();
        int[] dispatcherIDs = WSContainer.getDispatcherIDs();
        int port = -1;
        int i = 0;
        while (i < dispatcherIDs.length) {
            block7: {
                int dispatcherID = dispatcherIDs[i];
                ClusterElement clusterEl = WSContainer.getServiceContext().getClusterContext().getClusterMonitor().getParticipant(dispatcherID);
                if (clusterEl != null) {
                    try {
                        MessageAnswer msgAnswer = msgCtx.sendAndWaitForAnswer(dispatcherID, (int)portID, new byte[0], 0, 0, 0L);
                        if (msgAnswer.getLength() == 0) break block7;
                        ByteArrayInputStream in = new ByteArrayInputStream(msgAnswer.getMessage(), msgAnswer.getOffset(), msgAnswer.getLength());
                        DataInputStream dataStream = new DataInputStream(in);
                        try {
                            port = dataStream.readInt();
                            if (port != -1) {
                                Object[] res = new Object[]{clusterEl.getAddress(), new Integer(port)};
                                return res;
                            }
                        }
                        catch (IOException ioe) {
                            Location.getLocation((String)WSLogging.SERVER_LOCATION).catching("An error occured while parsing getSSLPort response: " + dispatcherIDs[i], (Throwable)ioe);
                        }
                    }
                    catch (ClusterException ce) {
                        Location.getLocation((String)WSLogging.SERVER_LOCATION).catching("An error occured while sending getSSLPort message to dispatcher: " + dispatcherIDs[i], (Throwable)ce);
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public Object[] getHTTPPort() {
        return DispatcherPortsGetterImpl.getPort((byte)3);
    }

    public Object[] getHTTPSPort() {
        return DispatcherPortsGetterImpl.getPort((byte)2);
    }
}

