/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.ServerRuntimeProcessException;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.registry.RuntimeRegistry;
import com.sap.engine.services.webservices.runtime.wsdl.ServiceGenerator;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitionsParser;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlVisualiserImpl {
    private static ServiceGenerator serviceGenerator = new ServiceGenerator();
    private static WSDLDefinitionsParser definitionsParser = new WSDLDefinitionsParser();
    private static DOMSerializer domSerializer = new DOMSerializer();

    public static void writeServiceWsld(String serviceEndpointId, HttpServletRequest request, String wsdlStyle, String sapParamValue, OutputStream out) throws ServerRuntimeProcessException {
        block9: {
            try {
                ServiceEndpointDefinition endpointDefinition = WsdlVisualiserImpl.getServiceEndpoint(serviceEndpointId);
                WSRuntimeDefinition wsRuntimeDefinition = endpointDefinition.getOwner();
                QName wsQName = wsRuntimeDefinition.getWsQName();
                String requestedUrl = request.getRequestURL().toString();
                String hostAddress = requestedUrl.substring(0, requestedUrl.indexOf(request.getContextPath()));
                String file = request.getParameter("file");
                boolean isSapWSDL = sapParamValue != null && sapParamValue.equals("sap_wsdl");
                Object retObj = ServiceGenerator.generateSOAPHTTPServiceDefinitions(wsQName.getLocalPart(), hostAddress, endpointDefinition.getOwner(), wsdlStyle, isSapWSDL, file);
                if (retObj instanceof WSDLDefinitions) {
                    WSDLDefinitionsParser wSDLDefinitionsParser = definitionsParser;
                    synchronized (wSDLDefinitionsParser) {
                        definitionsParser.writeDefintionsToStream((WSDLDefinitions)retObj, out);
                        definitionsParser.init();
                        break block9;
                    }
                }
                DOMSerializer dOMSerializer = domSerializer;
                synchronized (dOMSerializer) {
                    domSerializer.write((Node)((Element)retObj), out);
                }
            }
            catch (Exception e) {
                throw new ServerRuntimeProcessException(e);
            }
        }
    }

    public static void writeBindingWsld(String serviceEndpointId, String wsdlStyle, String sapParamValue, OutputStream out) throws ServerRuntimeProcessException {
        boolean isSapWSDL = sapParamValue != null && sapParamValue.equals("sap_wsdl");
        try {
            FileInputStream inputStream;
            ServiceEndpointDefinition endpointDefinition = WsdlVisualiserImpl.getServiceEndpoint(serviceEndpointId);
            String bindingWsdlRel = endpointDefinition.getBindingWsdl(wsdlStyle, isSapWSDL);
            File source = new File(bindingWsdlRel);
            if (source.exists()) {
                inputStream = new FileInputStream(source);
                try {
                    WsdlVisualiserImpl.copy(inputStream, out);
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    inputStream.close();
                    throw throwable;
                }
            } else {
                throw new Exception("The file:" + source.getPath() + " does not exist");
            }
            inputStream.close();
        }
        catch (Exception e) {
            throw new ServerRuntimeProcessException(e);
        }
    }

    public static void writePortTypeWsld(String serviceEndpointId, String wsdlStyle, OutputStream out, String sapParamValue) throws ServerRuntimeProcessException {
        try {
            FileInputStream inputStream;
            boolean isSapWSDL = sapParamValue != null && sapParamValue.equals("sap_wsdl");
            ServiceEndpointDefinition endpointDefinition = WsdlVisualiserImpl.getServiceEndpoint(serviceEndpointId);
            String bindingWsdlRel = endpointDefinition.getVIWsdlPath(wsdlStyle, isSapWSDL);
            File source = new File(bindingWsdlRel);
            if (source.exists()) {
                inputStream = new FileInputStream(source);
                try {
                    WsdlVisualiserImpl.copy(inputStream, out);
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    inputStream.close();
                    throw throwable;
                }
            } else {
                throw new Exception("The file:" + source.getPath() + " does not exist");
            }
            inputStream.close();
        }
        catch (Exception e) {
            throw new ServerRuntimeProcessException(e);
        }
    }

    private static ServiceEndpointDefinition getServiceEndpoint(String serviceEndpointId) throws ServerRuntimeProcessException {
        ServiceEndpointDefinition endpointDefinition = null;
        try {
            RuntimeRegistry runtimeRegistry = WSContainer.getRuntimeRegistry();
            endpointDefinition = runtimeRegistry.getServiceEndpoint(serviceEndpointId);
        }
        catch (RegistryException e) {
            e.setLogSettings(null, 200, Location.getLocation((String)WSLogging.RUNTIME_LOCATION));
            e.log();
            throw new ServerRuntimeProcessException((Throwable)((Object)e));
        }
        return endpointDefinition;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }
}

