/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.engine.services.webservices.runtime.definition.ConfigImpl;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.servlet.DocumentationHandler;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.UDDIPublication;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WSDProcessor
extends DefaultHandler {
    static final String FEATURE_ELEMENT = "Feature";
    static final String FEATURE_PROPERTY_ELEMENT = "Property";
    static final String NAME_ATTRIB = "name";
    static final String VALUE_ATTRIB = "value";
    private String name;
    private String documentation;
    private ArrayList uddiPublications = new ArrayList();
    private ArrayList features = new ArrayList();
    private FeatureInfo curFeature;

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (localName.equals("WebServiceDefinition")) {
            this.name = attributes.getValue(NAME_ATTRIB);
        }
        if (localName.equals("UDDITModelPublication")) {
            String tModelKey = attributes.getValue("tModelKey");
            if (tModelKey == null) {
                tModelKey = attributes.getValue(NAME_ATTRIB);
            }
            if (tModelKey != null) {
                UDDIPublication publication = new UDDIPublication();
                publication.setServiceKey(tModelKey);
                publication.setInquiryURL(attributes.getValue("inquiryUrl"));
                publication.setPublishURL(attributes.getValue("publishUrl"));
                this.uddiPublications.add(publication);
            }
        }
        if (localName.equals(FEATURE_ELEMENT)) {
            this.curFeature = new FeatureInfo(attributes.getValue(NAME_ATTRIB), null, new Properties());
        }
        if (localName.equals(FEATURE_PROPERTY_ELEMENT)) {
            ConfigImpl cfg = (ConfigImpl)this.curFeature.getConfiguration();
            cfg.setProperty(attributes.getValue(NAME_ATTRIB), attributes.getValue(VALUE_ATTRIB));
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (localName.equals(FEATURE_ELEMENT)) {
            this.features.add(this.curFeature);
            this.curFeature = null;
        }
    }

    public FeatureInfo[] getFeatures() {
        return this.features.toArray(new FeatureInfo[this.features.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public UDDIPublication[] getUDDIPublications() {
        return this.uddiPublications.toArray(new UDDIPublication[this.uddiPublications.size()]);
    }

    public void process(InputStream wsdInputStream, InputStream docInputStream) throws Exception {
        SAXParser saxParser = new SAXParserFactoryImpl().newSAXParser();
        InputSource input = new InputSource(wsdInputStream);
        saxParser.parse(input, (DefaultHandler)this);
        if (docInputStream != null) {
            DocumentationHandler docHandler = new DocumentationHandler();
            input = new InputSource(docInputStream);
            saxParser.parse(input, (DefaultHandler)docHandler);
            this.documentation = docHandler.getDocumentation();
            if (this.documentation != null && this.documentation.trim().length() == 0) {
                this.documentation = null;
            }
        }
    }
}

