/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappings;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.interfaces.webservices.runtime.PortTypeDescriptor;
import com.sap.engine.services.webservices.runtime.wsdl.BaseWSDLComponentGenerator;
import com.sap.engine.services.webservices.runtime.wsdl.DefinitionsHolder;
import com.sap.engine.services.webservices.runtime.wsdl.PortTypeDescriptorImpl;
import com.sap.engine.services.webservices.runtime.wsdl.PrefixFactory;
import com.sap.engine.services.webservices.runtime.wsdl.SchemaInfo;
import com.sap.engine.services.webservices.runtime.wsdl.StandardTypes;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLCreationException;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLFault;
import com.sap.engine.services.webservices.wsdl.WSDLMessage;
import com.sap.engine.services.webservices.wsdl.WSDLOperation;
import com.sap.engine.services.webservices.wsdl.WSDLPart;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSDLPortTypeGenerator {
    private static final String TARGETNAMESPACE = "targetNamespace";
    private static final String TNS_PREFIX = "tns";
    private static final String INPUTMSG_SUFFIX = "In";
    private static final String OUTPUTMSG_SUFFIX = "Out";
    private static final String REQUEST_PART_NAME = "parameters";
    private static final String RESPONSE_PART_NAME = "parameters";
    private static final String SEPARATOR = "_";
    public static final String NAMESPACE = "namespace";
    private static final String IS_QUALIFIED = "isQualified";
    public static final String SAP_DEFINITIONS_HINT_START_ELEMENT = "<sap:SAP_WSDL xmlns:sap=\"http://www.sap.com/webas\" >";
    public static final String SAP_DEFINITIONS_HINT_END_ELEMENT = "</sap:SAP_WSDL>";
    private static final String SOAP_REQUEST_WRAPPER = "SoapRequestWrapper";
    private static final String SOAP_RESPONSE_WRAPPER = "SoapResponseWrapper";
    private static final String ONE_WAY_OPERATION_FEATURE = "http://www.sap.com/webas/630/soap/features/mep/one-way";
    private static final String FAULT_ELEMENT_NAME = "fault-element-name";

    public static DefinitionsHolder generateDocumentLiteralPortType(JavaToQNameMappingRegistry registry, DOMSource[] literalSchemas, OperationDefinition[] operations, String targetNamespace, String operationsNS, String literalPortTypeName) throws Exception {
        WSDLDefinitions definitions = new WSDLDefinitions();
        definitions.addAdditionalAttribute(TARGETNAMESPACE, targetNamespace);
        PrefixFactory prefixFactory = new PrefixFactory();
        prefixFactory.registerPrefix(TNS_PREFIX, targetNamespace);
        Hashtable schemas = WSDLPortTypeGenerator.loadSchemasAsSchemaInfoObjects(literalSchemas);
        WSDLPortTypeGenerator.generateDocumentPortType0(schemas, definitions, prefixFactory, registry, operations, operationsNS, literalPortTypeName);
        ArrayList resovedSchemas = SchemaInfo.resolveSchemas(schemas);
        int i = 0;
        while (i < resovedSchemas.size()) {
            definitions.addSchema(new DOMSource(((SchemaInfo)resovedSchemas.get(i)).normalizeSchema()));
            ++i;
        }
        WSDLPortTypeGenerator.appendNamespaces(definitions, prefixFactory);
        DefinitionsHolder holder = new DefinitionsHolder();
        holder.setDefinitions(definitions);
        holder.setPortTypeDescriptors(new PortTypeDescriptor[]{new PortTypeDescriptorImpl(1, new QName(targetNamespace, literalPortTypeName))});
        return holder;
    }

    public static DefinitionsHolder generateRPCEncodedPortType(JavaToQNameMappingRegistry registry, DOMSource[] encodedSchemas, OperationDefinition[] operations, String targetNamespace, String encodedPortTypeName) throws Exception {
        WSDLDefinitions definitions = new WSDLDefinitions();
        definitions.addAdditionalAttribute(TARGETNAMESPACE, targetNamespace);
        PrefixFactory prefixFactory = new PrefixFactory();
        prefixFactory.registerPrefix(TNS_PREFIX, targetNamespace);
        WSDLPortTypeGenerator.generateRPCPortType0(definitions, prefixFactory, registry, operations, encodedPortTypeName, false, null, null);
        int i = 0;
        while (i < encodedSchemas.length) {
            definitions.addSchema(encodedSchemas[i]);
            ++i;
        }
        WSDLPortTypeGenerator.appendNamespaces(definitions, prefixFactory);
        DefinitionsHolder holder = new DefinitionsHolder();
        holder.setDefinitions(definitions);
        holder.setPortTypeDescriptors(new PortTypeDescriptor[]{new PortTypeDescriptorImpl(2, new QName(targetNamespace, encodedPortTypeName))});
        return holder;
    }

    public static DefinitionsHolder generateRPCLiteralPortType(JavaToQNameMappingRegistry registry, DOMSource[] encodedSchemas, OperationDefinition[] operations, String targetNamespace, String portTypeName, String operationsNS) throws Exception {
        WSDLDefinitions definitions = new WSDLDefinitions();
        definitions.addAdditionalAttribute(TARGETNAMESPACE, targetNamespace);
        PrefixFactory prefixFactory = new PrefixFactory();
        prefixFactory.registerPrefix(TNS_PREFIX, targetNamespace);
        Hashtable schemas = WSDLPortTypeGenerator.loadSchemasAsSchemaInfoObjects(encodedSchemas);
        WSDLPortTypeGenerator.generateRPCPortType0(definitions, prefixFactory, registry, operations, portTypeName, true, operationsNS, schemas);
        WSDLPortTypeGenerator.generateHeaderParameterElements(schemas, registry.getLiteralMappings(), operations, null);
        ArrayList orderedSchemas = SchemaInfo.resolveSchemas(schemas);
        int i = 0;
        while (i < orderedSchemas.size()) {
            definitions.addSchema(new DOMSource(((SchemaInfo)orderedSchemas.get(i)).normalizeSchema()));
            ++i;
        }
        WSDLPortTypeGenerator.appendNamespaces(definitions, prefixFactory);
        PortTypeDescriptorImpl portTypeDescriptor = new PortTypeDescriptorImpl(4, new QName(targetNamespace, portTypeName));
        DefinitionsHolder holder = new DefinitionsHolder(definitions, new PortTypeDescriptor[]{portTypeDescriptor});
        return holder;
    }

    public static DefinitionsHolder generateHTTPPortType(JavaToQNameMappingRegistry registry, DOMSource[] literalSchemas, OperationDefinition[] operations, String targetNamespace, String operationsNS, String portTypeName) throws Exception {
        WSDLDefinitions definitions = new WSDLDefinitions();
        definitions.addAdditionalAttribute(TARGETNAMESPACE, targetNamespace);
        PrefixFactory prefixFactory = new PrefixFactory();
        prefixFactory.registerPrefix(TNS_PREFIX, targetNamespace);
        WSDLPortType portType = new WSDLPortType();
        portType.setName(portTypeName);
        JavaToQNameMappings javaToQNameMappings = registry.getLiteralMappings();
        int i = 0;
        while (i < operations.length) {
            String namespace;
            OperationDefinition tempOperation = operations[i];
            String inputMessageName = WSDLPortTypeGenerator.getInputEncodedMessageName(portTypeName, tempOperation);
            WSDLMessage tempMessage = BaseWSDLComponentGenerator.generateRPCEncodedMessage(inputMessageName, tempOperation.getInputParameters(), javaToQNameMappings, prefixFactory, false);
            definitions.addMessage(tempMessage);
            String outputMessageName = WSDLPortTypeGenerator.getOutputEncodedMessageName(portTypeName, tempOperation);
            Config outputCnf = tempOperation.getOutputConfiguration();
            try {
                namespace = outputCnf.getProperty(NAMESPACE).getValue();
            }
            catch (NullPointerException e) {
                namespace = operationsNS;
            }
            tempMessage = BaseWSDLComponentGenerator.generateDocumentLiteralMessage(outputMessageName, "parameters", new QName(targetNamespace, WSDLPortTypeGenerator.getOutputElementName(tempOperation)), prefixFactory.getPrefix(namespace));
            definitions.addMessage(tempMessage);
            WSDLOperation wsdlOperation = BaseWSDLComponentGenerator.generatePortTypeOperation(tempOperation.getOperationName(), inputMessageName, outputMessageName, targetNamespace, TNS_PREFIX);
            portType.addOperation(wsdlOperation);
            ++i;
        }
        definitions.addPortType(portType);
        Hashtable schemasTable = WSDLPortTypeGenerator.loadSchemasAsSchemaInfoObjects(literalSchemas);
        WSDLPortTypeGenerator.generateLiteralElementSchemas(schemasTable, javaToQNameMappings, operations, operationsNS, false);
        ArrayList resovedSchemas = SchemaInfo.resolveSchemas(schemasTable);
        int i2 = 0;
        while (i2 < resovedSchemas.size()) {
            definitions.addSchema(new DOMSource(((SchemaInfo)resovedSchemas.get(i2)).normalizeSchema()));
            ++i2;
        }
        PortTypeDescriptorImpl portTypeDescriptor = new PortTypeDescriptorImpl(8, new QName(targetNamespace, portTypeName));
        WSDLPortTypeGenerator.appendNamespaces(definitions, prefixFactory);
        DefinitionsHolder holder = new DefinitionsHolder(definitions, new PortTypeDescriptor[]{portTypeDescriptor});
        return holder;
    }

    public static void generateLiteralElementSchemas(Hashtable schemas, JavaToQNameMappings literalMappings, OperationDefinition[] operations, String operationsDefaultNS, boolean generateInputAndFault) throws Exception {
        Element schemaElement = null;
        WSDLPortTypeGenerator.generateHeaderParameterElements(schemas, literalMappings, operations, operationsDefaultNS);
        boolean isQualified = false;
        if (operations.length > 0) {
            isQualified = Boolean.valueOf(operations[0].getGeneralConfiguration().getProperty(IS_QUALIFIED).getValue().trim());
        }
        int i = 0;
        while (i < operations.length) {
            Element tempElement;
            String tempPrefix;
            QName tempQName;
            String paramClassName;
            String paramName;
            Element sequence;
            Element complexType;
            Element baseElement;
            SchemaInfo schInfo;
            String namespace;
            OperationDefinition operation = operations[i];
            if (generateInputAndFault) {
                Config inputCnf = operation.getInputConfiguration();
                try {
                    namespace = inputCnf.getProperty(NAMESPACE).getValue();
                }
                catch (NullPointerException e) {
                    namespace = operationsDefaultNS;
                }
                schInfo = (SchemaInfo)schemas.get(namespace);
                if (schInfo == null) {
                    schInfo = new SchemaInfo(namespace, isQualified);
                    schemas.put(namespace, schInfo);
                }
                schemaElement = schInfo.getSchemaElement();
                baseElement = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                complexType = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                sequence = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                String inputOpElem = WSDLPortTypeGenerator.getInputElementName(operation);
                baseElement.setAttributeNS("", "name", inputOpElem);
                if (WSDLPortTypeGenerator.isSchemaElementAvailable(schemaElement, inputOpElem)) {
                    throw new WSDLCreationException("webservices_2031", new Object[]{"request", namespace, inputOpElem});
                }
                ParameterNode[] params = operation.getInputParameters();
                int j = 0;
                while (j < params.length) {
                    if (params[j].isExposed() && !params[j].isHeader()) {
                        paramName = params[j].getParameterName();
                        paramClassName = params[j].getJavaClassName();
                        tempQName = literalMappings.getMappedQName(paramClassName);
                        if (tempQName == null) {
                            throw new WSDLCreationException("webservices_2016", new Object[]{paramClassName, literalMappings});
                        }
                        tempPrefix = schInfo.getPrefixForUri(tempQName.getNamespaceURI());
                        tempElement = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        tempElement.setAttributeNS("", "name", paramName);
                        tempElement.setAttributeNS("", "type", tempPrefix + ":" + tempQName.getLocalPart());
                        if (params[j].isOptional()) {
                            tempElement.setAttributeNS("", "minOccurs", "0");
                        }
                        if (StandardTypes.isStandardType(paramClassName)) {
                            if (StandardTypes.isNillableStandardType(paramClassName)) {
                                tempElement.setAttributeNS("", "nillable", "true");
                            }
                        } else {
                            tempElement.setAttributeNS("", "nillable", "true");
                        }
                        sequence.appendChild(tempElement);
                    }
                    ++j;
                }
                complexType.appendChild(sequence);
                baseElement.appendChild(complexType);
                schemaElement.appendChild(baseElement);
            }
            if (!WSDLPortTypeGenerator.isOneWay(operation)) {
                Config outputCnf = operation.getOutputConfiguration();
                try {
                    namespace = outputCnf.getProperty(NAMESPACE).getValue();
                }
                catch (NullPointerException e) {
                    namespace = operationsDefaultNS;
                }
                schInfo = (SchemaInfo)schemas.get(namespace);
                if (schInfo == null) {
                    schInfo = new SchemaInfo(namespace, isQualified);
                    schemas.put(namespace, schInfo);
                }
                schemaElement = schInfo.getSchemaElement();
                String outOpElem = WSDLPortTypeGenerator.getOutputElementName(operation);
                baseElement = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                baseElement.setAttributeNS("", "name", outOpElem);
                complexType = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                sequence = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                if (WSDLPortTypeGenerator.isSchemaElementAvailable(schemaElement, outOpElem)) {
                    throw new WSDLCreationException("webservices_2031", new Object[]{"response", namespace, outOpElem});
                }
                ParameterNode[] outputParams = operation.getOutputParameters();
                if (outputParams.length > 0) {
                    if (outputParams.length != 1) {
                        throw new WSDLCreationException("webservices_2014", new Object[]{new Integer(outputParams.length), operation.getOperationName()});
                    }
                    paramName = outputParams[0].getParameterName();
                    paramClassName = outputParams[0].getJavaClassName();
                    tempElement = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                    tempElement.setAttributeNS("", "name", paramName);
                    if (paramClassName == null || paramClassName.length() == 0 || paramClassName.equals(Void.TYPE.getName())) {
                        tempElement.setAttributeNS("", "minOccurs", "0");
                        Element complexTypeElementInner = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                        Element sequenceInner = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                        complexTypeElementInner.appendChild(sequenceInner);
                        tempElement.appendChild(complexTypeElementInner);
                    } else {
                        tempQName = literalMappings.getMappedQName(paramClassName);
                        if (tempQName == null) {
                            throw new WSDLCreationException("webservices_2016", new Object[]{paramClassName, literalMappings});
                        }
                        tempPrefix = schInfo.getPrefixForUri(tempQName.getNamespaceURI());
                        tempElement.setAttributeNS("", "type", tempPrefix + ":" + tempQName.getLocalPart());
                        if (StandardTypes.isStandardType(paramClassName)) {
                            if (StandardTypes.isNillableStandardType(paramClassName)) {
                                tempElement.setAttributeNS("", "nillable", "true");
                            }
                        } else {
                            tempElement.setAttributeNS("", "nillable", "true");
                        }
                    }
                    sequence.appendChild(tempElement);
                }
                complexType.appendChild(sequence);
                baseElement.appendChild(complexType);
                schemaElement.appendChild(baseElement);
                if (generateInputAndFault) {
                    WSDLPortTypeGenerator.documentFaultsGeneration(operation, operationsDefaultNS, schemas, literalMappings);
                }
            }
            ++i;
        }
    }

    private static void documentFaultsGeneration(OperationDefinition operation, String operationsDefaultNS, Hashtable schemas, JavaToQNameMappings literalMappings) throws Exception {
        Fault[] faults = operation.getFaults();
        boolean isQualified = Boolean.valueOf(operation.getGeneralConfiguration().getProperty(IS_QUALIFIED).getValue().trim());
        if (faults != null) {
            int j = 0;
            while (j < faults.length) {
                String namespace;
                Fault cFault = faults[j];
                Config faultConfig = cFault.getFaultConfiguration();
                try {
                    namespace = faultConfig.getProperty(NAMESPACE).getValue();
                }
                catch (NullPointerException e) {
                    namespace = operationsDefaultNS;
                }
                SchemaInfo schInfo = (SchemaInfo)schemas.get(namespace);
                if (schInfo == null) {
                    schInfo = new SchemaInfo(namespace, isQualified);
                    schemas.put(namespace, schInfo);
                }
                Element schemaElement = schInfo.getSchemaElement();
                QName tempQName = literalMappings.getMappedQName(cFault.getJavaClassName());
                if (tempQName == null) {
                    throw new WSDLCreationException("webservices_2016", new Object[]{cFault.getJavaClassName(), literalMappings});
                }
                if (!WSDLPortTypeGenerator.isElementAlreadyAdded(WSDLPortTypeGenerator.generateFaultElementName(operation, cFault), tempQName, schInfo, "faults")) {
                    String tempPrefix = schInfo.getPrefixForUri(tempQName.getNamespaceURI());
                    Element baseElement = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                    baseElement.setAttributeNS("", "name", WSDLPortTypeGenerator.generateFaultElementName(operation, cFault));
                    baseElement.setAttributeNS("", "type", tempPrefix + ":" + tempQName.getLocalPart());
                    schemaElement.appendChild(baseElement);
                }
                ++j;
            }
        }
    }

    private static Hashtable loadSchemasAsSchemaInfoObjects(DOMSource[] schemas) throws WSDLCreationException {
        Hashtable<String, SchemaInfo> result = new Hashtable<String, SchemaInfo>(schemas.length);
        int i = 0;
        while (i < schemas.length) {
            SchemaInfo tmpSchema = new SchemaInfo((Element)schemas[i].getNode().cloneNode(true));
            if (result.put(tmpSchema.targetNamespace, tmpSchema) != null) {
                throw new WSDLCreationException("webservices_2021", new Object[]{tmpSchema.targetNamespace});
            }
            ++i;
        }
        return result;
    }

    private static void generateHeaderParameterElements(Hashtable schemas, JavaToQNameMappings literalMappings, OperationDefinition[] operations, String operationsDefaultNS) throws Exception {
        boolean isQualified = false;
        if (operations.length > 0) {
            isQualified = Boolean.valueOf(operations[0].getGeneralConfiguration().getProperty(IS_QUALIFIED).getValue().trim());
        }
        int i = 0;
        while (i < operations.length) {
            String defaultNS;
            ParameterNode[] inputParams = operations[i].getInputParameters();
            try {
                defaultNS = operations[i].getInputConfiguration().getProperty(NAMESPACE).getValue();
            }
            catch (NullPointerException e) {
                defaultNS = operationsDefaultNS;
            }
            int p = 0;
            while (p < inputParams.length) {
                if (inputParams[p].isHeader() && inputParams[p].isExposed()) {
                    SchemaInfo schInfo;
                    String headerElNS = inputParams[p].getHeaderElementNamespace();
                    if (headerElNS == null) {
                        headerElNS = defaultNS;
                    }
                    if ((schInfo = (SchemaInfo)schemas.get(headerElNS)) == null) {
                        schInfo = new SchemaInfo(headerElNS, isQualified);
                        schemas.put(headerElNS, schInfo);
                    }
                    Element schemaElement = schInfo.getSchemaElement();
                    QName tempQName = literalMappings.getMappedQName(inputParams[p].getJavaClassName());
                    if (tempQName == null) {
                        throw new WSDLCreationException("webservices_2016", new Object[]{inputParams[p].getJavaClassName(), literalMappings});
                    }
                    if (!WSDLPortTypeGenerator.isElementAlreadyAdded(inputParams[p].getParameterName(), tempQName, schInfo, "headers")) {
                        String tempPrefix = schInfo.getPrefixForUri(tempQName.getNamespaceURI());
                        Element headerElement = schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        headerElement.setAttributeNS("", "name", inputParams[p].getParameterName());
                        headerElement.setAttributeNS("", "type", tempPrefix + ":" + tempQName.getLocalPart());
                        if (StandardTypes.isStandardType(inputParams[p].getJavaClassName())) {
                            if (StandardTypes.isNillableStandardType(inputParams[p].getJavaClassName())) {
                                headerElement.setAttributeNS("", "nillable", "true");
                            }
                        } else {
                            headerElement.setAttributeNS("", "nillable", "true");
                        }
                        schemaElement.appendChild(headerElement);
                    }
                }
                ++p;
            }
            ++i;
        }
    }

    private static WSDLPortType generateDocumentPortType0(Hashtable schemas, WSDLDefinitions definitions, PrefixFactory prefixFactory, JavaToQNameMappingRegistry registry, OperationDefinition[] operations, String operationsDefaultNS, String literalPortTypeName) throws Exception {
        WSDLPortType portType = new WSDLPortType();
        portType.setName(literalPortTypeName);
        WSDLPortTypeGenerator.generateLiteralElementSchemas(schemas, registry.getLiteralMappings(), operations, operationsDefaultNS, true);
        int i = 0;
        while (i < operations.length) {
            String namespace;
            OperationDefinition tempOperation = operations[i];
            String outputMessageName = null;
            String inputMessageName = WSDLPortTypeGenerator.getInputLiteralMessageName(literalPortTypeName, tempOperation);
            try {
                namespace = tempOperation.getInputConfiguration().getProperty(NAMESPACE).getValue();
            }
            catch (NullPointerException e) {
                namespace = operationsDefaultNS;
            }
            WSDLMessage tempMessage = BaseWSDLComponentGenerator.generateDocumentLiteralMessage(inputMessageName, "parameters", new QName(namespace, WSDLPortTypeGenerator.getInputElementName(tempOperation)), prefixFactory.getPrefix(namespace));
            tempMessage = WSDLPortTypeGenerator.appendHeaderParts(tempMessage, tempOperation.getInputParameters(), namespace, prefixFactory);
            definitions.addMessage(tempMessage);
            if (!WSDLPortTypeGenerator.isOneWay(tempOperation)) {
                outputMessageName = WSDLPortTypeGenerator.getOutputLiteralMessageName(literalPortTypeName, tempOperation);
                try {
                    namespace = tempOperation.getOutputConfiguration().getProperty(NAMESPACE).getValue();
                }
                catch (NullPointerException nE) {
                    namespace = operationsDefaultNS;
                }
                tempMessage = BaseWSDLComponentGenerator.generateDocumentLiteralMessage(outputMessageName, "parameters", new QName(namespace, WSDLPortTypeGenerator.getOutputElementName(tempOperation)), prefixFactory.getPrefix(namespace));
                definitions.addMessage(tempMessage);
            }
            WSDLOperation wsdlOperation = BaseWSDLComponentGenerator.generatePortTypeOperation(tempOperation.getOperationName(), inputMessageName, outputMessageName, null, TNS_PREFIX);
            portType.addOperation(wsdlOperation);
            if (!WSDLPortTypeGenerator.isOneWay(tempOperation)) {
                Fault[] faults = tempOperation.getFaults();
                int k = 0;
                while (k < faults.length) {
                    String messageName = WSDLPortTypeGenerator.generateLiteralFaultMessageName(literalPortTypeName, tempOperation, faults[k].getFaultName());
                    String elementName = WSDLPortTypeGenerator.generateFaultElementName(tempOperation, faults[k]);
                    try {
                        namespace = faults[k].getFaultConfiguration().getProperty(NAMESPACE).getValue();
                    }
                    catch (NullPointerException nE) {
                        namespace = operationsDefaultNS;
                    }
                    tempMessage = BaseWSDLComponentGenerator.generateLiteralFaultMessage(messageName, prefixFactory.getPrefix(namespace), elementName);
                    definitions.addMessage(tempMessage);
                    WSDLFault fault = BaseWSDLComponentGenerator.generateFaultChannel(faults[k].getFaultName(), TNS_PREFIX, messageName);
                    wsdlOperation.addFault(fault);
                    ++k;
                }
            }
            ++i;
        }
        definitions.addPortType(portType);
        return portType;
    }

    private static WSDLPortType generateRPCPortType0(WSDLDefinitions definitions, PrefixFactory prefixFactory, JavaToQNameMappingRegistry registry, OperationDefinition[] operations, String encodedPortTypeName, boolean isLiteral, String operationsNS, Hashtable schemas) throws Exception {
        WSDLPortType portType = new WSDLPortType();
        portType.setName(encodedPortTypeName);
        JavaToQNameMappings javaToQNameMappings = isLiteral ? registry.getLiteralMappings() : registry.getEncodedMappings();
        int i = 0;
        while (i < operations.length) {
            OperationDefinition tempOperation = operations[i];
            if (isLiteral || !WSDLPortTypeGenerator.isOperationWithHeaders(tempOperation)) {
                Fault[] faults;
                String outputMessageName = null;
                String inputMessageName = WSDLPortTypeGenerator.getInputEncodedMessageName(encodedPortTypeName, tempOperation);
                WSDLMessage tempMessage = BaseWSDLComponentGenerator.generateRPCEncodedMessage(inputMessageName, tempOperation.getInputParameters(), javaToQNameMappings, prefixFactory, isLiteral);
                if (isLiteral) {
                    String headersNS;
                    try {
                        headersNS = tempOperation.getInputConfiguration().getProperty(NAMESPACE).getValue();
                    }
                    catch (NullPointerException e) {
                        headersNS = operationsNS;
                    }
                    tempMessage = WSDLPortTypeGenerator.appendHeaderParts(tempMessage, tempOperation.getInputParameters(), headersNS, prefixFactory);
                }
                definitions.addMessage(tempMessage);
                if (!WSDLPortTypeGenerator.isOneWay(tempOperation)) {
                    outputMessageName = WSDLPortTypeGenerator.getOutputEncodedMessageName(encodedPortTypeName, tempOperation);
                    tempMessage = BaseWSDLComponentGenerator.generateRPCEncodedMessage(outputMessageName, tempOperation.getOutputParameters(), javaToQNameMappings, prefixFactory, isLiteral);
                    definitions.addMessage(tempMessage);
                }
                WSDLOperation wsdlOperation = BaseWSDLComponentGenerator.generatePortTypeOperation(tempOperation.getOperationName(), inputMessageName, outputMessageName, null, TNS_PREFIX);
                if (!WSDLPortTypeGenerator.isOneWay(tempOperation) && (faults = tempOperation.getFaults()) != null) {
                    if (isLiteral) {
                        WSDLPortTypeGenerator.documentFaultsGeneration(tempOperation, operationsNS, schemas, javaToQNameMappings);
                        int k = 0;
                        while (k < faults.length) {
                            String namespace;
                            String messageName = WSDLPortTypeGenerator.generateLiteralFaultMessageName(encodedPortTypeName, tempOperation, faults[k].getFaultName());
                            String elementName = WSDLPortTypeGenerator.generateFaultElementName(tempOperation, faults[k]);
                            try {
                                namespace = faults[k].getFaultConfiguration().getProperty(NAMESPACE).getValue();
                            }
                            catch (NullPointerException nE) {
                                namespace = operationsNS;
                            }
                            tempMessage = BaseWSDLComponentGenerator.generateLiteralFaultMessage(messageName, prefixFactory.getPrefix(namespace), elementName);
                            definitions.addMessage(tempMessage);
                            WSDLFault fault = BaseWSDLComponentGenerator.generateFaultChannel(faults[k].getFaultName(), TNS_PREFIX, messageName);
                            wsdlOperation.addFault(fault);
                            ++k;
                        }
                    } else {
                        int k = 0;
                        while (k < faults.length) {
                            String faultMessageName = WSDLPortTypeGenerator.generateEncodedFaultMessageName(encodedPortTypeName, tempOperation, faults[k].getFaultName());
                            String faultPartName = WSDLPortTypeGenerator.generateFaultElementName(tempOperation, faults[k]);
                            tempMessage = BaseWSDLComponentGenerator.generateEncodedFaultMessage(faultMessageName, javaToQNameMappings, prefixFactory, faults[k], faultPartName);
                            definitions.addMessage(tempMessage);
                            WSDLFault wsdlFault = BaseWSDLComponentGenerator.generateFaultChannel(faults[k].getFaultName(), TNS_PREFIX, faultMessageName);
                            wsdlOperation.addFault(wsdlFault);
                            ++k;
                        }
                    }
                }
                portType.addOperation(wsdlOperation);
            }
            ++i;
        }
        definitions.addPortType(portType);
        return portType;
    }

    private static WSDLMessage appendHeaderParts(WSDLMessage message, ParameterNode[] inputParameterNodes, String defaultNS, PrefixFactory factory) throws WSDLException {
        int i = 0;
        while (i < inputParameterNodes.length) {
            if (inputParameterNodes[i].isHeader() && inputParameterNodes[i].isExposed()) {
                String ns = inputParameterNodes[i].getHeaderElementNamespace();
                if (ns == null) {
                    ns = defaultNS;
                }
                String prefix = factory.getPrefix(ns);
                WSDLPart part = new WSDLPart();
                part.setName(inputParameterNodes[i].getParameterName() + SEPARATOR + i);
                part.setType(1, new com.sap.engine.lib.xml.util.QName(prefix, inputParameterNodes[i].getParameterName(), ns));
                message.addPart(part);
            }
            ++i;
        }
        return message;
    }

    private static String getInputEncodedMessageName(String portTypeName, OperationDefinition operation) {
        return operation.getOperationName() + INPUTMSG_SUFFIX;
    }

    private static String getOutputEncodedMessageName(String portTypeName, OperationDefinition operation) {
        return operation.getOperationName() + OUTPUTMSG_SUFFIX;
    }

    private static String getInputLiteralMessageName(String portTypeName, OperationDefinition operationDefinition) {
        return WSDLPortTypeGenerator.getInputEncodedMessageName(portTypeName, operationDefinition) + "_doc";
    }

    private static String getOutputLiteralMessageName(String portTypeName, OperationDefinition operationDefinition) {
        return WSDLPortTypeGenerator.getOutputEncodedMessageName(portTypeName, operationDefinition) + "_doc";
    }

    private static String getInputElementName(OperationDefinition operationDefinition) {
        Config cfg = operationDefinition.getGeneralConfiguration();
        if (cfg != null) {
            String soapReqestWrap;
            String string = soapReqestWrap = cfg.getProperty(SOAP_REQUEST_WRAPPER) != null ? cfg.getProperty(SOAP_REQUEST_WRAPPER).getValue() : null;
            if (soapReqestWrap != null) {
                return soapReqestWrap;
            }
        }
        return operationDefinition.getOperationName();
    }

    private static String getOutputElementName(OperationDefinition operationDefinition) {
        Config cfg = operationDefinition.getGeneralConfiguration();
        if (cfg != null) {
            String soapRespWrap;
            String string = soapRespWrap = cfg.getProperty(SOAP_RESPONSE_WRAPPER) != null ? cfg.getProperty(SOAP_RESPONSE_WRAPPER).getValue() : null;
            if (soapRespWrap != null) {
                return soapRespWrap;
            }
        }
        return operationDefinition.getOperationName() + "Response";
    }

    private static String generateEncodedFaultMessageName(String portTypeName, OperationDefinition operationDefinition, String operationFault) {
        return operationDefinition.getOperationName() + SEPARATOR + operationFault;
    }

    private static String generateLiteralFaultMessageName(String portTypeName, OperationDefinition operationDefinition, String operationFault) {
        return WSDLPortTypeGenerator.generateEncodedFaultMessageName(portTypeName, operationDefinition, operationFault) + "_doc";
    }

    private static String generateFaultElementName(OperationDefinition operation, Fault fault) {
        String faultElementName = null;
        Config config = fault.getFaultConfiguration();
        if (config.getProperty(FAULT_ELEMENT_NAME) != null) {
            faultElementName = config.getProperty(FAULT_ELEMENT_NAME).getValue();
        }
        if (faultElementName == null) {
            faultElementName = operation.getOperationName() + SEPARATOR + fault.getFaultName();
        }
        return faultElementName;
    }

    private static WSDLDefinitions appendNamespaces(WSDLDefinitions definitions, PrefixFactory factory) {
        Hashtable mappings = factory.getMappings();
        Enumeration uris = mappings.keys();
        while (uris.hasMoreElements()) {
            String tempUri = (String)uris.nextElement();
            String tempPrefix = (String)mappings.get(tempUri);
            definitions.addAdditionalAttribute("xmlns:" + tempPrefix, tempUri);
        }
        return definitions;
    }

    private static boolean isOneWay(OperationDefinition opD) {
        Feature[] fs = opD.getFeatures();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getFeatureName().equals(ONE_WAY_OPERATION_FEATURE)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isOperationWithHeaders(OperationDefinition opD) {
        ParameterNode[] params = opD.getInputParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].isHeader() && params[i].isExposed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isElementAlreadyAdded(String headerName, QName headerType, SchemaInfo schema, String faultString) throws WSDLCreationException {
        Element schemaEl = schema.getSchemaElement();
        NodeList list = schemaEl.getElementsByTagName("xs:element");
        int i = 0;
        while (i < list.getLength()) {
            Element curr = (Element)list.item(i);
            if (curr.getAttribute("name").equals(headerName)) {
                String typeAttr = curr.getAttribute("type");
                int pos = typeAttr.indexOf(":");
                String uriPrefix = typeAttr.substring(0, pos);
                String typeName = typeAttr.substring(pos + 1, typeAttr.length());
                if (typeName.equals(headerType.getLocalPart())) {
                    String tmpUriPrefix = schema.getPrefixForUri(headerType.getNamespaceURI());
                    if (tmpUriPrefix.equals(uriPrefix)) {
                        return true;
                    }
                    throw new WSDLCreationException("webservices_2030", new Object[]{faultString, schema.getTargetNamespace(), headerName, headerType.getNamespaceURI(), typeName, headerType.getLocalPart()});
                }
                throw new WSDLCreationException("webservices_2030", new Object[]{faultString, schema.getTargetNamespace(), headerName, headerType.getNamespaceURI(), typeName, headerType.getLocalPart()});
            }
            ++i;
        }
        return false;
    }

    private static boolean isSchemaElementAvailable(Element schemaElement, String newElementName) {
        NodeList nodes = schemaElement.getElementsByTagName("xs:element");
        int i = 0;
        while (i < nodes.getLength()) {
            if (((Element)nodes.item(i)).getAttribute("name").equals(newElementName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

