/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.PortTypeDescriptor;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.TransportBindingProvider;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.wsdl.DefinitionsHolder;
import com.sap.engine.services.webservices.runtime.wsdl.FeatureBindingAppender;
import com.sap.engine.services.webservices.runtime.wsdl.PortTypeDescriptorImpl;
import com.sap.engine.services.webservices.runtime.wsdl.ServiceGenerator;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLCreationException;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLPortTypeGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.VISchemasInfo;
import com.sap.engine.services.webservices.wsdl.SAPFeature;
import com.sap.engine.services.webservices.wsdl.SAPUseFeature;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitionsParser;
import com.sap.engine.services.webservices.wsdl.WSDLImport;
import com.sap.engine.services.webservices.wsdl.WSDLPortType;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class WSDLGenerator {
    private static final String GENERATE_ALL_STYLES = "generate_all_styles";
    private TransportBindingProvider trBindingProvider = null;

    public WSDLGenerator(TransportBindingProvider trBindingProvider) {
        this.trBindingProvider = trBindingProvider;
    }

    public void generateStandAloneWsdls(WSRuntimeDefinition wsRuntimeDefinition, Hashtable viSchemasInfoes, String outputDir, String style, String hostAddress, boolean sapMode) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        try {
            ServiceEndpointDefinition[] definitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
            HashMapObjectObject hashTable = new HashMapObjectObject();
            int i = 0;
            while (i < definitions.length) {
                ServiceEndpointDefinition endpoint = definitions[i];
                VISchemasInfo viSchemaInfo = (VISchemasInfo)viSchemasInfoes.get(endpoint.getViRelPath());
                this.generateEndpointWSDLs(endpoint, wsRuntimeDefinition, viSchemaInfo, outputDir, style, sapMode);
                hashTable.put((Object)endpoint.getTransportBindingId(), (Object)this.trBindingProvider.getTransportBinding(endpoint.getTransportBindingId()));
                ++i;
            }
            WSDLDefinitions def = ServiceGenerator.generateSOAPHTTPServiceDefinitionsInternal(wsRuntimeDefinition.getWsQName().getLocalPart(), hostAddress, wsRuntimeDefinition, style, sapMode, hashTable, true, false, null);
            WSDLDefinitionsParser parser = new WSDLDefinitionsParser();
            parser.parseDefinitionsToFile(def, new File(outputDir + "/main.wsdl"));
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to generate web service's wsdls ", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    public void generateWsdls(WSRuntimeDefinition wsRuntimeDefinition, Hashtable viSchemasInfoes, HashMap[] mappings) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        try {
            ArrayList<String> mergedSupportedStyles = new ArrayList<String>();
            JavaToQNameMappingRegistryImpl javaToQNameRegistry = new JavaToQNameMappingRegistryImpl();
            javaToQNameRegistry.setLiteralMappings(mappings[0]);
            javaToQNameRegistry.setEncodedMappings(mappings[1]);
            wsRuntimeDefinition.setJavaToQNameMappingRegistry(javaToQNameRegistry);
            ServiceEndpointDefinition[] definitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
            int i = 0;
            while (i < definitions.length) {
                ServiceEndpointDefinition endpoint = definitions[i];
                VISchemasInfo viSchemaInfo = (VISchemasInfo)viSchemasInfoes.get(endpoint.getViRelPath());
                this.generateEndpointWSDLs(endpoint, wsRuntimeDefinition, viSchemaInfo, null, null, false);
                this.generateEndpointWSDLs(endpoint, wsRuntimeDefinition, viSchemaInfo, null, null, true);
                String[] endpointStyles = ((RuntimeTransportBinding)this.trBindingProvider.getTransportBinding(endpoint.getTransportBindingId())).getSupportedSyles();
                int j = 0;
                while (j < endpointStyles.length) {
                    if (!mergedSupportedStyles.contains(endpointStyles[j])) {
                        mergedSupportedStyles.add(endpointStyles[j]);
                    }
                    ++j;
                }
                File res = new File(wsRuntimeDefinition.getWsDirsHandler().getWsdlDir(), "alone");
                this.generateEndpointWSDLs(endpoint, wsRuntimeDefinition, viSchemaInfo, res.getAbsolutePath(), GENERATE_ALL_STYLES, false);
                this.generateEndpointWSDLs(endpoint, wsRuntimeDefinition, viSchemaInfo, res.getAbsolutePath(), GENERATE_ALL_STYLES, true);
                ++i;
            }
            wsRuntimeDefinition.setWsdlSupportedStyles(mergedSupportedStyles.toArray(new String[mergedSupportedStyles.size()]));
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to generate web service's wsdls ", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    private String getPortTypeTNS(String wsdName, String viName, String style) {
        return "urn:" + wsdName + "/" + viName + "/" + style;
    }

    private String getBindingTNS(String wsdName, String configName, String style) {
        return "urn:" + wsdName + "/" + configName + "/" + style;
    }

    private String getPortTypeImportLocation(ServiceEndpointDefinition endpoint, String style, boolean sapMode) {
        if (sapMode) {
            return endpoint.getServiceEndpointId() + "/porttypes?wsdl&" + "style=" + style + "&mode=sap_wsdl";
        }
        return endpoint.getServiceEndpointId() + "/porttypes?wsdl&" + "style=" + style;
    }

    private String getOperationsNS(String wsdName, String viName) {
        return "urn:" + wsdName + "/" + viName;
    }

    private DefinitionsHolder getBindingWSDLDefinitions(ArrayList imports, String targetNamespace) throws Exception {
        String prefix = "prt";
        WSDLDefinitions definitions = new WSDLDefinitions();
        definitions.targetNamespace = targetNamespace;
        ArrayList<WSDLImport> importDeclarations = new ArrayList<WSDLImport>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            PortTypeInfo ptInfo = (PortTypeInfo)imports.get(i);
            String portTypeTNS = ptInfo.portTypeDescriptor.getQName().getNamespaceURI();
            String portTypeLocation = ptInfo.importLocation;
            importDeclarations.add(new WSDLImport(null, portTypeLocation, portTypeTNS));
            definitions.addAdditionalAttribute("xmlns:" + prefix + i, portTypeTNS);
            ++i;
        }
        definitions.setImportDeclaratuions(importDeclarations);
        PortTypeDescriptor[] result = new PortTypeDescriptor[imports.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = ((PortTypeInfo)imports.get((int)i2)).portTypeDescriptor;
            ++i2;
        }
        return new DefinitionsHolder(definitions, result);
    }

    private String getBindingOutputFilePath(String outDir, String confName, String style, boolean sapMode) {
        if (sapMode) {
            return outDir + "/bindings/" + confName + "_" + style + "_sap.wsdl";
        }
        return outDir + "/bindings/" + confName + "_" + style + ".wsdl";
    }

    private String getPortTypeOutputFilePath(String outDir, String viName, String confName, String style, boolean sapMode) {
        if (sapMode) {
            return outDir + "/porttypes/" + confName + "_" + viName + "_" + style + "_sap.wsdl";
        }
        return outDir + "/porttypes/" + confName + "_" + viName + "_" + style + ".wsdl";
    }

    private void generateEndpointWSDLs(ServiceEndpointDefinition endpoint, WSRuntimeDefinition wsRuntimeDefinition, VISchemasInfo viSchemaInfo, String outputDir, String specificStyle, boolean sapMode) throws Exception {
        int[] portTypeTypes;
        RuntimeTransportBinding transportBinding = (RuntimeTransportBinding)this.trBindingProvider.getTransportBinding(endpoint.getTransportBindingId());
        JavaToQNameMappingRegistry javaToQNameRegistry = wsRuntimeDefinition.getJavaToQNameMappingRegistry();
        String confName = endpoint.getConfigurationName();
        String[] styles = transportBinding.getSupportedSyles();
        if (styles.length != (portTypeTypes = transportBinding.getNecessaryPortTypes()).length) {
            throw new WSDLCreationException(new Exception("The styles: " + styles.length + " and portTypes:" + portTypeTypes.length + "arrays differ"));
        }
        boolean isStandAlone = false;
        File outputDirFile = null;
        if (outputDir != null) {
            isStandAlone = true;
            outputDirFile = new File(outputDir);
            outputDirFile.mkdirs();
            if (specificStyle == null) {
                styles = transportBinding.getDefaultStyles();
                portTypeTypes = this.getPortTypeCodes(transportBinding, transportBinding.getDefaultStyles());
            } else if (specificStyle.equals(GENERATE_ALL_STYLES)) {
                styles = transportBinding.getSupportedSyles();
                portTypeTypes = transportBinding.getNecessaryPortTypes();
            } else {
                int i = 0;
                while (i < styles.length) {
                    if (styles[i].equals(specificStyle)) {
                        portTypeTypes = new int[]{portTypeTypes[i]};
                        styles = new String[]{specificStyle};
                        break;
                    }
                    ++i;
                }
                if (i == styles.length) {
                    return;
                }
            }
        }
        ArrayList<PortTypeInfo> bindingImports = new ArrayList<PortTypeInfo>();
        WSDLDefinitionsParser wsdlDefinitionsParser = new WSDLDefinitionsParser();
        int pt = 0;
        while (pt < styles.length) {
            String operationsNS;
            DefinitionsHolder defHolder;
            PortTypeDescriptorImpl desc;
            String importLocation;
            String targetNamespace;
            String portTypeName;
            String portTypeType;
            bindingImports.clear();
            int prtTCode = portTypeTypes[pt];
            if ((prtTCode & 2) == 2) {
                File portTypeFile;
                portTypeType = PortTypeDescriptorImpl.getPortTypeType(2);
                portTypeName = WSDLGenerator.getPortTypeName(viSchemaInfo.getViName(), portTypeType);
                targetNamespace = this.getPortTypeTNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName(), portTypeType);
                importLocation = null;
                if (isStandAlone) {
                    portTypeFile = new File(this.getPortTypeOutputFilePath(outputDir, viSchemaInfo.getViName(), confName, portTypeType, sapMode));
                    importLocation = this.getPortTypeOutputFilePath(this.getUpperDirsDots(outputDirFile, portTypeFile.getParentFile()), viSchemaInfo.getViName(), confName, portTypeType, sapMode);
                } else {
                    portTypeFile = new File(endpoint.getVIWsdlPath(portTypeType, sapMode));
                    importLocation = this.getPortTypeImportLocation(endpoint, portTypeType, sapMode);
                }
                desc = new PortTypeDescriptorImpl(2, new QName(targetNamespace, portTypeName));
                bindingImports.add(new PortTypeInfo(desc, importLocation));
                if (!portTypeFile.exists()) {
                    portTypeFile.getParentFile().mkdirs();
                    defHolder = WSDLPortTypeGenerator.generateRPCEncodedPortType(javaToQNameRegistry, viSchemaInfo.getEncodedSchemas(), endpoint.getOperations(), targetNamespace, portTypeName);
                    if (sapMode) {
                        this.appendDesigntimeFeatures(defHolder.getDefinitions(), wsRuntimeDefinition.getDesigntimeFeatures());
                    }
                    wsdlDefinitionsParser.parseDefinitionsToFile(defHolder.getDefinitions(), portTypeFile);
                    wsdlDefinitionsParser.init();
                }
            }
            if ((prtTCode & 1) == 1) {
                File portTypeFile;
                portTypeType = PortTypeDescriptorImpl.getPortTypeType(1);
                portTypeName = WSDLGenerator.getPortTypeName(viSchemaInfo.getViName(), portTypeType);
                targetNamespace = this.getPortTypeTNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName(), portTypeType);
                importLocation = null;
                if (isStandAlone) {
                    portTypeFile = new File(this.getPortTypeOutputFilePath(outputDir, viSchemaInfo.getViName(), confName, portTypeType, sapMode));
                    importLocation = this.getPortTypeOutputFilePath(this.getUpperDirsDots(outputDirFile, portTypeFile.getParentFile()), viSchemaInfo.getViName(), confName, portTypeType, sapMode);
                } else {
                    portTypeFile = new File(endpoint.getVIWsdlPath(portTypeType, sapMode));
                    importLocation = this.getPortTypeImportLocation(endpoint, portTypeType, sapMode);
                }
                desc = new PortTypeDescriptorImpl(1, new QName(targetNamespace, portTypeName));
                bindingImports.add(new PortTypeInfo(desc, importLocation));
                operationsNS = this.getOperationsNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName());
                if (!portTypeFile.exists()) {
                    portTypeFile.getParentFile().mkdirs();
                    defHolder = WSDLPortTypeGenerator.generateDocumentLiteralPortType(javaToQNameRegistry, viSchemaInfo.getLiteralSchemas(), endpoint.getOperations(), targetNamespace, operationsNS, portTypeName);
                    if (sapMode) {
                        this.appendDesigntimeFeatures(defHolder.getDefinitions(), wsRuntimeDefinition.getDesigntimeFeatures());
                    }
                    wsdlDefinitionsParser.parseDefinitionsToFile(defHolder.getDefinitions(), portTypeFile);
                    wsdlDefinitionsParser.init();
                }
            }
            if ((prtTCode & 4) == 4) {
                File portTypeFile;
                portTypeType = PortTypeDescriptorImpl.getPortTypeType(4);
                portTypeName = WSDLGenerator.getPortTypeName(viSchemaInfo.getViName(), portTypeType);
                targetNamespace = this.getPortTypeTNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName(), portTypeType);
                importLocation = null;
                if (isStandAlone) {
                    portTypeFile = new File(this.getPortTypeOutputFilePath(outputDir, viSchemaInfo.getViName(), confName, portTypeType, sapMode));
                    importLocation = this.getPortTypeOutputFilePath(this.getUpperDirsDots(outputDirFile, portTypeFile.getParentFile()), viSchemaInfo.getViName(), confName, portTypeType, sapMode);
                } else {
                    portTypeFile = new File(endpoint.getVIWsdlPath(portTypeType, sapMode));
                    importLocation = this.getPortTypeImportLocation(endpoint, portTypeType, sapMode);
                }
                desc = new PortTypeDescriptorImpl(4, new QName(targetNamespace, portTypeName));
                bindingImports.add(new PortTypeInfo(desc, importLocation));
                operationsNS = this.getOperationsNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName());
                if (!portTypeFile.exists()) {
                    portTypeFile.getParentFile().mkdirs();
                    defHolder = WSDLPortTypeGenerator.generateRPCLiteralPortType(javaToQNameRegistry, viSchemaInfo.getLiteralSchemas(), endpoint.getOperations(), targetNamespace, portTypeName, operationsNS);
                    if (sapMode) {
                        this.appendDesigntimeFeatures(defHolder.getDefinitions(), wsRuntimeDefinition.getDesigntimeFeatures());
                    }
                    wsdlDefinitionsParser.parseDefinitionsToFile(defHolder.getDefinitions(), portTypeFile);
                    wsdlDefinitionsParser.init();
                }
            }
            if ((prtTCode & 8) == 8) {
                File portTypeFile;
                portTypeType = PortTypeDescriptorImpl.getPortTypeType(8);
                portTypeName = WSDLGenerator.getPortTypeName(viSchemaInfo.getViName(), portTypeType);
                targetNamespace = this.getPortTypeTNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName(), portTypeType);
                importLocation = null;
                if (isStandAlone) {
                    portTypeFile = new File(this.getPortTypeOutputFilePath(outputDir, viSchemaInfo.getViName(), confName, portTypeType, sapMode));
                    importLocation = this.getPortTypeOutputFilePath(this.getUpperDirsDots(outputDirFile, portTypeFile.getParentFile()), viSchemaInfo.getViName(), confName, portTypeType, sapMode);
                } else {
                    portTypeFile = new File(endpoint.getVIWsdlPath(portTypeType, sapMode));
                    importLocation = this.getPortTypeImportLocation(endpoint, portTypeType, sapMode);
                }
                desc = new PortTypeDescriptorImpl(8, new QName(targetNamespace, portTypeName));
                bindingImports.add(new PortTypeInfo(desc, importLocation));
                operationsNS = this.getOperationsNS(wsRuntimeDefinition.getWsdName(), viSchemaInfo.getViName());
                if (!portTypeFile.exists()) {
                    portTypeFile.getParentFile().mkdirs();
                    defHolder = WSDLPortTypeGenerator.generateHTTPPortType(javaToQNameRegistry, viSchemaInfo.getLiteralSchemas(), endpoint.getOperations(), targetNamespace, operationsNS, portTypeName);
                    if (sapMode) {
                        this.appendDesigntimeFeatures(defHolder.getDefinitions(), wsRuntimeDefinition.getDesigntimeFeatures());
                    }
                    wsdlDefinitionsParser.parseDefinitionsToFile(defHolder.getDefinitions(), portTypeFile);
                    wsdlDefinitionsParser.init();
                }
            }
            targetNamespace = this.getBindingTNS(wsRuntimeDefinition.getWsdName(), endpoint.getConfigurationName(), styles[pt]);
            DefinitionsHolder holder = this.getBindingWSDLDefinitions(bindingImports, targetNamespace);
            transportBinding.generateBinding(styles[pt], endpoint.getWsdlBindingName(), endpoint.getTrBindingConfig(), endpoint.getOperations(), holder.getPortTypeDescriptors(), holder.getDefinitions());
            File bindingFile = isStandAlone ? new File(this.getBindingOutputFilePath(outputDir, confName, styles[pt], sapMode)) : (sapMode ? new File(endpoint.getBindingWsdl(styles[pt], true)) : new File(endpoint.getBindingWsdl(styles[pt], false)));
            bindingFile.getParentFile().mkdirs();
            if (sapMode) {
                FeatureBindingAppender.appendFeatures(holder.getDefinitions(), new ServiceEndpointDefinition[]{endpoint});
            }
            wsdlDefinitionsParser.parseDefinitionsToFile(holder.getDefinitions(), bindingFile);
            wsdlDefinitionsParser.init();
            ++pt;
        }
    }

    private int[] getPortTypeCodes(RuntimeTransportBinding trb, String[] defStyles) throws Exception {
        int[] res = new int[defStyles.length];
        String[] styles = trb.getSupportedSyles();
        int[] portTypeCodes = trb.getNecessaryPortTypes();
        int nom = 0;
        int i = 0;
        while (i < styles.length) {
            int j = 0;
            while (j < defStyles.length) {
                if (styles[i].equals(defStyles[j])) {
                    res[nom++] = portTypeCodes[i];
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private String getUpperDirsDots(File baseDir, File curDir) {
        String res = "";
        while (!baseDir.equals(curDir)) {
            res = res + "../";
            curDir = curDir.getParentFile();
        }
        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }
        return res;
    }

    private static String getPortTypeName(String viName, String ptStyle) {
        return viName + "_" + ServiceGenerator.getUpperLetteredString(ptStyle);
    }

    private String getFeatureWSDL_ID(String portTypeName, int nom) {
        return portTypeName + "_design-feature_" + nom;
    }

    private void appendDesigntimeFeatures(WSDLDefinitions def, FeatureInfo[] features) throws Exception {
        WSDLPortType portType = (WSDLPortType)def.getPortTypes().get(0);
        String portTypeName = portType.getName();
        String feature_NS_pref = "fns";
        String tnsPref = FeatureBindingAppender.setTNSPrefix(def);
        int i = 0;
        while (i < features.length) {
            FeatureInfo cur = features[i];
            SAPUseFeature useFeature = new SAPUseFeature();
            String featureID = this.getFeatureWSDL_ID(portTypeName, i);
            useFeature.setFeatureQName(new com.sap.engine.lib.xml.util.QName(tnsPref, featureID, cur.getFeatureName()));
            portType.addUseFeature(useFeature);
            SAPFeature sapFeature = new SAPFeature();
            sapFeature.setName(featureID);
            sapFeature.setUri(cur.getFeatureName());
            String fPref = FeatureBindingAppender.getPrefixForUri(def, cur.getFeatureName());
            if (fPref == null) {
                fPref = "fns" + i;
                def.addAdditionalAttribute("xmlns:" + fPref, cur.getFeatureName());
            }
            FeatureBindingAppender.loadProperties(sapFeature, cur.getConfiguration(), fPref);
            def.addFeature(sapFeature);
            ++i;
        }
    }

    private class PortTypeInfo {
        PortTypeDescriptor portTypeDescriptor;
        String importLocation;

        PortTypeInfo(PortTypeDescriptor portTypeDescriptor, String importLocation) {
            this.portTypeDescriptor = portTypeDescriptor;
            this.importLocation = importLocation;
        }
    }
}

