/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.additions.soaphttp.HTTPTransportBinding;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.servlet.DocumentationHandler;
import com.sap.engine.services.webservices.runtime.wsdl.PortTypeDescriptorImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitionsParser;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.engine.services.webservices.wsdl.WSDLImport;
import com.sap.engine.services.webservices.wsdl.WSDLPort;
import com.sap.engine.services.webservices.wsdl.WSDLService;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceGenerator {
    private static final String WSDL_HTTP_NS = "http://schemas.xmlsoap.org/wsdl/http/";
    private static final String TRANSPORTGUARANTEE_FEATURE = "http://www.sap.com/webas/630/soap/features/transportguarantee";
    private static final String SSL_PROPERTY = "TLSType";
    private static final String SSL_VALUE = "SSL";
    private static final String BINDING_NS_PREFIX = "bns";
    private static final String SOAP_ADDRESS_TAG = "address";
    private static final String IMPORT_TAG = "import";
    private static final String ROOT_WSDL_FILE = "wsdlroot.wsdl";
    private static final String MAIN_WSDL_FILE = "main.wsdl";
    private static WSDLDefinitionsParser wsdlDefinitionsParser = new WSDLDefinitionsParser();
    private static InstancesPool hashTablePool = new InstancesPool();
    private static DOMSerializer domSerializer = new DOMSerializer();
    private static SAXParser saxParser;
    private static DocumentationHandler wsdDocumHandler;
    private static DocumentBuilderFactoryImpl documentFactory;

    private static String getBindingImportLocation(String serverAddress, ServiceEndpointDefinition endpoint, String style, boolean isSapWSDL) {
        if (isSapWSDL) {
            if (serverAddress != null) {
                return ServiceGenerator.generateHTTPLocationAttrValue(serverAddress, endpoint, null, false) + "/bindings?wsdl&" + "style=" + style + "&mode=sap_wsdl";
            }
            return endpoint.getServiceEndpointId() + "/bindings?wsdl&" + "style=" + style + "&mode=sap_wsdl";
        }
        if (serverAddress != null) {
            return ServiceGenerator.generateHTTPLocationAttrValue(serverAddress, endpoint, null, false) + "/bindings?wsdl&" + "style=" + style;
        }
        return endpoint.getServiceEndpointId() + "/bindings?wsdl&" + "style=" + style;
    }

    private static String getStandAloneBindingImportLocation(ServiceEndpointDefinition endpoint, String style, boolean isSapWSDL) {
        if (isSapWSDL) {
            return "./bindings/" + endpoint.getConfigurationName() + "_" + style + "_sap.wsdl";
        }
        return "./bindings/" + endpoint.getConfigurationName() + "_" + style + ".wsdl";
    }

    private static String getTargetNamespace(ServiceEndpointDefinition endpoint, String style) {
        return "urn:" + endpoint.getOwner().getWsdName() + "/" + endpoint.getConfigurationName() + "/" + style;
    }

    private static Element getOutsideInWSDL(WSRuntimeDefinition wsDefinition, String hostAddress, String file) throws Exception {
        Element tmpAddEl;
        Element wsdlDefin;
        File wsdlFile;
        String outSideInWsdlPath = wsDefinition.getWsDirsHandler().getOutsideInWsdlPath(wsDefinition.getOutsideInDefinition().getWsdlRelPath());
        if (file == null) {
            wsdlFile = new File(outSideInWsdlPath);
        } else {
            File wsdlDir = new File(outSideInWsdlPath).getParentFile();
            wsdlFile = new File(wsdlDir, file);
        }
        ServiceEndpointDefinition[] endPoints = wsDefinition.getServiceEndpointDefinitions();
        if (endPoints.length == 0) {
            throw new Exception("No endpoints are found for webservice: " + wsDefinition.getWsQName());
        }
        String style = endPoints[0].getOutsideInConfiguration().getStyle().trim();
        DocumentBuilderFactoryImpl documentBuilderFactoryImpl = documentFactory;
        synchronized (documentBuilderFactoryImpl) {
            wsdlDefin = documentFactory.newDocumentBuilder().parse(wsdlFile).getDocumentElement();
        }
        NodeList nList = wsdlDefin.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", SOAP_ADDRESS_TAG);
        int i = 0;
        while (i < nList.getLength()) {
            tmpAddEl = (Element)nList.item(i);
            tmpAddEl.setAttribute("location", ServiceGenerator.generateHTTPLocationAttrValue(hostAddress, endPoints[0], style, true));
            ++i;
        }
        if (hostAddress.endsWith("/")) {
            hostAddress = hostAddress.substring(0, hostAddress.length() - 1);
        }
        nList = wsdlDefin.getElementsByTagNameNS("*", IMPORT_TAG);
        String uriPref = hostAddress + endPoints[0].getServiceEndpointId() + "?wsdl&file=";
        int i2 = 0;
        while (i2 < nList.getLength()) {
            tmpAddEl = (Element)nList.item(i2);
            String locValue = tmpAddEl.getAttribute("location");
            if (locValue.length() > 0) {
                tmpAddEl.setAttribute("location", uriPref + locValue);
            }
            if ((locValue = tmpAddEl.getAttribute("schemaLocation")).length() > 0) {
                tmpAddEl.setAttribute("schemaLocation", uriPref + locValue);
            }
            ++i2;
        }
        return wsdlDefin;
    }

    public static Object generateSOAPHTTPServiceDefinitions(String serviceName, String hostAddress, WSRuntimeDefinition wsDefinition, String style, boolean isSapWSDL, String file) throws Exception {
        WSDLDefinitions def;
        if (wsDefinition.hasOutsideInDefinition()) {
            return ServiceGenerator.getOutsideInWSDL(wsDefinition, hostAddress, file);
        }
        HashMapObjectObject hashTable = (HashMapObjectObject)hashTablePool.getInstance();
        if (hashTable == null) {
            hashTable = new HashMapObjectObject();
        }
        try {
            ServiceEndpointDefinition[] endPoints = wsDefinition.getServiceEndpointDefinitions();
            int i = 0;
            while (i < endPoints.length) {
                hashTable.put((Object)endPoints[i].getTransportBindingId(), (Object)WSContainer.getComponentFactory().getTransportBindingInstance(endPoints[i].getTransportBindingId()));
                ++i;
            }
            def = ServiceGenerator.generateSOAPHTTPServiceDefinitionsInternal(serviceName, hostAddress, wsDefinition, style, isSapWSDL, hashTable, false, false, null);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            hashTable.clear();
            hashTablePool.rollBackInstance(hashTable);
            throw throwable;
        }
        hashTable.clear();
        hashTablePool.rollBackInstance(hashTable);
        return def;
    }

    private static void saveOutsideInWSDLsInDirectory(String hostAddress, WSRuntimeDefinition wsDefinition, File resultDirectory) throws Exception {
        ServiceEndpointDefinition[] endPoints = wsDefinition.getServiceEndpointDefinitions();
        if (endPoints.length == 0) {
            throw new Exception("No endpoints are found for webservice: " + wsDefinition.getWsQName());
        }
        String style = endPoints[0].getOutsideInConfiguration().getStyle().trim();
        File wsdlDir = new File(wsDefinition.getWsDirsHandler().getOutsideInWsdlPath(wsDefinition.getOutsideInDefinition().getWsdlRelPath())).getParentFile();
        File[] wsdlFiles = wsdlDir.listFiles();
        int i = 0;
        while (i < wsdlFiles.length) {
            Object var19_18;
            Element wsdlDefin;
            File sWsdlFile = wsdlFiles[i];
            DocumentBuilderFactoryImpl documentBuilderFactoryImpl = documentFactory;
            synchronized (documentBuilderFactoryImpl) {
                wsdlDefin = documentFactory.newDocumentBuilder().parse(sWsdlFile).getDocumentElement();
            }
            NodeList nList = wsdlDefin.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", SOAP_ADDRESS_TAG);
            int j = 0;
            while (j < nList.getLength()) {
                Element tmpAddEl = (Element)nList.item(j);
                tmpAddEl.setAttribute("location", ServiceGenerator.generateHTTPLocationAttrValue(hostAddress, endPoints[0], style, true));
                ++j;
            }
            File dWsdlFile = sWsdlFile.getName().equals(ROOT_WSDL_FILE) ? new File(resultDirectory, MAIN_WSDL_FILE) : new File(resultDirectory, sWsdlFile.getName());
            FileOutputStream outputFile = new FileOutputStream(dWsdlFile);
            try {
                DOMSerializer dOMSerializer = domSerializer;
                synchronized (dOMSerializer) {
                    domSerializer.write((Node)wsdlDefin, (OutputStream)outputFile);
                }
                var19_18 = null;
            }
            catch (Throwable throwable) {
                var19_18 = null;
                outputFile.close();
                throw throwable;
            }
            outputFile.close();
            ++i;
        }
    }

    public static void saveAllWSDLsInDirectory(String serviceName, String hostAddress, WSRuntimeDefinition wsDefinition, String style, boolean isSapWSDL, File resultDirectory) throws Exception {
        WSDLDefinitions def;
        if (wsDefinition.hasOutsideInDefinition()) {
            ServiceGenerator.saveOutsideInWSDLsInDirectory(hostAddress, wsDefinition, resultDirectory);
            return;
        }
        HashMapObjectObject hashTable = (HashMapObjectObject)hashTablePool.getInstance();
        if (hashTable == null) {
            hashTable = new HashMapObjectObject();
        }
        resultDirectory.mkdirs();
        try {
            ServiceEndpointDefinition[] endPoints = wsDefinition.getServiceEndpointDefinitions();
            int i = 0;
            while (i < endPoints.length) {
                hashTable.put((Object)endPoints[i].getTransportBindingId(), (Object)WSContainer.getComponentFactory().getTransportBindingInstance(endPoints[i].getTransportBindingId()));
                ++i;
            }
            def = ServiceGenerator.generateSOAPHTTPServiceDefinitionsInternal(serviceName, hostAddress, wsDefinition, style, isSapWSDL, hashTable, true, true, resultDirectory.getAbsolutePath());
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            hashTable.clear();
            hashTablePool.rollBackInstance(hashTable);
            throw throwable;
        }
        hashTable.clear();
        hashTablePool.rollBackInstance(hashTable);
        File result = new File(resultDirectory, MAIN_WSDL_FILE);
        WSDLDefinitionsParser wSDLDefinitionsParser = wsdlDefinitionsParser;
        synchronized (wSDLDefinitionsParser) {
            wsdlDefinitionsParser.parseDefinitionsToFile(def, result);
            wsdlDefinitionsParser.init();
        }
    }

    public static WSDLDefinitions generateSOAPHTTPServiceDefinitionsInternal(String serviceName, String hostAddress, WSRuntimeDefinition wsDefinition, String style, boolean isSapWSDL, HashMapObjectObject hashTable, boolean standAlone, boolean isOnserver, String destDir) throws Exception {
        String wsdDoc;
        WSDLDefinitions def = new WSDLDefinitions();
        def.setName(wsDefinition.getWsdName());
        def.targetNamespace = "urn:" + wsDefinition.getWsdName();
        CharArray documentation = new CharArray();
        if (isSapWSDL) {
            documentation.append("<sap:SAP_WSDL xmlns:sap=\"http://www.sap.com/webas\" >");
        }
        if ((wsdDoc = ServiceGenerator.getWSDDocumentation(wsDefinition.getWsDirsHandler().getDocPath(wsDefinition.getDocumentationRelPath()))) != null && wsdDoc.length() > 0) {
            documentation.append(wsdDoc);
        }
        if (isSapWSDL) {
            documentation.append("</sap:SAP_WSDL>");
        }
        if (documentation.length() > 0) {
            WSDLDocumentation wsdlDocEl = new WSDLDocumentation();
            wsdlDocEl.setContent(documentation);
            def.setDocumentation(wsdlDocEl);
        }
        ArrayList<WSDLImport> imports = new ArrayList<WSDLImport>();
        ServiceEndpointDefinition[] endPoints = wsDefinition.getServiceEndpointDefinitions();
        WSDLService service = new WSDLService();
        service.setName(serviceName);
        int bindingPrefixes = 0;
        int sE = 0;
        while (sE < endPoints.length) {
            String tbPrefix;
            String btargetNamespace;
            ServiceEndpointDefinition cur = endPoints[sE];
            String serverAddress = cur.getTargetServerURL();
            if (serverAddress == null || serverAddress.trim().length() == 0) {
                serverAddress = hostAddress;
            }
            RuntimeTransportBinding transportBinding = (RuntimeTransportBinding)hashTable.get((Object)cur.getTransportBindingId());
            String[] endPointStyles = transportBinding.getSupportedSyles();
            int[] portTypeCodes = transportBinding.getNecessaryPortTypes();
            int st = 0;
            if (style == null || style.equals("")) {
                st = endPointStyles.length;
            } else {
                st = 0;
                while (st < endPointStyles.length) {
                    if (style.equals(endPointStyles[st])) {
                        btargetNamespace = ServiceGenerator.getTargetNamespace(cur, style);
                        tbPrefix = BINDING_NS_PREFIX + bindingPrefixes++;
                        if (standAlone) {
                            if (isOnserver) {
                                File f = new File(wsDefinition.getWsDirsHandler().getWsdlDir());
                                File base = new File(f, "alone");
                                File source = new File(base, ServiceGenerator.getStandAloneBindingImportLocation(cur, style, isSapWSDL));
                                File destination = new File(destDir, ServiceGenerator.getStandAloneBindingImportLocation(cur, style, isSapWSDL));
                                ServiceGenerator.copy(source, destination);
                                ServiceGenerator.copyRefPortTypes(base, destDir, cur, portTypeCodes[st], isSapWSDL);
                                imports.add(new WSDLImport(null, ServiceGenerator.getStandAloneBindingImportLocation(cur, style, isSapWSDL), btargetNamespace));
                            } else {
                                imports.add(new WSDLImport(null, ServiceGenerator.getStandAloneBindingImportLocation(cur, style, isSapWSDL), btargetNamespace));
                            }
                        } else {
                            imports.add(new WSDLImport(null, ServiceGenerator.getBindingImportLocation(serverAddress, cur, style, isSapWSDL), btargetNamespace));
                        }
                        def.addAdditionalAttribute("xmlns:" + tbPrefix, btargetNamespace);
                        service.addPort(ServiceGenerator.generatePort(cur.getServiceEndpointQualifiedName().getLocalPart(), serverAddress, style, tbPrefix, cur, transportBinding));
                        break;
                    }
                    ++st;
                }
            }
            if (st == endPointStyles.length) {
                endPointStyles = transportBinding.getDefaultStyles();
                portTypeCodes = ServiceGenerator.getPortTypeCodes(transportBinding, endPointStyles);
                int i = 0;
                while (i < endPointStyles.length) {
                    btargetNamespace = ServiceGenerator.getTargetNamespace(cur, endPointStyles[i]);
                    tbPrefix = BINDING_NS_PREFIX + bindingPrefixes++;
                    if (standAlone) {
                        if (isOnserver) {
                            File f = new File(wsDefinition.getWsDirsHandler().getWsdlDir());
                            File base = new File(f, "alone");
                            File source = new File(base, ServiceGenerator.getStandAloneBindingImportLocation(cur, endPointStyles[i], isSapWSDL));
                            File destination = new File(destDir, ServiceGenerator.getStandAloneBindingImportLocation(cur, endPointStyles[i], isSapWSDL));
                            ServiceGenerator.copy(source, destination);
                            ServiceGenerator.copyRefPortTypes(base, destDir, cur, portTypeCodes[i], isSapWSDL);
                            imports.add(new WSDLImport(null, ServiceGenerator.getStandAloneBindingImportLocation(cur, endPointStyles[i], isSapWSDL), btargetNamespace));
                        } else {
                            imports.add(new WSDLImport(null, ServiceGenerator.getStandAloneBindingImportLocation(cur, endPointStyles[i], isSapWSDL), btargetNamespace));
                        }
                    } else {
                        imports.add(new WSDLImport(null, ServiceGenerator.getBindingImportLocation(serverAddress, cur, endPointStyles[i], isSapWSDL), btargetNamespace));
                    }
                    def.addAdditionalAttribute("xmlns:" + tbPrefix, btargetNamespace);
                    service.addPort(ServiceGenerator.generatePort(cur.getServiceEndpointQualifiedName().getLocalPart(), serverAddress, endPointStyles[i], tbPrefix, cur, transportBinding));
                    ++i;
                }
            }
            ++sE;
        }
        def.setImportDeclaratuions(imports);
        def.addService(service);
        return def;
    }

    private static WSDLPort generatePort(String portName, String hostAddress, String style, String bindingNSPrefix, ServiceEndpointDefinition endpoint, RuntimeTransportBinding transportBinding) {
        WSDLPort port = new WSDLPort();
        port.setName(portName + "_" + ServiceGenerator.getUpperLetteredString(style));
        port.setBinding(new QName(bindingNSPrefix, endpoint.getWsdlBindingName().getLocalPart(), null));
        WSDLExtension ext = new WSDLExtension();
        ext.setLocalName(SOAP_ADDRESS_TAG);
        if (transportBinding instanceof HTTPTransportBinding) {
            ext.setURI(WSDL_HTTP_NS);
        } else {
            ext.setURI("http://schemas.xmlsoap.org/wsdl/soap/");
        }
        ext.setAttribute("location", ServiceGenerator.generateHTTPLocationAttrValue(hostAddress, endpoint, style, true), "");
        port.setExtension(ext);
        return port;
    }

    public static String generateHTTPLocationAttrValue(String hostAddress, ServiceEndpointDefinition def, String style, boolean isEndpoint) {
        String endpointUri;
        if (hostAddress.endsWith("/")) {
            hostAddress = hostAddress.substring(0, hostAddress.length() - 1);
        }
        if (isEndpoint) {
            Iterator itr = def.getProtocolIDFeatureMappings().values().iterator();
            boolean foundHttps = false;
            block0: while (!foundHttps && itr.hasNext()) {
                Feature[] tmp = (Feature[])itr.next();
                if (tmp == null) continue;
                int i = 0;
                while (i < tmp.length) {
                    if (tmp[i].getFeatureName().equals(TRANSPORTGUARANTEE_FEATURE)) {
                        foundHttps = true;
                        Config cfg = tmp[i].getConfiguration();
                        if (cfg != null && cfg.getProperty(SSL_PROPERTY) != null && cfg.getProperty(SSL_PROPERTY).getValue().equals(SSL_VALUE)) {
                            Object[] disNodeInfo = ServiceGenerator.getSSLDispatcher();
                            if (disNodeInfo != null) {
                                String host = ((InetAddress)disNodeInfo[0]).getHostAddress();
                                hostAddress = "https://" + host + ":" + disNodeInfo[1];
                                continue block0;
                            }
                            int ind = hostAddress.lastIndexOf(":");
                            String host = hostAddress.substring(hostAddress.indexOf("://") + 3);
                            int port = 443;
                            if (ind != -1) {
                                host = hostAddress.substring(hostAddress.indexOf("://") + 3, ind);
                                port = Integer.parseInt(hostAddress.substring(ind + 1)) + 1;
                            } else {
                                host = hostAddress.substring(hostAddress.indexOf("://"));
                            }
                            hostAddress = "https://" + host + ":" + port;
                            continue block0;
                        }
                    }
                    ++i;
                }
            }
        }
        if ((endpointUri = def.getServiceEndpointId()).startsWith("/")) {
            endpointUri = endpointUri.substring(1, endpointUri.length());
        }
        if (style == null) {
            return hostAddress + "/" + endpointUri;
        }
        if (style.equals("http")) {
            return hostAddress + "/" + endpointUri;
        }
        return hostAddress + "/" + endpointUri + "?style=" + style;
    }

    private static String getWSDDocumentation(String docPath) throws Exception {
        String doc;
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(docPath);
        }
        catch (FileNotFoundException fnfE) {
            return null;
        }
        SAXParser sAXParser = saxParser;
        synchronized (sAXParser) {
            try {
                saxParser.parse((InputStream)inputStream, (DefaultHandler)wsdDocumHandler);
                doc = wsdDocumHandler.getDocumentation();
                wsdDocumHandler.clear();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }
        return doc;
    }

    public static String getUpperLetteredString(String s) {
        char c = Character.toUpperCase(s.charAt(0));
        c = Character.toUpperCase(c);
        if (s.length() > 1) {
            return c + s.substring(1);
        }
        return new String(new char[]{c});
    }

    private static String getPortTypeOutputFilePath(String outDir, String viName, String confName, String style, boolean sapMode) {
        if (sapMode) {
            return outDir + "/porttypes/" + confName + "_" + viName + "_" + style + "_sap.wsdl";
        }
        return outDir + "/porttypes/" + confName + "_" + viName + "_" + style + ".wsdl";
    }

    /*
     * WARNING - void declaration
     */
    private static void copy(File source, File destination) throws Exception {
        destination.getParentFile().mkdirs();
        FileInputStream input = new FileInputStream(source);
        FileOutputStream output = new FileOutputStream(destination);
        byte[] arr = new byte[128];
        try {
            int b;
            while ((b = input.read(arr)) != -1) {
                void var5_5;
                output.write(arr, 0, (int)var5_5);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            input.close();
            output.close();
            throw throwable;
        }
        input.close();
        output.close();
    }

    private static void copyRefPortTypes(File baseDir, String destDir, ServiceEndpointDefinition endPoint, int prCode, boolean sapMode) throws Exception {
        File destination;
        File source;
        String style;
        String viName = endPoint.getvInterfaceName();
        if ((prCode & 2) == 2) {
            style = PortTypeDescriptorImpl.getPortTypeType(2);
            source = new File(ServiceGenerator.getPortTypeOutputFilePath(baseDir.getAbsolutePath(), viName, endPoint.getConfigurationName(), style, sapMode));
            destination = new File(ServiceGenerator.getPortTypeOutputFilePath(destDir, viName, endPoint.getConfigurationName(), style, sapMode));
            ServiceGenerator.copy(source, destination);
        }
        if ((prCode & 1) == 1) {
            style = PortTypeDescriptorImpl.getPortTypeType(1);
            source = new File(ServiceGenerator.getPortTypeOutputFilePath(baseDir.getAbsolutePath(), viName, endPoint.getConfigurationName(), style, sapMode));
            destination = new File(ServiceGenerator.getPortTypeOutputFilePath(destDir, viName, endPoint.getConfigurationName(), style, sapMode));
            ServiceGenerator.copy(source, destination);
        }
        if ((prCode & 4) == 4) {
            style = PortTypeDescriptorImpl.getPortTypeType(4);
            source = new File(ServiceGenerator.getPortTypeOutputFilePath(baseDir.getAbsolutePath(), viName, endPoint.getConfigurationName(), style, sapMode));
            destination = new File(ServiceGenerator.getPortTypeOutputFilePath(destDir, viName, endPoint.getConfigurationName(), style, sapMode));
            ServiceGenerator.copy(source, destination);
        }
        if ((prCode & 8) == 8) {
            style = PortTypeDescriptorImpl.getPortTypeType(8);
            source = new File(ServiceGenerator.getPortTypeOutputFilePath(baseDir.getAbsolutePath(), viName, endPoint.getConfigurationName(), style, sapMode));
            destination = new File(ServiceGenerator.getPortTypeOutputFilePath(destDir, viName, endPoint.getConfigurationName(), style, sapMode));
            ServiceGenerator.copy(source, destination);
        }
    }

    private static int[] getPortTypeCodes(RuntimeTransportBinding trb, String[] defStyles) throws Exception {
        int[] res = new int[defStyles.length];
        String[] styles = trb.getSupportedSyles();
        int[] portTypeCodes = trb.getNecessaryPortTypes();
        int nom = 0;
        int i = 0;
        while (i < styles.length) {
            int j = 0;
            while (j < defStyles.length) {
                if (styles[i].equals(defStyles[j])) {
                    res[nom++] = portTypeCodes[i];
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private static Object[] getSSLDispatcher() {
        MessageContext msgCtx = WSContainer.getServiceContext().getClusterContext().getMessageContext();
        int[] dispatcherIDs = WSContainer.getDispatcherIDs();
        int sslPort = -1;
        int i = 0;
        while (i < dispatcherIDs.length) {
            block7: {
                int dispatcherID = dispatcherIDs[i];
                ClusterElement clusterEl = WSContainer.getServiceContext().getClusterContext().getClusterMonitor().getParticipant(dispatcherID);
                if (clusterEl != null) {
                    try {
                        MessageAnswer msgAnswer = msgCtx.sendAndWaitForAnswer(dispatcherID, 2, new byte[0], 0, 0, 0L);
                        if (msgAnswer.getLength() == 0) break block7;
                        ByteArrayInputStream in = new ByteArrayInputStream(msgAnswer.getMessage(), msgAnswer.getOffset(), msgAnswer.getLength());
                        DataInputStream dataStream = new DataInputStream(in);
                        try {
                            sslPort = dataStream.readInt();
                            if (sslPort != -1) {
                                Object[] res = new Object[]{clusterEl.getAddress(), new Integer(sslPort)};
                                return res;
                            }
                        }
                        catch (IOException ioe) {
                            Location.getLocation((String)WSLogging.SERVER_LOCATION).catching("An error occured while parsing getSSLPort response: " + dispatcherIDs[i], (Throwable)ioe);
                        }
                    }
                    catch (ClusterException ce) {
                        Location.getLocation((String)WSLogging.SERVER_LOCATION).catching("An error occured while sending getSSLPort message to dispatcher: " + dispatcherIDs[i], (Throwable)ce);
                    }
                }
            }
            ++i;
        }
        return null;
    }

    static {
        try {
            saxParser = new SAXParserFactoryImpl().newSAXParser();
            documentFactory = new DocumentBuilderFactoryImpl();
            documentFactory.setNamespaceAware(true);
        }
        catch (Exception e) {
            Location.getLocation((String)WSLogging.SERVER_LOCATION).catching((Throwable)e);
        }
        wsdDocumHandler = new DocumentationHandler();
    }
}

