/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.services.webservices.runtime.wsdl.SchemaConvertor;
import com.sap.engine.services.webservices.runtime.wsdl.StandardTypes;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLCreationException;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TableState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceTypes;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SchemaInfo {
    private static final String URI_PREFIX = "urn:";
    private static final String PREFIX_BASE = "s";
    private static final String EMPTYNAMESPACE = "";
    private static DocumentBuilderFactory factory = new DocumentBuilderFactoryImpl();
    private Element schemaElement;
    private int prefixNom = 0;
    Hashtable imports;
    Hashtable originalImports = new Hashtable();
    String targetNamespace;
    boolean isVisited = false;

    SchemaInfo(String targetNamespace, boolean isQualified) throws WSDLException {
        try {
            this.targetNamespace = targetNamespace;
            this.imports = new Hashtable();
            Document doc = factory.newDocumentBuilder().newDocument();
            this.schemaElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
            this.schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            this.schemaElement.setAttributeNS(EMPTYNAMESPACE, "targetNamespace", targetNamespace);
            this.schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tns", targetNamespace);
            if (isQualified) {
                this.schemaElement.setAttributeNS(EMPTYNAMESPACE, "elementFormDefault", "qualified");
            }
            this.imports.put(targetNamespace, "tns");
            this.imports.put("http://www.w3.org/2001/XMLSchema", "xs");
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException((Exception)e);
        }
    }

    SchemaInfo(Element schemaElement) throws WSDLCreationException {
        if (!schemaElement.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || !schemaElement.getLocalName().equals("schema")) {
            throw new WSDLCreationException("webservices_2020", new Object[]{schemaElement.getNamespaceURI(), schemaElement.getLocalName()});
        }
        this.imports = new Hashtable();
        this.schemaElement = schemaElement;
        this.targetNamespace = schemaElement.getAttribute("xmlns:tns");
        NamedNodeMap list = schemaElement.getAttributes();
        int i = 0;
        while (i < list.getLength()) {
            Attr attr = (Attr)list.item(i);
            if (attr.getName().startsWith("xmlns")) {
                this.originalImports.put(attr.getValue(), attr.getName().substring("xmlns".length() + 1));
                ++this.prefixNom;
            }
            ++i;
        }
        this.imports.put(this.targetNamespace, "tns");
        this.imports.put("http://www.w3.org/2001/XMLSchema", "xs");
    }

    public static ArrayList resolveSchemas(Hashtable schemaInfos) throws WSDLCreationException {
        Iterator itr = schemaInfos.values().iterator();
        ArrayList resoved = new ArrayList();
        int totalNom = 0;
        while (itr.hasNext()) {
            SchemaInfo.resolveSchema((SchemaInfo)itr.next(), resoved, schemaInfos);
            ++totalNom;
        }
        if (resoved.size() != totalNom) {
            throw new WSDLCreationException("webservices_2019");
        }
        return resoved;
    }

    private static void resolveSchema(SchemaInfo schema, ArrayList resolved, Hashtable schemas) throws WSDLCreationException {
        if (resolved.contains(schema)) {
            return;
        }
        schema.isVisited = true;
        Enumeration enumeration = schema.imports.keys();
        while (enumeration.hasMoreElements()) {
            String keyNS = (String)enumeration.nextElement();
            if (keyNS.equals(schema.targetNamespace) || keyNS.equals("http://www.w3.org/2001/XMLSchema")) continue;
            SchemaInfo importedSchema = (SchemaInfo)schemas.get(keyNS);
            if (importedSchema == null) {
                throw new WSDLCreationException("webservices_2019", new Object[]{keyNS, schema.targetNamespace});
            }
            if (resolved.contains(importedSchema)) continue;
            if (importedSchema.isVisited) {
                resolved.add(schema);
            }
            SchemaInfo.resolveSchema(importedSchema, resolved, schemas);
        }
        if (((AbstractCollection)resolved).remove(schema)) {
            SchemaInfo.resolveSchema(schema, resolved, schemas);
        } else {
            resolved.add(schema);
        }
    }

    static String getUriFromTypeState(TypeState typeState, VirtualInterfaceTypes.Choice[] allTypes, String suffix) throws Exception {
        String nsValue;
        if (StandardTypes.isJavaUtilType(SchemaConvertor.getOriginalType(typeState))) {
            return "java:sap/standard";
        }
        if (typeState instanceof TableState) {
            typeState = SchemaInfo.getArrayComponent((TableState)typeState, allTypes);
        }
        if (typeState.hasTypeSoapExtensionType() && typeState.getTypeSoapExtensionType().getSoapExtensionType().hasNamespace() && (nsValue = typeState.getTypeSoapExtensionType().getSoapExtensionType().getNamespace()).length() > 0) {
            return nsValue;
        }
        return SchemaInfo.getUriFromClassName(SchemaConvertor.getOriginalType(typeState), suffix);
    }

    static String getUriFromClassName(String name, String suffix) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return URI_PREFIX + name;
        }
        String packg = name.substring(0, i);
        return URI_PREFIX + packg.replace('.', '/');
    }

    String getPrefixForTypeState(TypeState typeState, VirtualInterfaceTypes.Choice[] allTypes, String suffix) throws Exception {
        String uri = SchemaInfo.getUriFromTypeState(typeState, allTypes, suffix);
        return this.getPrefixForUri(uri);
    }

    String getPrefixForUri(String uri) {
        String prefix = (String)this.originalImports.get(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = (String)this.imports.get(uri);
        if (prefix == null) {
            prefix = PREFIX_BASE + this.prefixNom++;
            this.imports.put(uri, prefix);
        }
        return prefix;
    }

    String getTargetNamespace() {
        return this.targetNamespace;
    }

    Element getSchemaElement() {
        return this.schemaElement;
    }

    Element normalizeSchema() {
        this.imports.remove(this.targetNamespace);
        this.imports.remove("http://www.w3.org/2001/XMLSchema");
        Enumeration uries = this.imports.keys();
        Node firstChild = this.schemaElement.getFirstChild();
        while (uries.hasMoreElements()) {
            String tempUri = (String)uries.nextElement();
            String tempPrefix = (String)this.imports.get(tempUri);
            this.schemaElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + tempPrefix, tempUri);
            if (tempUri == EMPTYNAMESPACE) continue;
            Element importElement = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:import");
            importElement.setAttributeNS(EMPTYNAMESPACE, "namespace", tempUri);
            this.schemaElement.insertBefore(importElement, firstChild);
        }
        return this.schemaElement;
    }

    static TypeState getArrayComponent(TableState table, VirtualInterfaceTypes.Choice[] allTypes) throws Exception {
        String directTypeName = table.getTableLineType().getComplexTypeReference().getName().trim();
        TypeState tempState = SchemaConvertor.findTypeStateByOriginalName(directTypeName, allTypes);
        if (tempState instanceof TableState) {
            return SchemaInfo.getArrayComponent((TableState)tempState, allTypes);
        }
        return tempState;
    }

    static {
        factory.setNamespaceAware(true);
    }
}

