/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.services.webservices.runtime.wsdl.ArrayStruct;
import com.sap.engine.services.webservices.runtime.wsdl.DataField;
import com.sap.engine.services.webservices.runtime.wsdl.DataFieldList;
import com.sap.engine.services.webservices.runtime.wsdl.NameMappingRegistry;
import com.sap.engine.services.webservices.runtime.wsdl.SchemaInfo;
import com.sap.engine.services.webservices.runtime.wsdl.StandardTypes;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLCreationException;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ComplexTypeReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ConvertedTypeReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ElementaryState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.FaultState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.FieldState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.FieldTypeReference;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.FunctionState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.InlinePrimitiveTableReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ParameterMappedTypeReference;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ParameterState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.SoapExtensionTypeState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.StructureState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TableState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeOriginal;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeSoapExtensionType;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;

public class SchemaConvertor {
    public static final String SCHEMA_PREFIX = "xs:";
    public static final String SOAPENC_PREFIX = "soapenc:";
    public static final String TNS_STANDALONE = "tns";
    public static final String TNS_PREFIX = "tns:";
    public static final String ARRAY_PREFIX = "ArrayOf";
    public static final String ARRAY_DIMENTION_POSTFIX = "_";
    public static final String LITERAL_NS_SUFFIX = "literal";
    public static final String ENCODED_NS_SUFFIX = "encoded";
    public static final String SCHEMA_COMPLEXTYPE = "xs:complexType";
    public static final String SCHEMA_COMPLEXCONTENT = "xs:complexContent";
    public static final String SCHEMA_RESTRICTION = "xs:restriction";
    public static final String SCHEMA_ATTRIBUTE = "xs:attribute";
    public static final String SCHEMA_ALL = "xs:all";
    public static final String SCHEMA_ELEMENT = "xs:element";
    public static final String SCHEMA_EXTENSION = "xs:extension";
    public static final String SCHEMA_SEQUENCE = "xs:sequence";
    public static final String SCHEMA_ANY_ELEMENT = "any";
    public static final String SCHEMA_PROCESSCONTENTS = "processContents";
    public static final String SCHEMA_NAMESPACE = "namespace";
    public static final String SCHEMA_NAME = "name";
    public static final String SCHEMA_REF = "ref";
    public static final String SCHEMA_BASE = "base";
    public static final String SCHEMA_TYPE = "type";
    public static final String SCHEMA_NILLABLE = "nillable";
    public static final String SCHEMA_MAXOCCURS = "maxOccurs";
    public static final String SCHEMA_MINOCCURS = "minOccurs";
    public static final String SCHEMA_UNBOUNDED = "unbounded";
    public static final String SCHEMA_USE = "use";
    public static final String SCHEMA_USE_REQUIRED = "required";
    public static final String SCHEMA_USE_OPTIONAL = "optional";
    public static final String SCHEMA_ANYTYPE = "anyType";
    public static final String SOAPENC_ARRAY_TYPE = "soapenc:arrayType";
    public static final String SOAPENC_ARRAY = "soapenc:Array";
    public static final String WSDL_ARRAY_TYPE = "wsdl:arrayType";
    public static final String DEFAULT_ITEM_VALUE = "item";
    public static final String DEFAULT_NAMESPACE = "java.lang.xxx";
    public static final String SIMPLE_CONTENT = "simpleContent";
    public static final String _ANY_FEATURE = "_any";
    static final String JAVA_UTIL_SCHEMA_NAMESPACE = "java:sap/standard";
    private Element schemaElement;
    private ArrayList alreadyGenerated;
    private HashMap nameMapping;
    private Hashtable schemas = new Hashtable();
    private VirtualInterfaceTypes.Choice[] allTypes;
    private ArrayList arrayTypes = new ArrayList();
    private SchemaInfo currentSchema;
    private boolean isLiteralArrayRepresentation = false;
    private boolean isElFormDfQualified = true;
    private String currentSuffix = "encoded";
    private StructureState thrState;
    boolean isSerUsed;
    boolean isThrOrExcUsed;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$String;

    public SchemaConvertor() {
        this(new NameMappingRegistry());
    }

    public SchemaConvertor(NameMappingRegistry nameMappingGegistry) {
        this.alreadyGenerated = new ArrayList();
        this.nameMapping = new HashMap();
    }

    public HashMap getJavaToQNameMappings() {
        return (HashMap)this.nameMapping.clone();
    }

    private Element parseTypeState(TypeState typeState, boolean exclude) throws Exception {
        String originalType = SchemaConvertor.getOriginalType(typeState);
        if (this.alreadyGenerated.contains(originalType)) {
            return null;
        }
        if (StandardTypes.isStandardType(originalType)) {
            return null;
        }
        if (typeState instanceof TableState) {
            this.arrayTypes.add(new ArrayStruct((TableState)typeState, this.allTypes));
            return null;
        }
        if (originalType.equals((class$java$lang$Object == null ? (class$java$lang$Object = SchemaConvertor.class$("java.lang.Object")) : class$java$lang$Object).getName()) || exclude && originalType.equals((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName())) {
            return null;
        }
        if (exclude && originalType.equals((class$java$io$Serializable == null ? (class$java$io$Serializable = SchemaConvertor.class$("java.io.Serializable")) : class$java$io$Serializable).getName()) && !this.isSerUsed) {
            return null;
        }
        if (exclude && originalType.equals((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaConvertor.class$("java.lang.Exception")) : class$java$lang$Exception).getName()) && !this.isThrOrExcUsed) {
            return null;
        }
        this.alreadyGenerated.add(originalType);
        if (StandardTypes.isJavaUtilType(originalType)) {
            this.appendJavaUtilComplexType(originalType);
            this.nameMapping.put(originalType, new QName(JAVA_UTIL_SCHEMA_NAMESPACE, originalType.substring(originalType.lastIndexOf(".") + 1)));
            return null;
        }
        DataFieldList list = this.obtainDataFieldList(typeState);
        this.parseStructure(list);
        int i = 0;
        while (i < list.size()) {
            if (list.item(i).getTypeState() != null) {
                this.parseTypeState(list.item(i).getTypeState(), exclude);
            }
            ++i;
        }
        return this.schemaElement;
    }

    public DOMSource[] parseInEncodedMode(VirtualInterfaceState vInterface) throws Exception {
        if (vInterface.getVirtualInterfaceSoapExtensionVI() != null) {
            this.isElFormDfQualified = vInterface.getVirtualInterfaceSoapExtensionVI().getSoapExtensionVI().getUseNamespaces();
        }
        if (vInterface.getVirtualInterfaceTypes() != null) {
            this.allTypes = vInterface.getVirtualInterfaceTypes().getChoiceGroup();
            this.checkForSpecialUsage(vInterface.getVirtualInterfaceFunctions());
            int i = 0;
            while (i < this.allTypes.length) {
                this.parseTypeState(SchemaConvertor.extractTypeStateFromChoice(this.allTypes[i]), true);
                ++i;
            }
            if (this.isThrOrExcUsed) {
                this.parseTypeState(this.thrState, false);
            }
        }
        FunctionState[] functions = vInterface.getVirtualInterfaceFunctions();
        this.parseFunctions(functions);
        this.parseArrays();
        DOMSource[] schemas = this.createDomSourcesFromSchemas();
        this.schemas.clear();
        this.alreadyGenerated.clear();
        return schemas;
    }

    public DOMSource[] parseInEncodedMode(ArrayList typesList) throws Exception {
        DOMSource[] resultArray = new DOMSource[]{};
        int listSize = typesList.size();
        int i = 0;
        while (i < listSize) {
            DOMSource[] currentGenerated = this.parseInEncodedMode((VirtualInterfaceState)((Object)typesList.get(i)));
            DOMSource[] temp = new DOMSource[currentGenerated.length + resultArray.length];
            System.arraycopy(resultArray, 0, temp, 0, resultArray.length);
            System.arraycopy(currentGenerated, 0, temp, resultArray.length, currentGenerated.length);
            resultArray = temp;
            ++i;
        }
        return resultArray;
    }

    public DOMSource[] parseInLiteralMode(VirtualInterfaceState vi) throws Exception {
        this.isLiteralArrayRepresentation = true;
        this.currentSuffix = LITERAL_NS_SUFFIX;
        return this.parseInEncodedMode(vi);
    }

    public DOMSource[] parseInLiteralMode(ArrayList typesList) throws Exception {
        this.isLiteralArrayRepresentation = true;
        this.currentSuffix = LITERAL_NS_SUFFIX;
        return this.parseInEncodedMode(typesList);
    }

    public void clearState() {
        this.isLiteralArrayRepresentation = false;
        this.currentSuffix = ENCODED_NS_SUFFIX;
        this.allTypes = null;
        this.nameMapping.clear();
        this.schemas.clear();
        this.arrayTypes.clear();
        this.alreadyGenerated.clear();
    }

    private void parseStructure(DataFieldList list) throws Exception {
        Element temp;
        DataField tempField;
        if (list.isSimpleContent) {
            this.parserSimpleContent(list);
            return;
        }
        String schemaUri = SchemaInfo.getUriFromTypeState(list.getTypeState(), this.allTypes, this.currentSuffix);
        SchemaInfo tempSch = (SchemaInfo)this.schemas.get(schemaUri);
        if (tempSch == null) {
            tempSch = new SchemaInfo(schemaUri, this.isElFormDfQualified);
            this.schemas.put(schemaUri, tempSch);
        }
        this.schemaElement = tempSch.getSchemaElement();
        this.currentSchema = tempSch;
        Element complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
        String nameValue = SchemaConvertor.getComplexTypeName(list.getTypeState(), this.allTypes);
        complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
        this.nameMapping.put(SchemaConvertor.getOriginalType(list.getTypeState()), new QName(this.currentSchema.getTargetNamespace(), nameValue));
        Element seqOrAll = list.isUnordered ? this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ALL) : this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_SEQUENCE);
        TypeState listTState = list.getTypeState();
        if (this.hasParentForProcesing(listTState)) {
            String baseClassJavaName = listTState.getParentTypeName();
            TypeState baseTState = SchemaConvertor.findTypeStateByOriginalName(baseClassJavaName, this.allTypes);
            if (baseTState == null) {
                baseTState = this.getAdditionTypeState(baseClassJavaName);
            }
            if (baseTState == null || baseTState instanceof TableState) {
                throw new WSDLCreationException("webservices_2028", new Object[]{baseTState == null ? null : baseTState.getName(), listTState.getName(), baseClassJavaName});
            }
            String baseTypeUri = SchemaInfo.getUriFromTypeState(baseTState, this.allTypes, this.currentSuffix);
            String baseTypePref = tempSch.getPrefixForUri(baseTypeUri);
            String baseTypeCTName = SchemaConvertor.getComplexTypeName(baseTState, this.allTypes);
            Element complexContent = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXCONTENT);
            Element extensionBase = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_EXTENSION);
            extensionBase.setAttributeNS("", SCHEMA_BASE, baseTypePref + ":" + baseTypeCTName);
            complexContent.appendChild(extensionBase);
            extensionBase.appendChild(seqOrAll);
            complexType.appendChild(complexContent);
        } else {
            complexType.appendChild(seqOrAll);
        }
        int i = 0;
        while (i < list.size()) {
            tempField = list.item(i);
            if (!tempField.isAttribute) {
                if (tempField.getFieldName().equals(_ANY_FEATURE)) {
                    temp = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ANY_ELEMENT);
                    temp.setAttribute(SCHEMA_PROCESSCONTENTS, "lax");
                    temp.setAttribute(SCHEMA_NAMESPACE, "##other");
                    temp.setAttribute(SCHEMA_MINOCCURS, "0");
                    temp.setAttribute(SCHEMA_MAXOCCURS, SCHEMA_UNBOUNDED);
                } else {
                    temp = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ELEMENT);
                    temp.setAttributeNS("", SCHEMA_NAME, tempField.getFieldName());
                    if (this.setElementTypeAttributeValue(temp, tempField)) {
                        list.remove(i--);
                    }
                }
                seqOrAll.appendChild(temp);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < list.size()) {
            tempField = list.item(i2);
            if (tempField.isAttribute) {
                temp = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ATTRIBUTE);
                temp.setAttributeNS("", SCHEMA_NAME, tempField.getFieldName());
                this.setElementTypeAttributeValue(temp, tempField);
                list.remove(i2--);
                if (temp.hasAttribute(SCHEMA_NILLABLE)) {
                    temp.removeAttribute(SCHEMA_NILLABLE);
                }
                if (temp.hasAttribute(SCHEMA_MINOCCURS)) {
                    temp.removeAttribute(SCHEMA_MINOCCURS);
                }
                if (StandardTypes.isNillableStandardType(tempField.getVirtualTypeName())) {
                    temp.setAttributeNS("", SCHEMA_USE, SCHEMA_USE_OPTIONAL);
                } else {
                    temp.setAttributeNS("", SCHEMA_USE, SCHEMA_USE_REQUIRED);
                }
                seqOrAll.getParentNode().appendChild(temp);
            }
            ++i2;
        }
        this.schemaElement.appendChild(complexType);
    }

    private boolean hasParentForProcesing(TypeState typeState) throws Exception {
        if (SchemaConvertor.getOriginalType(typeState).equals((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaConvertor.class$("java.lang.Exception")) : class$java$lang$Exception).getName())) {
            typeState.setParentTypeName((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName());
            return true;
        }
        if (this.isThrOrExcUsed && SchemaConvertor.getOriginalType(typeState).equals((class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = SchemaConvertor.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException).getName())) {
            typeState.setParentTypeName((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaConvertor.class$("java.lang.Exception")) : class$java$lang$Exception).getName());
            return true;
        }
        if (typeState.hasParentTypeName()) {
            if (typeState.getParentTypeName().equals((class$java$lang$Object == null ? (class$java$lang$Object = SchemaConvertor.class$("java.lang.Object")) : class$java$lang$Object).getName())) {
                return false;
            }
            if (typeState.getParentTypeName().equals((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaConvertor.class$("java.lang.Exception")) : class$java$lang$Exception).getName()) && !this.isThrOrExcUsed) {
                return false;
            }
            return !typeState.getParentTypeName().equals((class$java$io$Serializable == null ? (class$java$io$Serializable = SchemaConvertor.class$("java.io.Serializable")) : class$java$io$Serializable).getName()) || this.isSerUsed;
        }
        return false;
    }

    private void parserSimpleContent(DataFieldList list) throws Exception {
        DataField tempField;
        String schemaUri = SchemaInfo.getUriFromTypeState(list.getTypeState(), this.allTypes, this.currentSuffix);
        SchemaInfo tempSch = (SchemaInfo)this.schemas.get(schemaUri);
        if (tempSch == null) {
            tempSch = new SchemaInfo(schemaUri, this.isElFormDfQualified);
            this.schemas.put(schemaUri, tempSch);
        }
        this.schemaElement = tempSch.getSchemaElement();
        this.currentSchema = tempSch;
        Element complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
        String nameValue = SchemaConvertor.getComplexTypeName(list.getTypeState(), this.allTypes);
        complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
        this.nameMapping.put(SchemaConvertor.getOriginalType(list.getTypeState()), new QName(this.currentSchema.getTargetNamespace(), nameValue));
        Element simpleContent = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "xs:simpleContent");
        Element extension = null;
        int i = 0;
        while (i < list.size()) {
            tempField = list.item(i);
            if (tempField.getFieldName().equals(SIMPLE_CONTENT)) {
                extension = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_EXTENSION);
                extension.setAttributeNS("", SCHEMA_BASE, StandardTypes.getMapType(tempField.getVirtualTypeName()));
                simpleContent.appendChild(extension);
                list.remove(i--);
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < list.size()) {
            tempField = list.item(i2);
            Element temp = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ATTRIBUTE);
            temp.setAttributeNS("", SCHEMA_NAME, tempField.getFieldName());
            temp.setAttributeNS("", SCHEMA_TYPE, StandardTypes.getMapType(tempField.getVirtualTypeName()));
            list.remove(i2--);
            extension.appendChild(temp);
            ++i2;
        }
        simpleContent.appendChild(extension);
        complexType.appendChild(simpleContent);
        this.schemaElement.appendChild(complexType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataFieldList obtainDataFieldList(TypeState typeState) throws Exception {
        FieldState[] fields;
        DataFieldList list = new DataFieldList(typeState);
        boolean put = true;
        if (typeState.hasParentTypeName() && !typeState.getParentTypeName().equals((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaConvertor.class$("java.lang.Exception")) : class$java$lang$Exception).getName())) {
            put = false;
        }
        if (put && !this.isThrOrExcUsed) {
            list.add(new DataField("message", "java.lang.String", "java.lang.String", null));
        }
        if (typeState instanceof ElementaryState) {
            return list;
        }
        if (!(typeState instanceof StructureState)) {
            throw new WSDLCreationException("webservices_2012", new Object[]{typeState});
        }
        StructureState structureState = (StructureState)typeState;
        if (structureState.getStructureSoapExtensionStructure() != null && structureState.getStructureSoapExtensionStructure().getSoapExtensionStructure().hasUnorderedFields()) {
            list.isUnordered = structureState.getStructureSoapExtensionStructure().getSoapExtensionStructure().getUnorderedFields();
        }
        if ((fields = structureState.getStructureFields()) == null) {
            fields = new FieldState[]{};
        }
        DataField df = null;
        boolean found = false;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getFieldName().equals(SIMPLE_CONTENT)) {
                if (found) {
                    throw new WSDLCreationException("webservices_2027", new Object[]{typeState.getName(), "more than one simpleContent"});
                }
                list.isSimpleContent = true;
                found = true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < fields.length) {
            block27: {
                block24: {
                    FieldTypeReference fTypeRef;
                    block25: {
                        TypeState tState;
                        block26: {
                            ArrayStruct aStr;
                            block23: {
                                fTypeRef = fields[i2].getFieldTypeReference();
                                if (list.isSimpleContent && !fTypeRef.hasConvertedTypeReference()) {
                                    throw new WSDLCreationException("webservices_2027", new Object[]{typeState.getName(), "not simple type"});
                                }
                                if (!fTypeRef.hasConvertedTypeReference()) break block23;
                                ConvertedTypeReferenceState convType = fTypeRef.getConvertedTypeReference();
                                df = new DataField(fields[i2].getFieldName(), convType.getOriginalType(), convType.getName(), null);
                                if (convType.getConvertedTypeReferenceSoapExtensionConvertedTypeRef() != null && convType.getConvertedTypeReferenceSoapExtensionConvertedTypeRef().getSoapExtensionConvertedTypeRef().hasIsAttribute()) {
                                    df.isAttribute = convType.getConvertedTypeReferenceSoapExtensionConvertedTypeRef().getSoapExtensionConvertedTypeRef().getIsAttribute();
                                }
                                if (this.isArray(fTypeRef.getConvertedTypeReference())) {
                                    aStr = new ArrayStruct(fTypeRef.getConvertedTypeReference(), this.allTypes);
                                    df.setArrayHolder(aStr);
                                    df.isAttribute = false;
                                    this.arrayTypes.add(aStr);
                                }
                                break block24;
                            }
                            if (!fTypeRef.hasComplexTypeReference()) break block25;
                            tState = SchemaConvertor.findTypeStateByOriginalName(fTypeRef.getComplexTypeReference().getName(), this.allTypes);
                            if (tState != null) break block26;
                            if (!this.isArray(fTypeRef.getComplexTypeReference())) {
                                throw new WSDLCreationException("webservices_2013", new Object[]{fTypeRef.getComplexTypeReference().getName()});
                            }
                            aStr = new ArrayStruct(fTypeRef.getComplexTypeReference(), this.allTypes);
                            df = new DataField(fields[i2].getFieldName(), aStr.javaClassName, aStr.componentComplexTypeName, null);
                            df.setArrayHolder(aStr);
                            this.arrayTypes.add(aStr);
                            list.add(df);
                            break block27;
                        }
                        df = new DataField(fields[i2].getFieldName(), tState.getTypeOriginal().getComplexTypeReference().getName(), tState.getName(), tState);
                        if (tState instanceof TableState) {
                            df.setArrayHolder(new ArrayStruct((TableState)tState, this.allTypes));
                            this.arrayTypes.add(df.getArrayHolder());
                        }
                        break block24;
                    }
                    if (fTypeRef.hasConvertedTableReference()) {
                        ArrayStruct aStr = new ArrayStruct(fTypeRef.getConvertedTableReference());
                        df = new DataField(fields[i2].getFieldName(), aStr.javaClassName, aStr.componentComplexTypeName, null);
                        df.setArrayHolder(aStr);
                        this.arrayTypes.add(aStr);
                    } else if (fTypeRef.hasInlineComplexTableReference()) {
                        String complType = fTypeRef.getInlineComplexTableReference().getName();
                        TypeState tState = SchemaConvertor.findTypeStateByOriginalName(complType, this.allTypes);
                        if (!(tState instanceof TableState)) throw new WSDLCreationException("webservices_2013", new Object[]{complType});
                        tState = SchemaConvertor.findTypeStateByOriginalName(((TableState)tState).getTableLineType().getComplexTypeReference().getName(), this.allTypes);
                        df = new DataField(fields[i2].getFieldName(), tState.getTypeOriginal().getComplexTypeReference().getName(), tState.getName(), tState);
                        df.isUnbounded = true;
                        if (tState instanceof TableState) {
                            df.setArrayHolder(new ArrayStruct((TableState)tState, this.allTypes));
                            this.arrayTypes.add(df.getArrayHolder());
                        }
                    } else if (fTypeRef.hasInlinePrimitiveTableReference()) {
                        InlinePrimitiveTableReferenceState inLPrim = fTypeRef.getInlinePrimitiveTableReference();
                        String inLType = inLPrim.getLineType();
                        int dim = inLPrim.getDimension();
                        if (dim == 1) {
                            df = new DataField(fields[i2].getFieldName(), inLType, inLType, null);
                        } else {
                            ArrayStruct aStr = new ArrayStruct(inLType, dim - 1, null);
                            df = new DataField(fields[i2].getFieldName(), aStr.javaClassName, aStr.componentComplexTypeName, null);
                            df.setArrayHolder(aStr);
                            this.arrayTypes.add(aStr);
                        }
                        df.isUnbounded = true;
                    }
                }
                list.add(df);
            }
            ++i2;
        }
        return list;
    }

    private boolean isArray(TypeReferenceState typeRefState) {
        if (typeRefState instanceof ConvertedTypeReferenceState && ((ConvertedTypeReferenceState)typeRefState).getOriginalType().endsWith("[]")) {
            return true;
        }
        return typeRefState instanceof ComplexTypeReferenceState && typeRefState.getName().endsWith("[]");
    }

    private boolean setElementTypeAttributeValue(Element element, DataField df) throws Exception {
        if (df.isUnbounded) {
            element.setAttributeNS("", SCHEMA_MAXOCCURS, SCHEMA_UNBOUNDED);
            element.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
        }
        if (df.hasArrayHolder()) {
            ArrayStruct aStr = (ArrayStruct)df.getArrayHolder();
            if (aStr.componentJavaClass.equals(Byte.TYPE.getName())) {
                element.setAttributeNS("", SCHEMA_TYPE, StandardTypes.getMapType(aStr.javaClassName));
            } else {
                String prefix = this.currentSchema.getPrefixForUri(aStr.namespace);
                element.setAttributeNS("", SCHEMA_TYPE, prefix + ":" + aStr.complexTypeName);
            }
            element.setAttributeNS("", SCHEMA_NILLABLE, "true");
            element.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
            return true;
        }
        if (StandardTypes.isJavaUtilType(df.getOriginalTypeName())) {
            String prefix = this.currentSchema.getPrefixForUri(JAVA_UTIL_SCHEMA_NAMESPACE);
            element.setAttributeNS("", SCHEMA_TYPE, prefix + ":" + SchemaConvertor.getJavaClassName(df.getOriginalTypeName()));
            element.setAttributeNS("", SCHEMA_NILLABLE, "true");
            element.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
            return true;
        }
        if (StandardTypes.isStandardType(df.getVirtualTypeName())) {
            element.setAttributeNS("", SCHEMA_TYPE, StandardTypes.getMapType(df.getVirtualTypeName()));
            if (StandardTypes.isNillableStandardType(df.getVirtualTypeName())) {
                element.setAttributeNS("", SCHEMA_NILLABLE, "true");
                element.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
            }
            return true;
        }
        String ns = SchemaInfo.getUriFromTypeState(df.getTypeState(), this.allTypes, null);
        String prefix = this.currentSchema.getPrefixForUri(ns);
        element.setAttributeNS("", SCHEMA_TYPE, prefix + ":" + SchemaConvertor.getComplexTypeName(df.getTypeState(), this.allTypes));
        element.setAttributeNS("", SCHEMA_NILLABLE, "true");
        element.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
        return false;
    }

    private boolean setElementTypeAttributeValue(Element element, ArrayStruct aStruct, boolean isEncodedArray) {
        if (StandardTypes.isStandardType(aStruct.componentJavaClass)) {
            if (!isEncodedArray) {
                element.setAttributeNS("", SCHEMA_TYPE, StandardTypes.getMapType(aStruct.componentJavaClass));
            } else {
                element.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", WSDL_ARRAY_TYPE, StandardTypes.getMapType(aStruct.componentJavaClass) + "[]");
            }
            element.setAttributeNS("", SCHEMA_NILLABLE, "true");
            return false;
        }
        String prefix = this.currentSchema.getPrefixForUri(aStruct.componentComplexTypeNS);
        if (!isEncodedArray) {
            element.setAttributeNS("", SCHEMA_TYPE, prefix + ":" + aStruct.componentComplexTypeName);
        } else {
            element.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", WSDL_ARRAY_TYPE, prefix + ":" + aStruct.componentComplexTypeName + "[]");
        }
        element.setAttributeNS("", SCHEMA_NILLABLE, "true");
        return false;
    }

    private DOMSource[] createDomSourcesFromSchemas() throws WSDLCreationException {
        ArrayList resoved = SchemaInfo.resolveSchemas(this.schemas);
        DOMSource[] domSources = new DOMSource[resoved.size()];
        int i = 0;
        while (i < resoved.size()) {
            DOMSource tempSource;
            Element normalizedSchema = ((SchemaInfo)resoved.get(i)).normalizeSchema();
            domSources[i] = tempSource = new DOMSource(normalizedSchema);
            ++i;
        }
        return domSources;
    }

    private void parseFunctions(FunctionState[] functions) throws Exception {
        int f = 0;
        while (f < functions.length) {
            ParameterMappedTypeReference mtRef;
            ParameterState[] params;
            FunctionState function = functions[f];
            if (function.getFunctionIncomingParameters() != null) {
                params = function.getFunctionIncomingParameters();
                int i = 0;
                while (i < params.length) {
                    mtRef = params[i].getParameterMappedTypeReference();
                    if (mtRef.hasConvertedTableReference()) {
                        this.arrayTypes.add(new ArrayStruct(mtRef.getConvertedTableReference()));
                    }
                    if (mtRef.hasComplexTypeReference() && this.isArray(mtRef.getComplexTypeReference()) && !(SchemaConvertor.findTypeStateByOriginalName(mtRef.getComplexTypeReference().getName(), this.allTypes) instanceof TableState)) {
                        this.arrayTypes.add(new ArrayStruct(mtRef.getComplexTypeReference(), this.allTypes));
                    }
                    if (mtRef.hasConvertedTypeReference() && this.isArray(mtRef.getConvertedTypeReference())) {
                        this.arrayTypes.add(new ArrayStruct(mtRef.getConvertedTypeReference(), this.allTypes));
                    }
                    if (mtRef.hasInlineComplexTableReference()) {
                        throw new WSDLCreationException("webservices_2026", new Object[]{"inlineComplexType"});
                    }
                    if (mtRef.hasInlinePrimitiveTableReference()) {
                        throw new WSDLCreationException("webservices_2026", new Object[]{"inlinePrimitiveType"});
                    }
                    ++i;
                }
            }
            if (function.getFunctionOutgoingParameters() != null) {
                params = function.getFunctionOutgoingParameters();
                if (params.length != 1) {
                    throw new WSDLCreationException("webservices_2014", new Object[]{new Integer(1), function.getName()});
                }
                mtRef = params[0].getParameterMappedTypeReference();
                if (mtRef.hasConvertedTableReference()) {
                    this.arrayTypes.add(new ArrayStruct(mtRef.getConvertedTableReference()));
                }
                if (mtRef.hasComplexTypeReference() && this.isArray(mtRef.getComplexTypeReference()) && !(SchemaConvertor.findTypeStateByOriginalName(mtRef.getComplexTypeReference().getName(), this.allTypes) instanceof TableState)) {
                    this.arrayTypes.add(new ArrayStruct(mtRef.getComplexTypeReference(), this.allTypes));
                }
                if (mtRef.hasConvertedTypeReference() && this.isArray(mtRef.getConvertedTypeReference())) {
                    this.arrayTypes.add(new ArrayStruct(mtRef.getConvertedTypeReference(), this.allTypes));
                }
                if (mtRef.hasInlineComplexTableReference()) {
                    throw new WSDLCreationException("webservices_2026", new Object[]{"inlineComplexType"});
                }
                if (mtRef.hasInlinePrimitiveTableReference()) {
                    throw new WSDLCreationException("webservices_2026", new Object[]{"inlinePrimitiveType"});
                }
            }
            ++f;
        }
    }

    private void appendJavaUtilComplexType(String javaUtilClName) throws Exception {
        SchemaInfo temp = (SchemaInfo)this.schemas.get(JAVA_UTIL_SCHEMA_NAMESPACE);
        if (temp == null) {
            temp = new SchemaInfo(JAVA_UTIL_SCHEMA_NAMESPACE, this.isElFormDfQualified);
            this.schemas.put(JAVA_UTIL_SCHEMA_NAMESPACE, temp);
        }
        Element parentSchemaEl = temp.getSchemaElement();
        String cmpTName = SchemaConvertor.getJavaClassName(javaUtilClName);
        Element cmpTEl = parentSchemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
        cmpTEl.setAttributeNS("", SCHEMA_NAME, cmpTName);
        Element item = parentSchemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ELEMENT);
        item.setAttributeNS("", SCHEMA_NAME, SchemaConvertor.getJavaClassName(javaUtilClName));
        item.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
        item.setAttributeNS("", SCHEMA_MAXOCCURS, SCHEMA_UNBOUNDED);
        item.setAttributeNS("", SCHEMA_TYPE, "xs:anyType");
        Element seq = parentSchemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_SEQUENCE);
        seq.appendChild(item);
        cmpTEl.appendChild(seq);
        parentSchemaEl.appendChild(cmpTEl);
    }

    private void parseArrays() throws Exception {
        ArrayList<ArrayStruct> generated = new ArrayList<ArrayStruct>(this.arrayTypes.size());
        int i = 0;
        while (i < this.arrayTypes.size()) {
            ArrayStruct aStr = (ArrayStruct)this.arrayTypes.get(i);
            if (!generated.contains(aStr) && !aStr.componentJavaClass.equals(Byte.TYPE.getName())) {
                String nameValue;
                Element complexType;
                SchemaInfo temp = (SchemaInfo)this.schemas.get(aStr.namespace);
                if (temp == null) {
                    temp = new SchemaInfo(aStr.namespace, this.isElFormDfQualified);
                    this.schemas.put(aStr.namespace, temp);
                }
                this.schemaElement = temp.getSchemaElement();
                this.currentSchema = temp;
                if (this.isLiteralArrayRepresentation) {
                    complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
                    nameValue = aStr.complexTypeName;
                    complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
                    this.nameMapping.put(aStr.javaClassName, new QName(this.currentSchema.getTargetNamespace(), nameValue));
                    Element sequence = (Element)complexType.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_SEQUENCE));
                    Element arrayElement = (Element)sequence.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ELEMENT));
                    arrayElement.setAttributeNS("", SCHEMA_MAXOCCURS, SCHEMA_UNBOUNDED);
                    arrayElement.setAttributeNS("", SCHEMA_MINOCCURS, Integer.toString(0));
                    arrayElement.setAttributeNS("", SCHEMA_NAME, aStr.itemName);
                    this.setElementTypeAttributeValue(arrayElement, aStr, false);
                    this.schemaElement.appendChild(complexType);
                } else {
                    complexType = this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXTYPE);
                    nameValue = aStr.complexTypeName;
                    complexType.setAttributeNS("", SCHEMA_NAME, nameValue);
                    this.nameMapping.put(aStr.javaClassName, new QName(this.currentSchema.getTargetNamespace(), nameValue));
                    Element complexContent = (Element)complexType.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_COMPLEXCONTENT));
                    Element restriction = (Element)complexContent.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_RESTRICTION));
                    restriction.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
                    restriction.setAttributeNS("", SCHEMA_BASE, SOAPENC_ARRAY);
                    Element attribute = (Element)restriction.appendChild(this.schemaElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", SCHEMA_ATTRIBUTE));
                    attribute.setAttributeNS("", SCHEMA_REF, SOAPENC_ARRAY_TYPE);
                    this.setElementTypeAttributeValue(attribute, aStr, true);
                    this.schemaElement.appendChild(complexType);
                }
                generated.add(aStr);
                if (aStr.componentState != null && aStr.componentState instanceof TableState) {
                    this.arrayTypes.add(new ArrayStruct((TableState)aStr.componentState, this.allTypes));
                }
                if (aStr.dimention > 1) {
                    this.arrayTypes.add(new ArrayStruct(aStr));
                }
            }
            ++i;
        }
    }

    static String getOriginalType(TypeState typeState) throws Exception {
        if (typeState.getTypeOriginal() != null) {
            if (typeState.getTypeOriginal().hasComplexTypeReference()) {
                return typeState.getTypeOriginal().getComplexTypeReference().getName();
            }
            return typeState.getTypeOriginal().getFault().getName();
        }
        return typeState.getName();
    }

    static TypeState findTypeStateByOriginalName(String originalName, VirtualInterfaceTypes.Choice[] typeStates) throws Exception {
        TypeState tempState = null;
        int i = 0;
        while (i < typeStates.length) {
            block7: {
                String javaClass;
                block6: {
                    block5: {
                        tempState = SchemaConvertor.extractTypeStateFromChoice(typeStates[i]);
                        if (!tempState.getTypeOriginal().hasComplexTypeReference()) break block5;
                        javaClass = tempState.getTypeOriginal().getComplexTypeReference().getName();
                        break block6;
                    }
                    if (!tempState.getTypeOriginal().hasFault()) break block7;
                    javaClass = tempState.getTypeOriginal().getFault().getName();
                }
                if (javaClass.equals(originalName)) {
                    return tempState;
                }
            }
            ++i;
        }
        return null;
    }

    static TypeState extractTypeStateFromChoice(VirtualInterfaceTypes.Choice choice) throws Exception {
        if (choice.hasElementary()) {
            return choice.getElementary();
        }
        if (choice.hasStructure()) {
            return choice.getStructure();
        }
        if (choice.hasTable()) {
            return choice.getTable();
        }
        return null;
    }

    static String getArrayNS(TableState table, VirtualInterfaceTypes.Choice[] allTypes) throws WSDLCreationException {
        String nsValue;
        if (table.getTypeSoapExtensionType() != null && table.getTypeSoapExtensionType().getSoapExtensionType().hasNamespace() && (nsValue = table.getTypeSoapExtensionType().getSoapExtensionType().getNamespace()).length() > 0) {
            return nsValue;
        }
        try {
            TypeState typeState = SchemaInfo.getArrayComponent(table, allTypes);
            if (typeState == null) {
                throw new WSDLCreationException("webservices_2013", new Object[]{table.getName()});
            }
            return SchemaInfo.getUriFromTypeState(typeState, allTypes, null);
        }
        catch (Exception e) {
            throw new WSDLCreationException(e);
        }
    }

    static String getComplexTypeName(TypeState state, VirtualInterfaceTypes.Choice[] allTypes) throws Exception {
        String s;
        String origCl = SchemaConvertor.getOriginalType(state);
        if (StandardTypes.isJavaUtilType(origCl)) {
            return SchemaConvertor.getJavaClassName(origCl);
        }
        if (state.getTypeSoapExtensionType() != null) {
            String ns;
            if (state.getTypeSoapExtensionType().getSoapExtensionType().hasLocalname()) {
                return state.getTypeSoapExtensionType().getSoapExtensionType().getLocalname();
            }
            if (state.getTypeSoapExtensionType().getSoapExtensionType().hasNamespace() && (ns = state.getTypeSoapExtensionType().getSoapExtensionType().getNamespace()).length() > 0) {
                return SchemaConvertor.filterNCName(state.getName(), state);
            }
        }
        if (state instanceof TableState) {
            state = SchemaInfo.getArrayComponent((TableState)state, allTypes);
        }
        if (state.getTypeOriginal().hasComplexTypeReference()) {
            s = SchemaConvertor.getJavaClassName(state.getTypeOriginal().getComplexTypeReference().getName());
            return SchemaConvertor.filterNCName(s, state);
        }
        s = SchemaConvertor.getJavaClassName(state.getTypeOriginal().getFault().getName());
        return SchemaConvertor.filterNCName(s, state);
    }

    static String getJavaClassName(String fullName) {
        int ind = fullName.lastIndexOf(".");
        if (ind == -1) {
            return fullName;
        }
        return fullName.substring(ind + 1);
    }

    static String filterNCName(String s, TypeState type) throws WSDLCreationException {
        if (Symbols.isNCName((String)s)) {
            return s;
        }
        throw new WSDLCreationException("webservices_2029", new Object[]{s, type != null ? type.getName() : "null"});
    }

    private TypeState getAdditionTypeState(String originalName) {
        if (this.thrState != null) {
            return this.thrState;
        }
        if (originalName.equals((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName())) {
            StructureState strS = new StructureState();
            strS.setName((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName());
            strS.setParentTypeName((class$java$lang$Object == null ? (class$java$lang$Object = SchemaConvertor.class$("java.lang.Object")) : class$java$lang$Object).getName());
            TypeOriginal to = new TypeOriginal();
            ComplexTypeReferenceState ctRef = new ComplexTypeReferenceState();
            ctRef.setName((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName());
            to.setComplexTypeReference(ctRef);
            strS.setTypeOriginal(to);
            FieldState fMessage = new FieldState();
            fMessage.setName("0");
            fMessage.setFieldName("message");
            ConvertedTypeReferenceState strRef = new ConvertedTypeReferenceState();
            strRef.setName((class$java$lang$String == null ? (class$java$lang$String = SchemaConvertor.class$("java.lang.String")) : class$java$lang$String).getName());
            strRef.setOriginalType((class$java$lang$String == null ? (class$java$lang$String = SchemaConvertor.class$("java.lang.String")) : class$java$lang$String).getName());
            FieldTypeReference fTypeRef = new FieldTypeReference();
            fTypeRef.setConvertedTypeReference(strRef);
            fMessage.setFieldTypeReference(fTypeRef);
            strS.setStructureFields(new FieldState[]{fMessage});
            SoapExtensionTypeState soapExt = new SoapExtensionTypeState();
            soapExt.setLocalname("Throwable");
            soapExt.setName("SoapExtension");
            soapExt.setNamespace("urn:java.lang");
            TypeSoapExtensionType tsExt = new TypeSoapExtensionType();
            tsExt.setSoapExtensionType(soapExt);
            strS.setTypeSoapExtensionType(tsExt);
            this.thrState = strS;
            return strS;
        }
        return null;
    }

    private void checkForSpecialUsage(FunctionState[] functions) throws Exception {
        this.checkTypesSection();
        this.checkFunctions(functions);
        this.getAdditionTypeState((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName());
    }

    private void checkTypesSection() throws Exception {
        String type = null;
        int i = 0;
        while (i < this.allTypes.length) {
            TypeState cur = SchemaConvertor.extractTypeStateFromChoice(this.allTypes[i]);
            if (cur instanceof StructureState) {
                StructureState s = (StructureState)cur;
                FieldState[] fields = s.getStructureFields();
                if (fields == null) {
                    fields = new FieldState[]{};
                }
                int f = 0;
                while (f < fields.length) {
                    FieldState field = fields[f];
                    if (field.getFieldTypeReference().hasComplexTypeReference()) {
                        type = field.getFieldTypeReference().getComplexTypeReference().getName();
                    } else if (field.getFieldTypeReference().hasFault()) {
                        type = field.getFieldTypeReference().getFault().getName();
                    } else if (field.getFieldTypeReference().hasInlineComplexTableReference()) {
                        type = field.getFieldTypeReference().getInlineComplexTableReference().getName();
                    }
                    this.checkType(type);
                    ++f;
                }
            } else if (cur instanceof TableState) {
                TableState table = (TableState)cur;
                if (table.getTableLineType().hasComplexTypeReference()) {
                    type = table.getTableLineType().getComplexTypeReference().getName();
                } else if (table.getTableLineType().hasFault()) {
                    type = table.getTableLineType().getFault().getName();
                } else if (table.getTableLineType().hasInlineComplexTableReference()) {
                    type = table.getTableLineType().getInlineComplexTableReference().getName();
                }
                this.checkType(type);
            }
            ++i;
        }
    }

    private void checkFunctions(FunctionState[] functions) throws Exception {
        int i = 0;
        while (i < functions.length) {
            ParameterState[] params;
            FunctionState function = functions[i];
            if (function.getFunctionIncomingParameters() != null) {
                params = function.getFunctionIncomingParameters();
                this.checkParameters(params);
            }
            if (function.getFunctionOutgoingParameters() != null) {
                params = function.getFunctionOutgoingParameters();
                this.checkParameters(params);
            }
            if (function.getFunctionFaults() != null) {
                FaultState[] fFaults = function.getFunctionFaults();
                int ff = 0;
                while (ff < fFaults.length) {
                    this.checkType(fFaults[ff].getName());
                    ++ff;
                }
            }
            ++i;
        }
    }

    private void checkParameters(ParameterState[] params) throws Exception {
        int p = 0;
        while (p < params.length) {
            ParameterState param = params[p];
            String type = null;
            if (param.getParameterMappedTypeReference().hasComplexTypeReference()) {
                type = param.getParameterMappedTypeReference().getComplexTypeReference().getName();
            } else if (param.getParameterMappedTypeReference().hasFault()) {
                type = param.getParameterMappedTypeReference().getFault().getName();
            } else if (param.getParameterMappedTypeReference().hasInlineComplexTableReference()) {
                type = param.getParameterMappedTypeReference().getInlineComplexTableReference().getName();
            }
            this.checkType(type);
            ++p;
        }
    }

    private void checkType(String type) {
        if (type != null) {
            if (type.equals((class$java$io$Serializable == null ? (class$java$io$Serializable = SchemaConvertor.class$("java.io.Serializable")) : class$java$io$Serializable).getName())) {
                this.isSerUsed = true;
            } else if (type.equals((class$java$lang$Throwable == null ? (class$java$lang$Throwable = SchemaConvertor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName()) || type.equals((class$java$lang$Exception == null ? (class$java$lang$Exception = SchemaConvertor.class$("java.lang.Exception")) : class$java$lang$Exception).getName())) {
                this.isThrOrExcUsed = true;
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

