/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.PropertyDescriptor;
import com.sap.engine.lib.xml.util.QName;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.wsdl.SAPFeature;
import com.sap.engine.services.webservices.wsdl.SAPOption;
import com.sap.engine.services.webservices.wsdl.SAPProperty;
import com.sap.engine.services.webservices.wsdl.SAPUseFeature;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.util.ArrayList;
import java.util.Enumeration;

public class FeatureBindingAppender {
    private static final String FEATURE_BASE = "_runtime-feature_";
    private static final String FEATURE_NS_PREFIX = "fns";
    private static final String TARGETNS_PREFIX = "tns";

    public static WSDLDefinitions appendFeatures(WSDLDefinitions definitions, ServiceEndpointDefinition[] endpoints) throws WSDLException {
        String tnsPref = FeatureBindingAppender.setTNSPrefix(definitions);
        int nsNom = 0;
        int i = 0;
        while (i < endpoints.length) {
            WSDLBinding[] bindings = FeatureBindingAppender.getBindings(definitions, endpoints[i].getWsdlBindingName().getLocalPart());
            int j = 0;
            while (j < bindings.length) {
                nsNom = FeatureBindingAppender.appendSAPFeatures(endpoints[i], definitions, bindings[j].getName(), nsNom);
                SAPUseFeature[] useFeatures = FeatureBindingAppender.createUseFeatures(bindings[j].getName(), null, endpoints[i].getFeaturesChain(), tnsPref);
                if (useFeatures != null) {
                    int f = 0;
                    while (f < useFeatures.length) {
                        bindings[j].addUseFeature(useFeatures[f]);
                        ++f;
                    }
                }
                OperationDefinition[] operations = endpoints[i].getOperations();
                int op = 0;
                while (op < operations.length) {
                    useFeatures = FeatureBindingAppender.createUseFeatures(bindings[j].getName(), operations[op].getOperationName(), ((OperationDefinitionImpl)operations[op]).getFeaturesChain(), tnsPref);
                    WSDLBindingOperation bndOperation = bindings[j].getOperation(operations[op].getOperationName());
                    if (bndOperation != null && useFeatures != null) {
                        int f = 0;
                        while (f < useFeatures.length) {
                            bndOperation.addUseFeatire(useFeatures[f]);
                            ++f;
                        }
                    }
                    ++op;
                }
                ++j;
            }
            ++i;
        }
        return definitions;
    }

    private static int appendSAPFeatures(ServiceEndpointDefinition endpoint, WSDLDefinitions def, String bindingName, int fnsNom) {
        SAPFeature sapFeature;
        String fLable;
        FeatureInfo[] features = endpoint.getFeaturesChain();
        if (features != null) {
            int j = 0;
            while (j < features.length) {
                fLable = FeatureBindingAppender.getFeatureLable(bindingName, null, j);
                sapFeature = new SAPFeature();
                sapFeature.setName(fLable);
                sapFeature.setUri(features[j].getFeatureName());
                String prefix = FeatureBindingAppender.getPrefixForUri(def, features[j].getFeatureName());
                if (prefix == null) {
                    prefix = FEATURE_NS_PREFIX + fnsNom++;
                }
                def.addAdditionalAttribute("xmlns:" + prefix, features[j].getFeatureName());
                def.addFeature(FeatureBindingAppender.loadProperties(sapFeature, features[j].getConfiguration(), prefix));
                ++j;
            }
        }
        OperationDefinition[] operations = endpoint.getOperations();
        int j = 0;
        while (j < operations.length) {
            features = ((OperationDefinitionImpl)operations[j]).getFeaturesChain();
            if (features != null && features.length != 0) {
                int f = 0;
                while (f < features.length) {
                    fLable = FeatureBindingAppender.getFeatureLable(bindingName, operations[j].getOperationName(), f);
                    sapFeature = new SAPFeature();
                    sapFeature.setName(fLable);
                    sapFeature.setUri(features[f].getFeatureName());
                    String prefix = FeatureBindingAppender.getPrefixForUri(def, features[f].getFeatureName());
                    if (prefix == null) {
                        prefix = FEATURE_NS_PREFIX + fnsNom++;
                    }
                    def.addAdditionalAttribute("xmlns:" + prefix, features[f].getFeatureName());
                    def.addFeature(FeatureBindingAppender.loadProperties(sapFeature, features[f].getConfiguration(), prefix));
                    ++f;
                }
            }
            ++j;
        }
        return fnsNom;
    }

    public static SAPFeature loadProperties(SAPFeature feature, Config cnf, String fNSPrefix) {
        PropertyDescriptor[] fProperties = cnf.getProperties();
        int p = 0;
        while (p < fProperties.length) {
            if (fProperties[p].hasSimpleContent() || fProperties[p].hasValueAttrib()) {
                SAPProperty sapProperty = new SAPProperty();
                sapProperty.setQname(new QName(fNSPrefix, fProperties[p].getPropertyDescriptorName(), feature.getUri()));
                SAPOption sapOption = new SAPOption();
                if (fProperties[p].hasSimpleContent()) {
                    sapOption.setValue(fProperties[p].getSimpleContent());
                } else {
                    sapOption.setValue(fNSPrefix + ":" + fProperties[p].getValue());
                }
                sapProperty.addOption(sapOption);
                feature.addProperty(sapProperty);
            }
            ++p;
        }
        return feature;
    }

    private static String getFeatureLable(String bindingName, String operationName, int nom) {
        if (operationName == null) {
            return bindingName + FEATURE_BASE + nom;
        }
        return bindingName + "_" + operationName + FEATURE_BASE + nom;
    }

    private static SAPUseFeature[] createUseFeatures(String bindingName, String operationName, FeatureInfo[] features, String tnsPref) {
        if (features == null || features.length == 0) {
            return null;
        }
        SAPUseFeature[] res = new SAPUseFeature[features.length];
        int i = 0;
        while (i < res.length) {
            SAPUseFeature useF = new SAPUseFeature();
            useF.setFeatureQName(new QName(tnsPref, FeatureBindingAppender.getFeatureLable(bindingName, operationName, i), features[i].getFeatureName()));
            res[i] = useF;
            ++i;
        }
        return res;
    }

    private static WSDLBinding[] getBindings(WSDLDefinitions definitions, String bindingName) {
        ArrayList<WSDLBinding> resultBindings = new ArrayList<WSDLBinding>();
        ArrayList bindings = definitions.getBindings();
        int i = 0;
        while (i < bindings.size()) {
            WSDLBinding tmpBinding = (WSDLBinding)bindings.get(i);
            if (tmpBinding.getName().equals(bindingName) || tmpBinding.getName().equals(bindingName + "_document")) {
                resultBindings.add(tmpBinding);
            }
            ++i;
        }
        return resultBindings.toArray(new WSDLBinding[resultBindings.size()]);
    }

    public static String getPrefixForUri(WSDLDefinitions def, String ns) {
        Enumeration en = def.getAdditionalAttributes().keys();
        while (en.hasMoreElements()) {
            String tmp = (String)en.nextElement();
            if (!tmp.startsWith("xmlns:") || !def.getAdditionalAttributes().get(tmp).equals(ns)) continue;
            return tmp.substring("xmlns:".length());
        }
        return null;
    }

    public static String setTNSPrefix(WSDLDefinitions def) {
        String pref;
        String trgNS = def.getAdditionalAttrValue("targetNamespace");
        if (trgNS == null) {
            trgNS = def.targetNamespace;
        }
        if ((pref = FeatureBindingAppender.getPrefixForUri(def, trgNS)) == null) {
            def.addAdditionalAttribute("xmlns:tns", trgNS);
            pref = TARGETNS_PREFIX;
        }
        return pref;
    }
}

