/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.wsdl;

import com.sap.engine.services.webservices.runtime.wsdl.SchemaConvertor;
import com.sap.engine.services.webservices.runtime.wsdl.SchemaInfo;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLCreationException;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ComplexTypeReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ConvertedTableReferenceSoapExtensionTable;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ConvertedTableReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ConvertedTypeReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TableState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeReferenceState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.TypeState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceTypes;

class ArrayStruct {
    static final String DEFAULT_STRING_SIMPLE_TYPE = "String";
    String javaClassName;
    String namespace;
    String complexTypeName;
    String componentComplexTypeName;
    String componentComplexTypeNS;
    String componentJavaClass;
    String itemName = "item";
    int dimention;
    TypeState componentState;
    static /* synthetic */ Class class$java$lang$String;

    ArrayStruct(TableState table, VirtualInterfaceTypes.Choice[] allTypes) throws Exception {
        this.complexTypeName = this.getComplexTypeName(table, allTypes);
        this.javaClassName = table.getTypeOriginal().getComplexTypeReference().getName();
        this.namespace = SchemaConvertor.getArrayNS(table, allTypes);
        this.componentJavaClass = table.getTableLineType().getComplexTypeReference().getName();
        this.componentState = SchemaConvertor.findTypeStateByOriginalName(this.componentJavaClass, allTypes);
        if (this.componentState instanceof TableState) {
            this.componentComplexTypeNS = SchemaConvertor.getArrayNS((TableState)this.componentState, allTypes);
            this.componentComplexTypeName = this.getComplexTypeName((TableState)this.componentState, allTypes);
        } else {
            this.componentComplexTypeNS = SchemaInfo.getUriFromTypeState(this.componentState, allTypes, null);
            this.componentComplexTypeName = SchemaConvertor.getComplexTypeName(this.componentState, allTypes);
        }
        TypeState typeState = SchemaInfo.getArrayComponent(table, allTypes);
        this.itemName = SchemaConvertor.getJavaClassName(typeState.getName());
        if (table.hasTableSoapExtensionTable() && table.getTableSoapExtensionTable().getSoapExtensionTable().hasItemLabel()) {
            this.itemName = table.getTableSoapExtensionTable().getSoapExtensionTable().getItemLabel();
        }
    }

    ArrayStruct(String inlineType, int dim, ConvertedTableReferenceSoapExtensionTable soapExtTable) throws WSDLCreationException {
        this.dimention = dim;
        String baseClassName = inlineType;
        this.javaClassName = this.getJavaArrayDeclaration(baseClassName, this.dimention);
        this.componentComplexTypeNS = this.namespace = SchemaInfo.getUriFromClassName("java.lang.xxx", null);
        if (baseClassName.equals((class$java$lang$String == null ? (class$java$lang$String = ArrayStruct.class$("java.lang.String")) : class$java$lang$String).getName())) {
            this.complexTypeName = this.getComplexTypeName(DEFAULT_STRING_SIMPLE_TYPE, this.dimention);
            this.componentComplexTypeName = this.getComplexTypeName(DEFAULT_STRING_SIMPLE_TYPE, this.dimention - 1);
            this.itemName = DEFAULT_STRING_SIMPLE_TYPE;
        } else {
            this.complexTypeName = this.getComplexTypeName(baseClassName, this.dimention);
            this.componentComplexTypeName = this.getComplexTypeName(baseClassName, this.dimention - 1);
            this.itemName = baseClassName;
        }
        this.componentJavaClass = baseClassName + this.getSuffixBrackets(this.dimention - 1);
        if (soapExtTable != null && soapExtTable.getSoapExtensionTable().hasItemLabel()) {
            this.itemName = soapExtTable.getSoapExtensionTable().getItemLabel();
        }
    }

    ArrayStruct(ConvertedTableReferenceState simpleTypesTable) throws WSDLCreationException {
        this(simpleTypesTable.getConvertedTableReferenceLineType().getConvertedTypeReference().getName(), simpleTypesTable.getDimension(), simpleTypesTable.getConvertedTableReferenceSoapExtensionTable());
    }

    ArrayStruct(TypeReferenceState typeRefState, VirtualInterfaceTypes.Choice[] allTypes) throws Exception {
        if (typeRefState instanceof ConvertedTypeReferenceState) {
            ConvertedTypeReferenceState cnv = (ConvertedTypeReferenceState)typeRefState;
            this.javaClassName = cnv.getOriginalType();
            this.dimention = this.getDimention(this.javaClassName);
            String baseClassName = this.cutArrayBrackets(this.javaClassName);
            this.componentComplexTypeNS = this.namespace = SchemaInfo.getUriFromClassName("java.lang.xxx", null);
            if (baseClassName.equals((class$java$lang$String == null ? (class$java$lang$String = ArrayStruct.class$("java.lang.String")) : class$java$lang$String).getName())) {
                this.complexTypeName = this.getComplexTypeName(DEFAULT_STRING_SIMPLE_TYPE, this.dimention);
                this.componentComplexTypeName = this.getComplexTypeName(DEFAULT_STRING_SIMPLE_TYPE, this.dimention - 1);
                this.itemName = DEFAULT_STRING_SIMPLE_TYPE;
            } else {
                this.complexTypeName = this.getComplexTypeName(baseClassName, this.dimention);
                this.componentComplexTypeName = this.getComplexTypeName(baseClassName, this.dimention - 1);
                this.itemName = baseClassName;
            }
            this.componentJavaClass = baseClassName + this.getSuffixBrackets(this.dimention - 1);
        } else if (typeRefState instanceof ComplexTypeReferenceState) {
            ComplexTypeReferenceState complex = (ComplexTypeReferenceState)typeRefState;
            this.javaClassName = complex.getName();
            this.dimention = this.getDimention(this.javaClassName);
            String baseClassName = this.cutArrayBrackets(this.javaClassName);
            TypeState innerMostType = SchemaConvertor.findTypeStateByOriginalName(baseClassName, allTypes);
            this.componentComplexTypeNS = this.namespace = SchemaInfo.getUriFromTypeState(innerMostType, allTypes, null);
            this.complexTypeName = this.getComplexTypeName(innerMostType.getName(), this.dimention);
            this.itemName = innerMostType.getName();
            this.componentComplexTypeName = this.dimention > 1 ? this.getComplexTypeName(innerMostType.getName(), this.dimention - 1) : innerMostType.getName();
            this.componentJavaClass = baseClassName + this.getSuffixBrackets(this.dimention - 1);
        }
    }

    ArrayStruct(ArrayStruct parent) throws WSDLCreationException {
        this.dimention = parent.dimention - 1;
        this.javaClassName = parent.componentJavaClass;
        this.complexTypeName = parent.componentComplexTypeName;
        this.componentComplexTypeNS = this.namespace = parent.componentComplexTypeNS;
        String baseClassName = this.cutArrayBrackets(this.javaClassName);
        this.componentComplexTypeName = this.getComplexTypeName(baseClassName, this.dimention - 1);
        this.componentJavaClass = baseClassName + this.getSuffixBrackets(this.dimention - 1);
        this.itemName = parent.itemName;
    }

    private String getJavaArrayDeclaration(String javaClass, int dimention) {
        while (dimention > 0) {
            javaClass = javaClass + "[]";
            --dimention;
        }
        return javaClass;
    }

    private String getComplexTypeName(TableState table, VirtualInterfaceTypes.Choice[] allTypes) throws Exception {
        if (table.hasTypeSoapExtensionType() && table.getTypeSoapExtensionType().getSoapExtensionType().hasLocalname()) {
            return SchemaConvertor.filterNCName(table.getTypeSoapExtensionType().getSoapExtensionType().getLocalname(), table);
        }
        String complexTypeName = SchemaConvertor.getComplexTypeName(table, allTypes);
        String javaClassName = table.getTypeOriginal().getComplexTypeReference().getName();
        int dimention = this.getDimention(javaClassName);
        complexTypeName = this.getComplexTypeName(complexTypeName, dimention);
        return complexTypeName;
    }

    private String cutArrayBrackets(String arrayName) {
        int delim = arrayName.indexOf("[]");
        return arrayName.substring(0, delim);
    }

    private int getDimention(String originalArray) {
        int delim = originalArray.indexOf("[]");
        return (originalArray.length() - delim) / 2;
    }

    private String getSuffixBrackets(int nom) {
        String res = "";
        int i = 0;
        while (i < nom) {
            res = res + "[]";
            ++i;
        }
        return res;
    }

    private String getComplexTypeName(String baseName, int dim) throws WSDLCreationException {
        if (dim > 1) {
            return SchemaConvertor.filterNCName("ArrayOf" + baseName + dim + "D", null);
        }
        return SchemaConvertor.filterNCName("ArrayOf" + baseName, null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayStruct)) {
            return false;
        }
        ArrayStruct sObj = (ArrayStruct)obj;
        return this.complexTypeName.equals(sObj.complexTypeName) && this.namespace.equals(sObj.namespace);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

