/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.servlet;

import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.registry.RuntimeRegistry;
import com.sap.engine.services.webservices.runtime.servlet.ServletDispatcherImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.WSManagementInterfaceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSInformation {
    private String encodeWS(WSRuntimeDefinition ws) {
        WSIdentifier wsID = ws.getWSIdentifier();
        String appName = URLEncoder.encode(wsID.getApplicationName());
        String jarName = URLEncoder.encode(wsID.getJarName());
        String serviceName = URLEncoder.encode(wsID.getServiceName());
        String wsStr = serviceName + "/" + appName + "/" + jarName;
        byte[] result = BASE64Encoder.encode((byte[])wsStr.getBytes());
        return new String(result, 0, result.length);
    }

    public void writeInfo(String endpointId, HttpServletRequest request, HttpServletResponse response, HttpServlet servlet, ServletDispatcherImpl dispatcher) throws Exception {
        RuntimeRegistry runtimeRegistry = WSContainer.getRuntimeRegistry();
        ServiceEndpointDefinition endpoint = runtimeRegistry.getServiceEndpoint(endpointId);
        if (endpoint != null) {
            String area = request.getParameter("AREA");
            if ("WSDLZIP".equals(area)) {
                this.writeWSDLZip(request, response, endpoint);
            } else {
                String style = request.getParameter("style");
                String styleParam = style != null && style.length() > 0 ? "&style=" + style : "";
                response.sendRedirect("/wsnavigator/jsps/index.jsp?localWS=" + URLEncoder.encode(this.encodeWS(endpoint.getOwner())) + styleParam);
            }
        } else {
            response.sendError(404);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeWSDLZip(HttpServletRequest request, HttpServletResponse response, ServiceEndpointDefinition endpoint) throws Exception {
        int l;
        String styleParam = request.getParameter("STYLE");
        if (styleParam == null) {
            styleParam = "";
        }
        boolean sapMode = request.getParameter("SAPWSDL") != null;
        File wsdlsDirectory = WSManagementInterfaceImpl.getWSDLsDirectory(endpoint, styleParam, sapMode, request.getServerName(), request.getServerPort(), null);
        JarUtils jarUtils = new JarUtils();
        File jarFile = new File(wsdlsDirectory, "../wsdls.zip");
        if (!jarFile.exists()) {
            jarUtils.makeJarFromDir(jarFile.getAbsolutePath(), wsdlsDirectory.getAbsolutePath());
        }
        FileInputStream in = new FileInputStream(jarFile);
        response.setContentType("application/zip");
        response.setHeader("Content-disposition", "123; filename=\"" + (sapMode ? "SAP" : "") + "WSDL" + styleParam + ".zip\"");
        ServletOutputStream out = response.getOutputStream();
        byte[] b = new byte[1024];
        while ((l = ((InputStream)in).read(b)) != -1) {
            void var12_12;
            out.write(b, 0, (int)var12_12);
        }
        ((InputStream)in).close();
        out.close();
    }
}

