/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.servlet;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.interfaces.webservices.runtime.ServletsHelper;
import com.sap.engine.interfaces.webservices.runtime.UDDIPublicationExt;
import com.sap.engine.interfaces.webservices.runtime.WebServiceExt;
import com.sap.engine.interfaces.webservices.server.event.Event;
import com.sap.engine.interfaces.webservices.uddi4j.UDDIRegistry;
import com.sap.engine.lib.jaxp.SAXParserFactoryImpl;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.servlet.DocumentationHandler;
import com.sap.engine.services.webservices.runtime.servlet.VIHandler;
import com.sap.engine.services.webservices.runtime.wsdl.ServiceGenerator;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.WSManagementInterface;
import com.sap.engine.services.webservices.server.WSManagementInterfaceImpl;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.UDDIPublication;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.WSDLAbstractGeneratorImpl;
import com.sap.engine.services.webservices.server.deploy.event.uddipublication.UDDIPublicationEvent;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import org.xml.sax.helpers.DefaultHandler;

public class ServletsHelperImpl
implements ServletsHelper {
    public static final String ROOT_CONFIGURATION_NAME = "WebServicesAddOn";

    public static ConfigurationHandler getHandler() throws ConfigurationException {
        ConfigurationHandlerFactory factory = WSContainer.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
        ConfigurationHandler handler = factory.getConfigurationHandler();
        return handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Configuration getConfiguration(ConfigurationHandler handler, int access) throws ConfigurationException {
        String[] names = handler.getAllRootNames();
        boolean rootExists = false;
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(ROOT_CONFIGURATION_NAME)) {
                rootExists = true;
            }
            ++i;
        }
        if (!rootExists) {
            if (access != 1) return null;
            return handler.createRootConfiguration(ROOT_CONFIGURATION_NAME);
        }
        if (access != 1) return handler.openConfiguration(ROOT_CONFIGURATION_NAME, 0);
        return handler.openConfiguration(ROOT_CONFIGURATION_NAME, 1);
    }

    public static Configuration getSubConfiguration(ConfigurationHandler handler, String subConfigName, int access) throws ConfigurationException {
        Configuration subConfiguration;
        Configuration configuration = ServletsHelperImpl.getConfiguration(handler, access);
        if (configuration == null) {
            return null;
        }
        if (!configuration.existsSubConfiguration(subConfigName)) {
            if (access == 0) {
                return null;
            }
            subConfiguration = configuration.createSubConfiguration(subConfigName);
        } else {
            subConfiguration = configuration.getSubConfiguration(subConfigName);
        }
        return subConfiguration;
    }

    public void sendFile(String name, String type, byte[] data) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationHandler handler = ServletsHelperImpl.getHandler();
            Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, type, 1);
            configuration.updateFileAsStream(name, (InputStream)new ByteArrayInputStream(data), true);
            handler.commit();
            handler.closeAllConfigurations();
            Object var8_7 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
    }

    public boolean fileExists(String name, String type) throws Exception {
        boolean bl;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationHandler handler = ServletsHelperImpl.getHandler();
            Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, type, 0);
            if (configuration == null) {
                boolean bl2 = false;
                Object var9_8 = null;
                Thread.currentThread().setContextClassLoader(loader);
                return bl2;
            }
            boolean exists = configuration.existsFile(name);
            handler.closeAllConfigurations();
            bl = exists;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Thread.currentThread().setContextClassLoader(loader);
            throw throwable;
        }
        Object var9_9 = null;
        Thread.currentThread().setContextClassLoader(loader);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getFile(String name, String type) throws Exception {
        byte[] byArray;
        ConfigurationHandler handler = ServletsHelperImpl.getHandler();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            int l;
            Configuration configuration = ServletsHelperImpl.getSubConfiguration(handler, type, 0);
            if (configuration == null || !configuration.existsFile(name)) {
                throw new Exception("Such a file does not exist: type = " + type + ", name = " + name);
            }
            InputStream in = configuration.getFile(name);
            byte[] buf = new byte[10];
            int offset = 0;
            while ((l = in.read(buf, offset, buf.length - offset)) != -1) {
                void var8_9;
                if ((offset += var8_9) != buf.length) continue;
                byte[] temp = new byte[buf.length * 2];
                System.arraycopy(buf, 0, temp, 0, buf.length);
                buf = temp;
            }
            byte[] file = new byte[offset];
            System.arraycopy(buf, 0, file, 0, offset);
            byArray = file;
            Object var13_12 = null;
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            Thread.currentThread().setContextClassLoader(loader);
            handler.closeAllConfigurations();
            throw throwable;
        }
        handler.closeAllConfigurations();
        return byArray;
    }

    public UDDIRegistry[] getUDDIRegistries() throws Exception {
        WSManagementInterface mngInt = WSManagementInterfaceImpl.getManagementInterface();
        UDDIRegistry[] registries = mngInt.getUDDIRegistries();
        return registries;
    }

    public void addUDDIRegistry(UDDIRegistry registry) throws Exception {
        WSManagementInterface mngInt = WSManagementInterfaceImpl.getManagementInterface();
        mngInt.addUDDIRegistry(registry);
    }

    public void generateWSDLFromWSD(String wsdID, OutputStream result) throws Exception {
        byte[] wsd = this.getFile(wsdID, "wsdGUID");
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        SAXParser parser = factory.newSAXParser();
        VIHandler handler = new VIHandler();
        ByteArrayInputStream in = new ByteArrayInputStream(wsd);
        parser.parse((InputStream)in, handler, wsdID);
        ((InputStream)in).close();
        String[] viIds = handler.getVIIds();
        InputStream[] vis = new InputStream[viIds.length];
        String[] rpcLocations = new String[viIds.length];
        String[] docLocations = new String[viIds.length];
        String wsdName = handler.getWSDName();
        String wsd2WSDLServletPath = "/wsd2wsdl?wsd=" + URLEncoder.encode(wsdName);
        int i = 0;
        while (i < viIds.length) {
            vis[i] = new ByteArrayInputStream(this.getFile(viIds[i], "viGUID"));
            rpcLocations[i] = wsd2WSDLServletPath + "&vi=" + viIds[i] + "&style=rpc";
            docLocations[i] = wsd2WSDLServletPath + "&vi=" + viIds[i] + "&style=document";
            ++i;
        }
        String wsdDocumentation = null;
        try {
            String docID = wsdID + "_en";
            byte[] wsdDoc = this.getFile(docID, "wsdGUID");
            factory = new SAXParserFactoryImpl();
            parser = factory.newSAXParser();
            DocumentationHandler documentationHandler = new DocumentationHandler();
            in = new ByteArrayInputStream(wsdDoc);
            parser.parse((InputStream)in, (DefaultHandler)documentationHandler);
            ((InputStream)in).close();
            wsdDocumentation = documentationHandler.getDocumentation();
        }
        catch (Exception e) {
            Location.getLocation((String)WSLogging.RUNTIME_LOCATION).catching("English documentation file cannot be found. Probably it is not uploaded.", (Throwable)e);
        }
        WSDLAbstractGeneratorImpl.generatePortTypesWSDL(wsdName, wsdDocumentation, vis, rpcLocations, docLocations, result);
    }

    public void generateWSDLFromVI(String viID, String wsdName, String style, OutputStream result) throws Exception {
        byte[] vi = this.getFile(viID, "viGUID");
        ByteArrayInputStream viStream = new ByteArrayInputStream(vi);
        try {
            if ("rpc".equals(style)) {
                WSDLAbstractGeneratorImpl.generateRPCPortType(wsdName, viStream, result);
            } else if ("document".equals(style)) {
                WSDLAbstractGeneratorImpl.generateDocumentPortType(wsdName, viStream, result);
            } else {
                throw new Exception("Unknown style passed for generating PortTypes of the WSD WSDL: " + style);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((InputStream)viStream).close();
            throw throwable;
        }
        ((InputStream)viStream).close();
    }

    public String[] getAddressPointsForWS(String hostName, int port, String serviceName, String applicationName, String jarName) throws Exception {
        WSRuntimeDefinition webService = this.getWS(serviceName, applicationName, jarName);
        if (webService != null) {
            ServiceEndpointDefinition[] ports = webService.getServiceEndpointDefinitions();
            String[] addressPoints = new String[ports.length];
            int j = 0;
            while (j < ports.length) {
                addressPoints[j] = ServiceGenerator.generateHTTPLocationAttrValue("http://" + hostName + ":" + port, ports[j], null, true);
                ++j;
            }
            return addressPoints;
        }
        throw new Exception("The specified web service cannot be found: serviceName = " + serviceName + ", applicationName = " + applicationName + ", jarName = " + jarName);
    }

    private WSRuntimeDefinition getWS(String serviceName, String applicationName, String jarName) throws RemoteException {
        WSManagementInterface mngInt = WSManagementInterfaceImpl.getManagementInterface();
        WSRuntimeDefinition[] webServices = mngInt.listWebServices();
        WSIdentifier wsId = new WSIdentifier(applicationName, jarName, serviceName);
        int i = 0;
        while (i < webServices.length) {
            WSRuntimeDefinition webService = webServices[i];
            if (wsId.equals(webService.getWSIdentifier())) {
                return webService;
            }
            ++i;
        }
        return null;
    }

    public String getUDDIKeyForWS(String serviceName, String applicationName, String jarName, UDDIRegistry registry) throws Exception {
        WSRuntimeDefinition webService = this.getWS(serviceName, applicationName, jarName);
        if (webService != null) {
            UDDIPublication[] publications = webService.getUddiPublications();
            if (publications == null) {
                return webService.getUddiKey();
            }
            String regInquiryURL = registry.getInquiryURL();
            String regPublishURL = registry.getPublishURL();
            int i = 0;
            while (i < publications.length) {
                UDDIPublication publication = publications[i];
                String inquiryURL = publication.getInquiryURL();
                String publishURL = publication.getPublishURL();
                if (regInquiryURL.equals(inquiryURL) && regPublishURL.equals(publishURL)) {
                    return publication.getServiceKey();
                }
                ++i;
            }
            return webService.getUddiKey();
        }
        throw new Exception("The specified web service cannot be found: serviceName = " + serviceName + ", applicationName = " + applicationName + ", jarName = " + jarName);
    }

    public String[] getWSDRefereneces(String serviceName, String applicationName, String jarName, UDDIRegistry registry) throws Exception {
        WSRuntimeDefinition webService = this.getWS(serviceName, applicationName, jarName);
        if (webService != null) {
            UDDIPublication[] publications = webService.getWsdUDDIPublications();
            if (publications == null) {
                return new String[0];
            }
            Vector<String> keysVector = new Vector<String>();
            String regInquiryURL = registry.getInquiryURL();
            String regPublishURL = registry.getPublishURL();
            int i = 0;
            while (i < publications.length) {
                UDDIPublication publication = publications[i];
                String inquiryURL = publication.getInquiryURL();
                String publishURL = publication.getPublishURL();
                if (inquiryURL == null || publishURL == null || inquiryURL.equals(regInquiryURL) && publishURL.equals(regPublishURL)) {
                    keysVector.addElement(publications[i].getServiceKey());
                }
                ++i;
            }
            Object[] keys = new String[keysVector.size()];
            keysVector.copyInto(keys);
            return keys;
        }
        throw new Exception("The specified web service cannot be found: serviceName = " + serviceName + ", applicationName = " + applicationName + ", jarName = " + jarName);
    }

    public void setUDDIKeyToWS(String uddiKey, String serviceName, String applicationName, String jarName, UDDIRegistry registry) throws Exception {
        UDDIPublication[] publications;
        WSRuntimeDefinition webService = this.getWS(serviceName, applicationName, jarName);
        if (webService != null) {
            publications = webService.getUddiPublications();
            if (publications == null) {
                publications = new UDDIPublication[1];
            } else {
                int i = 0;
                while (i < publications.length) {
                    UDDIPublication publication = publications[i];
                    if (publication.getServiceKey().equals(uddiKey) && publication.getInquiryURL().equals(registry.getInquiryURL()) && publication.getPublishURL().equals(registry.getPublishURL())) {
                        return;
                    }
                    ++i;
                }
                UDDIPublication[] temp = new UDDIPublication[publications.length + 1];
                System.arraycopy(publications, 0, temp, 0, publications.length);
                publications = temp;
            }
        } else {
            throw new Exception("The specified web service cannot be found: serviceName = " + serviceName + ", applicationName = " + applicationName + ", jarName = " + jarName);
        }
        UDDIPublication newPublication = new UDDIPublication();
        newPublication.setInquiryURL(registry.getInquiryURL());
        newPublication.setPublishURL(registry.getPublishURL());
        newPublication.setServiceKey(uddiKey);
        publications[publications.length - 1] = newPublication;
        UDDIPublicationEvent uddiPublicationEvent = new UDDIPublicationEvent(webService.getWSIdentifier().getApplicationName(), webService.getWSIdentifier().getServiceName());
        uddiPublicationEvent.setUddiPublications(publications);
        WSContainer.getEventContext().getEventHandler().handle((Event)uddiPublicationEvent);
    }

    public WebServiceExt[] getAllWebServices() {
        WSManagementInterface mngInt = WSManagementInterfaceImpl.getManagementInterface();
        WSRuntimeDefinition[] webServices = mngInt.listWebServices();
        WebServiceExt[] webServicesExt = new WebServiceExt[webServices.length];
        int i = 0;
        while (i < webServices.length) {
            WSRuntimeDefinition def = webServices[i];
            webServicesExt[i] = this.definitionToExternal(def);
            ++i;
        }
        return webServicesExt;
    }

    private WebServiceExt definitionToExternal(WSRuntimeDefinition def) {
        WebServiceExt ws = new WebServiceExt();
        ws.setNameURI(def.getWsQName().getNamespaceURI());
        ws.setLocalName(def.getWsQName().getLocalPart());
        UDDIPublication[] publications = def.getUddiPublications();
        if (publications != null) {
            UDDIPublicationExt[] publicationsExt = new UDDIPublicationExt[publications.length];
            int i = 0;
            while (i < publications.length) {
                UDDIPublicationExt pubExt = new UDDIPublicationExt();
                UDDIPublication pub = publications[i];
                pubExt.setInquiryURL(pub.getInquiryURL());
                pubExt.setPublishURL(pub.getPublishURL());
                pubExt.setServiceKey(pub.getServiceKey());
                publicationsExt[i] = pubExt;
                ++i;
            }
            ws.setUDDIPublication(publicationsExt);
        }
        ws.setDescription(def.getWsdDocumentation());
        ws.setWSDLStyles(def.getWsdlSupportedStyles());
        ServiceEndpointDefinition[] endpoints = def.getServiceEndpointDefinitions();
        String[] uris = new String[endpoints.length];
        int j = 0;
        while (j < uris.length) {
            uris[j] = endpoints[j].getServiceEndpointId();
            ++j;
        }
        ws.setEndpointURIs(uris);
        return ws;
    }

    public WebServiceExt getWebService(String serviceName, String appName, String jarName) {
        WSManagementInterface mngInt = WSManagementInterfaceImpl.getManagementInterface();
        WSRuntimeDefinition[] webServices = mngInt.listWebServices();
        int i = 0;
        while (i < webServices.length) {
            WSRuntimeDefinition def = webServices[i];
            WSIdentifier wsID = def.getWSIdentifier();
            if (wsID.getServiceName().equals(serviceName) && wsID.getApplicationName().equals(appName) && wsID.getJarName().equals(jarName)) {
                return this.definitionToExternal(def);
            }
            ++i;
        }
        return null;
    }

    public String getProxyJars() {
        return WSContainer.getWSDeployer().getJarsPath();
    }

    public HTTPProxyResolver getHTTPProxyResolver() {
        return WSContainer.getHTTPProxyResolver();
    }
}

