/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.runtime.servlet;

import com.sap.engine.interfaces.webservices.runtime.ServletDispatcher;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.engine.services.webservices.runtime.registry.RuntimeRegistry;
import com.sap.engine.services.webservices.runtime.servlet.WSInformation;
import com.sap.engine.services.webservices.runtime.wsdl.WsdlVisualiserImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletDispatcherImpl
implements ServletDispatcher {
    public static final String SAP_WS_RUNTIME_DISABLED = "sap-ws-runtime-disabled";
    public static final String SAP_WS_TEST = "sap-ws-test";
    private RuntimeProcessor wsProcessor;
    private WsdlVisualiserImpl wsdlVisualizer;
    private WSInformation wsInfo;
    private InstancesPool httpTransports = new InstancesPool();

    public ServletDispatcherImpl() {
    }

    public ServletDispatcherImpl(RuntimeProcessor runtimeProcessor) {
        this.init(runtimeProcessor);
    }

    public void init(RuntimeProcessor runtimeProcessor) {
        this.setWsProcessor(runtimeProcessor);
        this.setWsInfo(new WSInformation());
        this.setWsdlVisualizer(new WsdlVisualiserImpl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(Object req, Object res, Object servlet) throws Exception {
        String endpointId;
        RuntimeRegistry runtimeRegistry = WSContainer.getRuntimeRegistry();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestedUri = request.getRequestURI();
        if (requestedUri.endsWith("/")) {
            requestedUri = requestedUri.substring(0, requestedUri.lastIndexOf("/"));
        }
        if (!runtimeRegistry.contains(endpointId = requestedUri) && !runtimeRegistry.contains(endpointId = endpointId.substring(0, endpointId.lastIndexOf("/")))) {
            response.sendError(404, "Web Service Endpoint URI expected. Not found endpoint with URI: " + requestedUri + " nor with URI: " + endpointId + ". ");
            return;
        }
        if (request.getHeader(SAP_WS_RUNTIME_DISABLED) != null) {
            return;
        }
        if (request.getParameter(SAP_WS_TEST) != null) {
            this.wsInfo.writeInfo(endpointId, request, response, (HttpServlet)servlet, this);
            return;
        }
        HTTPTransport transport = null;
        try {
            try {
                transport = (HTTPTransport)this.httpTransports.getInstance();
                if (transport == null) {
                    transport = new HTTPTransport(endpointId, request, response);
                } else {
                    transport.setEntryPointID(endpointId);
                    transport.setRequest(request);
                    transport.setResponse(response);
                }
                this.wsProcessor.process((Transport)transport);
            }
            catch (Exception e) {
                Location.getLocation((String)WSLogging.RUNTIME_LOCATION).catching("doPost context: " + request.getContextPath(), (Throwable)e);
                String eMessage = e.getLocalizedMessage();
                if (eMessage == null) {
                    eMessage = "null";
                }
                response.sendError(500, eMessage);
                Object var13_11 = null;
                transport.clear();
                this.httpTransports.rollBackInstance(transport);
                return;
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            transport.clear();
            this.httpTransports.rollBackInstance(transport);
            throw throwable;
        }
        transport.clear();
        this.httpTransports.rollBackInstance(transport);
    }

    public void doGet(Object req, Object res, Object servlet) throws Exception {
        RuntimeRegistry runtimeRegistry = WSContainer.getRuntimeRegistry();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestedUri = request.getRequestURI();
        if (requestedUri.endsWith("/")) {
            requestedUri = requestedUri.substring(0, requestedUri.lastIndexOf("/"));
        }
        if (request.getHeader(SAP_WS_RUNTIME_DISABLED) != null) {
            return;
        }
        HttpServlet httpServlet = (HttpServlet)servlet;
        try {
            String endpointId = requestedUri;
            if (request.getParameter("wsdl") != null) {
                String wsdlStyle = request.getParameter("style");
                String sapValue = request.getParameter("mode");
                StringBuffer errorMsg = new StringBuffer();
                if (requestedUri.endsWith("/bindings")) {
                    if (!runtimeRegistry.contains(endpointId = endpointId.substring(0, endpointId.indexOf("/bindings")))) {
                        response.sendError(404, "Web Service Endpoint URI expected. Not found endpoint with URI: " + endpointId + ". ");
                        return;
                    }
                    errorMsg = new StringBuffer();
                    if (!this.checkWsdlParams(wsdlStyle, true, sapValue, false, errorMsg)) {
                        response.sendError(406, errorMsg.toString());
                        return;
                    }
                    response.setContentType("text/xml");
                    WsdlVisualiserImpl.writeBindingWsld(endpointId, wsdlStyle, sapValue, (OutputStream)response.getOutputStream());
                    response.flushBuffer();
                    return;
                }
                if (requestedUri.endsWith("/porttypes")) {
                    if (!runtimeRegistry.contains(endpointId = endpointId.substring(0, endpointId.indexOf("/porttypes")))) {
                        response.sendError(404, "Web Service Endpoint URI expected. Not found endpoint with URI: " + endpointId + ". ");
                        return;
                    }
                    errorMsg = new StringBuffer();
                    if (!this.checkWsdlParams(wsdlStyle, true, sapValue, false, errorMsg)) {
                        response.sendError(406, errorMsg.toString());
                        return;
                    }
                    response.setContentType("text/xml");
                    WsdlVisualiserImpl.writePortTypeWsld(endpointId, wsdlStyle, (OutputStream)response.getOutputStream(), sapValue);
                    response.flushBuffer();
                    return;
                }
                if (!runtimeRegistry.contains(endpointId)) {
                    response.sendError(404, "Web Service Endpoint URI expected. Not found endpoint with URI: " + endpointId + ". ");
                    return;
                }
                errorMsg = new StringBuffer();
                if (!this.checkWsdlParams(wsdlStyle, false, sapValue, false, errorMsg)) {
                    response.sendError(406, errorMsg.toString());
                    return;
                }
                response.setContentType("text/xml");
                WsdlVisualiserImpl.writeServiceWsld(endpointId, request, wsdlStyle, sapValue, (OutputStream)response.getOutputStream());
                response.flushBuffer();
                return;
            }
            if (runtimeRegistry.contains(endpointId)) {
                this.wsInfo.writeInfo(endpointId, request, response, httpServlet, this);
            } else {
                endpointId = requestedUri.substring(0, requestedUri.lastIndexOf("/"));
                if (!runtimeRegistry.contains(endpointId)) {
                    response.sendError(404, "Web Service Endpoint URI expected. Not found endpoint with URI: " + requestedUri + " nor with URI: " + endpointId + ". ");
                    return;
                }
                HTTPTransport transport = new HTTPTransport(endpointId, request, response);
                this.wsProcessor.process((Transport)transport);
            }
        }
        catch (Exception e) {
            Location.getLocation((String)WSLogging.RUNTIME_LOCATION).catching("doGet context: " + request.getContextPath(), (Throwable)e);
            String eMessage = e.getLocalizedMessage();
            if (eMessage == null) {
                eMessage = "null";
            }
            response.sendError(500, eMessage);
        }
    }

    public void setWsdlVisualizer(WsdlVisualiserImpl wsdlVisualizer) {
        this.wsdlVisualizer = wsdlVisualizer;
    }

    public void setWsInfo(WSInformation wsInfo) {
        this.wsInfo = wsInfo;
    }

    public void setWsProcessor(RuntimeProcessor wsProcessor) {
        this.wsProcessor = wsProcessor;
    }

    public RuntimeProcessor getWsProcessor() {
        return this.wsProcessor;
    }

    private boolean checkWsdlParams(String style, boolean isStyleRequired, String mode, boolean isModeRequired, StringBuffer excMsg) {
        if (excMsg == null) {
            excMsg = new StringBuffer();
        }
        if (style != null) {
            if (!(style.equals("document") || style.equals("rpc") || style.equals("rpc_enc") || style.equals("mime") || style.equals("http"))) {
                String endMsg = ". ";
                if (!isStyleRequired) {
                    endMsg = " or none. ";
                }
                excMsg.append("Invalid value for parameter style. Accepted values are: document, rpc, rpc_enc, mime or http" + endMsg);
                return false;
            }
        } else if (isStyleRequired) {
            if (excMsg != null) {
                excMsg.append("Parameter style is required. ");
            }
            return false;
        }
        if (mode != null) {
            if (!mode.equals("sap_wsdl")) {
                String endMsg = ". ";
                if (!isModeRequired) {
                    endMsg = " or none. ";
                }
                excMsg.append("Invalid value for parameter mode. Accepted value is: sap_wsdl" + endMsg);
                return false;
            }
        } else if (isModeRequired) {
            if (excMsg != null) {
                excMsg.append("Parameter mode is required. ");
            }
            return false;
        }
        return true;
    }
}

